<?php $__env->startSection('content'); ?>
<div class="breadcrumb-area">
    <div class="container-fluid">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Config</a></li>
                <li class="breadcrumb-item"><a class="active-color" href="#">Config Create</a>
                </li>
            </ol>
        </nav>
    </div>
</div>
        <div class="row">
            <div class="col-lg-12">
            <?php echo e(Form::open(array('route' => 'config/store','files'=>true, 'id'=>'dropzone-demo'))); ?>

                <div class="bg-boxshadow">
                  <div  class="row">
                    <div class="creat-new col-md-6">
                        Config Name <input type="text" id="pwd" placeholder="Enter config name" name="config_name" value="<?php echo e(@$config->config_name); ?>">
                        <?php if($errors->has('config_name')): ?>
                            <div class="error" style="color: red"><?php echo e($errors->first('config_name')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="creat-new col-md-6">Remark <input type="text" placeholder="Enter remark" name="remark">
                    <?php if($errors->has('remark')): ?>
                        <div class="error" style="color: red"><?php echo e($errors->first('remark')); ?></div>
                    <?php endif; ?>
                    </div>
                  </div>
                    <div class="ibox-content from-block mb-30">
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="order_id">Aircraft Type</label>
                                    <select data-style="btn-select-tag" class="selectpicker form-control mb-15" name="aircraft_type">
                                        <?php $__currentLoopData = $aircraft; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aircraftData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($aircraftData->aircraft_id); ?>"><?php echo e($aircraftData->aircraft_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="status">Manufacturer</label>
                                    <select data-style="btn-select-tag" class="form-control mb-15" id="dbox2" name="manufacturer">
                                    </select>
                                    <input name="manufacturer_name" placeholder="Enter manufacturer" type="text" id="manufacturer_data" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                                    <button type="button" class="btn  btn-primary btn-xs manufacturerAdd" id="ProbListBtn2">Add</button>
                                    <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="DeleteManufacturer();">Remove</button>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Model</label>
                                    <select data-style="btn-select-tag" class="form-control mb-15" id="dbox" name="model">
                                    </select>
                                    <input placeholder="Enter model" type="text" id="model_data" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                                    <button type="button" class="btn btn-primary btn-xs modelAdd" id="ProbListBtn" onclick="ListProbs();">Add</button>
                                    <button type="button" class="btn btn-primary btn-xs" id="test" onclick="DeleteModel();">Remove</button>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label  class="col-form-label" for="variant">Variant</label>
                                     <select cdata-style="btn-select-tag" class="selectpicker form-control mb-15 variants" id="variants" name="variant">
                                    </select>
                                    <input placeholder="Enter variant" type="text" id="variant_name" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                                    <button type="button" class="btn btn-primary btn-xs modelVariant">Add</button>
                                    <button type="button" class="btn btn-primary btn-xs" onclick="removeVariant();">Remove</button>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label  class="col-form-label" for="customer">Aircraft Image</label>
                                    <div class="button dropdown">
                                        <select class="selectpicker form-control mb-15" id="aircraft-selector" name="image2">
                                            <?php $__currentLoopData = $configImage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $configImageData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option data-thumbnail="<?php echo e($configImageData->files); ?>" value="<?php echo e($configImageData->configuration_image_id); ?>" ><?php echo e($configImageData->file_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <img height="100px" class="aircraft-preview" alt="aircraft">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                              <div class="button-block">
                                <button class="btn btn-primary btn-md" type="submit">Cancel</button>
                                <button class="btn btn-info btn-md" type="submit">Create This Configuration</button>
                              </div>
                        </div>
                    </div>
                </div>
            <?php echo e(Form::close()); ?>

            </div>
        </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
aircraft();

$(document).ready(function(){
  getManufacturerItem();
  getModelItem();
  getVariantItem();
});

$("#aircraft-selector").change(function(){
    aircraft = $(this).find(':selected').data('thumbnail');
    $('.aircraft-preview').attr('src', '/uploads/' + aircraft);
});

$('.manufacturerAdd').click(function(){
  var manufacturer_data = $('#manufacturer_data').val();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $.ajax({
      url: '/config/addManufacturer',
      type: 'POST',
      cache: false,
      data : { manufacturer_data:manufacturer_data },
      processData: true,
      success: function (data) {
        data = data.replace(/\"/g, "");
        $('#manufacturer_data').val('');
        $('#dbox2').append('<option value="Option Value">'+data+'</option>');
        getManufacturerItem();
      }
   });
});

// get all Manufacurer value from database
function getManufacturerItem(){
  $.ajax({
      url: '<?php echo e(route('get-manufacturer')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
          var manufacturerString = "";
          
          // sort  the array
          var sortdata= data.data.sort(function(a, b) {
            var textA = a.manufacturer_name.toUpperCase();
            var textB = b.manufacturer_name.toUpperCase();
            return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
          });

        // bind value to html element
          $.each(sortdata, function(i, item ) {
            manufacturerString += '<option value="'+item.id+'">'+item.manufacturer_name+'</option>';
          });
          $('#dbox2').html(manufacturerString);

      }
     
   });
}





$('.modelAdd').click(function(){
  var model_data = $('#model_data').val();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  $.ajax({
      url: '/config/addModel',
      type: 'POST',
      cache: false,
      data : { model_data:model_data },
      processData: true,
      success: function (data) {
        data = data.replace(/\"/g, "");
        $('#model_data').val('');
        $('#dbox').append('<option value="Option Value">'+data+'</option>');
        getModelItem();
      }
   });
});

// get all Model value from database
function getModelItem(){
  $.ajax({
      url: '<?php echo e(route('get-model')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
          var modelString = "";

        // sort  the array
        var sortdata= data.data.sort(function(a, b) {
                    var textA = a.model_name.toUpperCase();
                    var textB = b.model_name.toUpperCase();
                    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
                  });

          // bind value to html element
          $.each(sortdata, function(i, item ) {
            modelString += '<option value="'+item.id+'">'+item.model_name+'</option>';
          });
          $('#dbox').html(modelString);
      }
      
   });
  
}


function aircraft() {
  var aircraft = $('#aircraft-selector').find(':selected').data('thumbnail');
  $('.aircraft-preview').attr('src', '/uploads/' + aircraft);
}

function ListProbs() {
    var y = document.getElementById("dbox");
    var txt1 = document.getElementById("ProbAreaFrom").value;
    var option = document.createElement("option");
    option.text = txt1
    y.add(option);
    ProbAreaFrom.value="";
}

function ListProbs2() {
    var y = document.getElementById("dbox2");
    var txt2 = document.getElementById("ProbAreaFrom2").value;
    var option = document.createElement("option");
    option.text = txt2
    y.add(option);
    ProbAreaFrom.value="";
}

function DeleteManufacturer() {
  var index = $('#dbox2').get(0).selectedIndex;
  var id = $('#dbox2').val();
  $('#dbox2 option:eq(' + index + ')').remove();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  $.ajax({
      url: '/config/removeManufacture/'+ id,
      type: 'post',
      cache: false,
      processData: true,
      success: function (data) {
      }
   });
}

function DeleteModel() {
    var index = $('#dbox').get(0).selectedIndex;
    var m_id = $('#dbox').val();

    $('#dbox option:eq(' + index + ')').remove();
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
        url: '/config/removeModel/'+ m_id,
        type: 'post',
        cache: false,
        processData: true,
        success: function (data) {
        }
     });
}

$('.modelVariant').click(function(){
  var variantName = $('#variant_name').val();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  $.ajax({
      url: '/config/addVariant',
      type: 'POST',
      cache: false,
      data : { variant_name : variantName },
      processData: true,
      success: function () {
        $('#variant_name').val('');
        $('.variants').append('<option>' + variantName + '</option>');
        getVariantItem();
        $('#variant_name').val('');
      }
   });
});

// get all Variant value from database
function getVariantItem(){
  $.ajax({
      url: '<?php echo e(route('get-variant')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
          var variantString = "";
          $.each(data.data, function(i, item ) {
            variantString += (item.variant_id == 4) ? '<option value="'+item.variant_id+'" selected="selected">'+item.variant_name+'</option>' :'<option value="'+item.variant_id+'">'+item.variant_name+'</option>';
          });
          $('#variants').html(variantString);
      }
   });
}

function removeVariant() {
    var index = $('.variants').get(0).selectedIndex;
    var id = $('.variants').val();

    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
        url: '/config/removeVariant/' + id,
        type: 'post',
        cache: false,
        processData: true,
        success: function () {
          $('.variants option:eq(' + index + ')').remove();
        }
     });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>