@extends('admin.layouts.master')
@section('content')
<div class="container-fluid">
	<div class="row">
        <div class="col-12">
            <div class="product-list--area bg-boxshadow">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card--body">
                            <div class="profile_thumb_content text-center">
                                <div class="profile--thumb ">
																	@if(empty($user['image']))
                                    <img src="{{ asset('img/default.png') }}" alt="">
																	@else
																	<img src="{{ asset('img/'.$user['image']) }}" alt="Card image cap">
																	@endif
                                </div>
                                <div class="media-body-content">
                                    <h4 class="mb-2">{{$user['name']}} </h4>
                                    <p  class="d-inline-block email-id text-dark-color mr-3">
                                        <strong>Email id : </strong>
                                        <span class="text-color-gray">{{$user['email']}}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card--body">
                            <div class="ap-line-dashed"></div>
                            <div class="row mb-2">
                                <div class="col-3 text-muted">
                                    <h6 class="font--weigth-300 font-s--14">Languages:</h6>
                                </div>
                                <div class="col-9">
                                    <a href="#" class="text-dark">{{$user['language']}}</a>
                                </div>
                            </div>
                            <div class="ap-line-dashed"></div>
                            <div class="row mb-2">
                                <div class="col-3 text-muted">
                                    <h6 class="font--weigth-300 font-s--14">Phone:</h6>
                                </div>
                                <div class="col-9">{{$user['phone']}}</div>
                            </div>
                            <div class="ap-line-dashed"></div>
                            <div class="row">
                                <div class="col-3 text-muted">
                                    <h6 class="font--weigth-300 font-s--14">Address : </h6>
                                </div>
                                <div class="col-9"> {{$user['address']}} </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
$(document).ready(function(){
	$('.table').on('click','.delete_row', function(){
		var id = $(this).attr('data-id');
		$(this).closest('tr').remove();
		$.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
        $.ajax(
    	{
        url: "delete/"+id,
        type: 'get', // replaced from put
        dataType: "JSON",
        success: function (response)
        {
            console.log(response); // see the reponse sent
        },
        error: function(xhr) {
         console.log(xhr.responseText); // this line will save you tons of hours while debugging
        // do something here because of error
       }
    });

});

});
</script>
@endsection
