@extends('admin.layouts.master')
@section('content')

<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        .on {
            border: 1px solid black;
        }

        html,
        body {
            overflow: auto;
        }

        .swal-title {
            font-weight: 500;
            font-size: 1rem !important;

        }

        .swal-icon:first-child {
            margin-top: 18px !important;
        }

        .swal-icon {
            width: 50px !important;
            height: 50px !important;

        }

        .swal-icon--warning__body {
            width: 3px;
            height: 21px;
            top: 13px;
            margin-left: 0px !important;
        }

        .swal-icon--warning__dot {
            width: 4px !important;
            height: 4px !important;
            border-radius: 50% !important;
            margin-left: -2px !important;
            bottom: -9px !important;
        }
    </style>
</head>
<div class="breadcrumb-area">
    <div class="container-fluid">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">
                        Edit Customer
                    </a>
                </li>
                </li>
            </ol>
        </nav>
    </div>
    <form action="{{route('update_flightpaduser', $customer_info->id)}}" method="post" autocomplete="off" enctype="multipart/form-data" files="true" id="ss">
        @csrf

        <div class="ibox bg-boxshadow min-height mb-50">
            <div class="row user-form">
                <div class="col-sm-6">
                    <div class="form-group row">
                        <label class="col-sm-12 col-form-label">Customer Name</label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control" id="customer_name" placeholder="Enter Customer Name" name="customer_name" page_id={{$customer_info->id}} value="{{@$customer_info->customer_name}}" required>

                            @if ($errors->has('customer_name'))
                            <div class="error" style="color: red">{{ $errors->first('customer_name') }}</div>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group row">
                        <label class="col-sm-12 col-form-label">FC Com Key</label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control" id="fc_com_key" placeholder="Enter FC Com Key" name="fc_com_key" value="{{@$customer_info->fc_com_key}}" required>
                            <p id="fcmsg"></p>
                            @if ($errors->has('fc_com_key'))
                            <div class="error" style="color: red">{{ $errors->first('fc_com_key') }}</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="row username" style="padding: 13px;">
                @foreach($user_info as $k=>$a)


                <div class="row user-form-<?PHP echo $k; ?>" style="margin:0px;margin-top:10px;border:1px solid #000;">
                    <input type="text" name="user_id[]" hidden value="{{@$a->id}}">
                    <div class="col-sm-6">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Username</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control text-left" id="username" placeholder="Enter Username" name="username[]" value="{{@$a->username}}" required>
                                @if ($errors->has('username'))
                                <div class="error" style="color: red">{{ $errors->first('username') }}</div>
                                @endif
                            </div>

                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Password</label>
                            <div class="col-sm-12">
                                <input autocomplete="false" type="text" class="form-control text-left" id="password" placeholder="Enter Password" name="password[]" value="{{@$a->password}}" required>
                                @if ($errors->has('password'))
                                <div class="error" style="color: red">{{ $errors->first('password') }}</div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Attributes* <a style="color:#007bff" id="editAttributes" onclick="edit_attributes('<?php echo $k; ?>');">Edit</a></label>
                            <div class="col-sm-12">
                                <input type="text" readonly class="form-control text-left" id="attributes_<?php echo $k; ?>" placeholder="Enter  Attributes" name="fattributes[]" value="{{preg_replace('!\s+!',', ', trim($a->attributes))}}">
                                @if ($errors->has('attributes'))
                                <div class="error" style="color: red">{{ $errors->first('attributes') }}</div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Aircraft Types</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control text-left" id="aircraft_types" placeholder="Enter Aircraft Types" name="aircraft_types[]" value="{{@$a->aircraft_type}}">
                                @if ($errors->has('attributes'))
                                <div class="error" style="color: red">{{ $errors->first('attributes') }}</div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12" style="text-align: right;">

                        <button class="btn btn-danger " id="removeuser" type="button" data-token="{{ csrf_token() }}" onclick="removeCustomer('<?php echo $k ?>','{{@$a->id}}')">Remove</button>
                    </div>
                </div>
                @endforeach
            </div>

            <div class="col-sm-12 row">
                <button type="button" id="addUser" class="btn btn-success btn1" style="
      margin-top: 6px;">Add Username</button>
            </div>

            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Features* <a style="color:#007bff" id="editFeatures" onclick="edit_features()">Edit</a></label>
                <div class="col-sm-12">
                    <textarea type="text" readonly class="form-control text-left" id="ffeatures" name="features" value="{{@$customer_info->features}}">{{@$user_feature_info->features}}</textarea>
                </div>
            </div>
            <div class="form-group">
                            <div class="col-sm-12 row">
                                <div class="col-md-3">
                                    <label class="control-label col-md-3" style="font-size: initial;">LogoManifest:</label>
                                    <input type='file' name="ac_image" accept="image/png, image/jpeg" onchange="loadFile(event,1);" class='files' style="margin-left: 15px; color:transparent;" />
                                    <input type="hidden" id="deletetrigger" name="deletetrigger" value="false">

                                </div>
                                @if($customer_info->ac_image_name)
                                <div style="height:102px; width: 700px; overflow:hidden ;margin-left:-65px;">
                                    <img id="blah_1" src="/uploads/<?= $customer_info->ac_image_name; ?>" style="height: 102px;width: 700px;" />
                                </div>
                                @else
                                <div style="height:102px; width: 700px; overflow:hidden ;margin-left:-65px; background:white;">
                                    <img id="blah_1" style="height: 102px;width: 700px; " />
                                </div>
                                @endif
                            </div>
                            <button class="btn btn-danger " type="button" id="removelogo" onclick="removelogomanifest(event,1)">Remove</button>
                        </div>
            <!-- <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Confirm  Password</label>
                      <div class="col-sm-12">
                          <input id="password-confirm" type="password" class="form-control" name="password_confirmation" placeholder="Confirm Password">
                          @if ($errors->has('confirm password'))
                              <div class="error" style="color: red">{{ $errors->first('confirm password') }}</div>
                          @endif
                      </div>
                  </div>
                </div> -->



            <div class="acaircraft" style="padding : 13px; margin-top: 10px;">
                @if(isset($aircraft_customer_info ) || !empty($aircraft_customer_info))
                @foreach($aircraft_customer_info as $key=>$val)

                <div class="row ac-form-<?PHP echo $key; ?>" style="background: #E7DDDD;margin-top: 5px;">
                    <input type="text" name="customeraircraft[<?PHP echo $key; ?>][customer_aircraft_id]" hidden value="{{@$val->id}}">
                    <div class="col-sm-1" style="position: absolute;">
                        <div class="form-group row">
                            <div class="col-sm-12" style="margin-top: 43px;"> {{$key +1}}: </div>
                        </div>
                    </div>
                    <div class="col-sm-3" style="position: relative;left: 14px;">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Aircraft For This Customer :</label>
                            <div class="col-sm-12">
                                <select data-style="btn-select-tag" class="form-control mb-15" id="ac_aircraft" name="customeraircraft[<?php echo $key; ?>][aircraft_name]" style="text-align: left;">
                                    @foreach($aircraft_data as $aircraft_datas)
                                    <option value="{{$aircraft_datas->id }}" {{ $aircraft_datas->id == $val->available_aircraft ? 'selected' : '' }}>{{ $aircraft_datas->display_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Ac Text <a style="color:#007bff" id="editActxt" onclick="edit_ac_text('<?php echo $key; ?>');">Edit</a></label>
                            <div class="col-sm-12">
                                <input type="text" readonly class="form-control text-left" id="ac_text_<?php echo $key; ?>" placeholder="Enter Ac Text" name="customeraircraft[<?php echo $key; ?>][ac_text]" value="{{@$val->ac_text}}" data-value="0">
                                @if ($errors->has('ac_text'))
                                <div class="error" style="color: red">{{ $errors->first('ac_text') }}</div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row col-sm-11">
                        <div class="col-sm-1">
                            <div class="form-group row">
                                <div class="col-sm-12" style="margin-left:16px;margin-top: 10px;font-size: initial;"> Configurations: </div>
                            </div>
                        </div>
                        <div class="configuration_<?PHP echo $key; ?> col-sm-11" style="position: relative;left: 67px;">

                            @foreach($list_data_info as $keys=>$airval)
                            @foreach($airval as $key1=>$val1)

                            @if($val->id == $val1->aircraft_id)

                            <div class="row config-form-{{@$val1->id}}_<?PHP echo $key; ?>">
                                <input type="text" name="customeraircraft[<?php echo $key; ?>][config][aircraft_config_id][]" hidden value="{{@$val1->id}}">
                                <div class="col-sm-1" style="position: absolute;">
                                    <div class="form-group row">
                                        <div class="col-sm-12" style="margin-left:2px;margin-top: 10px;">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <div class="col-sm-12">
                                            <input type="text" readonly class="form-control text-left config_id" id="config_id" name="customeraircraft[<?php echo $key; ?>][config][config_id][]" value="{{@$val1->config_id}}" data-value="0" style="margin-left: 9px;">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="margin-left: -32px;">
                                        <div class="col-sm-8">
                                            <button type="button" id="config_edit" class="btn btn-success btn1" onclick="editConfig('{{@$val1->config_id}}', '<?php echo $customer_info->id ?>')">View</button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-8">
                                    <div class="form-group row" >
                                        <div class="col-sm-12">
                                            <input type="text" readonly class="form-control text-left config_data" id="config_data" placeholder="Enter config Data" name="customeraircraft[<?php echo $key; ?>][config][config_data][]" value="{{@$val1->config_data}}" data-value="0">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-1 text-right">
                                    <button class="btn btn-danger " type="button" id="removeconfig" onclick="removeConfig('{{@$val1->id}}', '<?php echo $key ?>')">Remove</button>
                                </div>
                            </div>

                            @endif
                            @endforeach

                            @endforeach
                        </div>
                        <button type="button" id="config_add" class="btn btn-success btn1" onclick="addconfig('<?php echo $key ?>');" style="margin-left: 28px;">Add Configuration</button>

                    </div>
                    <div class="row col-sm-11" style="padding-top: 20px;">
                        <div class="col-sm-1">
                            <div class="form-group row">
                                <div class="col-sm-12" style="margin-left:16px;margin-top: 10px;font-size: initial;white-space: nowrap"> CG Envelope: </div>
                            </div>
                        </div>
                        <div class="cgenvelop_<?PHP echo $key; ?> col-sm-11" style="position: relative;left: 67px;">

                            @foreach($cg_data_info as $cgkeys=>$cgval)
                            @foreach($cgval as $key2=>$val2)

                            @if($val->id == $val2->aircraft_id)

                            <div class="row cgenvelop-form-{{@$val2->id}}_<?PHP echo $key; ?>">
                                <input type="text" name="customeraircraft[<?php echo $key; ?>][cgenvelop][aircraft_envelope_id][]" hidden value="{{@$val2->id}}">
                                <div class="col-sm-1" style="position: absolute;">
                                    <div class="form-group row">
                                        <div class="col-sm-12" style="margin-left:2px;margin-top: 10px;">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <div class="col-sm-12">
                                            <input type="text" readonly class="form-control text-left cg_id" id="cg_id" name="customeraircraft[<?php echo $key; ?>][cgenvelop][cg_id][]" value="{{@$val2->cg_id}}" data-value="0" style="margin-left: 9px;">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="margin-left: -32px;">
                                        <div class="col-sm-8">
                                            <button type="button" id="cg_edit" class="btn btn-success btn1" onclick="editCg('{{@$val2->cg_id}}', '<?php echo $customer_info->id ?>')">View</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-8">
                                    <div class="form-group row">
                                        <div class="col-sm-12">
                                            <input type="text" readonly class="form-control text-left cg_data" id="cg_data" placeholder="Enter config Data" name="customeraircraft[<?php echo $key; ?>][cgenvelop][cg_data][]" value="{{@$val2->cg_data}}" data-value="0">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-1 text-right">
                                    <button class="btn btn-danger" type="button" id="removeCG" onclick="removeCG_1({{@$val2->id}}, <?php echo $key ?>);">Remove</button>
                                </div>

                            </div>

                            @endif
                            @endforeach

                            @endforeach
                        </div>
                        <div class="col-sm-12 config_button" style="padding-bottom: 30px;">
                            <button type="button" id="cg_add" class="btn btn-success btn1" style="margin-left: 14px;" onclick="addcg('<?php echo $key ?>');">Add CG Envelope</button>
                        </div>
                    </div>
                    <div class="col-sm-2" style="padding-right: 0px;">
                            <div class="form-group">
                                <label class="col-sm-12 col-form-label" style="font-size: initial;padding-right: 0px;">Performance:</label>
                            </div>
                        </div>
                        <div class="col-sm-9" style="padding-bottom: 10px;">
                        </div>
                        <div class="col-sm-12" style="padding-bottom: 10px;">
                            <textarea cols="60" rows="1" class="form-control text-left" id="ac_performance_<?php echo $key; ?>" placeholder="Enter Performance" name="customeraircraft[<?php echo $key; ?>][ac_performance]" value="{{@$val->ac_performance}}" style="overflow-y: scroll;">{{@$val->ac_performance}}</textarea>

                            <!--<input type="text" class="form-control text-left" id="ac_performance_<?php echo $key; ?>" placeholder="Enter Performance" name="customeraircraft[<?php echo $key; ?>][ac_performance]" value="{{@$val->ac_performance}}" data-value="0">-->
                            @if ($errors->has('ac_performance'))
                            <div class="error" style="color: red">{{ $errors->first('ac_performance') }}</div>
                            @endif
                        </div>
                        
                    <div class="row text_form_<?PHP echo $key; ?> col-sm-11">
                        
                        <div class="col-sm-2" style="padding-right: 0px;">
                            <div class="form-group">
                                <label class="col-sm-12 col-form-label" style="font-size: initial;padding-right: 0px;">Fuel Interpolation:</label>
                            </div>
                        </div>
                        <div class="col-sm-9" style="padding-bottom: 10px;">
                            <textarea cols="30" rows="1" class="form-control text-left" id="ac_fuelinterpolation_<?php echo $key; ?>" placeholder="Enter FuelInterpolation" name="customeraircraft[<?php echo $key; ?>][ac_fuelinterpolation]" value="{{@$val->ac_fuelinterpolation}}" style="overflow-y: scroll;">{{@$val->ac_fuelinterpolation}}</textarea>

                            <!--<input type="text" class="form-control text-left" id="ac_fuelinterpolation_<?php echo $key; ?>" placeholder="Enter FuelInterpolation" name="customeraircraft[<?php echo $key; ?>][ac_fuelinterpolation]" value="{{@$val->ac_fuelinterpolation}}" data-value="0">-->
                            @if ($errors->has('ac_fuelinterpolation'))
                            <div class="error" style="color: red">{{ $errors->first('ac_fuelinterpolation') }}</div>
                            @endif
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="col-sm-12 col-form-label" style="font-size: initial;">CG Multiple:</label>
                            </div>
                        </div>
                        <div class="col-sm-9" style="padding-bottom: 10px;">
                            <textarea cols="30" rows="1" class="form-control text-left" id="ac_cgmultiple<?php echo $key; ?>" placeholder="Enter CGmultiple" name="customeraircraft[<?php echo $key; ?>][ac_cgmultiple]" value="{{@$val->ac_cgmultiple}}" style="overflow-y: scroll;" data-value="0">{{@$val->ac_cgmultiple}}</textarea>

                            <!--<input type="text" class="form-control text-left" id="ac_cgmultiple<?php echo $key; ?>" placeholder="Enter FuelInterpolation" name="customeraircraft[<?php echo $key; ?>][ac_cgmultiple]" value="{{@$val->ac_cgmultiple}}" data-value="0">-->
                            @if ($errors->has('ac_cgmultiple'))
                            <div class="error" style="color: red">{{ $errors->first('ac_cgmultiple') }}</div>
                            @endif
                        </div>


                        
                    </div>
                    <div class="col-sm-12 config_button" style="display:flex; justify-content: flex-end; padding-bottom:32px;padding-top: 10px;">
                        <button class="btn btn-danger " type="button" id="removeuser" data-token="{{ csrf_token() }}" onclick="removeAc('<?php echo $key ?>','{{@$val->id}}')">Remove</button>

                    </div>
                    <!-- <div class="col-sm-12" style="text-align:right;">

                    </div> -->
                </div>
                @endforeach
                @endif
            </div>

            <div class="col-sm-12 row">
                <button type="button" id="addac" class="btn btn-success btn1">Add Aircraft</button>
            </div>
            <button type="submit" style="text-align: right;  margin-top: 16px;" class="btn btn-primary save_btn">Save</button>
            @if(session()->has('message'))
            <div class="alert alert-dark-success" style="margin-top: 16px;">
                {{ session()->get('message') }}
            </div>
            @endif
        </div>

    </form>

    <br /><br /><br /><br />
    <br /><br /><br /><br />
    <div class="modal fade" id="ActextModal" tabindex="-1" role="dialog" aria-labelledby="ActextModal" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ActextModal">Add Ac Text</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="ac_text_body" style="overflow-y: auto;height: 350px;">
                    <div class="ac_textOption"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="save_ac_text">Save changes</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="AttributsModal" tabindex="-1" role="dialog" aria-labelledby="AttributsModal" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="AttributsModal">Add Attributes</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="attributes_body" style="overflow-y: auto;height: 300px;">
                    <div class="attriOption"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="save_attr">Save changes</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="featuresModal" tabindex="-1" role="dialog" aria-labelledby="featuresModal" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="featuresModal">Add Features</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body features_body" style="overflow-y: auto;height: 300px;">
                    <div class="featureOption"></div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary save_features">Save changes</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="configurationModal" tabindex="-1" role="dialog" aria-labelledby="configurationModal" aria-hidden="true" data-keyboard="false" data-backdrop="static">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="configurationModal"> Add Configuration</h5>
                </div>
                <div class="modal-body" id="ac_text_body" style="overflow-y: auto;height: 270px;">
                    <div class="col-sm-6" style="position: relative;left: 109px;top: 15px;">
                        <div class="form-group">

                            <div class="ac_config_option">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-5" style="position: relative;left: 110px;top: 22px;">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label" style="font: message-box;transform: translatex(36%);"> OR </label>
                            <div class="ac_config_text" style="position: relative;top: 22px;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="cgenvelopModal" tabindex="-1" role="dialog" aria-labelledby="cgenvelopModal" aria-hidden="true" data-keyboard="false" data-backdrop="static">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cgenvelopModal"> Add CG Envelope</h5>
                </div>
                <div class="modal-body" id="ac_text_body" style="overflow-y: auto;height: 270px;">
                    <div class="col-sm-6" style="position: relative;left: 109px;top: 15px;">
                        <div class="form-group">

                            <div class="cg_env_option">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-5" style="position: relative;left: 110px;top: 22px;">
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label" style="font: message-box;transform: translatex(36%);"> OR </label>
                            <div class="cg_env_text" style="position: relative;top: 22px;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="config_pop_Modal" tabindex="-1" role="dialog" aria-labelledby="config_pop_Modal" aria-hidden="true">
        <div class="modal-dialog" role="document" style="position: absolute; right: 40%;">
            <div class="modal-content" style="width: 172%;">
                <div class="modal-header">
                    <h5 class="modal-title" id="config_pop_Modal">Config Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="container-fluid">
                    <div class="product-list--area bg-boxshadow">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="ibox">
                                    <div class="ibox-content">

                                        <div class="table_config">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="cg_pop_Modal" tabindex="-1" role="dialog" aria-labelledby="cg_pop_Modal" aria-hidden="true">
        <div class="modal-dialog" role="document" style="position: absolute; right: 40%;">
            <div class="modal-content" style="width: 172%;">
                <div class="modal-header">
                    <h5 class="modal-title" id="cg_pop_Modal">CG Envelope Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="container-fluid">
                    <div class="product-list--area bg-boxshadow">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="ibox">
                                    <div class="ibox-content">
                                        <div class="table_cg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @section('script')
    <script src="{{asset('/js/plugins-js/fselect-js/fselect.js')}}"></script>
    <script>
        $("document").ready(function() {

            setTimeout(function() {
                $("div.alert").remove();
            }, 2000); // 5 secs

        });
        $(document).ready(function() {
            $(".save_btn").click(function() {
                window.scrollTo(0, 0);
            });
        });

        function edit_ac_text(id) {
            var attrArray1 = $.trim($('#ac_text_' + parseInt(id)).val());
            if (attrArray1 !== "") {
                var attrArray = attrArray1.split(', ');
            } else {
                var attrArray = [];
            }
            $('.ac_textOption').empty();
            var attr_list = <?php if (!empty($aircraft_customer)) {
                                echo $aircraft_customer;
                            } else { ?>[] <?php } ?>;
            // console.log(attr_list);
            var userAttr = [];
            $.each(attr_list, function(key1, val1) {
                var index = $.inArray(val1.ac_text_name, attrArray);

                if (index != -1) {
                    var index1 = attrArray.indexOf(val1.ac_text_name);
                    var data = '<input type="checkbox" id="ac_text_option_' + key1 + '" name="ac_text_option" value="' + val1['ac_text_name'] + '" checked> <label> ' + val1['ac_text_name'] + '</label><br>';
                    $('.ac_textOption').append(data);
                    attrArray.splice(index1, 1);
                } else {
                    var data = '<input type="checkbox" id="ac_text_option_' + key1 + '" name="ac_text_option" value="' + val1['ac_text_name'] + '"> <label> ' + val1['ac_text_name'] + '</label><br>';
                    $('.ac_textOption').append(data);
                }

            });
            userAttr.push(attrArray);

            $('.ac_textOption').append('<input name="actextId" value="' + id + '" id="actextId" hidden>');
            if (attrArray.length !== 0) {
                var attr_list = userAttr.join(', ');
                $('.ac_textOption').append('<input type="checkbox" id="other_option_ac_text" value="1" checked onchange="actextChanged();"> <label>Other</label>');
                $('.ac_textOption').append('<input name="userAddedactext" id="userAddedactext" class="form-control" placeholder="Enter Ac Text separated with space" value="' + attr_list + '">');
            } else {
                var attr_list = "";
                $('.ac_textOption').append('<input type="checkbox" id="other_option_ac_text"  value="1" onchange="actextChanged();"> <label>Other</label>');
                $('.ac_textOption').append('<input name="userAddedactext" style="display:none;" id="userAddedactext" class="form-control" placeholder="Enter Ac Text separated with space" value="' + userAttr.join(', ') + '">');
            }
            $('#ActextModal').modal('show');

        }

        function edit_attributes(id) {
            var attrArray1 = $.trim($('#attributes_' + parseInt(id)).val());
            if (attrArray1 !== "") {
                var attrArray = attrArray1.split(', ');
            } else {
                var attrArray = [];
            }
            $('.attriOption').empty();
            var attr_list = <?php if (!empty($flightpadAttributes)) {
                                echo $flightpadAttributes;
                            } else { ?>[] <?php } ?>;
            var userAttr = [];
            $.each(attr_list, function(key1, val1) {
                var index = $.inArray(val1.attribute_name, attrArray);

                if (index != -1) {
                    var index1 = attrArray.indexOf(val1.attribute_name);
                    var data = '<input type="checkbox" id="attribute_option_' + key1 + '" name="attribute_option" value="' + val1['attribute_name'] + '" checked> <label> ' + val1['attribute_name'] + '</label><br>';
                    $('.attriOption').append(data);
                    attrArray.splice(index1, 1);
                } else {
                    var data = '<input type="checkbox" id="attribute_option_' + key1 + '" name="attribute_option" value="' + val1['attribute_name'] + '"> <label> ' + val1['attribute_name'] + '</label><br>';
                    $('.attriOption').append(data);
                }

            });
            userAttr.push(attrArray);

            $('.attriOption').append('<input name="attrId" value="' + id + '" id="attrId" hidden>');
            if (attrArray.length !== 0) {
                var attr_list = userAttr.join(', ');
                $('.attriOption').append('<input type="checkbox" id="other_option_attr" value="1" checked onchange="attrChanged();"> <label>Other</label>');
                $('.attriOption').append('<input name="userAddedAttributes" id="userAddedAttributes" class="form-control" placeholder="Enter attributes separated with space" value="' + attr_list + '">');
            } else {
                var attr_list = "";
                $('.attriOption').append('<input type="checkbox" id="other_option_attr"  value="1" onchange="attrChanged();"> <label>Other</label>');
                $('.attriOption').append('<input name="userAddedAttributes" style="display:none;" id="userAddedAttributes" class="form-control" placeholder="Enter attributes with space" value="' + userAttr.join(', ') + '">');
            }
            $('#AttributsModal').modal('show');

        }

        function edit_features() {
            var attrArray1 = $.trim($('#ffeatures').val());
            if (attrArray1 !== "") {
                var attrArray = attrArray1.split(', ');
            } else {
                var attrArray = [];
            }
            $('.featureOption').empty();
            var attr_list = <?php if (!empty($feature_data)) {
                                echo $feature_data;
                            } else { ?>[] <?php } ?>;
            var userAttr = [];
            $.each(attr_list, function(key1, val1) {
                var index = $.inArray(val1.features, attrArray);
                if (index != -1) {
                    var index1 = attrArray.indexOf(val1.features);
                    var data = '<input type="checkbox" id="feature_option_' + key1 + '" name="feature_option" value="' + val1['features'] + '" checked> <label> ' + val1['features'] + '</label><br>';
                    $('.featureOption').append(data);
                    attrArray.splice(index1, 1);
                } else {
                    var data = '<input type="checkbox" id="feature_option_' + key1 + '" name="feature_option" value="' + val1['features'] + '"> <label> ' + val1['features'] + '</label><br>';
                    $('.featureOption').append(data);
                }

            });
            userAttr.push(attrArray);
            if (attrArray.length !== 0) {
                var feature_list = userAttr.join(', ');
                $('.featureOption').append('<input type="checkbox" id="other_option" value="1" checked onchange="valueChanged()"> <label>Other</label>');
                $('.featureOption').append('<input name="userAddedFeatures" id="userAddedFeatures" class="form-control text-left" placeholder="Enter Features with space" value="' + feature_list + '">');
            } else {
                var feature_list = "";
                $('.featureOption').append('<input type="checkbox" id="other_option" value="1" onchange="valueChanged()"> <label>Other</label>');
                $('.featureOption').append('<input name="userAddedFeatures" style="display:none;" id="userAddedFeatures" class="form-control text-left " placeholder="Enter Features Separated with space" value="' + userAttr.join(', ') + '">');
            }
            $('#featuresModal').modal('show');
        }

        function valueChanged() {
            if ($('#other_option').is(":checked")) {
                $("#userAddedFeatures").show();
            } else {
                $("#userAddedFeatures").hide();
                $("#userAddedFeatures").val('');

            }
        }

        function actextChanged() {
            if ($('#other_option_ac_text').is(":checked")) {
                $("#userAddedactext").show();
            } else {
                $("#userAddedactext").hide();
                $("#userAddedactext").val('');
            }
        }

        function attrChanged() {
            if ($('#other_option_attr').is(":checked")) {
                $("#userAddedAttributes").show();
            } else {
                $("#userAddedAttributes").hide();
                $("#userAddedAttributes").val('');

            }
        }

        $("body").on('change', function(e) {
            // $("#ss").submit(function(e) {

            var id = $('#customer_name').attr('page_id');
            var customer_name = $('#customer_name').val();
            var fc = $('#fc_com_key').val();
            var customer = $('#customer_name').attr('value');
           
            var fc_key = $('#fc_com_key').attr('value');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }

            });
            $.ajax({
                type: "GET",
                url: '{{route("getcustomer")}}',
                data: {
                    customer_name: customer_name,
                    fc_com_key: fc
                },
                success: function(data) {
                    if ((fc_key == fc) ) {
                        // if ((customer == customer_name) && (data.fc_com_key[0].id == id)) {  //For popup issue while adding same user name
                        if ((customer == customer_name)) {

                        } else {
                            swal({
                  title: "Entered  customer name for given fcom key is not valid ,Change it to  : " + customer, 
                                text: "",
                                icon: "warning",
                                buttons: false,
                                dangerMode: true,
                            });
                            $("#customer_name").val(customer);


                        }
                    }
                    if ((customer == customer_name)){
                    if ((fc_key == fc)) {

                    } else {
                        swal({
                            title: "customer name already exists",
                            text: "",
                            icon: "warning",
                            buttons: false,
                            dangerMode: true,
                        });
                        $("#fc_com_key").val(fc_key);

                    }
                }
                }

            });

        });



        // $("#fc_com_key").on('change', function(e) {
        //         alert("FD");
        //         var id = $('#customer_name').attr('page_id');
        //         var fckey = $('#fc_com_key').val();
        //         $.ajaxSetup({
        //             headers: {
        //                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //             }

        //         });
        //         $.ajax({
        //             type: "GET",
        //             url: '{{route("getcustomer")}}',
        //             data: {
        //                 fc_com_key: fc_com_key,
        //             },
        //             success: function(data) {



        //             }

        //         });

        //     });
        $(document).ready(function() {
            $(".save_features").click(function() {
                var programming = $("input[name='feature_option']:checked");
                var features_checked = programming.map(function() {
                    return this.value;
                }).get().join(', ');


                var feature_data = $('#userAddedFeatures').val();
                var sepfeaturerdata = feature_data.replace(/[ ,]+/g, ", ");
                if (features_checked == "") {
                    $('#ffeatures').val(sepfeaturerdata);
                } else if (feature_data == "") {
                    features_checked += sepfeaturerdata;
                    $('#ffeatures').val(features_checked);
                } else {
                    features_checked += ', ' + sepfeaturerdata;
                    $('#ffeatures').val(features_checked);
                }
                $('#featuresModal').modal('hide');
            });
        });

        $("#save_attr").click(function() {
            var attrs = $("input[name='attribute_option']:checked");
            var attrList = attrs.map(function() {
                return this.value;
            }).get().join(', ');
            var id = $('#attrId').val();
            var attribute_data = $('#userAddedAttributes').val();
            var sepattrdata = attribute_data.replace(/[ ,]+/g, ", ");
            if (attrList == "") {
                $('#attributes_' + id + '').val(sepattrdata);
            } else if (attribute_data == "") {
                attrList += sepattrdata;
                $('#attributes_' + id + '').val(attrList);
            } else {
                attrList += ', ' + sepattrdata;
                $('#attributes_' + id + '').val(attrList);
            }
            $('#AttributsModal').modal('hide');
        });
        $("#save_ac_text").click(function() {
            var attrs = $("input[name='ac_text_option']:checked");
            var ac_text_List = attrs.map(function() {
                return this.value;
            }).get().join(', ');
            var id = $('#actextId').val();
            var userdata = $('#userAddedactext').val();
            var sepuserdata = userdata.replace(/[ ,]+/g, ", ");
            if (ac_text_List == "") {
                $('#ac_text_' + id + '').val(sepuserdata);
            } else if (userdata == "") {
                ac_text_List += sepuserdata;
                $('#ac_text_' + id + '').val(ac_text_List);
            } else {
                ac_text_List += ', ' + sepuserdata;
                $('#ac_text_' + id + '').val(ac_text_List);
            }

            $('#ActextModal').modal('hide');

        });
        var i = <?php echo sizeof($user_info); ?>;

        $(document).on('click', '#addUser', function() {
            var userFields = '<div class="row user-form-' + i + '" style="margin:0px;margin-top:10px;border:1px solid #000;"><input type="text" name="user_id[]" hidden>' +
                '<div class="col-sm-6">' +
                '<div class="form-group row">' +
                '<label class="col-sm-12 col-form-label">Username</label>' +
                '<div class="col-sm-12">' +
                '<input type="text" class="form-control text-left usernames" id="username" placeholder="Enter Username" name="username[]" value="{{@$flight_pad_user->username}}" required>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-6">' +
                '<div class="form-group row">' +
                '<label class="col-sm-12 col-form-label">Password</label>' +
                '<div class="col-sm-12">' +
                '<input autocomplete="false" type="text" class="form-control text-left" id="password" placeholder="Enter Password" name="password[]" value="{{@$flight_pad_user->password}}">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-12">' +
                '<div class="form-group row">' +
                '<label class="col-sm-12 col-form-label">Attributes* <a style="color:#007bff" id="editAttributes" onclick="edit_attributes(' + i + ');">Edit</a></label>' +
                '<div class="col-sm-12">' +
                '<input type="text" readonly class="form-control text-left" id="attributes_' + i + '" placeholder="Enter Attributes" name="fattributes[]">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-6">' +
                '<div class="form-group row">' +
                '<label class="col-sm-12 col-form-label">Aircraft Types</label>' +
                '<div class="col-sm-12">' +
                '<input type="text" class="form-control text-left" id="aircraft_types" placeholder="Enter Aircraft Types" name="aircraft_types[]">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-12" style="text-align: right;">' +
                '<button  class = "btn btn-danger" type="button" id="removeuser" onclick="removeCustomer(' + i + ')">Remove</button>' +
                '</div>' +
                '</div>';

            $('.username').append(userFields);
            i++;
        });

        function removeCustomer(value, id) {
            var delete_confirmation = confirm("Are you sure you want to delete this record ?");
            if (delete_confirmation == true) {
                $('.user-form-' + value).remove();
            } else {
                return false;
            }
        }
        var j = <?php if (isset($aircraft_customer_info)) {
                    echo sizeof($aircraft_customer_info);
                } else { ?>0<?php } ?>;
        var l = <?php if (isset($list_data_info)) {
                    echo sizeof($list_data_info);
                } else { ?> 0 <?php } ?>;
        var m = <?php if (isset($cg_data_info)) {
                    echo sizeof($cg_data_info);
                } else { ?> 0 <?php } ?>;
        $(document).on('click', '#addac', function() {

            var ac_fields = '<div class="row ac-form-' + j + '" style="background: #E7DDDD; margin-top: 4px;">' +
                '<input type="text" name="customeraircraft[' + j + '][customer_aircraft_id]" hidden>' +
                '<div class="col-sm-1" style="position: absolute;">' +
                '<div class="form-group row">' +
                '<div class="col-sm-12" style="margin-top: 43px;"> ' + parseInt(j + 1) + ' </div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-3" style="position: relative;left: 14px;">' +
                '<div class="form-group row">' +
                '<label class="col-sm-12 col-form-label">Aircraft For This Customer :</label>' +
                '<div class="col-sm-12">' +
                '<select data-style="btn-select-tag" class="form-control mb-15" id="ac_aircraft" name="customeraircraft[' + j + '][aircraft_name]" style="text-align: left;">' +
                '@foreach($aircraft_data as $aircraft_datas)' +
                '<option value={{$aircraft_datas->id}}> {{"$aircraft_datas->display_name"}}</option>' +
                '@endforeach' +
                '</select>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-8">' +
                '<div class="form-group row">' +
                '<label class="col-sm-12 col-form-label">Ac Text <a style="color:#007bff" id="editActxt" onclick="edit_ac_text(' + j + ');">Edit</a></label>' +
                '<div class="col-sm-12">' +
                '<input type="text" class="form-control text-left"  readonly  id="ac_text_' + j + '"  placeholder="Enter Ac Text" name="customeraircraft[' + j + '][ac_text]">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="row col-sm-11">' +
                '<div class="col-sm-1">' +
                '<div class="form-group row">' +
                '<div class="col-sm-12" style="margin-left:16px;margin-top: 10px;font-size: initial;"> Configurations: </div>' +
                '</div>' +
                '</div>' +
                '<div class="configuration_' + l + ' col-sm-11" style="position: relative;left: 67px;">' +
                '</div>' +
                '<button type="button" id="config_add" class="btn btn-success" onclick="addconfig(' + l + ');" style="margin-left: 28px;">Add Configuration</button>' +
                '</div>' +

                '<div class="row col-sm-11" style="padding-top: 20px;">' +
                '<div class="col-sm-1">' +
                '<div class="form-group row">' +
                '<div class="col-sm-12" style="margin-left:16px;margin-top: 10px;font-size: initial;white-space: nowrap;"> CG Envelope: </div>' +
                '</div>' +
                '</div>' +
                '<div class="cgenvelop_' + m + ' col-sm-11" style="position: relative;left: 67px;">' +
                '</div>' +
                '</div>' +
                '<div class = "col-sm-12" style="padding-bottom: 30px;">' +
                '<button type="button" id="cg_add" style="margin-left: 14px;"class="btn btn-success" onclick="addcg(' + m + ');" style="margin-left: 28px;">Add CG Envelope</button>' +
                '</div>' +

                '<div class="col-sm-2" style="padding-right: 0px;">' +
                '<div class="form-group">'+
                '<label class="col-sm-12 col-form-label" style="font-size: initial;padding-right: 0px;">Performance:</label>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-9" style="padding-bottom: 10px;">'+
                '</div>'+
                '<div class="col-sm-12" style="padding-bottom: 10px;">' +
                '<textarea cols="60" rows="1" class="form-control text-left" id="ac_performance_' + j + '" placeholder="Enter Performance" name="customeraircraft[' + j + '][ac_performance]" value="" style="overflow-y: scroll;"></textarea>' +
                '</div>' +

                '<div class="row text_form_' + j + ' col-sm-11">' +
                 '<div class="col-sm-2"style="padding-right: 0px;">' +
                '<div class="form-group">' +
                '<label class="col-sm-12 col-form-label" style="font-size:initial;padding-right: 0px;">Fuel Interpolation:</label>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-9"style="padding-bottom: 10px;">' +
                '<textarea cols="30" rows="1" class="form-control text-left" id="ac_fuelinterpolation_' + j + '" placeholder="Enter FuelInterpolation" name="customeraircraft[' + j + '][ac_fuelinterpolation]" value=""  style="overflow-y: scroll;"></textarea>' +
                // '<input type="text" class="form-control text-left" id="ac_fuelinterpolation_' + j + '" placeholder="Enter FuelInterpolation" name="customeraircraft[' + j + '][ac_fuelinterpolation]"  data-value="0">' +
                '</div>' +
                '<div class="col-sm-2">' +
                '<div class="form-group">' +
                '<label class="col-sm-12 col-form-label" style="font-size: initial;">CG Multiple:</label>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-9"style="padding-bottom: 10px;">' +
                '<textarea cols="30" rows="1" class="form-control text-left" id="ac_cgmultiple_' + j + '" placeholder="Enter CGmultiple" name="customeraircraft[' + j + '][ac_cgmultiple]" value="" style="overflow-y: scroll;" data-value="0"></textarea>' +
                // '<input type="text" class="form-control text-left" id="ac_cgmultiple_' + j + '" placeholder="Enter CGmultiple" name="customeraircraft[' + j + '][ac_cgmultiple]"  data-value="0">' +
                '</div>' +
                '</div>' +
                

                '<div class="col-sm-12" style = "display:flex; justify-content: flex-end; padding-bottom:32px;padding-top: 10px;">' +
                '<button class = "btn btn-danger " type="button" id="removeac" onclick="removeAc(' + j + ')">Remove</button>' +
                '</div>' +

                // '<div class="col-sm-12 text-right">' +
                // '</div>' +
                '</div>';



            $('.acaircraft').append(ac_fields);
            l++;
            j++;
            m++;


        });

        function removeAc(value, id) {
            var delete_confirmation = confirm("Are you sure you want to delete this record ?");
            if (delete_confirmation == true) {
                $('.ac-form-' + value).remove();
            }
            if (delete_confirmation == false) {
                return false;
            }

        }
    </script>
    <script>
        function configtextvalues(id, k) {

            var config_text_data = $('.manualid').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '/allconfig',
                type: 'POST',
                cache: false,
                data: {
                    config_list: config_text_data
                },
                processData: true,
                success: function(data) {
                    $.each(JSON.parse(data), function(index, value) {

                        var configuration_values = value.config_name + ', ' + value.manufacturer_name + ', ' + value.model_name + ', ' + value.callsign + ', ' + value.remark;
                        if (configuration_values) {
                            var sepattrdata = configuration_values.replace(/null/g, "-");

                            $('.config_id_' + id + '_' + k).val(value.configurations_id);
                            $('.config_data_' + id + '_' + k).val(sepattrdata);

                        }

                        var rt = $('.config_id_' + id + '_' + k).val();

                        if (rt) {

                        } else {

                            $('.config_data_' + id + '_' + k).val();
                            $('.config_data_' + id + '_' + k).val(" ");
                            $('.manualid').css("border-color", "red");
                            $('.err').text("no data found");
                            $('.err').css({
                                "color": "white",
                                "background": "#ee2814",
                                "border": "solid red 5px"
                            });
                            $('#configurationModal').modal('show');

                        }
                    });
                    $('#configurationModal').modal('hide');
                }
            });
        }

        function cgtextvalues(id, n) {

            var cg_text_data = $('.cg_manualid').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '/allcgdata',
                type: 'POST',
                cache: false,
                data: {
                    config_list: cg_text_data
                },
                processData: true,
                success: function(data) {
                    async: false
                    console.log(data);

                    $.each(JSON.parse(data), function(index, value) {

                        var configuration_values = value.envelope_name + ', ' + value.manufacturer_name + ', ' + value.model_name + ', ' + value.remark;
                        if (configuration_values) {
                            var sepattrdata = configuration_values.replace(/null/g, "-");

                            $('.cg_id_' + id + '_' + n).val(value.envelope_id);
                            $('.cg_data_' + id + '_' + n).val(sepattrdata);

                        }

                        var rt = $('.cg_id_' + id + '_' + n).val();

                        if (rt) {

                        } else {

                            $('.cg_data_' + id + '_' + n).val();
                            $('.cg_data_' + id + '_' + n).val(" ");
                            $('.cg_manualid').css("border-color", "red");
                            $('.err_cg').text("no data found");
                            $('.err_cg').css({
                                "color": "white",
                                "background": "#ee2814",
                                "border": "solid red 5px"
                            });
                            $('#cgenvelopModal').modal('show');

                        }
                    });
                    $('#cgenvelopModal').modal('hide');
                }
            });
        }

        function add_configuration(id, k) {
            var ConfigDropdownHtml = '';
            ConfigDropdownHtml = '<button type="button" id="pop" class="btn btn-success btn1 pop_but" onchange="configvalues(' + id + ', ' + k + ');">Select your option</button>';

            var config_text = '<div class="col-sm-12">' +
                '<input type="text" class="form-control manualid" id="manualid" placeholder="Enter Id" onchange="configtextvalues(' + id + ', ' + k + ');" name="config_list"  value="">' +
                '</div>' +
                '<div class = "err d-flex justify-content-center"></div>';

            var config_lis_data = '<table id="configurations" class="display table table-stripped toggle-arrow-tiny no-footer dataTable" aria-describedby="configurations_info" role="grid" data-page-size="15">' +
                '<thead>' +
                '<tr>' +
                '<th data-orderable="true" class="sorting-icon1">ID <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon2">Config Name <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon3">Manufacturer<span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon4">Model <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon5">Callsign <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon6">Remark <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '</tr>' +
                '</thead>' +

                '<tbody>' +
                '@if(count($config_data))' +
                '@foreach($config_data as $b)' +

                '<tr>' +

                '<td class = "sorting_1 config_list_id_<?= $b->configurations_id; ?>" onclick="configvalues(' + id + ', ' + k + ',<?= $b->configurations_id ?>);" value = "{{$b->configurations_id}}"><?= $b->configurations_id ?></td>' +
                '<td><?= $b->config_name ?></td>' +
                '<td><?= $b->manufacturer_name ?></td>' +
                '<td><?= $b->model_name ?></td>' +
                '<td><?= $b->callsign ?></td>' +
                '<td><?= $b->remark ?></td>' +

                '</tr>' +

                '@endforeach' +

                '@else' +
                '<tr>' +
                '<td>Dont have any records!</td>' +
                '</tr>' +
                '@endif' +
                '</tbody>' +
                '</table>';
            $(".table_config").html(config_lis_data);
            $('.ac_config_option').html(ConfigDropdownHtml);

            $('.ac_config_text').html(config_text);

            $('#configurationModal').modal('show');
            $('#configurations').DataTable({
                orderCellsTop: true,
                lengthMenu: [25, 50, 200, 300, 500, 900, 1200, 100, 10],
                initComplete: function() {
                    this.api().columns('.select-filter').every(function() {
                        var column = this;
                        var select = $('<select class="select2"><option value="">Filter</option></select>')
                            .appendTo($(column.header()).empty())
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });
                        column.data().unique().sort().each(function(d, j) {
                            if (d !== '') {
                                select.append('<option value="' + d + '">' + d + '</option>')
                            }
                        });
                    });
                }
            });
            $('.select2').select2();
        }

        function add_cg_envelop(id, n) {
            var cgConfigDropdownHtml = '';
            cgConfigDropdownHtml =
                '<button type="button" id="pop_cg" class="btn btn-success btn1 cg_pop_but" onchange="cgenvelopvalues(' + id + ', ' + n + ');">Select your option</button>';
            var cg_en_text = '<div class = "row">' +
                '<div class="col-sm-11">' +
                '<input type="text" class="form-control cg_manualid" id="cg_manualid" placeholder="Enter Id" onchange="cgtextvalues(' + id + ', ' + n + ');" name="cg_envelop_list_data"  value="" style="margin-top: 14px;margin-left:16px;">' +
                '</div>' +
                '<div class = " col-sm-10 err_cg d-flex justify-content-center" style="position: relative; left:140px;"></div></div>';


            var cg_en_lis_data = '<table id="cgEnvelopes" class="display table table-stripped toggle-arrow-tiny" data-page-size="15">' +
                '<thead>' +
                '<tr>' +
                '<th data-orderable="true" class="sorting-icon1">ID <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon2">CG Envelope Name <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon3">Manufacturer<span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon4">Model <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '<th data-orderable="true" class="sorting-icon6">Remark <span id="orderByToggle"><i class="fa fa-sort" aria-hidden="true"></i></span></th>' +
                '</tr>' +
                '</thead>' +

                '<tbody>' +
                '@if(count($cgEnvelopes))' +
                '@foreach($cgEnvelopes as $cgEnvelopes_data)' +

                '<tr>' +
                '<td class = "cg_envelope_list_id_<?= $cgEnvelopes_data->envelope_id; ?>" onclick="cgenvelopvalues(' + id + ', ' + n + ',<?= $cgEnvelopes_data->envelope_id ?>);" value = "{{$cgEnvelopes_data->envelope_id}}"><?= $cgEnvelopes_data->envelope_id ?></td>' +
                '<td><?= $cgEnvelopes_data->envelope_name ?></td>' +
                '<td><?= $cgEnvelopes_data->manufacturer_name ?></td>' +
                '<td><?= $cgEnvelopes_data->model_name ?></td>' +
                '<td><?= $cgEnvelopes_data->remark ?></td>' +

                '</tr>' +

                '@endforeach' +

                '@else' +
                '<tr>' +
                '<td>Dont have any records!</td>' +
                '</tr>' +
                '@endif' +
                '</tbody>' +
                '</table>';
            $(".table_cg").html(cg_en_lis_data);
            $('.cg_env_option').html(cgConfigDropdownHtml);

            $('.cg_env_text').html(cg_en_text);

            $('#cgenvelopModal').modal('show');


            $('#cgEnvelopes').DataTable({
                orderCellsTop: true,
                lengthMenu: [25, 50, 200, 300, 500, 900, 1200, 100, 10],
                initComplete: function() {
                    this.api().columns('.select-filter').every(function() {
                        var column = this;
                        var select = $('<select class="select2"><option value="">Filter</option></select>')
                            .appendTo($(column.header()).empty())
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });
                        column.data().unique().sort().each(function(d, j) {
                            if (d !== '') {
                                select.append('<option value="' + d + '">' + d + '</option>')
                            }
                        });
                    });
                }
            });
            $('.select2').select2();
        }

        function configvalues(id, k, r) {

            var config_dropdowndata = $('.config_list_id_' + r).text();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '/allconfig',
                type: 'POST',
                cache: false,
                data: {
                    config_list: config_dropdowndata
                },
                processData: true,
                success: function(data) {
                    console.log(data);
                    $.each(JSON.parse(data), function(index, value) {
                        var configuration_values = value.config_name + ', ' + value.manufacturer_name + ', ' + value.model_name + ', ' + value.callsign + ', ' + value.remark;

                        if (configuration_values) {
                            var sepattrdata = configuration_values.replace(/null/g, "-");
                            var e = $('.config_id_' + id + '_' + k).val(value.configurations_id);
                            $('.config_data_' + id + '_' + k).val(sepattrdata);

                        } else {
                            var e = $('.config_id_' + id + '_' + k).val(" ");
                            $('.config_data_' + id + '_' + k).val(" ");

                        }

                    });
                    $('#configurationModal').modal('hide');
                    $('#config_pop_Modal').modal("hide");
                }
            });
        }

        function cgenvelopvalues(id, n, r) {
            var config_dropdowndata = $(".cg_envelope_list_id_" + r).text();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '/allcgdata',
                type: 'POST',
                cache: false,
                data: {
                    config_list: config_dropdowndata
                },
                processData: true,
                success: function(data) {
                    $.each(JSON.parse(data), function(index, value) {

                        var configuration_values = value.envelope_name + ', ' + value.manufacturer_name + ', ' + value.model_name + ', ' + value.remark;

                        if (configuration_values) {
                            if (value.remark == "") {
                                var configuration_values = value.envelope_name + ', ' + value.manufacturer_name + ', ' + value.model_name + ', "-"';

                            } else if (value.model_name == "") {
                                var configuration_values = value.envelope_name + ', ' + value.manufacturer_name + ', -' + value.remark;

                            }

                            var sepattrdata = configuration_values.replace(/ null/g, "-");
                            $('.cg_id_' + id + '_' + n).val(value.envelope_id);
                            $('.cg_data_' + id + '_' + n).val(sepattrdata);
                        }
                    });

                    $('#cgenvelopModal').modal('hide');
                    $('#cg_pop_Modal').modal("hide");
                }
            });
        }

        var k = <?php if (isset($list_data_info)) {
                    echo sizeof($list_data_info);
                } else { ?>0<?php } ?>;
        var n = <?php if (isset($cg_data_info)) {
                    echo sizeof($cg_data_info);
                } else { ?> 0 <?php } ?>;

        function addconfig(id) {

            var config_append = '<div class="row config-form-' + id + '_' + k + '">' +
                '<input type="text" name="customeraircraft[' + id + '][config][aircraft_config_id][]" hidden value="">' +
                '<div class="col-sm-1" style="position: absolute;">' +
                '<div class="form-group row">' +
                '<div class="col-sm-12" style="margin-left:2px;margin-top: 10px;">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-2">' +
                '<div class="form-group row">' +
                '<div class="col-sm-12">' +
                '<input type="text" readonly class="form-control text-left config_id_' + k + '_' + id + '" id="config_id_' + k + '_' + id + '" name=" customeraircraft[' + id + '][config][config_id][]" value="" onchange="configvalues(' + k + '); configtextvalues(' + k + ');" data-value="0" style="width: 64px; margin-left: 24px;">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-1">' +
                '<div class="form-group" style="margin-left: -32px;">' +
                '<div class="col-sm-8">' +
                '<button type="button" id="config_edit" class="btn btn-success btn1" onclick="editConfig2(' + id + ', ' + k +');" >View</button>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-8">' +
                '<div class="form-group row>' +
                '<div class="col-sm-12">' +
                '<input type="text" readonly class="form-control text-left config_data_' + k + '_' + id + '" id="config_data_' + k + '_' + id + '" placeholder="Enter config Data" onchange="configvalues(' + k + '); configtextvalues(' + k + ');" name="customeraircraft[' + id + '][config][config_data][]" value="" data-value="0">' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-1 text-right">' +
                '<button class = "btn btn-danger "type="button"  id="removeconfig" onclick="removeConfig(' + id + ', ' + k + ')">Remove</button>' +
                '</div>' +
                '</div>' +
                '</div>';

            $('.configuration_' + id).append(config_append);
            add_configuration(k, id);
            k++;
            $('#configurationModal').modal({
                backdrop: 'static',
                keyboard: false
            })
            // $('#configurationModal').modal('show');
        }

        function addcg(id) {
            var cg_append = '<div class="row cgenvelop-form-' + id + '_' + n + '">' +
                '<input type="text" name="customeraircraft[' + id + '][cgenvelop][aircraft_envelope_id][]" hidden value="">' +
                '<div class="col-sm-2">' +
                '<div class="form-group row">' +
                '<div class="col-sm-12">' +
                '<input type="text" readonly class="form-control text-left cg_id_' + n + '_' + id + '" id="cg_id_' + n + '_' + id + '" name="customeraircraft[' + id + '][cgenvelop][cg_id][]" value="" onchange="cgenvelopvalues(' + n + '); cgtextvalues(' + n + ');" data-value="0" style="width: 64px; margin-left: 24px;">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-1">' +
                '<div class="form-group"  style="margin-left: -32px;">' +
                '<div class="col-sm-8">' +
                '<button type="button" id="cg_edit'+ '_'  + n + '_' + id + '" class="btn btn-success btn1" onclick="editCg2(' + id + ', ' + n +');" >View</button>' + 
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-8">' +
                '<div class="form-group row">' +
                '<div class="col-sm-12">' +
                '<input type="text" readonly class="form-control text-left cg_data_' + n + '_' + id + '" id="cg_data_' + n + '_' + id + '" placeholder="Enter Cg Envelop Data" onchange="cgenvelopvalues(' + n + '); cgtextvalues(' + n + ');" name="customeraircraft[' + id + '][cgenvelop][cg_data][]" value="" data-value="0">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="col-sm-1 text-right">' +
                '<button class = "btn btn-danger "type="button"  id="removeCG" onclick="removeCG_1(' + id + ', ' + n + ');">Remove</button>' +
                '</div>' +
                '</div>';
            $('.cgenvelop_' + id).append(cg_append);
            add_cg_envelop(n, id);
            n++;
        }

        function removeCG_1(value, id) {
            var delete_confirmation = confirm("Are you sure you want to delete this record ?");
            if (delete_confirmation == true) {
                $('.cgenvelop-form-' + value + '_' + id).remove();

            } else {
                return false;
            }
        }

        function removeConfig(value, id) {
            var delete_confirmation = confirm("Are you sure you want to delete this record ?");
            if (delete_confirmation == true) {
                $('.config-form-' + value + '_' + id).remove();

            } else {
                return false;
            }
        }
        function editConfig(value, id) {
            console.log(value);
            console.log(id);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
          type: "POST",
          url: '/update_flightpaduser/' + id,
          headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
          data: $('form').serialize(),
          dataType: "json",
          success: function (json) {
           // console.log(json);
            window.location = "/config/edit/" + value ;
          },
          error: function(xhr, status, error) {
            window.location = "/config/edit/" + value ;
        }
        });
        
       // window.location = "/config/edit/" + value ;
        }

        function editConfig2(value, id){
            console.log(value);
            console.log(id);
            var sites = {!! json_encode($customer_info) !!};
            var custmer_id = sites.id;
            var fetch_id = 'config_id_';
            fetch_id = fetch_id + id + '_' + value ;
            var value2 = document.getElementById(fetch_id).value; 
            $.ajax({
            type: "POST",
            url: '/update_flightpaduser/' + custmer_id,
            data: $('form').serialize(),
            dataType: "json",
            success: function (json) {
                //console.log(json);
                window.location = "/config/edit/" + value2 ;
            },
            error: function(xhr, status, error) {
               // alert(xhr.responseText);
               window.location = "/config/edit/" + value2 ;
            }
            });
            
          //  window.location = "/config/edit/" + value2 ;
        }
        function editCg(value, id) {
        $.ajax({
          type: "POST",
          url: '/update_flightpaduser/' + id,
          data: $('form').serialize(),
          dataType: "json",
          success: function (json) {
            //console.log(json);
            window.location = "/config/edit/" + value ;
          },
          error: function(xhr, status, error) {
            //alert(xhr.responseText);
            window.location = "/config/edit/" + value ;
        }
        });
        
       // window.location = "/cgEnvelope/edit/" + value ;
        }

        function editCg2(value, id){
            var sites = {!! json_encode($customer_info) !!};
            var custmer_id = sites.id;
            var fetch_id = 'cg_id_';
            fetch_id = fetch_id + id + '_' + value ;
            var value2 = document.getElementById(fetch_id).value; 

            $.ajax({
            type: "POST",
            url: '/update_flightpaduser/' + custmer_id,
            data: $('form').serialize(),
            dataType: "json",
            success: function (json) {
                //console.log(json);
                window.location = "/config/edit/" + value2 ;
            },
            error: function(xhr, status, error) {
                //alert(xhr.responseText);
                window.location = "/config/edit/" + value2 ;
            }
            });
            
           // window.location = "/cgEnvelope/edit/" + value2 ;
        }
        $(document).on('click', '#pop', function() {
            $('#config_pop_Modal').modal("show");
        });
        $(document).on('click', '#pop_cg', function() {
            $('#cg_pop_Modal').modal("show");
        });

        function readURL(input) {

            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#blah')
                        .attr('src', e.target.result);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }


        var loadFile = function(event, i) {
            console.log("eyes");
            var id = $(".files").attr('dv');
            console.log(id);
            console.log(event);
            var output = document.getElementById('blah_' + i + '');
            output.src = URL.createObjectURL(event.target.files[0]);
            console.log(output.src);
            document.getElementById("deletetrigger").value = "false";
            $("#blah_1").show();
            output.onload = function() {
                URL.revokeObjectURL(output.src) // free memory
            }
        };
        function removelogomanifest(event, i) {
            
            var id = $(".files").attr('dv');
            var output = document.getElementById('blah_' + i + '');
            output.src = "";
            document.getElementById("deletetrigger").value = "true";
            
            $("#blah_1").hide();
            // var image_x = document.getElementById('blah_' + i + '');
            // //image_x.parentNode.removeChild(image_x);
            // image_x.src = "";
        };
        window.addEventListener( "pageshow", function ( event ) {
    var historyTraversal = event.persisted || 
    ( typeof window.performance != "undefined" && 
        window.performance.navigation.type === 2 );
    if ( historyTraversal ) {
      // Handle page restore.
      window.location.reload();
    }
  });
    </script>

    @endsection