@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
    <div class="container-fluid">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                <a href="#">
                  Add New FlightPadAircraft
                </a></li>
                </li>
            </ol>
        </nav>
    </div>
</div>
      <form action="{{route('store_flightpadaircraft')}}" method="post" autocomplete="off">
      @csrf
      <div class="ibox bg-boxshadow min-height mb-50">
        <div class="row user-form">
          <div class="col-sm-6">
            <div class="form-group row">
              <label class="col-sm-12 col-form-label">Image Name</label>
              <div class="col-sm-12">
                  <input type="text" class="form-control" id="image" name="image">
                  @if ($errors->has('image'))
                      <div class="error" style="color: red">{{ $errors->first('image') }}</div>
                  @endif
              </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Category</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="category" name="category">
                    @if ($errors->has('category'))
                        <div class="error" style="color: red">{{ $errors->first('category') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">ID Backend</label>
                <div class="col-sm-12">
                   <input type="text" class="form-control" id="id_backend" name="id_backend">
                    @if ($errors->has('id_backend'))
                        <div class="error" style="color: red">{{ $errors->first('id_backend') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Type</label>
                <div class="col-sm-12">
                <select class="form-control" id="type" name="type">
                @foreach($types as $type)
                  <option value="{{$type->aircraft_name}}">{{$type->aircraft_name}}</option>
                @endforeach
                </select>
                    <!-- <input type="text" class="form-control" id="type" name="type"> -->
                  @if ($errors->has('type'))
                      <div class="error" style="color: red">{{ $errors->first('type') }}</div>
                  @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Manufacturer</label>
                <div class="col-sm-12">
                <input type="text" class="form-control" id="manufacturer" name="manufacturer" value="{{@$flight_pad_aircraft->manufacturer}}">
                    @if ($errors->has('manufacturer'))
                        <div class="error" style="color: red">{{ $errors->first('manufacturer') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Model</label>
                <div class="col-sm-12">
                <input type="text" class="form-control" id="model" name="model" value="{{@$flight_pad_aircraft->model}}">
                    @if ($errors->has('model'))
                        <div class="error" style="color: red">{{ $errors->first('model') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Display Manufacturer</label>
                <div class="col-sm-12">
                 <input type="text" class="form-control" id="display_manufacturer" name="display_manufacturer" value="{{@$flight_pad_aircraft->display_manufacturer}}">
                    @if ($errors->has('display_manufacturer'))
                        <div class="error" style="color: red">{{ $errors->first('display_manufacturer') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Display Name</label>
                <div class="col-sm-12">
                 <input type="text" class="form-control" id="display_name"  name="display_name" value="{{@$flight_pad_aircraft->display_name}}">
                    @if ($errors->has('display_name'))
                        <div class="error" style="color: red">{{ $errors->first('display_name') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Variant</label>
                <div class="col-sm-12">
                 <input type="text" class="form-control" id="variant" name="variant" value="NONE">
                    @if ($errors->has('variant'))
                        <div class="error" style="color: red">{{ $errors->first('variant') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Call Sign</label>
                <div class="col-sm-12">
                 <input type="text" class="form-control" id="call_sign" name="call_sign" value="noReg">
                    @if ($errors->has('call_sign'))
                        <div class="error" style="color: red">{{ $errors->first('call_sign') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Unit</label>
                <div class="col-sm-12">
                <select class="form-control" id="unit" name="unit">
                  <option value="kg">kg</option>
                  <option value="lbs">lbs</option>
                </select>
                    @if ($errors->has('unit'))
                        <div class="error" style="color: red">{{ $errors->first('unit') }}</div>
                    @endif
                </div>
            </div>
          </div>
         <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">BEW</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="bew" name="bew" value="{{@$flight_pad_aircraft->bew}}">
                    @if ($errors->has('bew'))
                        <div class="error" style="color: red">{{ $errors->first('bew') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Moment Lat</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="moment_lat" name="moment_lat" value="{{@$flight_pad_aircraft->moment_lat}}">
                    @if ($errors->has('moment_lat'))
                        <div class="error" style="color: red">{{ $errors->first('moment_lat') }}</div>
                    @endif
                </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Moment Long</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="moment_long" name="moment_long" value="{{@$flight_pad_aircraft->moment_long}}">
                    @if ($errors->has('moment_long'))
                        <div class="error" style="color: red">{{ $errors->first('moment_long') }}</div>
                    @endif
                </div>
            </div>
          </div>
           <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">MTOW</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="mtow" name="mtow" value="{{@$flight_pad_aircraft->mtow}}">
                    @if ($errors->has('mtow'))
                        <div class="error" style="color: red">{{ $errors->first('mtow') }}</div>
                    @endif
                </div>
            </div>
          </div>
           <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Max Fuel</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="max_fuel" name="max_fuel" value="{{@$flight_pad_aircraft->max_fuel}}">
                    @if ($errors->has('max_fuel'))
                        <div class="error" style="color: red">{{ $errors->first('max_fuel') }}</div>
                    @endif
                </div>
            </div>
          </div>
           <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Description Line1</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="description_line1" name="description_line1" value="{{@$flight_pad_aircraft->description_line1}}">
                    @if ($errors->has('description_line1'))
                        <div class="error" style="color: red">{{ $errors->first('description_line1') }}</div>
                    @endif
                </div>
            </div>
          </div>
           <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Description Line2</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="description_line2" name="description_line2" value="{{@$flight_pad_aircraft->description_line1}}">
                    @if ($errors->has('description_line1'))
                        <div class="error" style="color: red">{{ $errors->first('description_line1') }}</div>
                    @endif
                </div>
            </div>
          </div>
           <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Version</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="version" name="version" value="{{@$flight_pad_aircraft->version}}">
                    @if ($errors->has('version'))
                        <div class="error" style="color: red">{{ $errors->first('version') }}</div>
                    @endif
                </div>
            </div>
          </div>
           <div class="col-sm-6">
            <div class="form-group row">
                <label class="col-sm-12 col-form-label">Internal Remarks</label>
                <div class="col-sm-12">
                    <input type="text" class="form-control" id="internal_remarks" name="internal_remarks" value="{{@$flight_pad_aircraft->internal_remarks}}">
                    @if ($errors->has('internal_remarks'))
                        <div class="error" style="color: red">{{ $errors->first('internal_remarks') }}</div>
                    @endif
                </div>
            </div>
          </div>
      </div>
      <button type="submit" class="btn btn-primary" id="subbtn">Submit</button>
    </div>
    </form>
    <br /><br /><br /><br />
    <br /><br /><br /><br />
@endsection
@section('script')
<script src="{{asset('/js/plugins-js/fselect-js/fselect.js')}}"></script>

@endsection
