<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsInUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->timestamp('email_verified_at')->nullable()->after('email');
            $table->string('encrypted_password')->after('password');
            $table->text('configurations')->after('remember_token');
            $table->string('customer_data',500)->after('configurations');
            $table->string('user_fleet_control_id',500)->after('customer_data');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('email_verified_at');
            $table->dropColumn('encrypted_password');
            $table->dropColumn('configurations');
            $table->dropColumn('customer_data');
            $table->dropColumn('user_fleet_control_id');
        });
    }
}
