<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAircraftTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('airCraft', function (Blueprint $table) {
            $table->increments('ac_id',10);
            $table->integer('aircraft_type')->nullable();
            $table->integer('manufacturer');
            $table->integer('model');
            $table->integer('variant');
            $table->text('remark');
            $table->datetime('created_at');
            $table->datetime('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('airCraft');
    }
}
