<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class UpdateMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('menus', function (Blueprint $table) {
            $table->dropColumn('roles')->nullable();
        });
        Schema::create('menu_role', function (Blueprint $table) {
            $table->integer('menu_id')->unsigned()->index();
            // $table->foreign('menu_id')->references('id')->on('menus')->onDelete('cascade');
            $table->integer('role_id')->unsigned()->index();
            // $table->foreign('role_id')->references('id')->on('roles')->onDelete('cascade');
            $table->unique(['menu_id', 'role_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('menu_role');
        Schema::table('menus', function (Blueprint $table) {
            $table->string('roles')->nullable()->after('parent_id');
        });
    }
}
