<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Redirect;
use Schema;
use DB;
use App\User;
use App\Http\Requests\CreateListingRequest;
use App\Http\Requests\UpdateListingRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Traits\FileUploadTrait;
use Illuminate\Support\Facades\Input;
use App\Http\Requests\UserRequest;
use Auth;
use Hash;

class UserListingController extends Controller {

    public function index() {
      $user = Auth::user();
      $roleId = $user->role_id;
      $userId = $user->id;

      $user = DB::table('users')
                      ->select('users.id', 'users.first_name', 'users.last_name', 'users.email', 'users.role_id', 'users.configurations', 'roles.title')
                      ->leftJoin('roles', 'roles.id', '=', 'users.role_id')
                      ->when($roleId === 2, function ($query) use($userId) {
                         return $query->where('users.id', $userId);
                       })
                      ->get();

      for ($x =0; $x < sizeof($user); $x ++) {
        $prefix = $grantedList = '';
        if($user[$x]->configurations) {
          $grantedIds = explode(',', $user[$x]->configurations);
          $getGrantedData = DB::table('configurations')
                              ->select('configurations_id', 'config_name')
                              ->whereIn('configurations_id', $grantedIds)
                              ->get();

          for ($j=0; $j < sizeof($getGrantedData); $j++) {
            $grantedList .= $prefix . '' . $getGrantedData[$j]->configurations_id . ". " . $getGrantedData[$j]->config_name;
            $prefix = str_repeat("&nbsp;", 10);
          }
        }
        $user[$x]->granted = $grantedList;
      }

      return view('admin.users.userlist', compact('user'));
    }

    public function create() {
      $roles = DB::table('roles')->get();
      if(Auth::user()->role_id == 1){
        $roles = array_except($roles,[2]);
      }
      $configurations = DB::table('configurations')->select('configurations_id', 'config_name')->get();
      return view('admin.users.create', compact('roles', 'configurations'));
    }

    public function store(UserRequest $request, User $user) {
        $all = $request->all();
        $file = Input::file('image');

        if (Input::hasFile('image')) {
            $fileName = time().'.'.request()->image->getClientOriginalExtension();
            $file->move('img/', $fileName);
            $all['image'] = $fileName;
        } else {
          $all['image'] = '';
        }

        $ids = '';
        if($all['role_id'] == 2) {
          if(isset($all['configurations'])) {
            $ids = implode(',', $all['configurations']);
          }
        }
        $all['configurations'] = $ids;

        if (is_null($all['image'])) {}
        $all['password'] = bcrypt($all['password']);

        $all['customer_data'] = ($all['customer_data'] == "") ? "" : $all['customer_data'];
        $all['user_fleet_control_id'] = ($all['user_fleet_control_id'] == "") ? "" : $all['user_fleet_control_id'];

        User::create($all);
        return redirect('/user');
    }

    public function show(User $user,$id){
    	$user = User::findOrFail($id);
        return view('admin.users.view',['user'=>$user]);
    }

    public function edit(User $user,$id){
        $user = User::findOrFail($id);
        $roles = DB::table('roles')->get();
        $configurations = DB::table('configurations')->select('configurations_id', 'config_name')->get();
        $grantedConfigurations = [];
        if($user->configurations) {
          $grantedConfigurations = explode(',', $user->configurations);
        }
        return view('admin.users.create', compact('user', 'roles', 'configurations', 'grantedConfigurations'));
    }

    public function update(UserRequest $request, User $user,$id) {
      $user = User::find($id);
      $all = $request->all();
      $file = Input::file('image');

        if (Input::hasFile('image')) {
          $fileName = time().'.'.request()->image->getClientOriginalExtension();
          $file->move('img/', $fileName);
          $all['image'] = $fileName;
        } else {
          $all['image'] = $user->image;
        }

        $ids = '';
        if(isset($all['role_id'])) {
          if($all['role_id'] == 2 && isset($all['configurations'])) {
            $ids = implode(',', $all['configurations']);
          }
        }
        $all['configurations'] = $ids;

        if($all['password']) {
          $all['password'] = bcrypt($all['password']);
        }

        $all['customer_data'] = ($all['customer_data'] == "") ? "" : $all['customer_data'];
        $all['user_fleet_control_id'] = ($all['user_fleet_control_id'] == "") ? "" : $all['user_fleet_control_id'];

        $user->update($all);
        return redirect('/user');
    }

    public function checkPassowrdChanged(Request $request){
      $pass = $request->password;
      if(!(Hash::check($pass, Auth::user()->password))){
         return "1";
      } else {
         return "0";
      } 
   }

    public function destroy(User $user,$id) {
        DB::table('users')->where('id', $id)->delete();
        return redirect('/user');
    }

}
