<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Redirect;
use Schema;
use App\Listing;
use App\Http\Requests\CreateListingRequest;
use App\Http\Requests\UpdateListingRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Traits\FileUploadTrait;


class ListingController extends Controller {

	/**
	 * Display a listing of listing
	 *
     * @param Request $request
     *
     * @return \Illuminate\View\View
	 */
	public function index(Request $request)
    {
        $listing = Listing::all();

		return view('admin.listing.index', compact('listing'));
	}

	/**
	 * Show the form for creating a new listing
	 *
     * @return \Illuminate\View\View
	 */
	public function create()
	{
	    return view('admin.listing.create');
	}

	/**
	 * Store a newly created listing in storage.
	 *
     * @param CreateListingRequest|Request $request
	 */
	public function store(CreateListingRequest $request)
	{
	    $request = $this->saveFiles($request);
			Listing::create($request->all());

			return redirect()->route(config('quickadmin.route').'.listing.index');
	}

	public function user_list()
	{
	   return view('admin.layouts.user_list');
	}

	/**
	 * Show the form for editing the specified listing.
	 *
	 * @param  int  $id
     * @return \Illuminate\View\View
	 */
	public function edit($id)
	{
		$listing = Listing::find($id);

		return view('admin.listing.edit', compact('listing'));
	}

	/**
	 * Update the specified listing in storage.
     * @param UpdateListingRequest|Request $request
     *
	 * @param  int  $id
	 */
	public function update($id, UpdateListingRequest $request)
	{
			$listing = Listing::findOrFail($id);
      $request = $this->saveFiles($request);
			$listing->update($request->all());

			return redirect()->route(config('quickadmin.route').'.listing.index');
	}

	/**
	 * Remove the specified listing from storage.
	 *
	 * @param  int  $id
	 */
	public function destroy($id)
	{
		Listing::destroy($id);

		return redirect()->route(config('quickadmin.route').'.listing.index');
	}

    /**
     * Mass delete function from index page
     * @param Request $request
     *
     * @return mixed
     */
    public function massDelete(Request $request)
    {
        if ($request->get('toDelete') != 'mass') {
            $toDelete = json_decode($request->get('toDelete'));
            Listing::destroy($toDelete);
        } else {
            Listing::whereNotNull('id')->delete();
        }

        return redirect()->route(config('quickadmin.route').'.listing.index');
    }

}
