<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Redirect;
use Schema;
use App\User;
use App\Configurations;
use App\Cg_envelope;
use App\Http\Requests\CreateListingRequest;
use App\Http\Requests\UpdateListingRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\Traits\GetDropdownValueFromDBTrait;
use DB;
use App\Http\Requests\ConfigRequest;
use App\Http\Requests\CGEnvelopeRequest;
use App\Variant;
use App\Configuration_image;
use App\Cg_envelope_data;
use App\Item;
use Config;
use Auth;

class CGEnvelopeController extends Controller {

    use GetDropdownValueFromDBTrait;

    public function index() {
        $cgEnvelopes = DB::table('cg_envelopes')
                          ->select('envelope_id', 'is_locked', 'envelope_name', 'variant.variant_name', 'remark', 'manufacturer_name', 'model_name')
                          ->leftJoin('variant', 'cg_envelopes.variant', '=', 'variant.variant_id')
                          ->leftJoin('manufacturer', 'manufacturer.id', '=', 'cg_envelopes.manufacturer')
                          ->leftJoin('model', 'model.id', '=', 'cg_envelopes.model')
                          ->get();

        return view('admin.CGEnvelope.list', compact('cgEnvelopes'));
    }

    public function create() {
        $aircraft = DB::table('aircraft_type')->get();
        $manufacturer = $this->getManufacturer();
        $variant = $this->getVariant();
        $model = $this->getModel();

        return view('admin.CGEnvelope.create', compact('manufacturer', 'variant', 'aircraft', 'model'));
    }

    public function store(CGEnvelopeRequest $request, Configurations $config) {
        $all = $request->all();
        $all['box_width'] = 450;
        $all['box_height'] = 400;
        $all['unit'] = 'kg';
        $all['remark'] = empty($all['remark']) ? '' : $all['remark'];
        $data = Cg_envelope::create($all);
        return redirect('/cgEnvelope/edit/'.$data->id);
    }

    public function edit($id) {
        $envelope = DB::table('cg_envelopes')
                        ->where('cg_envelopes.envelope_id', $id)
                        ->first();
        if (!$envelope) { abort(404); }

        $manufacturer = DB::table('manufacturer')->get();
        $aircraft = DB::table('aircraft_type')->get();
        $variant = DB::table('variant')->get();
        $model = DB::table('model')->get();

        return view('admin.CGEnvelope.edit', compact('manufacturer', 'variant', 'aircraft', 'model', 'envelope'));
    }

    public function envelopePoints($id){
      $envelope_data = Cg_envelope_data::select('x_value','y_value')->where('envelope_id', '=', $id)->get();
      return $envelope_data;
    }

    public function copy($id) {
      $last = Cg_envelope::orderBy('envelope_id', 'desc')->first();
      $cloneId = $last->envelope_id + 1;
      $envelope = Cg_envelope::where('envelope_id', '=', $id)->first();
      $cloneConfig = $envelope->replicate();
      $cloneConfig->envelope_id = $cloneId;
      $cloneConfig->envelope_name .= '_copy';
      $cloneConfig->is_locked = 1;
      $cloneConfig->save();

      $envelope_datas = DB::table('cg_envelope_data')
                      ->where('envelope_id', $id)
                      ->get();

      foreach($envelope_datas as $envelope_data) {
        $cloneData = [
          'envelope_id' => $cloneId,
          'x_value' => $envelope_data->x_value,
          'y_value' => $envelope_data->y_value,
        ];
        DB::table('cg_envelope_data')->insert($cloneData);
      }

      return redirect('/cgEnvelope');
    }

    public function update(CGEnvelopeRequest $request, $id) {
        $data = request()->except(['_token','x_value','y_value','dps']);
        $data['remark'] = empty($data['remark']) ? '' :  $data['remark'];

        DB::table('cg_envelopes')
                ->where('envelope_id', $id)
                ->update($data);
        $syncDps = json_decode($request->dps);
        DB::table('cg_envelope_data')->where('envelope_id', $id)->delete();
        foreach ($syncDps as $key => $value) {
          DB::table('cg_envelope_data')->insert(
              ['envelope_id' => $id, 'x_value' => $value->x, 'y_value' => $value->y]);
        }
        return response()->json([
             'status' => 'success',
             'message' => 'Successfully saved'
        ]);
    }

    public function destroy($id) {
       DB::table('cg_envelopes')->where('envelope_id', $id)->delete();
    }

    public function lockUnlockState(Request $request, $id, $is_locked){
      $stateVal = ($is_locked == 1) ? 0 : 1;
      DB::table('cg_envelopes')->where('envelope_id',$id)->update(array('is_locked' => $stateVal));
      return redirect('/cgEnvelope');
    }
/**
   * @OA\Get( path="/api/cgEnvelopenew/{id}",
   * summary = "to get response from database",
   *  tags={"Flightpad"},
   *     @OA\Parameter(
   *        name="id", in="path",required=true, 
   *          @OA\Schema(type="integer",)
   *     ),
   *      @OA\Parameter(
   *        name="AppKey", in="header",required=true, 
   *          @OA\Schema(type="string",)
   *     ),

   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */
    public function getCgEnvelopesnew(Request $request, $id){

    //   $appkey = $request->header('AppKey');
    //   $userAppkey= config('constants.AuthKey');
      
    //  if($userAppkey == $appkey){
      $cgEnvelopes = DB::table('cg_envelopes')
                      ->select(
                          'envelope_name',
                          'aircraft_name AS aircraft_type ',
                          'manufacturer_name',
                          'model_name',
                          'variant_name',
                          'box_width',
                          'remark',
                          'unit',
                          'x_min',
                          'x_max',
                          'y_min',
                          'y_max',
                          'x_line',
                          'y_line'
                        )
                      ->leftJoin('aircraft_type', 'cg_envelopes.aircraft_type', '=', 'aircraft_type.aircraft_id')
                      ->leftJoin('manufacturer', 'cg_envelopes.manufacturer', '=', 'manufacturer.id')
                      ->leftJoin('model', 'cg_envelopes.model', '=', 'model.id')
                      ->leftJoin('variant', 'cg_envelopes.variant', '=', 'variant.variant_id')
                      ->where('envelope_id', $id)->first();
 
        $cgEnvelopesLogs = DB::table('cg_envelope_data')
                            ->select(
                                'x_value',
                                'y_value'
                              )
                            ->leftJoin('cg_envelopes', 'cg_envelope_data.envelope_id', '=', 'cg_envelopes.envelope_id')
                            ->where('cg_envelope_data.envelope_id', $id)
                            ->get();
          $response = array(
            'cg_envelope' => $cgEnvelopes ? $cgEnvelopes : '',
            'points' => $cgEnvelopesLogs,
          );
        // }else {
        //   $response['fail'] = 'authentication fail';
        // }
          return json_encode($response);
        
    }

    /**
   * @OA\Get( path="/api/cgEnvelope/{id}",
   * summary = "to get response from database",
   *  tags={"unsecure Api"},
   *     @OA\Parameter(
   *        name="id", in="path",required=true, 
   *          @OA\Schema(type="integer",)
   *     ),

   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */
    public function getCgEnvelopes(Request $request, $id){

     
      $cgEnvelopes = DB::table('cg_envelopes')
                      ->select(
                          'envelope_name',
                          'aircraft_name AS aircraft_type ',
                          'manufacturer_name',
                          'model_name',
                          'variant_name',
                          'box_width',
                          'remark',
                          'unit',
                          'x_min',
                          'x_max',
                          'y_min',
                          'y_max',
                          'x_line',
                          'y_line'
                        )
                      ->leftJoin('aircraft_type', 'cg_envelopes.aircraft_type', '=', 'aircraft_type.aircraft_id')
                      ->leftJoin('manufacturer', 'cg_envelopes.manufacturer', '=', 'manufacturer.id')
                      ->leftJoin('model', 'cg_envelopes.model', '=', 'model.id')
                      ->leftJoin('variant', 'cg_envelopes.variant', '=', 'variant.variant_id')
                      ->where('envelope_id', $id)->first();
 
        $cgEnvelopesLogs = DB::table('cg_envelope_data')
                            ->select(
                                'x_value',
                                'y_value'
                              )
                            ->leftJoin('cg_envelopes', 'cg_envelope_data.envelope_id', '=', 'cg_envelopes.envelope_id')
                            ->where('cg_envelope_data.envelope_id', $id)
                            ->get();
          $response = array(
            'cg_envelope' => $cgEnvelopes ? $cgEnvelopes : '',
            'points' => $cgEnvelopesLogs,
          );
          return json_encode($response);
        }
    

    
}
