<?php $__env->startSection('content'); ?>
<div class="breadcrumb-area">
    <div class="container-fluid">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                <a href="#">
                  <?php if(isset($user)): ?>
                    Edit User
                  <?php else: ?>
                    Create User
                  <?php endif; ?>
                </a></li>
                </li>
            </ol>
        </nav>
    </div>
</div>
            <?php if(isset($user)): ?>
            <?php echo e(Form::open(array('route' => ['update',$user->id],'files'=>true, 'id'=> 'updateUser'))); ?>

            <?php endif; ?>
            <?php echo e(Form::open(array('route' => 'store','files'=>true))); ?>

            <div class="ibox bg-boxshadow min-height mb-50">
              <div class="row user-form">
                <div class="col-sm-6">
                  <div class="form-group row">
                    <label class="col-sm-12 col-form-label">First Name</label>
                    <div class="col-sm-12">
                        <input type="text" class="form-control" id="fnm" placeholder="Enter first name" name="first_name" value="<?php echo e(@$user->first_name); ?>">
                        <?php if($errors->has('first_name')): ?>
                            <div class="error" style="color: red"><?php echo e($errors->first('first_name')); ?></div>
                        <?php endif; ?>
                    </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Last Name</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="lnm" placeholder="Enter last name" name="last_name" value="<?php echo e(@$user->last_name); ?>">
                          <?php if($errors->has('last_name')): ?>
                              <div class="error" style="color: red"><?php echo e($errors->first('last_name')); ?></div>
                          <?php endif; ?>
                      </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Address</label>
                      <div class="col-sm-12">
                        <textarea class="form-control" id="address" placeholder="Enter address" name="address"><?php echo e(@$user->address); ?></textarea>
                          <?php if($errors->has('address')): ?>
                              <div class="error" style="color: red"><?php echo e($errors->first('address')); ?></div>
                          <?php endif; ?>
                      </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Email</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="email" placeholder="Enter Email Id" name="email" value="<?php echo e(@$user->email); ?>">
                          <?php if($errors->has('email')): ?>
                              <div class="error" style="color: red"><?php echo e($errors->first('email')); ?></div>
                          <?php endif; ?>
                      </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Password</label>
                      <div class="col-sm-12">
                          <input type="password" class="form-control" id="pwd" placeholder="Enter New Password" name="password">
                          <?php if($errors->has('password')): ?>
                              <div class="error" style="color: red"><?php echo e($errors->first('password')); ?></div>
                          <?php endif; ?>
                      </div>
                  </div>
                </div>
                <?php if(!isset($user)): ?>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Confirm  Password</label>
                      <div class="col-sm-12">
                          <input id="password-confirm" type="password" class="form-control" name="password_confirmation" placeholder="Enter Confirm Password">
                          <?php if($errors->has('confirm password')): ?>
                              <div class="error" style="color: red"><?php echo e($errors->first('confirm password')); ?></div>
                          <?php endif; ?>
                      </div>
                  </div>
                </div>
                <?php endif; ?>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Phone</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="phone" placeholder="Enter phone" name="phone" value="<?php echo e(@$user->phone); ?>">
                          <?php if($errors->has('phone')): ?>
                              <div class="error" style="color: red"><?php echo e($errors->first('phone')); ?></div>
                          <?php endif; ?>
                      </div>
                  </div>
                </div>
                <div class="col-sm-6" style="display:none">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Language</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="language" placeholder="Enter language" name="language" value="<?php echo e(@$user->language); ?>">
                          <?php if($errors->has('language')): ?>
                              <div class="error" style="color: red"><?php echo e($errors->first('language')); ?></div>
                          <?php endif; ?>
                      </div>
                  </div>
                </div>
                <div class="col-sm-6" style="display:none">
                  <div class="form-group row">
                    <label class="col-sm-12 col-form-label" for="image">Image</label>
                    <div class="col-sm-12">
                      <?php echo Form::file('image', array('class' => 'form-control')); ?>

                      <?php if($errors->has('image')): ?>
                        <div class="error" style="color: red"><?php echo e($errors->first('image')); ?></div>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
                <?php if(Auth::user()->role_id === 1 || Auth::user()->role_id === 3): ?>
                  <div class="col-sm-6">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">User Type</label>
                      <div class="col-sm-12">
                        <select data-style="btn-select-tag" class="form-control mb-15 user-type" name="role_id">
                          <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php ($selected = ''); ?>
                              <?php if(isset($user) && $role->id == $user->role_id): ?>
                                <?php ($selected = 'selected'); ?>
                              <?php endif; ?>
                              <option <?php echo e($selected); ?> value="<?php echo e($role->id); ?>"><?php echo e($role->title); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Customer Data</label>
                      <div class="col-sm-12">
                        <input type="text" class="form-control" placeholder="Enter customer data" name="customer_data" value="<?php echo e(@$user->customer_data); ?>">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">User Fleet Control Id</label>
                      <div class="col-sm-12">
                        <input type="text" class="form-control" placeholder="Enter user fleet control id" name="user_fleet_control_id" value="<?php echo e(@$user->user_fleet_control_id); ?>">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6 access-configurations">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Configurations</label>
                      <div class="col-sm-12">
                        <?php if(count($configurations)): ?>
                          <select name="configurations[]" class="selectpicker form-control mb-15 configurations" multiple="multiple">
                              <?php $__currentLoopData = $configurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <?php ($selected = ''); ?>
                                  <?php if(isset($grantedConfigurations) && in_array($config->configurations_id, $grantedConfigurations)): ?>
                                    <?php ($selected = 'selected'); ?>
                                  <?php endif; ?>
                                  <option <?php echo e($selected); ?> value="<?php echo e($config->configurations_id); ?>"><?php echo e($config->configurations_id); ?>. <?php echo e($config->config_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </select>
                        <?php else: ?>
                          <div class="alert alert-dark-warning">You don't have any configurations!</div>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
          </div>
          <?php echo e(Form::close()); ?>

          <br /><br /><br /><br />
          <br /><br /><br /><br />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('/js/plugins-js/fselect-js/fselect.js')); ?>"></script>
<script type="text/javascript">
$(document).ready(function() {
  check($('.user-type').val());
  $('.configurations').fSelect();
  $('.user-type').change(function() {
    check($(this).val());
  });


  $(document).on("submit", '#updateUser', function(e) {

    var pwd = $('#pwd').val();
    var data = {
        password : pwd
      }
    $.ajax({
          type: "GET",
          url: '/checkPassowrdChanged',
          data: data,
          dataType: "json",
          success: function (json) {
            updateUserData(json);
          },
          error: function () {
            
          }
      });


    
  });

  function updateUserData(pwd){
      
    if(pwd == 1){
      alert("Change password? Are you sure?");
    }

    var form = $('#updateUser');
     e.preventDefault();
     $.ajaxSetup({
       headers: {
         'X-CSRF-TOKEN':  $('meta[name="csrf-token"]').attr('content')
       }
     });
     $.ajax({
        type: "POST",
        cache: false,
        url: form.attr('action'),
        data: form.serialize(),
        processData: true,
        dataType: "json",
    });
      
  }

  function check(val) {
    if(val == 1) {
      $('.access-configurations').hide();
    } else {
      $('.access-configurations').show();
    }
  }

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>