<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
   return view('auth/login');
})->name('login');

Auth::routes();

Route::group(['middleware' => ['auth']], function() {
  Route::get('/user', 'Admin\UserListingController@index')->name('user');
  Route::get('/create', 'Admin\UserListingController@create')->name('create')->middleware(['admin']);
  Route::get('/edit/{edit}', 'Admin\UserListingController@edit')->name('edit');
  Route::get('/show/{show}', 'Admin\UserListingController@show')->name('show');
  Route::post('/update/{update}', 'Admin\UserListingController@update')->name('update');
  Route::get('/delete/{delete}', 'Admin\UserListingController@destroy')->name('delete')->middleware(['admin']);
  Route::get('/checkPassowrdChanged', 'Admin\UserListingController@checkPassowrdChanged')->name('checkPassowrdChanged');

  Route::post('/store', 'Admin\UserListingController@store')->name('store');

  Route::get('/components/{id}', 'Admin\ConfigurationsController@getComponents')->name('components');
  Route::post('/orderComponents', 'Admin\ConfigurationsController@orderComponents')->name('orderComponents');

  Route::get('/config', 'Admin\ConfigurationsController@index')->name('config');
  Route::any('/config2', 'Admin\ConfigurationsController@index2')->name('config2');
  Route::get('/config/create', 'Admin\ConfigurationsController@create')->name('config/create')->middleware(['admin']);
  Route::get('/config/edit/{edit}', 'Admin\ConfigurationsController@edit')->name('config/edit');
  Route::get('/config/copy/{copy}', 'Admin\ConfigurationsController@copy')->name('config/copy')->middleware(['admin']);
  Route::post('/config/update/{update}', 'Admin\ConfigurationsController@update')->name('config/update');
  Route::post('/config/undoChanges', 'Admin\ConfigurationsController@undoChanges')->name('config/undoChanges');
  Route::delete('/config/delete/{delete}', 'Admin\ConfigurationsController@destroy')->name('config/delete')->middleware(['admin']);
  Route::get('/config/editacdata/{id}', 'Admin\ConfigurationsController@editacdata')->name('config/editacdata');
  
  Route::get('/config/updateallacdata/{id}', 'Admin\ConfigurationsController@updateallacdata')->name('config/updateallacdata');

  Route::post('/config/store', 'Admin\ConfigurationsController@store')->name('config/store');
  Route::get('/config/setting', 'Admin\ConfigurationsController@setting')->name('config/setting')->middleware(['admin']);
  Route::get('/config/displaydata', 'Admin\ConfigurationsController@displaydata')->name('config/displaydata')->middleware(['admin']);

  Route::get('/flightpadApi', 'Admin\SwagController@swag')->name('config/swage')->middleware(['admin']);
  Route::get('/Api', 'Admin\SwagController@SwaggerUI')->name('config/SwaggerUI')->middleware(['admin']);
  
  Route::post('/config/storeallacdata', 'Admin\ConfigurationsController@storeallacdata')->name('storeallacdata');

  //flightpadusers 
  Route::post('/getFeatures', 'Admin\FlightpadusersController@getFeatures')->name('getFeatures');
  Route::any('/getcustomername', 'Admin\FlightpadusersController@getcustomername')->name('getcustomername')->middleware(['admin']);
  Route::any('/getcustomer', 'Admin\FlightpadusersController@getcustomer')->name('getcustomer')->middleware(['admin']);
  Route::get('/add_customers','Admin\FlightpadCustomerController@create')->name('add_customer')->middleware(['admin']);
  Route::post('/store_customers','Admin\FlightpadCustomerController@store')->name('store_customer')->middleware(['admin']);
  Route::post('/delete_customers','Admin\FlightpadCustomerController@destroy')->name('delete_customer')->middleware(['admin']);
  Route::get('/edit_flightpadcustomer/{id}','Admin\FlightpadCustomerController@editFlightpadCustomer')->name('edit_flightpadcustomer')->middleware(['admin']);
  Route::post('/update_flightpadCustomer/{id}','Admin\FlightpadCustomerController@update')->name('update_flightpadCustomer')->middleware(['admin']);

  Route::any('/flightpadusers', 'Admin\FlightpadusersController@flightpadusers')->name('flightpadusers')->middleware(['admin']);
  // flightpadusers
  Route::get('/edit_flightpaduser/{edit}','Admin\FlightpadusersController@editFlightpaduser')->name('edit_flightpaduser')->middleware(['admin']);
  Route::get('/add_flightpaduser','Admin\FlightpadusersController@addFlightpaduser')->name('add_flightpaduser')->middleware(['admin']);

  Route::post('/allconfig','Admin\FlightpadusersController@getallconfig')->name('getallconfig')->middleware(['admin']);
  Route::post('/allcgdata','Admin\FlightpadusersController@getallcgdata')->name('getallcgdata')->middleware(['admin']);
  Route::post('/store_flightpaduser','Admin\FlightpadusersController@storeFlightpaduser')->name('store_flightpaduser')->middleware(['admin']);

  Route::post('/delete_flightpaduser','Admin\FlightpadusersController@deleteFlightpaduser')->name('delete_flightpaduser')->middleware(['admin']);

  Route::post('/update_flightpaduser/{id}','Admin\FlightpadusersController@updateFlightPadUser')->name('update_flightpaduser')->middleware(['admin']);

  Route::post('/change_row_order','Admin\FlightpadusersController@changeRowOrder')->name('change_row_order')->middleware(['admin']);

  Route::any('/flightpadaircrafts', 'Admin\FlightpadaircraftController@flightpadaircrafts')->name('flightpadaircrafts')->middleware(['admin']);

  Route::any('/add_flightpadaircraft', 'Admin\FlightpadaircraftController@createFlightpadaircraft')->name('add_flightpadaircraft')->middleware(['admin']);

Route::any('/store_flightpadaircraft', 'Admin\FlightpadaircraftController@storeFlightpadaircraft')->name('store_flightpadaircraft')->middleware(['admin']);

Route::post('/delete_flightpadaircraft','Admin\FlightpadaircraftController@deleteFlightpadaircraft')->name('delete_flightpadaircraft')->middleware(['admin']);

  Route::post('/edit_flightpadaircraft','Admin\FlightpadaircraftController@editFlightpadaircraft')->name('edit_flightpadaircraft')->middleware(['admin']);

Route::post('/update_flightpadaircraft','Admin\FlightpadaircraftController@updateFlightPadAircraft')->name('update_flightpadaircraft')->middleware(['admin']);

Route::post('/change_row_orders','Admin\FlightpadaircraftController@changeRowOrders')->name('change_row_orders')->middleware(['admin']);

Route::post('/upload_excel','Admin\FlightpadaircraftController@upload_excel')->name('upload_excel')->middleware(['admin']);


  Route::post('/config/addManufacturer', 'Admin\ConfigurationsController@addManufacturer')->name('config/addManufacturer')->middleware(['admin']);
  Route::post('/config/removeManufacture/{removeManufacture}', 'Admin\ConfigurationsController@removeManufacture')->name('config/removeManufacture')->middleware(['admin']);

  Route::post('/configAircraft/upload', 'Admin\ConfigurationsController@configAircraftUpload')->name('configAircraft/upload')->middleware(['admin']);
  Route::post('/configSymbol/upload', 'Admin\ConfigurationsController@configSymbolUpload')->name('configSymbol/upload')->middleware(['admin']);

  Route::delete('/configAircraft/remove/', 'Admin\ConfigurationsController@configAircraftRemove')->name('configAircraft/remove')->middleware(['admin']);
  Route::delete('/configSymbol/remove/', 'Admin\ConfigurationsController@configSymbolRemove')->name('configSymbol/remove')->middleware(['admin']);

  Route::post('/config/addModel', 'Admin\ConfigurationsController@addModel')->name('config/addModel')->middleware(['admin']);
  Route::post('/config/addspecial', 'Admin\ConfigurationsController@addspecial')->name('config/addspecial')->middleware(['admin']);
  Route::post('/config/addsymbol', 'Admin\ConfigurationsController@addsymbol')->name('config/addsymbol')->middleware(['admin']);
  Route::post('/config/removeModel/{id}', 'Admin\ConfigurationsController@removeModel')->name('config/removeModel')->middleware(['admin']);
  Route::post('/config/removespecial/{id}', 'Admin\ConfigurationsController@removespecial')->name('config/removespecial')->middleware(['admin']);
  Route::delete('/config/removesymbol/', 'Admin\ConfigurationsController@removesymbol')->name('config/removesymbol')->middleware(['admin']);
  Route::post('/config/addVariant', 'Admin\ConfigurationsController@addVariant')->name('config/addVariant')->middleware(['admin']);
  Route::post('/config/removeVariant/{id}', 'Admin\ConfigurationsController@removeVariant')->name('config/removeVariant')->middleware(['admin']);


  Route::get('/config/displayuser', 'UsersController@getUserInfo')->name('config/dis')->middleware(['admin']);

  Route::post('/config/specialItem/{id}', 'Admin\ConfigurationsController@specialItem')->name('config/specialItem')->middleware(['admin']);
  // Route::post('/config/addSpecialItem', 'Admin\ConfigurationsController@addSpecialItem')->name('config/addSpecialItem')->middleware(['admin']);
  Route::post('/config/addSpecialItem', 'Admin\ConfigurationsController@addSpecialItem')->name('config/addSpecialItem')->middleware(['admin']);
  Route::post('/config/removeSpecialItem/{id}', 'Admin\ConfigurationsController@removeSpecialItem')->name('config/removeSpecialItem')->middleware(['admin']);
  Route::post('/config/addAcManufacturer', 'Admin\ConfigurationsController@addAcManufacturer')->name('config/addAcManufacturer')->middleware(['admin']);
  Route::post('/config/addAcModel', 'Admin\ConfigurationsController@addAcModel')->name('config/addAcModel')->middleware(['admin']);
  Route::post('/config/addAcvariant', 'Admin\ConfigurationsController@addAcvariant')->name('config/addAcvariant')->middleware(['admin']);
  
  Route::post('/config/removeAcManufacturer/{id}', 'Admin\ConfigurationsController@removeAcManufacturer')->name('config/removeAcManufacturer')->middleware(['admin']);
  Route::post('/config/removeAcModel/{id}', 'Admin\ConfigurationsController@removeAcModel')->name('config/removeAcModel')->middleware(['admin']);
  Route::post('/config/removeAcVariant/{id}', 'Admin\ConfigurationsController@removeAcVariant')->name('config/removeAcVariant')->middleware(['admin']);
  Route::post('/config/removeAcDisplayname/{id}', 'Admin\ConfigurationsController@removeAcDisplayname')->name('config/removeAcDisplayname')->middleware(['admin']);

  Route::get('/config/lockUnlockState/{id}/{is_locked}', 'Admin\ConfigurationsController@lockUnlockState')->name('config/lockUnlockState')->middleware(['admin']);
  Route::post('/config/copyConfigData/{configid}/{email}', 'Admin\ConfigurationsController@copyConfigData')->name('config/copyConfigData');
  
  Route::get('/symbolitem', 'Admin\ConfigurationsController@symbolitem')->name('get-symbolitem');
  Route::get('/specialitems', 'Admin\ConfigurationsController@specialitems')->name('get-specialitems');
  Route::get('/specials', 'Admin\ConfigurationsController@specials')->name('get-specials');
  Route::get('/acmanufacturer', 'Admin\ConfigurationsController@acmanufacturer')->name('get-acmanufacturer');
  Route::get('/acmodeltypes', 'Admin\ConfigurationsController@acmodeltypes')->name('get-acmodeltypes');
  Route::get('/acvarianttypes', 'Admin\ConfigurationsController@acvarianttypes')->name('get-acvarianttypes');


  Route::get('/cgEnvelope', 'Admin\CGEnvelopeController@index')->name('cgEnvelope');
  Route::get('/cgEnvelope/create', 'Admin\CGEnvelopeController@create')->name('cgEnvelope/create')->middleware(['admin']);
  Route::get('/cgEnvelope/edit/{edit}', 'Admin\CGEnvelopeController@edit')->name('cgEnvelope/edit');
  Route::get('/cgEnvelope/copy/{copy}', 'Admin\CGEnvelopeController@copy')->name('cgEnvelope/copy')->middleware(['admin']);
  Route::post('/cgEnvelope/store', 'Admin\CGEnvelopeController@store')->name('cgEnvelope/store');
  Route::post('/cgEnvelope/update/{update}', 'Admin\CGEnvelopeController@update')->name('cgEnvelope/update');
  Route::delete('/cgEnvelope/delete/{delete}', 'Admin\CGEnvelopeController@destroy')->name('cgEnvelope/delete')->middleware(['admin']);
  Route::get('/envelopePoints/{id}', 'Admin\CGEnvelopeController@envelopePoints')->name('envelopePoints')->middleware(['admin']);

  Route::get('/cgEnvelope/lockUnlockState/{id}/{is_locked}', 'Admin\CGEnvelopeController@lockUnlockState')->name('cgEnvelope/lockUnlockState')->middleware(['admin']);

  /**
   * Aircraft CRUDE 
   * Routes 
   */

  Route::get('/airCraft', 'Admin\AirCraftController@index')->name('airCraft');
  Route::get('/airCraft/create', 'Admin\AirCraftController@create')->name('airCraft/create')->middleware(['admin']);
  Route::get('/airCraft/edit/{edit}', 'Admin\AirCraftController@edit')->name('airCraft/edit');
  Route::post('/airCraft/store', 'Admin\AirCraftController@store')->name('airCraft/store');
  Route::post('/airCraft/update/{update}', 'Admin\AirCraftController@update')->name('airCraft/update');
  Route::get('/airCraft/copy/{copy}', 'Admin\AirCraftController@copy')->name('airCraft/copy')->middleware(['admin']);
  Route::delete('/airCraft/delete/{delete}', 'Admin\AirCraftController@destroy')->name('airCraft/delete')->middleware(['admin']);
  Route::post('/airCraft/addPerformance/{id}', 'Admin\AirCraftController@addPerformance')->name('airCraft/addPerformance');
  Route::delete('/perFormanceFile/delete/{delete}', 'Admin\AirCraftController@performanceFileDestroy')->name('perFormanceFile/delete')->middleware(['admin']);

  Route::get('/manufacturer', 'Admin\AirCraftController@getManufacturer')->name('get-manufacturer');
  Route::get('/model', 'Admin\AirCraftController@getModel')->name('get-model');
  Route::get('/variant', 'Admin\AirCraftController@getVariant')->name('get-variant');
  

  Route::get('/airCraft/lockUnlockState/{id}/{is_locked}', 'Admin\AirCraftController@lockUnlockState')->name('airCraft/lockUnlockState')->middleware(['admin']);

  
Route::get('/aircraftview','Admin\AirCraftController@aircraftview')->name('aircraftview');
});
