@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
    <div class="container-fluid">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Config</a></li>
                <li class="breadcrumb-item"><a class="active-color" href="#">Config Create   </a>
                </li>
            </ol>
        </nav>
    </div>
</div>
        <div class="row">
            <div class="col-lg-12">
            {{ Form::open(array('route' => 'config/store','files'=>true, 'id'=>'dropzone-demo')) }}
                <div class="bg-boxshadow">
                  <div  class="row">
                    <div class="creat-new col-md-6">
                        Config Name :  <input type="text" id="pwd" placeholder="Enter Config Name" name="config_name" value="{{@$config->config_name}}">
                        @if ($errors->has('config_name'))
                            <div class="error" style="color: red">{{ $errors->first('config_name') }}</div>
                        @endif
                    </div>

                    <div class="creat-new col-md-6"> Remark :  <input type="text" placeholder="Enter Remark" name="remark">
                    @if ($errors->has('remark'))
                        <div class="error" style="color: red">{{ $errors->first('remark') }}</div>
                    @endif
                    </div>
                  </div>
                    <div class="ibox-content from-block mb-30">
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="order_id"> Aircraft Type  </label>
                                    <select data-style="btn-select-tag" class="selectpicker form-control mb-15" name="aircraft_type">

                                        @foreach($aircraft as $aircraftData)
                                            <option value="{{$aircraftData->aircraft_id}}">{{$aircraftData->aircraft_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="status"> Manufacturer  </label>
                                    <select data-style="btn-select-tag" class="form-control mb-15" id="dbox2" name="manufacturer">
                                        @foreach($manufacturer as $manufacturerData)
                                            <option value="{{$manufacturerData->id}}"> {{$manufacturerData->manufacturer_name}} </option>
                                        @endforeach
                                    </select>
                                    <input name="manufacturer_name" placeholder="Enter Manufacturer" type="text" id="manufacturer_data" style=" padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2">
                                    <button type="button" class="btn  btn-primary btn-xs manufacturerAdd" id="ProbListBtn2">Add </button>
                                    <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="DeleteManufacturer();">Remove </button>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer"> Model </label>
                                    <select data-style="btn-select-tag" class="form-control mb-15" id="dbox" name="model">
                                        @foreach($model as $modelData)

                                            <option value="{{$modelData->id}}">{{$modelData->model_name}}</option>
                                        @endforeach
                                    </select>
                                    <input placeholder="Enter model" type="text" id="model_data" style=" padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2 ">
                                    <button type="button" class="btn  btn-primary btn-xs modelAdd" id="ProbListBtn" onclick="ListProbs();">Add </button>
                                    <button type="button" class="btn btn-primary btn-xs" id="test" onclick="DeleteModel();">Remove </button>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label  class="col-form-label" for="customer"> Variant </label>
                                     <select cdata-style="btn-select-tag" class="selectpicker form-control mb-15" name="variant">
                                        @foreach($variant as $variantData)

                                            <option value="{{$variantData->variant_id}}">{{$variantData->variant_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label  class="col-form-label" for="customer"> Image </label>
                                    <div class="button dropdown">
                                        <select class="selectpicker form-control mb-15" id="colorselector" name="image2">
                                            @foreach($configImage as $configImageData)
                                            @php($selected = '')
                                                <option data-thumbnail="{{ asset('img/'.$configImageData->files) }}" value="{{$configImageData->files}}" >{{$configImageData->files}} </option>
                                            @endforeach
                                        </select>
                                        <!-- <form action="/configImage/create" method="post" class="test_add_img" enctype="multipart/form-data" id="btnsubmit">

                                        <input  type="file" id="config_image" style=" padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2 ">
                                        <button type="button" class="btn  btn-primary btn-xs img_Add" id="config_image_add">Add </button>
                                        <button type="button" class="btn btn-primary btn-xs" id="test">Remove </button>
                                        </form> -->
                                    </div>
                                    <div class="output">
                                        <div id="{{$configImageData->configuration_image_id}}" class="red"> <img src=""  id="image"></div>
                                        <!-- <div id="image2" class="aircraft_block yellow"><img src="">  </div>
                                        <div id="image3" class="aircraft_block blue"> “<img src=""> </div> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                              <div class="button-block">
                                <button class="btn btn-primary btn-md" type="submit"> Cancel </button>
                                <button class="btn btn-info btn-md" type="submit"> Create This Configuration </button>
                                <!-- <button class="btn btn-success btn-md" type="submit"> Copy data from exiting configuration </button> -->
                              </div>
                        </div>
                    </div>
                </div>
            {{ Form::close() }}
            </div>
        </div>



@endsection

@section('script')
<script>

var selectedImage = $('#colorselector').children("option:selected").html();
$('#image').attr('src','/img/'+selectedImage);

$("#colorselector").change(function(){
        var selectedImage = $(this).children("option:selected").html();
        $('#image').attr('src','/img/'+selectedImage);
    });


function setCar() {
    var img = document.getElementById("colorselector");
    var i = $('#colorselector').attr('name');
    console.log(i);
    img.src = this.value;
    return false;
}
document.getElementById("colorselector").onchange = setCar;

// $('input[type="file"]').change(function(e){
//     var filename = $('input[type=file]').val().replace(/C:\\fakepath\\/i, '');
//      $('#config_image').val(filename);
//         });
// $('#config_image_add').click(function(){
//     var img_name = $('#config_image').val().replace(/C:\\fakepath\\/i, '');
//     // var idimg = $('.imgs').attr('id');
//     // var srcimg = $('.imgs').attr('src');
//     $.ajaxSetup({
//     headers: {
//       'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//     }
//   });
//     $.ajax({
//                       url: '/configImage/create',
//                       type: 'POST',
//                       data:{ file_name:img_name },
//                       cache: false,
//                       processData: true,
//                       success: function (data) {
//
//                       }
//                    });
//
//     alert('ID is: '+ idimg+ '\n SRC: '+ srcimg);
//   });

$("#config_image_add").click(function (e) {

        e.preventDefault();

        var form = $('.test_add_img');
        var formData = new FormData(form);
        console.log(formData);
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: '/configImage/create',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            success: function(response) {

            }
        });
    });



$('.manufacturerAdd').click(function(){
  var manufacturer_data = $('#manufacturer_data').val();
  $.ajaxSetup({
  headers: {
    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
  }
});
  $.ajax({
      url: '/config/addManufacturer',
      type: 'POST',
      cache: false,
      data : { manufacturer_data:manufacturer_data },
      processData: true,
      success: function (data) {
        data = data.replace(/\"/g, "");
        $('#dbox2').append('<option value="Option Value">'+data+'</option>');

      }
   });
});
$('.modelAdd').click(function(){
  var model_data = $('#model_data').val();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  $.ajax({
      url: '/config/addmodel',
      type: 'POST',
      cache: false,
      data : { model_data:model_data },
      processData: true,
      success: function (data) {
        data = data.replace(/\"/g, "");
        $('#dbox').append('<option value="Option Value">'+data+'</option>');
      }
   });
});

    function ListProbs() {
        var y = document.getElementById("dbox");
        var txt1 = document.getElementById("ProbAreaFrom").value;
        var option = document.createElement("option");
        option.text = txt1
        y.add(option);
        ProbAreaFrom.value="";
    }



    function ListProbs2() {
        var y = document.getElementById("dbox2");
        var txt2 = document.getElementById("ProbAreaFrom2").value;
        var option = document.createElement("option");
        option.text = txt2
        y.add(option);
        ProbAreaFrom.value="";
    }

    function DeleteManufacturer() {
      var index = $('#dbox2').get(0).selectedIndex;
      var id = $('#dbox2').val();
      $('#dbox2 option:eq(' + index + ')').remove();
      $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
      $.ajax({
          url: '/config/removeManufacture/'+ id,
          type: 'post',
          cache: false,
          processData: true,
          success: function (data) {
          }
       });

    }


    function DeleteModel() {

        var index = $('#dbox').get(0).selectedIndex;
        var m_id = $('#dbox').val();

        $('#dbox option:eq(' + index + ')').remove();
        $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
        $.ajax({
                          url: '/config/removeModel/'+ m_id,
                          type: 'post',
                          cache: false,
                          processData: true,
                          success: function (data) {
                          }
                       });
    }



</script>
@endsection
