@extends('admin.layouts.master')
<style>
.select-editable {
    position:relative;
    background-color:white;
    border:solid grey 1px;
    width:120px;
    height:18px;
}
.colo{
  color: red !important;
}
.margin-bottom {
    margin-bottom:15px;
}
.select-editable select {
    position:absolute;
    top:0px;
    left:0px;
    font-size:14px;
    border:none;
    width:120px;
    margin:0;
}
.select-editable input {
    position:absolute;
    top:0px;
    left:0px;
    width:100px;
    padding:1px;
    font-size:12px;
    border:none;
}
.select-editable select:focus, .select-editable input:focus {
    outline:none;
} 
.copy_color {
  color: red;
} 
</style>
<link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
    <script src="//code.jquery.com/jquery-1.10.2.js"></script>
    <script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
@section('content')
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="{{route('config')}}">Config</a></li>
               <li class="breadcrumb-item"><a class="active-color" href="#">Config Edit</a>
               </li>
           </ol>
       </nav>
   </div>
</div>

<span id="auth_id" style="display:none">{{Auth::user()->role_id}}</span>

<div class="modal fade" id="myModal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
         <h5 class="modal-title">Item Symbol Images</h5>
         <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <form method="get" >
          <div class="form-group row">
            @foreach($items as $item)
              <div class="col-sm-3">
                  <label style="cursor: pointer; padding-bottom: 10px;" >
                      <img src="{{asset('uploads/'.$item->image)}}" id="{{$item->id}}" width="{{$item->width}}px" height="{{$item->height}}px" alt="item-{{$item->id}}" class="img-thumbnail create-symbol-item">
                  </label>
              </div>
            @endforeach
            <br />
            <h5 class="text-item">All Text Item</h5>
            <select data-style="btn-select-tag" class="form-control create-no-symbol-item" size="6">
                @foreach($specialItems as $item)
                    <option data-asset="{{ json_encode($item) }}" value="{{$item->special_item_id}}">{{$item->special_item_name}}</option>
                @endforeach
            </select>
         </div>
       </form>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="update-symbol-model" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
         <h5 class="modal-title">Update Item Symbol</h5>
         <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <form method="get">
          <div class="form-group row">
            @foreach($items as $item)
              <div class="col-sm-3">
                  <label style="cursor: pointer; padding-bottom: 10px;" >
                      <img src="{{asset('uploads/'.$item->image)}}" id="{{$item->id}}" width="{{$item->width}}px" height="{{$item->height}}px" alt="item-{{$item->id}}" class="img-symbol">
                  </label>
              </div>
            @endforeach
         </div>
       </form>
     </div>
    </div>
  </div>
</div>
        <div class="row">
            <div class="col-lg-12">
            {{ Form::open(array('route' => ['config/update', $config->configurations_id], 'id' => 'gyronimo')) }}
                <div class="bg-boxshadow">
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="creat-new">
                            Config Name <input type="text" class="sync" placeholder="Enter config name" name="config_name" value="{{@$config->config_name}}">
                            @if ($errors->has('config_name'))
                                <div class="error" style="color: red">{{ $errors->first('config_name') }}</div>
                            @endif
                        </div>
                      </div>
                      <div class="col-sm-2" style="position: absolute;left: 44%;font-size: 17px;">
                        <div class="creat-new">
                          <label class="col-form-label" for="order_id">ID : {{$config->configurations_id}} </label>
                        </div>
                      </div>
                       <div class="col-sm-6">
                        <div class="creat-new">
                            Registration/Call Sign <input type="text" class="sync" placeholder="Enter call sign" name="callsign" value="{{@$config->callsign}}">
                        </div>
                      </div>
                    </div>
                    <div class="ibox-content from-block mb-30">
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="order_id">Aircraft Type</label>
                                    <select @if(Auth::user()->role_id == 2) disabled @endif data-style="btn-select-tag" class="selectpicker form-control mb-15 sync" name="aircraft_type">
                                        @foreach($aircraft as $aircraftData)
                                        @php($selected = '')
                                            @if($config->aircraft_type === $aircraftData->aircraft_id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$aircraftData->aircraft_id}}" {{$selected}}>{{$aircraftData->aircraft_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label">Manufacturer</label>
                                    <select @if(Auth::user()->role_id == 2) disabled @endif data-style="btn-select-tag" class="form-control mb-15 sync" id="dbox2" name="manufacturer">
                                        @foreach($manufacturer as $manufacturerData)
                                        @php($selected = '')
                                            @if($config->manufacturer === $manufacturerData->id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$manufacturerData->id}}" {{$selected}}> {{$manufacturerData->manufacturer_name}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Model</label>
                                    <select @if(Auth::user()->role_id == 2) disabled @endif data-style="btn-select-tag" class="form-control mb-15 sync" id="dbox" name="model">
                                        @foreach($model as $modelData)
                                        @php($selected = '')
                                            @if($config->model === $modelData->id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$modelData->id}}" {{$selected}}>{{$modelData->model_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Variant</label>
                                     <select @if(Auth::user()->role_id == 2) disabled @endif cdata-style="btn-select-tag" class="selectpicker form-control mb-15 sync" name="variant">
                                        @foreach($variant as $variantData)
                                        @php($selected = '')
                                            @if($config->variant === $variantData->variant_id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$variantData->variant_id}}" {{$selected}}>{{$variantData->variant_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Unit</label>
                                     <select @if(Auth::user()->role_id == 2) disabled @endif cdata-style="btn-select-tag" class="form-control mb-15 sync" name="unit">
                                       <option <?php if($config->unit == 'kg') echo 'selected="selected"'; ?>>kg</option>
                                       <option <?php if($config->unit == 'lbs') echo 'selected="selected"'; ?>>lbs</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="creat-new">
                            Remark <input type="text" class="sync" placeholder="Enter remark" name="remark" value="{{@$config->remark}}">
                        </div>
                      </div>
                      @if(Auth::user()->role_id == 1 || Auth::user()->role_id == 3)
                      <div class="col-sm-6">
                        <div class="creat-new">
                         <div class="row">
                            <div class="col-sm-4" style="padding-top:10px;">
                              Copy this Config to Client
                            </div>
                            <div class="col-sm-6">
                              <select name="copyConfig" id="copyConfig" class="form-control">
                                <option value="">Select Client</option>
                                @foreach($userConfiguration as $userConfigurationData)
                                    <option value="{{$userConfigurationData->role_id}}">{{$userConfigurationData->email}}</option>
                                @endforeach
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      @endif
                    </div>

                    <div class="col-md-12 text-center">
                      @if($config->is_locked != 1)
                        <label style="color:#e22800;font-size:30px;">LOCKED! You can not save changes!</label>
                      @endif
                    </div>
                </div>
  <div class="row">
    <div class="col-12">
      <div class="product-list--area bg-boxshadow">
        <div class='gyronimo-handle'></div>
        <div class="box-block">
         <div class="row">
           <div class="col-sm-2">
             <div class="form-group">
               <label class="col-form-label">BOX Width</label>
               <input class="form-control mb-15 sync" type="number" placeholder="Enter width px" id="box-width-input" name="box_width" value="{{$config->box_width}}">
             </div>
            </div>
            <div class="col-sm-2">
             <div class="form-group">
               <label class="col-form-label">Box height</label>
               <input class="form-control mb-15 sync" type="number" placeholder="Enter height px" id="box-height-input" name="box_height" value="{{$config->box_height}}">
             </div>
            </div>
            @if (isset($aircrafts))
              <div class="col-sm-2">
               <div class="form-group">
                 <label class="col-form-label">Aircraft Image</label>
                   <select @if(Auth::user()->role_id == 2) disabled @endif class="selectpicker form-control mb-15 sync" id="aircraft-selector" name="image2">
                       @foreach($aircrafts as $aircraft)
                           @if($aircraft->configuration_image_id == $config->image2)
                             @php($selected = 'selected=selected')
                           @else
                             @php($selected = '')
                           @endif
                           <option {{$selected}} data-thumbnail="{{$aircraft->files}}" value="{{$aircraft->configuration_image_id}}">{{$aircraft->file_name}}</option>
                       @endforeach
                   </select>
               </div>
              </div>
            @endif
            <div class="col-sm-6">
              <button type="button" id="center-btn" class="btn center-btn more-btn btn-warning btn-lg">
                Center
              </button>
              <button @if(Auth::user()->role_id == 2) disabled @endif type="button" id="show-configurations" style="background-color: #A9A9A9 !important;border-color: transparent;" class="btn more-btn btn-success btn-lg">
                Show/Hide Config Details
              </button>
               <button @if(Auth::user()->role_id == 2) disabled @endif type="button" id="show-topconfigurations" style="margin-right: 7px;background-color: #A9A9A9 !important;border-color: transparent;" class="btn more-btn btn-success btn-lg">
                Show/Hide Topview Setup
              </button>
            </div>
          </div>
         </div>
            <div class="row images-block">
              <div class="col-sm-5" style="padding-left: 0px; padding-right: 0px;margin-top:35%;">
                  <div class="helicopter-frame" id="wrapper">
                       <div id="fwd-red-line" class="lines red-line" style="top: {{$config->fwd_top_px}}; left: {{$config->fwd_left_px}}"></div>
                       <div id="aft-blue-line" class="lines blue-line" style="top: {{$config->aft_top_px}}; left: {{$config->aft_left_px}}"></div>
                       <div id="x1-yellow-line" class="lines yellowline"></div>
                       <div id="x2-green-line" class="lines greenline" style="top: {{$config->x2_top_px}}; left: {{$config->x2_left_px}}"></div>
                       <div class="aircraft-img-wrapper">
                          <img id="aircraft-img" style="position: relative;" src="{{asset('uploads/'.$config->files)}}">
                       </div>
                  </div>
              </div>
              <div class="col-sm-7">
               <div class="row left-block">
                <div class="col-sm-12" id="top-div">
                 <div class="col-sm-4" style="float:left;">
                    <div class="parameter">
                        <div class="form-data red-color"><span style="min-width: 80px; font-size: 20px;">FWD</span>
                            <input class="sync" type="number" placeholder="Enter fwd unit" id="fwd-input" value="{{$config->clongarmfrontseat}}" name="clongarmfrontseat" step="any"> </div>
                        <div class="form-data blue-color"><span style="min-width: 80px; font-size: 20px;">AFT</span>
                            <input class="sync" type="number" placeholder="Enter aft unit" id="aft-input" value="{{$config->clongarmrearseat}}" name="clongarmrearseat" step="any"> </div>
                     </div>
                     <div class="parameter-xy">
                        <div class="form-data yellow-color"><span style="min-width: 80px; font-size: 20px;">X1</span>
                         <input class="sync" type="number" placeholder="Enter x1 unit" id="x1-input" value="{{$config->ckeeptozero}}" step="any" name="ckeeptozero"> </div>
                        <div class="form-data green-color"><span style="min-width: 80px; font-size: 20px;">X2</span>
                         <input class="sync" type="number" placeholder="Enter x2 unit" id="x2-input" value="{{$config->clatarmrightseat}}" step="any" name="clatarmrightseat"> </div>
                     </div>
                  </div>
                  <div class="col-sm-4" style="float:left;">
                    <div class="form-data">
                      <span>FWD Ypos</span>
                      <input class="sync" step="any" type="number" id="line-fwd-ypos-input" min="0" placeholder="Enter ypos" name="cseatsfront" value="{{$config->cseatsfront}}">
                    </div>
                     <div class="form-data">
                      <span>AFT Ypos</span>
                      <input class="sync" step="any" type="number" id="line-aft-ypos-input" placeholder="Enter ypos" name="cseatsrear" value="{{$config->cseatsrear}}">
                    </div>
                    <div class="form-data">
                      <span>X1 Xpos</span>
                      <input class="sync" step="any" type="number" id="line-x1-xpos-input" min="0" placeholder="Enter xpos" name="clatcenter" value="{{$config->clatcenter}}">
                    </div>
                    <div class="form-data">
                      <span>X2 XPos</span>
                      <input class="sync" step="any" type="number" id="line-x2-xpos-input" placeholder="Enter xpos" name="clatright" value="{{$config->clatright}}">
                    </div>
                  </div>
                  <div class="col-sm-4" style="float:left;">
                    <div class="form-data">
                      <span>Aircraft Width</span>
                      <input class="sync" step="any" type="number" id="aircraft-width-input" placeholder="Enter width" name="cacwidth" value="{{$config->cacwidth}}">
                    </div>
                     <div class="form-data">
                      <span>Aircraft height</span>
                      <input class="sync" step="any" type="number" id="aircraft-height-input" placeholder="Enter height" name="cacheight" value="{{$config->cacheight}}">
                    </div>
                    <div class="form-data">
                      <span>Aircraft YPos</span>
                      <input class="sync" step="any" type="number" id="aircraft-ypos-input" placeholder="Enter ypos" name="cacy" value="{{$config->cacy}}">
                    </div>
                    <div class="form-data">
                      <span>Aircraft XPos</span>
                      <input class="sync" step="any" type="number" id="aircraft-xpos-input" placeholder="Enter xpos" name="cacx" value="{{$config->cacx}}">
                    </div>
                  </div>

                  </div>

                  <div id="from-demo" class="configuration-more-block" style="display: none; min-height: 300px;">
                      <div class="form-group">
                        <label>Weight Units</label>
                        <input class="sync" name="cweightunits" value="{{$config->cweightunits}}" style="min-width: 70px;" class="form-control" type="text" placeholder="Enter weight units" >
                      </div>
                      <div class="form-group">
                        <label>Max Ramp</label>
                        <input class="sync" name="cmaxramp" value="{{$config->cmaxramp}}" style="min-width: 70px;" class="form-control" placeholder="Enter max ramp" type="number">
                      </div>
                      <div class="form-group">
                        <label>Max TOW</label>
                        <input class="sync" name="cmaxtow" value="{{$config->cmaxtow}}" style="min-width: 70px;" class="form-control" placeholder="Enter max tow" type="number">
                      </div>
                      <div class="form-group">
                        <label>Max LDW</label>
                        <input class="sync" name="cmaxldw" value="{{$config->cmaxldw}}" style="min-width: 70px;" class="form-control" placeholder="Enter max ldw" type="number">
                      </div>
                      <div class="form-group">
                        <label>Calc Lateral Fuel</label>
                        <!-- <input name="ccalclateralfuel" value="{{$config->ccalclateralfuel}}" style="min-width: 70px;" class="form-control" placeholder="Enter calc lateral fuel" type="number"> -->
                        <select class="form-control sync" name="ccalclateralfuel" value="{{$config->ccalclateralfuel}}">
                            <option value="ok" <?php if($config->ccalclateralfuel == 'ok') echo ' selected="selected"'; ?>>ok</option>
                            <option value="noLat" <?php if($config->ccalclateralfuel == 'noLat') echo ' selected="selected"'; ?>>noLat</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Fuel Units</label>
                        <input name="cfuelunits" value="{{$config->cfuelunits}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter fuel units">
                      </div>
                      <div class="form-group">
                        <label>Enter mode</label>
                        <input name="centermode" value="{{$config->centermode}}" style="min-width: 70px;" class="form-control sync" placeholder="Enter enter mode" type="text" >
                      </div>
                      <div class="form-group">
                        <label>Fuel Flow lbs/h</label>
                        <input name="cfuelflowlbsperh" value="{{$config->cfuelflowlbsperh}}" step="0.01" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter fuel flow lbs/h">
                      </div>
                      <div class="form-group">
                       <label>Preset Main</label>
                       <input name="cpresetmain" value="{{$config->cpresetmain}}" step="0.01" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter preset main">
                      </div>
                      <div class="form-group">
                        <label>Preset Landing</label>
                        <input name="cpresetlanding" value="{{$config->cpresetlanding}}" step="0.01" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter preset landing">
                      </div>
                      <div class="form-group">
                        <label>Swap off/on</label>
                        <select class="form-control sync" name="swapoffon" value="{{$config->swapoffon}}">
                            <option value="on" <?php if($config->swapoffon == 'on') echo ' selected="selected"'; ?>>On</option>
                            <option value="off" <?php if($config->swapoffon == 'off') echo ' selected="selected"'; ?>>Off</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Quick/Crew (q/c)</label>
                       <select class="form-control sync" name="cquickcrew" value="{{$config->cquickcrew}}">
                            <option value="q" <?php if($config->cquickcrew == 'q') echo ' selected="selected"'; ?>>q</option>
                            <option value="c" <?php if($config->cquickcrew == 'c') echo ' selected="selected"'; ?>>c</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>ID / WID / WN</label>
                       <select class="form-control sync" name="cidwidwn" value="{{$config->cidwidwn}}">
                            <option value="ID" <?php if($config->cidwidwn == 'ID') echo ' selected="selected"'; ?>>ID</option>
                            <option value="WID" <?php if($config->cidwidwn == 'WID') echo ' selected="selected"'; ?>>WID</option>
                            <option value="WN" <?php if($config->cidwidwn == 'WN') echo ' selected="selected"'; ?>>WN</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Color Code</label>
                        <select class="form-control sync" name="ccolorcode" value="{{$config->ccolorcode}}">
                            <option value="Yellow" <?php if($config->ccolorcode == 'Yellow') echo ' selected="selected"'; ?>>Yellow</option>
                            <option value="Green" <?php if($config->ccolorcode == 'Green') echo ' selected="selected"'; ?>>Green</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Flight/Legs</label>
                        <select class="form-control sync" name="cflightlegs" value="{{$config->cflightlegs}}">
                            <option value="FlightMode" <?php if($config->cflightlegs == 'FlightMode') echo ' selected="selected"'; ?>>FlightMode</option>
                            <option value="LegMode" <?php if($config->cflightlegs == 'LegMode') echo ' selected="selected"'; ?>>LegMode</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Seat Width</label>
                        <input name="cseatwidth" value="{{$config->cseatwidth}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter seat width">
                      </div>
                      <div class="form-group">
                        <label>Seat Height</label>
                        <input name="cseatheight" value="{{$config->cseatheight}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter seat height">
                      </div>
                      <div class="form-group">
                        <label>Fuel Panel Height</label>
                        <input name="cfuelpanelheight" value="{{$config->cfuelpanelheight}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter fuel panel height">
                        <!-- <select class="form-control sync" name="cfuelpanelheight" value="{{$config->cfuelpanelheight}}">
                            <option value="160" <?php if($config->cfuelpanelheight == '160') echo ' selected="selected"'; ?>>160</option>
                            <option value="450" <?php if($config->cfuelpanelheight == '450') echo ' selected="selected"'; ?>>450</option>
                         </select> -->
                      </div>
                      <div class="form-group">
                        <label>Fuel Panel Start</label>
                       <select class="form-control sync" name="cfuelpanelstart" value="{{$config->cfuelpanelstart}}">
                            <option value="Open" <?php if($config->cfuelpanelstart == 'Open') echo ' selected="selected"'; ?>>Open</option>
                            <option value="Closed" <?php if($config->cfuelpanelstart == 'Closed') echo ' selected="selected"'; ?>>Closed</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>LargeTopView</label>
                        <select class="form-control sync" name="clargetopview" value="{{$config->clargetopview}}">
                            <option value="yes" <?php if($config->clargetopview == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->clargetopview == 'no') echo ' selected="selected"'; ?>>No</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Config/equip Label</label>
                         <select class="form-control sync" name="cconfigequiplabel" value="{{$config->cconfigequiplabel}}">
                            <option value="yes" <?php if($config->cconfigequiplabel == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->cconfigequiplabel == 'no') echo ' selected="selected"'; ?>>No</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Special Manifest</label>
                        <input name="cspecialmanifest" value="{{$config->cspecialmanifest}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter special manifest">
                      </div>
                      <div class="form-group">
                        <label>Setup Options</label>
                        <input name="csetupoptions" value="{{$config->csetupoptions}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter setup options">
                      </div>
                      <div class="form-group">
                        <label>Date (US/EU)</label>
                        <select class="form-control sync" name="cdateuseu" value="{{$config->cdateuseu}}">
                            <option value="EU" <?php if($config->cdateuseu == 'EU') echo ' selected="selected"'; ?>>EU</option>
                            <option value="US" <?php if($config->cdateuseu == 'US') echo ' selected="selected"'; ?>>US</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Picker Minute Interval</label>
                        <input name="cpickerminuteinterval" value="{{$config->cpickerminuteinterval}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter picker minute interval">
                      </div>
                      <div class="form-group">
                        <label>Picker Locale</label>
                        <select class="form-control sync" name="cpickerlocale" value="{{$config->cpickerlocale}}">
                            <option value="en_GB" <?php if($config->cpickerlocale == 'en_GB') echo ' selected="selected"'; ?>>en_GB</option>
                            <option value="en_US" <?php if($config->cpickerlocale == 'en_US') echo ' selected="selected"'; ?>>en_US</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Config Stations Start</label>
                        <input name="cconfigstationsstart" value="{{$config->cconfigstationsstart}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter config stations start">
                      </div>
                      <div class="form-group">
                        <label>Config Stations End</label>
                        <input name="cconfigstationsend" value="{{$config->cconfigstationsend}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter config stations end">
                      </div>
                      <div class="form-group">
                        <label>Manifest Export</label>
                        <select class="form-control sync" name="cmanifestexport" value="{{$config->cmanifestexport}}">
                            <option value="yes" <?php if($config->cmanifestexport == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->cmanifestexport == 'no') echo ' selected="selected"'; ?>>No</option>
                        </select>
                      </div>
                      <div class="form-group">
                        <label>Summary Export</label>
                        <select class="form-control sync" name="csummaryexport" value="{{$config->csummaryexport}}">
                            <option value="yes" <?php if($config->csummaryexport == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->csummaryexport == 'no') echo ' selected="selected"'; ?>>No</option>
                        </select>
                      </div>
                      <div class="form-group">
                        <label>Allow Interor Edit</label>
                        <select class="form-control sync" name="callowinteroredit" value="{{$config->callowinteroredit}}">
                            <option value="yes" <?php if($config->callowinteroredit == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->callowinteroredit == 'no') echo ' selected="selected"'; ?>>No</option>
                        </select>
                      </div>
                      <div class="form-group">
                        <label>Check Margin</label>
                        <select class="form-control sync" name="ccheckmargin" value="{{$config->ccheckmargin}}">
                            <option value="yes" <?php if($config->ccheckmargin == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->ccheckmargin == 'no') echo ' selected="selected"'; ?>>No</option>
                        </select>
                      </div>
                      <div class="form-group">
                        <label>Margin Percent</label>
                        <input name="cmarginpercent" value="{{$config->cmarginpercent}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter margin percent" >
                      </div>
                      <div class="form-group">
                        <label>Second CG envelope</label>
                        <select class="form-control sync" name="csecondcgenvelope" value="{{$config->csecondcgenvelope}}">
                            <option value="yes" <?php if($config->csecondcgenvelope == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->csecondcgenvelope == 'no') echo ' selected="selected"'; ?>>No</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>LinePilot</label>
                        <input name="clinepilot" value="{{$config->clinepilot}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter linepilot">
                      </div>
                      <div class="form-group">
                        <label>Calc max External/Hoist</label>
                         <select class="form-control sync" name="ccalcmaxexternalorhoist" value="{{$config->ccalcmaxexternalorhoist}}">
                            <option value="yes" <?php if($config->ccalcmaxexternalorhoist == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->ccalcmaxexternalorhoist == 'no') echo ' selected="selected"'; ?>>No</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>Allow Equip Change</label>
                        <select class="form-control sync" name="callowequipchange" value="{{$config->callowequipchange}}">
                            <option value="yes" <?php if($config->callowequipchange == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->callowequipchange == 'no') echo ' selected="selected"'; ?>>No</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>FWD/AFT CG Check</label>
                        <select class="form-control sync" name="cfwdaftcgcheck" value="{{$config->cfwdaftcgcheck}}">
                            <option value="on" <?php if($config->cfwdaftcgcheck == 'on') echo ' selected="selected"'; ?>>On</option>
                            <option value="off" <?php if($config->cfwdaftcgcheck == 'off') echo ' selected="selected"'; ?>>Off</option>
                        </select>
                      </div>
                      <div class="form-group">
                        <label>Aux Fuel Volume</label>
                        <input name="cauxfuelvolume" value="{{$config->cauxfuelvolume}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter aux fuel volume">
                      </div>
                      <div class="form-group">
                        <label>Date Format</label><br />
                        <!-- <select class="form-control sync" name="cdateformat" value="{{$config->cdateformat}}">
                            <option value="dd-MM-yyyy HH-mm" <?php //if($config->cdateformat == 'dd-MM-yyyy HH-mm') echo ' selected="selected"'; ?>>dd-MM-yyyy HH-mm</option>
                            <option value="MM-dd-yyyy HH-mm" <?php //if($config->cdateformat == 'MM-dd-yyyy HH-mm') echo ' selected="selected"'; ?>>MM-dd-yyyy HH-mm</option>
                         </select> -->
                        <input list="dateFormate" value="{{$config->cdateformat}}" id="cdateformat" name="cdateformat" style="width: 180px;"/>
                        <datalist id="dateFormate">
                            <option value="dd-MM-yyyy HH-mm" <?php if($config->cdateformat == 'dd-MM-yyyy HH-mm') echo ' selected="selected"'; ?>>dd-MM-yyyy HH-mm</option>
                            <option value="MM-dd-yyyy HH-mm" <?php if($config->cdateformat == 'MM-dd-yyyy HH-mm') echo ' selected="selected"'; ?>>MM-dd-yyyy HH-mm</option>
                        </datalist>
                      </div>
                      <div class="form-group">
                        <label>Flt Data Elements</label>
                        <input name="cfltdataelements" value="{{$config->cfltdataelements}}" style="min-width: 70px;" class="form-control sync" placeholder="Enter flt data elements">
                      </div>
                      <div class="form-group">
                        <label>Allow BEW Override</label>
                       <select class="form-control sync" name="callowbewoverride" value="{{$config->callowbewoverride}}">
                            <option value="yes" <?php if($config->callowbewoverride == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->callowbewoverride == 'no') echo ' selected="selected"'; ?>>No</option>
                       </select>
                      </div>
                      <div class="form-group">
                        <label>LOCK RESET if not sent</label>
                        <select class="form-control sync" name="clockresetifnotsent" value="{{$config->clockresetifnotsent}}">
                            <option value="yes" <?php if($config->clockresetifnotsent == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->clockresetifnotsent == 'no') echo ' selected="selected"'; ?>>No</option>
                         </select>
                      </div>
                      <div class="form-group">
                        <label>if Units (meter)</label>
                        <select class="form-control sync" name="cifunitsaremeter" value="{{$config->cifunitsaremeter}}">
                            <option value="yes" <?php if($config->cifunitsaremeter == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->cifunitsaremeter == 'no') echo ' selected="selected"'; ?>>No</option>
                        </select>
                      </div>
                      <div class="form-group">
                        <label>Set Line as Free Load</label>
                        <input name="csetlineasfreeload" value="{{$config->csetlineasfreeload}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter set line as free load">
                      </div>
                      <div class="form-group">
                        <label>Port/Land/Both</label>
                        <input name="cportlandboth" value="{{$config->cportlandboth}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter port/land/both">
                      </div>
                       <div class="form-group">
                        <label>Risk Assess</label>
                        <input name="criskassess" value="{{$config->criskassess}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter risk assess">
                      </div>
                       <div class="form-group">
                        <label>DocViewer</label>
                        <input name="cdocviewer" value="{{$config->cdocviewer}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter doc viewer">
                      </div>
                       <div class="form-group">
                        <label>Int. Configurator</label>
                        <input name="cintconfigurator" value="{{$config->cintconfigurator}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter int. configurator">
                      </div>
                      <div class="form-group">
                        <label>QuickLoad Preset</label>
                       <input name="cquickloadpreset" value="{{$config->cquickloadpreset}}" style="min-width: 70px;" class="form-control sync" placeholder="Enter quickLoad preset" type="number">
                      </div>
                      <div class="form-group">
                        <label>yUp Heli Individual</label>
                       <input name="cyupheliindividual" value="{{$config->cyupheliindividual}}" tyle="min-width: 70px;" class="form-control sync" placeholder="Enter yup heli individual" type="number">
                      </div>
                      <div class="form-group">
                        <label>yUp Heli Plan</label>
                        <input name="yupheliplan" value="{{$config->yupheliplan}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter yup heli plan">
                      </div>
                      <div class="form-group">
                        <label>Tank Max Usable Fuel Volume</label>
                         <input step="any" name="ctankmaxfuelvolume" value="{{$config->ctankmaxfuelvolume}}" style="min-width: 70px;" class="form-control sync" type="number" placeholder="Enter tank max usable fuel volume">
                      </div>
                      <div class="form-group">
                        <label>Specific fuel weight lbs/Gal</label>
                        <input name="cfactorlbsgal" value="{{$config->cfactorlbsgal}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter specific fuel weight lbs/Gal">
                      </div>
                      <div class="form-group">
                        <label>Specific fuel weight kg/liter</label>
                        <input name="cfactorkgliter" value="{{$config->cfactorkgliter}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter specific fuel weight kg/liter">
                      </div>
                      <div class="form-group">
                        <label>Check AC updates</label>
                        <select class="form-control sync" name="ccheckacupdates">
                            <option value="yes" <?php if($config->ccheckacupdates == 'yes') echo ' selected="selected"'; ?>>Yes</option>
                            <option value="no" <?php if($config->ccheckacupdates == 'no') echo ' selected="selected"'; ?>>No</option>
                        </select>
                      </div>
                      <div class="form-group">
                        <label>Boxed Sliders</label>
                        <input name="cboxedsliders" value="{{$config->cboxedsliders}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter boxed sliders">
                      </div>
                      <div class="form-group">
                        <label>Box Alpha</label>
                        <input name="cboxalpha" value="{{$config->cboxalpha}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter box alpha">
                      </div>
                      <div class="form-group">
                        <label>Slider Alpha</label>
                        <input name="cslideralpha" value="{{$config->cslideralpha}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter slider alpha">
                      </div>
                      <div class="form-group">
                        <label>Box Gap</label>
                        <input name="cboxgap" value="{{$config->cboxgap}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter box gap">
                      </div>
                      <div class="form-group">
                        <label>Top Box Ypos</label>
                        <input name="ctopypos" value="{{$config->ctopypos}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter top box ypos">
                      </div>
                      <div class="form-group">
                        <label>BoxStyle</label>
                        <input name="cboxstyle" value="{{$config->cboxstyle}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter boxstyle">
                      </div>
                      <div class="form-group">
                        <label>CGexternal</label>
                        <input name="ccgexternal" value="{{$config->ccgexternal}}" style="min-width: 70px;" class="form-control sync" type="text" placeholder="Enter cgexternal">
                      </div>
                      <div class="form-group">
                        <label>Perf Button Width</label>
                        <input name="cperfbuttonwidth" value="{{$config->cperfbuttonwidth}}" style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      
                      <div class="form-group">
                        <label>Selector Buttons</label>
                        <input name="selectorbuttons" value="{{$config->selectorbuttons}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Factor Crew Weight</label>
                        <input name="factorcrewweight" value="{{$config->factorcrewweight}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Flight Types</label>
                        <input name="flighttypes" value="{{$config->flighttypes}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Supply Fuel Volume</label>
                        <input name="supplyfuelvolume" value="{{$config->supplyfuelvolume}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Subtract Supply Fuel</label>
                        <input name="subtractsupplyfuel" value="{{$config->subtractsupplyfuel}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Second Max Avail Text</label>
                        <input name="secondmaxavailtext" value="{{$config->secondmaxavailtext}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Depends on Display Button</label>
                        <input name="dependsondisplaybutton" value="{{$config->dependsondisplaybutton}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Max Avail on Manifest</label>
                        <input name="maxavailonmanifest" value="{{$config->maxavailonmanifest}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Fuel Presets</label>
                        <input name="fuelpresets" value="{{$config->fuelpresets}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Auto Landing Fuel Preset</label>
                        <input name="autolandingfuelpreset" value="{{$config->autolandingfuelpreset}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>CG Alarm (T0_LD_ZF)</label>
                        <input name="extra1" value="{{$config->extra1}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Envi Standard Setting</label>
                        <input name="extra2" value="{{$config->extra2}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Enter OAT (ISA/OAT)</label>
                        <input name="extra3" value="{{$config->extra3}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>extra 2 FuelTanks</label>
                        <input name="extra4" value="{{$config->extra4}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Altimeter US</label>
                        <input name="extra5" value="{{$config->extra5}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>show Item on LM if 0</label>
                        <input name="extra6" value="{{$config->extra6}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>allowCustomStation</label>
                        <input name="extra7" value="{{$config->extra7}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Extra 8</label>
                        <input name="extra8" value="{{$config->extra8}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Extra 9</label>
                        <input name="extra9" value="{{$config->extra9}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                      <div class="form-group">
                        <label>Extra 10</label>
                        <input name="extra10" value="{{$config->extra10}}"  style="min-width: 70px;" class="form-control sync" type="text">
                      </div>
                    </div>
                </div>

              <div class="add-items">
                <button style="width: 150px; padding: 10px;" type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal">Add Item</button>
                <button style="width: 150px; padding: 10px;" type="button" class="btn btn-primary btn-lg float-right list-items-btn">Full View</button>
              </div>
              <div class="add-items">
                  <div id="store-items" class="log-data-block"></div>
              </div>
            </div>
             </div>
             <div class="row">
                 <div class="col-sm-12">
                     <div class="button-block">
                       <button onclick="location.href='{{ route('config') }}'" class="btn btn-primary btn-md" type="button">Cancel</button>
                      @if($config->is_locked == 1)
                        <button class="btn btn-info btn-md" type="submit" id="save">Save</button>
                      @else
                        <button class="btn btn-info btn-md save" type="button">Save</button>
                      @endif
                      
                      <button class="btn btn-danger btn-md clearCopiedItems" type="button" onclick="clearCopiedData();">Clear Copied Data</button>
                      <button type="button" class="btn btn-info btn-md pasteItems" data-toggle="modal" data-target="#pasteModal">Paste Items</button> 
                      <button class="btn btn-danger btn-md undo" type="button" style="display:none;" onclick="undoChanges('configurations',{{$config->configurations_id}});">Undo Last Changes</button>
                    </div>
                 </div>
             </div>
             <div style="height: 50px; margin-top: 15px">
               <div class='gyronimo-handle'></div>
             </div>
            </div>
        </div>
    </div>

 <!-- copy config data -->
 <div class="modal fade" id="configModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content" style="padding: 5%;">
				<!-- <div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
					<h4 class="modal-title" id="myModalLabel">Promo QR Code</h4>
				</div> -->
				<div class="modal-body text-center">
          <label style="font-size: 20px;">Copy this config to</label><br />
          <label style="font-size: 20px;" id="clientEmail">Copy this config to</label><br />
					<label style="font-size: 20px;">Are You Sure?</label>

          <div class="button-block" style="padding-left: 25%;">
            <button class="btn btn-primary btn-md" data-dismiss="modal" aria-hidden="true" type="button">Cancel</button>
            <button class="btn btn-info btn-md" type="submit" id="copyConfigData">Copy</button>
          </div>

				</div>
				<!-- <div class="modal-footer">
					<a id="downloadQR" class="btn btn-primary" download><i class="fa fa-download"></i>  Download QR Code</a>
				</div> -->
			</div>
		</div>
	</div>

  <div class="modal" tabindex="-1" role="dialog" id="pasteModal">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" style="
    position: absolute;
    left: 100px;">Select position for paste items</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" style="
    text-align: center;">
          <div class="form-check">
      <input class="form-check-input" type="checkbox" value="end" id="flexCheckChecked">
      <label class="form-check-label" for="flexCheckChecked"style="font-size: 15;">
      At the end of the list
      </label>
        </div>
        <h6 class="or" style="margin-top:10px;">OR</h6>
        <input name="ItemPosition" id="itemPosition" type = "text" style="width: 300px;margin-left: 80px;margin-top: 10px;" placeholder = "Enter position to paste items" class="form-control" autocomplete="off">
        <div class = "show_warning" style="width: 300px;margin-left: 80px;margin-top: 10px;display: block;"></div>
      </div>
    
     
      <div class="modal-footer"style="flex-direction: column;">
        <button type="button" class="btn btn-primary" style="justify-content: center;" onclick="pasteItem();">Paste at Selected Position</button>
        <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button> -->
      </div>
    </div>
  </div>
</div>

<input id="current" type="hidden">
<input id="item-type" type="hidden">
<input id="rows" type="hidden" value="0">
<input id="selected-list-item" type="hidden">
<input id="topY" name="top_y" type="hidden">
<input id="bottomY" name="bottom_y" type="hidden">
<input id="leftX" name="left_x" type="hidden">
<input id="rightX" name="right_x" type="hidden">
<input id="store" name="store" type="hidden">
<input id="config" type="hidden" value="{{Request::segment(3)}}">
<input id="config-image-id" name="image2" type="hidden" value="{{$config->image2}}">
</form>

<h1 id="copied"></h1>
</div>
<script src="{{asset('js/jquery-1.12.4.js')}}"></script>
<script type="text/javascript" src="{{asset('js/jquery-ui.js')}}"></script>
<script type="text/javascript">
var synced = true;
var collapseCounter = 0;
var store = new Array();
// var copyItem = [];
var appUrl = 	window.location.origin ? window.location.origin + '/' : window.location.protocol + '/' + window.location.host;
var settings = {
  configId: $('#config').val(),
  lineWidthPx: 6,
  yellowLineWidthPx: 6
};

var iSeatSymbolData = {!! json_encode($iSeatSymbol->toArray()) !!};
var iSeatSymbolOptions = "";
Object.keys(iSeatSymbolData).forEach(function (k) {
  var option = "<option value='" + iSeatSymbolData[k].iseatsymbol_id + "'>" + iSeatSymbolData[k].iseatsymbol + "</option>";
  iSeatSymbolOptions += option;
});

var iSpecialData = {!! json_encode($iSpecials->toArray()) !!};
var iSpecialsOptions = "";
Object.keys(iSpecialData).forEach(function (k) {
  var option = "<option value='" + iSpecialData[k].ispecial_id + "'>" + iSpecialData[k].ispecial + "</option>";
  iSpecialsOptions += option;
});

syncStore();

window.onbeforeunload = function (e) {
  if(!synced) {
    var e = e || window.event;
    if (e) {
      e.returnValue = 'Data not saved yet!';
    }
    return 'Data not saved yet!';
  }
};
function undoChanges(table_name, row_id){
  if (confirm('Undo will reverse the last saved changes (except item deletion). Are you sure you want to proceed?')) {
    $.ajax({
      url: '/config/undoChanges',
      cache: false,
      type: 'post',
      data: {table_name:table_name, row_id:row_id},
      success: function(data) {
         location.reload();
      }
    });  
  }  
}

$(document).ready(function () {
  $(document).on('keyup change', '.sync', function () {
    synced = false;
  });

  $("#store-items").sortable({
    opacity: 0.7,
    cursor: 'move',
    update: function(event, ui) {
      var lists = $(this).sortable('toArray').toString().split(',');
      var sequence = 1;
      var newStore = [];
      var counter = 4;
      var dataId = $('.duplicate-item-btn').data('id');
      Object.keys(lists).forEach(function (list) {
        var item = lists[list];
        $('#counter').html(parseInt(counter) + parseInt(dataId));
        window.store[item].sequence = sequence;
        newStore.push(window.store[item]);
        sequence++;
      });
      syncStore();
      window.store.length = 0;
      window.store = newStore.slice();
      displayStore();
    }
  });

  $("#fwd-red-line, #aft-blue-line, #x1-yellow-line, #x2-green-line").draggable({
    containment: "#wrapper",
    scroll: false
  });

  var box = getDimensionDiv('wrapper');
  var aircraftWidth = box.width / 2 + box.width * 30 / 100;
  var yellowlineLeft = parseInt($("#x1-yellow-line").css('left'), 10);
  // if(yellowlineLeft == 106) {
  //   $("#x1-yellow-line").css('left', (aircraftWidth / 2));
  //   // $("#x1-yellow-line").css('top', (box.height / 2));
  // }

  var x1LineCss = parseInt("<?php echo $config->x1_left_px; ?>", 10) - (window.settings.yellowLineWidthPx / 2);
  $("#x1-yellow-line").css('top', "<?php echo $config->x1_top_px; ?>");
  $("#x1-yellow-line").css('left', x1LineCss);

  var x2LineCss = parseInt("<?php echo $config->x2_left_px; ?>", 10) - (window.settings.lineWidthPx / 2);
  $("#x2-green-line").css('top', "<?php echo $config->x2_top_px; ?>");
  $("#x2-green-line").css('left', x2LineCss);

  var fwdLineCss = parseInt("<?php echo $config->fwd_top_px; ?>", 10) - (window.settings.lineWidthPx / 2);
  $("#fwd-red-line").css('top', fwdLineCss);
  $("#fwd-red-line").css('left', "<?php echo $config->fwd_left_px; ?>");

  var aftLineCss = parseInt("<?php echo $config->aft_top_px; ?>", 10) - (window.settings.lineWidthPx / 2);
  $("#aft-blue-line").css('top', aftLineCss);
  $("#aft-blue-line").css('left', "<?php echo $config->aft_left_px; ?>");


  if($('#box-width-input').val() == 0 && $('#box-height-input').val() == 0) {
    $('#box-width-input').val(box.width);
    $('#box-height-input').val(box.height);
  }
  document.getElementById("wrapper").style.width = $('#box-width-input').val() + "px";
  document.getElementById("wrapper").style.height = $('#box-height-input').val() + "px";

  var aircraft = getDimensionDiv('aircraft-img');
  if($('#aircraft-width-input').val() == 0 && $('#aircraft-height-input').val() == 0) {
    $('#aircraft-width-input').val(parseInt(aircraftWidth, 10));
    $('#aircraft-height-input').val(aircraft.height);
  }
  document.getElementById("aircraft-img").style.width = $('#aircraft-width-input').val() + "px";
  document.getElementById("aircraft-img").style.height = $('#aircraft-height-input').val() + "px";
  document.getElementById("aircraft-img").style.top = $('#aircraft-ypos-input').val() + "px";
  document.getElementById("aircraft-img").style.left = $('#aircraft-xpos-input').val() + "px";

  // lines y and x pos  
  // $('#line-fwd-ypos-input').val(extractInt("<?php echo $config->fwd_top_px; ?>"));
  // $('#line-aft-ypos-input').val(extractInt("<?php echo $config->aft_top_px; ?>"));
  // $('#line-x1-xpos-input').val(extractInt("<?php echo $config->x1_left_px; ?>"));
  // $('#line-x2-xpos-input').val(extractInt("<?php echo $config->x2_left_px; ?>"));

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $.ajax({
      url: '/components/' + window.settings.configId,
      cache: false,
      type: 'get',
      success: function(data) {
          var components = JSON.parse(data);
          setLinesDefaultOffset(false);
          Object.keys(components).forEach(function (component) {
            var comp = components[component];
            var status = comp.status;
            if (status === 1) { return; }
            //symbol
            var width = comp.isymbolwidth != 0 ? comp.isymbolwidth : comp.width;
            var height = comp.isymbolheight != 0 ? comp.isymbolheight : comp.height;
            var partId = comp.part_id;

            var unitY = parseFloat(comp.ilatarm, 10);
            var offsetUnitY = parseInt(comp.ilongoffset, 10);
            var pxY = getPxY(unitY, offsetUnitY, height);

            var unitX = parseFloat(comp.ilongarm, 10);
            var offsetUnitX = parseInt(comp.ilatoffset, 10);
            var pxX = getPxX(unitX, offsetUnitX, width);
            var src = comp.image ? appUrl + 'uploads/' + comp.image : '';

            $('#rows').val(comp.id);
            var data = {
              row: comp.id,
              id: comp.item_id,
              partId,
              unitX,
              unitY,
              pxX: pxX + 'px',
              pxY: pxY + 'px',
              src,
              width,
              height,
              rotation: comp.irotation,
              iLatOffset: comp.ilatoffset,
              iLongOffset: comp.ilongoffset,
              label: comp.iseatlabel,
              name: comp.istationname,
              ionoff: comp.ionoff,
              specials: comp.ispecials,
              symbolname: comp.iseatsymbol,
              occw: comp.ioccweight,
              itemw: comp.iweight,
              maxw: comp.imaxweight,
              occname: comp.ioccname,
              leftright: comp.ileftright,
              alternate: comp.iarmalternate,
              status: comp.status,
              type: comp.type,
              sequence: comp.sequence,
            };

            addSymbol(data.type, data.partId, data.pxY, data.pxX, data.src, width, height, data.label, data.rotation);
            window.store.push(data);
          });
          displayStore();
      }
  });

  $('.create-symbol-item').on('click', function () {
    document.getElementById("current").value = $(this).attr('id');
    document.getElementById("item-type").value = "symbol";
    createItem();
  });

  $('.create-no-symbol-item').on('change', function () {
    document.getElementById("current").value = $(this).val();
    document.getElementById("item-type").value = "no-symbol";
    var asset = $(this).find(':selected').data('asset');
    createItem(asset);
  });

  $("#show-configurations").click(function(){
    $("#from-demo").toggle();
  });

  // $("#show-topconfigurations").click(function(){
  //   $("#top-div").toggle();
  //   $(".lines").toggle();
  //   $(".helicopter-wrapper").toggle();
  // });

  $(".list-items-btn").click(function () {
    if(collapseCounter % 2 === 0) {
      $('.list-items').collapse("show");
    } else {
      $('.list-items').collapse("hide");
    }
    $(this).text(function(i, v) {
       return v === 'Full View' ? 'List View' : 'Full View'
    })
    collapseCounter++;
  });

  $(document).on('click', '.item-list-toggle', function () {
    $(this).text(function(i, v){
       return v === 'Full View' ? 'List View' : 'Full View'
    })
  });

  $('#box-width-input').on('keyup mouseup', function () {
    document.getElementById("wrapper").style.width = $(this).val() + "px";
    updateXPositions();
  });

  $('#box-height-input').on('keyup mouseup', function () {
    document.getElementById("wrapper").style.height = $(this).val() + "px";
    updateYPositions();
  });

  $("#aircraft-selector").change(function(){
    var aircraftImage = '/uploads/' + $(this).find(':selected').data('thumbnail');
    var aircraftId = $(this).val();
    $('#config-image-id').val(aircraftId);
    $('#aircraft-img').attr('src', aircraftImage);
  });

  $('#aircraft-width-input').on('keyup mouseup', function () {
    document.getElementById("aircraft-img").style.width = $(this).val() + "px";
  });

  $('#aircraft-height-input').on('keyup mouseup', function () {
    document.getElementById("aircraft-img").style.height = $(this).val() + "px";
  });

  $('#aircraft-ypos-input').on('keyup mouseup', function () {
    document.getElementById("aircraft-img").style.top = $(this).val() + "px";
  });

  $('#aircraft-xpos-input').on('keyup mouseup', function () {
    document.getElementById("aircraft-img").style.left = $(this).val() + "px";
  });

  $('#line-fwd-ypos-input').on('keyup mouseup', function () {
    var centerFwdLineCss = parseInt($(this).val(), 10) - (window.settings.lineWidthPx / 2);
    document.getElementById("fwd-red-line").style.top = centerFwdLineCss + "px";
    setLinesDefaultOffset(false);
    updateXPositions();
    updateYPositions();
  });

  $('#line-aft-ypos-input').on('keyup mouseup', function () {
    var centerAftLineCss = parseInt($(this).val(), 10) - (window.settings.lineWidthPx / 2);
    document.getElementById("aft-blue-line").style.top = centerAftLineCss + "px";
    setLinesDefaultOffset(false);
    updateXPositions();
    updateYPositions();
  });

  $('#line-x1-xpos-input').on('keyup mouseup', function () {
    var centerX1YellowCss = parseInt($(this).val(), 10) - (window.settings.yellowLineWidthPx / 2);
    document.getElementById("x1-yellow-line").style.left = centerX1YellowCss + "px";
    setLinesDefaultOffset(false);
    updateXPositions();
    updateYPositions();
  });

  $('#line-x2-xpos-input').on('keyup mouseup', function () {
    var centerX2PosLineCss = parseInt($(this).val(), 10) - (window.settings.lineWidthPx / 2);
    document.getElementById("x2-green-line").style.left = centerX2PosLineCss + "px";
    setLinesDefaultOffset(false);
    updateXPositions();
    updateYPositions();
  });

  $('#fwd-input, #aft-input').on('keyup mouseup', function () {
    updateYPositions();
  });

  $('#x1-input, #x2-input').on('keyup mouseup', function () {
    updateXPositions();
  });

  $('#center-btn').on('click', function () {
    var box = getDimensionDiv('wrapper');
    var centerX1Yellow = parseInt(box.width / 2, 10);
    var centerX1YellowCss = centerX1Yellow - (window.settings.yellowLineWidthPx / 2);
    $("#x1-yellow-line").css('left', centerX1YellowCss + "px");
    $('#line-x1-xpos-input').val(centerX1Yellow);
    syncStore();

    var aircraft = getDimension('aircraft-img');
    var centerAircraft = parseInt((box.width / 2 - aircraft.width), 10);
    $("#aircraft-img").css('left', centerAircraft + "px");
    $('#aircraft-xpos-input').val(centerAircraft);

    setLinesDefaultOffset(false);
    updateXPositions();
    updateYPositions();    
  });

  $(document).on('keyup mouseup', '.item-label-input', function () {
    var id = $(this).attr('id');
    var type = $(this).data('type');
    window.store[id].label = $(this).val();
    if (type == 'symbol') {
      $("#" + window.store[id].partId + " span").html($(this).val());
    }
    syncStore();
  });

  $(document).on('keyup mouseup', '.item-name-input', function () {
    var id = $(this).attr('id');
    window.store[id].name = $(this).val();
    syncStore();
  });

  $(document).on('keyup mouseup', '.item-ionoff-input', function () {
    var id = $(this).attr('id');
    window.store[id].ionoff = $(this).val();
    syncStore();
  });

  $(document).on('change', '.item-specials-select', function () {
    var id = $(this).attr('id');
    window.store[id].specials = $(this).val();
    syncStore();
  });

  $(document).on('keyup mouseup', '.unit-x-input', function () {
    updateXUnit($(this).attr('id'), $(this).val());
  });

  $(document).on('keyup mouseup', '.unit-y-input', function () {
    updateYUnit($(this).attr('id'), $(this).val());
  });

  $(document).on('keyup mouseup', '.item-width-input', function () {
    var type = $(this).data('type');
    updateItemWidth($(this).attr('id'), $(this).val(), type);
  });

  $(document).on('keyup mouseup', '.item-height-input', function () {
    var type = $(this).data('type');
    updateItemHeight($(this).attr('id'), $(this).val(), type);
  });

  $(document).on('keyup mouseup', '.item-rotation-input', function () {
    var type = $(this).data('type');
    updateItemRotation($(this).attr('id'), $(this).val(), type);
  });

  $(document).on('keyup mouseup', '.item-ilatoffset-input', function () {
    var id = $(this).attr('id');
    window.store[id].iLatOffset = $(this).val();
    updateXPosition(id);
  });

  $(document).on('keyup mouseup', '.item-ilongoffset-input', function () {
    var id = $(this).attr('id');
    window.store[id].iLongOffset = $(this).val();
    updateYPosition(id);
  });

  $(document).on('keyup mouseup', '.occ-weight-input', function () {
    var id = $(this).attr('id');
    window.store[id].occw = $(this).val();
    syncStore();
  });

  $(document).on('keyup mouseup', '.item-weight-input', function () {
    var id = $(this).attr('id');
    window.store[id].itemw = $(this).val();
    syncStore();;
  });

  $(document).on('keyup mouseup', '.item-max-input', function () {
    var id = $(this).attr('id');
    window.store[id].maxw = $(this).val();
    syncStore();
  });

  $(document).on('change', '.item-symbol-name-select', function () {
    var id = $(this).attr('id');
    window.store[id].symbolname = $(this).val();
    syncStore();
  });

  $(document).on('keyup mouseup', '.occ-name-input', function () {
     var id = $(this).attr('id');
    window.store[id].occname = $(this).val();
    syncStore();
  });

  $(document).on('change', '.item-leftright-select', function () {
    var id = $(this).attr('id');
    window.store[id].leftright = $(this).val();
    syncStore();
  });

  $(document).on('keyup mouseup', '.item-alternate-input', function () {
    var id = $(this).attr('id');
    window.store[id].alternate = $(this).val();
    syncStore();
  });

  $(document).on('click', '.item-trash', function () {
    if (confirm('Are you sure ?')) {
      var id = $(this).attr('id');
      var partId = window.store[id].partId;
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/api/component/' + partId,
        cache: false,
        type: 'delete',
        success: function(data) {
            window.store.splice(id, 1);
            $('#' + partId).remove();
            syncStore();
            displayStore();
        }
      });
    }
  });

  $(document).on('click', '.list-item-symbol', function () {
    $('#selected-list-item').val($(this).attr('id'));
    $('#update-symbol-model').modal('toggle');
  });

  $(document).on('click', '.img-symbol', function () {
    var selectedSymbolId = $(this).attr('id');
    var selectedSymbolSrc = $(this).attr('src');
    var selectedSymbolWidth = $(this).attr('width');
    var selectedSymbolHeight = $(this).attr('height');
    var selectedListItem = $('#selected-list-item').val();
    window.store[selectedListItem].id = selectedSymbolId;
    window.store[selectedListItem].src = selectedSymbolSrc;
    window.store[selectedListItem].width = extractInt(selectedSymbolWidth);
    window.store[selectedListItem].height = extractInt(selectedSymbolHeight);
    var partId = window.store[selectedListItem].partId;
    syncStore();
    displayStore();
    $('#' + partId + ' img')
                  .attr('src', selectedSymbolSrc)
                  .width(selectedSymbolWidth)
                  .height(selectedSymbolHeight);
    $('#update-symbol-model').modal('toggle');
  });

  $(document).on('click', '.duplicate-item-btn', function () {
    var itemId = $(this).data('id');
    var item = window.store[itemId];
    var partId = generatePartId();
    var row = item['row'] + 1;
    var cloneItem = {
      row,
      id: item.id,
      partId,
      unitX: item.unitX,
      unitY: item.unitY,
      pxX: item.pxX,
      pxY: item.pxY,
      src: item.src,
      width: item.width,
      height: item.height,
      rotation: item.rotation,
      iLatOffset: item.iLatOffset,
      iLongOffset: item.iLongOffset,
      label: item.label,
      name: item.name,
      ionoff: item.ionoff,
      specials: item.specials,
      symbolname: item.symbolname,
      occw: item.occw,
      itemw: item.itemw,
      maxw: item.maxw,
      occname: item.occname,
      leftright: item.leftright,
      alternate: item.alternate,
      status: item.status,
      type: item.type,
      sequence: getNewSequence(),
    };
    window.store.push(cloneItem);
    addSymbol(item.type, partId , item.pxY, item.pxX, item.src, item.width, item.height, item.label, item.rotation);
    syncStore();
    displayStore();
  });

  $(document).on("submit", '#gyronimo', function(e) {

    var clientSelection = $('#copyConfig').val();
    var clientEmail = $('#copyConfig').find('option:selected').text();
    var authId = $('#auth_id').text();
    if(authId != "2"){
      if(clientSelection != ""){
        $('#configModal').modal('show');
        $('#clientEmail').html(clientEmail);
        // copyConfigurationData();
        return false;
      }
    }
    
     var form = $(this);
     e.preventDefault();
     $.ajaxSetup({
       headers: {
         'X-CSRF-TOKEN':  $('meta[name="csrf-token"]').attr('content')
       }
     });
     $.ajax({
        type: "POST",
        cache: false,
        url: form.attr('action'),
        data: form.serialize(),
        processData: true,
        dataType: "json",
        success: function (json) {
          synced = true;
          $('.gyronimo-handle').html(json.message);
          $('.gyronimo-handle').removeClass("hidden");
          $('.gyronimo-handle').addClass("alert alert-dark-success");
          setTimeout(function () {
            $('.gyronimo-handle').addClass("hidden");
          }, 5000);
          $('.undo').show();
        },
        error: function () {
          $('.gyronimo-handle').html('Something went wrong!');
          $('.gyronimo-handle').removeClass("hidden");
          $('.gyronimo-handle').addClass("alert alert-dark-danger");
          setTimeout(function () {
            $('.gyronimo-handle').addClass("hidden");
          }, 5000);
        }
    });
  });
});

$(document).ready(function() {
    $(".item-height-input").trigger("mouseup");
});

$(window).load(function() {
    $(".item-height-input").trigger("mouseup");
});

function getNewSequence() {
  var sequence = 1;
  if (window.store.length > 0) {
    var s = Math.max.apply(Math, window.store.map(function(s) { return s.sequence; }));
    sequence = s + 1;
  }  
  return sequence;
}

function generatePartId() {
  return "part" + Math.floor(Math.random() * 100000000000000) + 1;
}

function addSymbol(type, partId, pxY, pxX, src, width, height, label, rotation) {
  if (type == 'symbol') {
    $('.aircraft-img-wrapper').append(
      "<div class='helicopter-wrapper' id='" + partId + "' style='position: absolute; top: " + pxY + "; left: " + pxX + "; z-index: 111; color: #fff; font-size: 25px; text-align: center;'>" +
        "<img class='helicopter-parts' src='" + src + "' style='width: " + width + "px; height: " + height + "px;'>" +
        "<span id='item-label'>" + label + "</span>" +
      "</div>"
    );
    rotate(partId, rotation);
  }
}

function createItem(asset) {
  setLinesDefaultOffset();

  var id = document.getElementById("current").value;
  var type = document.getElementById("item-type").value;
  var row = parseInt(document.getElementById("rows").value, 10) + 1;
  if (type == "symbol") {
    // var width = $('#' + id).attr('width');
    // var height = $('#' + id).attr('height');
    // var w = width.replace(/\D+$/g, "");
    // var h = height.replace(/\D+$/g, "");
    var src = $('#' + id).attr('src');

    var width = 50;
    var height = 50;

    var specials = 1;
    var symbolname = 1;
    var itemw = 0;
    var name = 'name';
    var ionoff = 1;
    var alternate = '';

  } else {
    var src = "";
    var width = 0;
    var height = 0;

    if(asset) {
      var specials = asset.special_item_specials;
      var symbolname = asset.special_item_symbol;
      var itemw = asset.special_item_weight;
      var name = asset.special_item_station_name;
      var ionoff = asset.special_item_ionoff;
      var alternate = asset.special_item_alternate;

    } else {
      var specials = 1;
      var symbolname = 1;
      var itemw = 0;
      var name = 'name';
      var ionoff = 1;
      var alternate = '';
    }
  }

  var unitY = parseInt(document.getElementById("fwd-input").value, 10);
  var pxY = getPxY(unitY, 0, height);

  var unitX = parseFloat(document.getElementById("x1-input").value, 10);
  var pxX = getPxX(unitX, 0, width);

  var partId = generatePartId();

  var data = {
    row,
    id,
    partId,
    unitX,
    unitY,
    pxX: pxX + 'px',
    pxY: pxY + 'px',
    src,
    width,
    height,
    rotation: 0,
    iLatOffset: 0,
    iLongOffset: 0,
    label: '',
    name,
    ionoff,
    specials,
    symbolname,
    occw: 0,
    itemw,
    maxw: 300,
    occname: '-',
    leftright: '',
    alternate,
    status: 0,
    type,
    sequence: getNewSequence(),
  };

  addSymbol(type, data.partId, data.pxY, data.pxX, src, width, height, data.label, data.rotation);
  window.store.push(data);
  document.getElementById("rows").value = row;
  syncStore();
  displayStore();
  $('#myModal').modal('hide');
  synced = false;
}

function getClass(type) {
  if(type == "no-symbol") {
    return "special-item-hidden";
  }
  return "";
}
$( "#flexCheckChecked" ).click(function() {
if ($(this).prop('checked')) {
  $("#itemPosition").hide()
    $("#itemPosition").val("");
    $(".show_warning").html("")
    $('.show_warning').removeClass("alert alert-dark-danger");
    $(".or").hide();
        }
        else {
    $("#itemPosition").css({'border':''})
    $("#itemPosition").show();
    $(".or").show();
        }
      });
// $(document).on('change', '.sel', function() {
//   var option = $(".sel").val();
//   if(option === "end"){
//     $("#itemPosition").hide()
//     $("#itemPosition").val("");
//     $(".show_warning").html("")
//     $('.show_warning').removeClass("alert alert-dark-danger");
//   }else{
//     $("#itemPosition").css({'border':''})
//     $("#itemPosition").show();
//   }
//   // Does some stuff and logs the event to the console
// });
$("input").keypress(function(){
  $("#itemPosition").css({'border':''})
  $(".show_warning").html("")
  $('.show_warning').removeClass("alert alert-dark-danger");
   
  var availableTags = [];
    var noOfIds = $('.store-item').map(function() { 
      var no = $(this).attr('data-value');
      availableTags.push(no);
      return no;
    });
  
    $( "#itemPosition" ).autocomplete({
      source:  availableTags,
    });
  });
  var partIdArray = [];
function pasteItem(){
  console.log('partIdArray', partIdArray)
  var noOfIds = $('.store-item').map(function() {
    return $(this).attr('id');
  });
  var copieditems = JSON.parse(localStorage.getItem("copyItems"));
  var count_of_copied = copieditems.length;
  // var option = $(".sel").val();
  var position = parseInt($("#itemPosition").val()) - 4;
    // if(option ==="val"){
      if ($("#flexCheckChecked").prop('checked')) {
         position = parseInt(noOfIds.length);
          
        }
        else {
       if(position === "") {
        $("#itemPosition").css({'border':'solid red'})
        $(".show_warning").html("Value field can not be blank")
        $('.show_warning').addClass("alert alert-dark-danger");

        return false;
      }
      else if(parseInt(noOfIds.length) <= position || parseInt($("#itemPosition").val()) < 4 ) {
        $("#itemPosition").css({'border':'solid red'})
        $(".show_warning").html("Please insert value starting from 4 and must be less than or equal to "+(parseInt(noOfIds.length)+3));
        $('.show_warning').addClass("alert alert-dark-danger");

        return false;
      }
      else {
        position = position;
      }
    }
    // }
    // else {
    //   $("#itemPosition").css({'border':''})
    // }
   
    //  if(position === "" || (parseInt(noOfIds.length) < parseInt(position))){
        
    //  }
    //  else{
      
    //  }
     $('#store-items').find( ".store-item" ).eq(position).nextAll().andSelf().remove();
     var rearrangedData = new Array();
     var index = position;
     $.each(window.store, function(key,item){
       if(key >= index){
         if(window.store[index] !== undefined){
          rearrangedData.push(window.store[index]);
          window.store.splice(index, 1);
         }
       }
     });
     console.log('copieditems', copieditems);
    //  console.log('partId', $('#' + partI
     console.log('window', window);
     
    //  copieditems.forEach((copyElement, indexVal) => {  //copied element

    //   // partIdArray.forEach(partIdObject => {    // copeid element id
    //     // if(partIdObject == copyElement.partId) {
    //         window.iSeatSymbolData.forEach(element => {    //dropdown value
    //         element[indexVal] = copyElement.partId;
    //       // })
    //     // }
    //   });

    //   partIdArray.forEach(partIdObject => {
    //     if(partIdObject == copyElement.partId) {
    //       window.iSpecialData.forEach(element => {
    //         element[indexVal] = copyElement.partId;
    //       })
    //     }
    //   });

    //   console.log('iSeatSymbolData', window.iSeatSymbolData);
    //   console.log('iSpecialData', window.iSpecialData);
    // });
     Object.keys(copieditems).forEach(function (k) {
     var item = copieditems[k];
     var nextIndex = position;
     var count = nextIndex + 4;
     var itemInfo = JSON.stringify(item);
      $('#store-items').append(
       "<div class='row-block store-item' id='" + (nextIndex + parseInt(k)) + "' data-value='"+(parseInt(k) + count)+"'>" +
          "<button type='button' data-toggle='collapse' data-target='#list-items-" + (nextIndex + parseInt(k)) + "' class='btn btn-warning btn-xs item-list-toggle float-right'>Full View</button>" +
          "<button type='button' data-id='" + (nextIndex + parseInt(k)) + "' class='btn btn-success btn-xs duplicate-item-btn float-right'>Duplicate</button>" +
          "<div class='log-block'>" +
              "<label id='counter' style='font-size: 19px;color: #e61010;position: absolute;margin-top: 5px;margin-left: 7px;'>"+(parseInt(k) + count)+"</label><br/>"+
              "<div class='form-group'>" +
                  "<i id='" + (nextIndex + parseInt(k)) + "' class='fa fa-trash item-trash'></i>" +
              "</div>" +
              "<div class='form-group'>" +
              "<i id='copy_" + (nextIndex + parseInt(k)) + "' class='fa fa-copy item-copy' onclick= 'CopyItems("+itemInfo+", "+(nextIndex + parseInt(k))+");' value =''></i>" +
              "</div>" +
              "<div class='form-group'>" +
                  "<label>Seat Label</label>" +
                  "<input data-type='" + item.type + "' class='item-label-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.label + "' />" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Name</label>" +
                "<input style='min-width: 120px !important;' class='item-name-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.name + "'>" +
              "</div>" +
              "<div class='form-group " + getClass(item.type) + "'>" +
                  "<div style='width: 60px; cursor: pointer;'>" +
                     "<img class='list-item-symbol' style='width:100%;' id='" + (nextIndex + parseInt(k)) + "' src='" + item.src + "'>" +
                  "</div>" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Long</label>" +
                "<input class='unit-y-input form-control sync' step='any' type='number' id='" + (nextIndex + parseInt(k)) + "' value='" + item.unitY + "' />" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Lat</label>" +
                "<input class='unit-x-input form-control sync' step='any' type='number' id='" + (nextIndex + parseInt(k)) + "' value='" + item.unitX + "' />" +
              "</div>" +
              "<div class='form-group " + getClass(item.type) + "'>" +
                "<label>Rotation</label>" +
                "<input data-type='" + item.type + "' class='item-rotation-input form-control sync' step='any' type='number' min='-360' max='360' id='" + (nextIndex + parseInt(k)) + "' value='" + item.rotation + "' />" +
              "</div>" +
              "<div id='list-items-" + (nextIndex + parseInt(k)) + "' class='collapse list-items'>" +
                "<div class='form-group " + getClass(item.type) + "'>" +
                   "<label>Symbol Width</label>" +
                   "<input data-type='" + item.type + "' type='number' class='item-width-input form-control sync' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.width + "'>" +
                "</div>" +
                "<div class='form-group " + getClass(item.type) + "'>" +
                   "<label>Symbol Height</label>" +
                   "<input data-type='" + item.type + "' type='number' class='item-height-input form-control sync' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.height + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Offset Long</label>" +
                   "<input class='item-ilongoffset-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.iLongOffset + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Offset Lat</label>" +
                   "<input class='item-ilatoffset-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.iLatOffset + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>On/Off</label>" +
                  "<input class='item-ionoff-input form-control sync' title='0/1' placeholder='0/1' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.ionoff + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Specials</label>" +
                  "<select class='item-specials-select item-specials-select-" + (nextIndex + parseInt(k)) + " form-control sync'  id='" + (nextIndex + parseInt(k)) + "'>" +
                   "</select>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Symbol Name</label>" +
                  "<select class='item-symbol-name-select item-symbol-name-select-" + (nextIndex + parseInt(k)) + " form-control sync' id='" + (nextIndex + parseInt(k)) + "'>" +
                   "</select>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Occ Weight</label>" +
                   "<input style='min-width: 70px;' class='occ-weight-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.occw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Item Weight</label>" +
                   "<input style='min-width: 70px;' class='item-weight-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.itemw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Max Weight</label>" +
                   "<input style='min-width: 70px;' class='item-max-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.maxw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Occ Name</label>" +
                   "<input style='min-width: 70px;' class='occ-name-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.occname + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Left/Right</label>" +
                  "<select class='item-leftright-select item-leftright-select-" + (nextIndex + parseInt(k)) + " form-control sync' id='" + (position + parseInt(k)) + "'>"+
                  "</select>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Arm Alternate </label>" +
                   "<input style='min-width: 70px;' class='item-alternatecd-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.alternate + "'>" +
                "</div>" +
              "</div>" +
          "</div>" +
       "</div>"
     );
     
    //  $('.item-symbol-name-select-' + (nextIndex + parseInt(k))).val(item.symbolname);
    $('.item-leftright-select-' + (nextIndex + parseInt(k))).val(item.leftright);
    //  $('.item-specials-select-' + (nextIndex + parseInt(k))).val(item.specials);
     var itemId = (nextIndex + parseInt(k));
     console.log(itemId);
     var item = item;
     var partId = generatePartId();
     console.log('k', copieditems[k]);
     console.log()
     if(copieditems[k].leftright == "R"){
      console.log("R");
      $("#"+itemId+".item-leftright-select-"+itemId).append(
          $("<option value='-'>-</option><option value='L'>L</option><option value='R' selected>R</option>")
        );
     }
     else if(copieditems[k].leftright == "L"){
      $("#"+itemId+".item-leftright-select-"+itemId).append(
          $("<option value='-'>-</option><option value='L' selected>L</option><option value='R'>R</option>")
        );
     }
     else{
      console.log("else");
      $("#"+itemId+".item-leftright-select-"+itemId).append(
          $("<option value='-'>-</option><option value='L'>L</option><option value='R'>R</option>")
        );
     }
     window.iSeatSymbolData.forEach(element => {
        // partIdArray.forEach(partIdObject => {
          // if(partIdObject == copieditems[k].partId) {
            if(parseInt(copieditems[k].symbolname) == element.iseatsymbol_id){
              element.selectedItem = "selected";
             } else {
               element.selectedItem = "";
             }
          // }
        // });
        $("#"+itemId+".item-symbol-name-select-"+itemId).append(
            $("<option value = "+element.iseatsymbol_id+" "+element.selectedItem+">"+element.iseatsymbol+"</option>")
            );
        }); 
        
        window.iSpecialData.forEach(element => {
        // partIdArray.forEach(partIdObject => {
          // if(partIdObject == copieditems[k].partId) {
            if(parseInt(copieditems[k].specials) == element.ispecial_id){
              element.selectedItem = "selected";
            } else {
              element.selectedItem = "";
            }
            $("#"+itemId+".item-specials-select-"+itemId).append(
              $("<option value = "+element.ispecial_id+" "+element.selectedItem+">"+element.ispecial+"</option>")
              );
            // }
        // }); 
        }); 
        


    var row = item['row'];
    var cloneItem = {
      row,
      id: item.id,
      partId,
      unitX: item.unitX,
      unitY: item.unitY,
      pxX: item.pxX,
      pxY: item.pxY,
      src: item.src,
      width: item.width,
      height: item.height,
      rotation: item.rotation,
      iLatOffset: item.iLatOffset,
      iLongOffset: item.iLongOffset,
      label: item.label,
      name: item.name,
      ionoff: item.ionoff,
      specials: item.specials,
      symbolname: item.symbolname,
      occw: item.occw,
      itemw: item.itemw,
      maxw: item.maxw,
      occname: item.occname,
      leftright: item.leftright,
      alternate: item.alternate,
      status: item.status,
      type: item.type,
      sequence: getNewSequence(),
    };
    window.store.push(cloneItem);
    addSymbol(item.type, partId , item.pxY, item.pxX, item.src, item.width, item.height, item.label, item.rotation);
    syncStore();
  });
  var ids = $('.store-item').map(function() {
    return $(this).attr('id');
  });
  var nextIndex = position + count_of_copied;
  Object.keys(rearrangedData).forEach(function (k) {
     var item = rearrangedData[k];
     var count = parseInt(ids.length) + 4;
     var itemInfo = JSON.stringify(item);
      $('#store-items').append(
       "<div class='row-block store-item' id='" + (nextIndex + parseInt(k)) + "' data-value='"+(parseInt(k) + parseInt(count))+"'>" +
          "<button type='button' data-toggle='collapse' data-target='#list-items-" + (nextIndex + parseInt(k)) + "' class='btn btn-warning btn-xs item-list-toggle float-right'>Full View</button>" +
          "<button type='button' data-id='" + (nextIndex + parseInt(k)) + "' class='btn btn-success btn-xs duplicate-item-btn float-right'>Duplicate</button>" +
          "<div class='log-block'>" +
              "<label id='counter' style='font-size: 19px;color: #e61010;position: absolute;margin-top: 5px;margin-left: 7px;'>"+(parseInt(k) + parseInt(count))+"</label><br/>"+
              "<div class='form-group'>" +
                  "<i id='" + (nextIndex + parseInt(k)) + "' class='fa fa-trash item-trash'></i>" +
              "</div>" +
              "<div class='form-group'>" +
              "<i id='copy_" + (nextIndex + parseInt(k)) + "' class='fa fa-copy item-copy' onclick= 'CopyItems("+itemInfo+", "+(nextIndex + parseInt(k))+");' value =''></i>" +
              "</div>" +
              "<div class='form-group'>" +
                  "<label>Seat Label</label>" +
                  "<input data-type='" + item.type + "' class='item-label-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.label + "' />" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Name</label>" +
                "<input style='min-width: 120px !important;' class='item-name-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.name + "'>" +
              "</div>" +
              "<div class='form-group " + getClass(item.type) + "'>" +
                  "<div style='width: 60px; cursor: pointer;'>" +
                     "<img class='list-item-symbol' style='width:100%;' id='" + (nextIndex + parseInt(k)) + "' src='" + item.src + "'>" +
                  "</div>" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Long</label>" +
                "<input class='unit-y-input form-control sync' step='any' type='number' id='" + (nextIndex + parseInt(k)) + "' value='" + item.unitY + "' />" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Lat</label>" +
                "<input class='unit-x-input form-control sync' step='any' type='number' id='" + (nextIndex + parseInt(k)) + "' value='" + item.unitX + "' />" +
              "</div>" +
              "<div class='form-group " + getClass(item.type) + "'>" +
                "<label>Rotation</label>" +
                "<input data-type='" + item.type + "' class='item-rotation-input form-control sync' step='any' type='number' min='-360' max='360' id='" + (nextIndex + parseInt(k)) + "' value='" + item.rotation + "' />" +
              "</div>" +
              "<div id='list-items-" + (nextIndex + parseInt(k)) + "' class='collapse list-items'>" +
                "<div class='form-group " + getClass(item.type) + "'>" +
                   "<label>Symbol Width</label>" +
                   "<input data-type='" + item.type + "' type='number' class='item-width-input form-control sync' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.width + "'>" +
                "</div>" +
                "<div class='form-group " + getClass(item.type) + "'>" +
                   "<label>Symbol Height</label>" +
                   "<input data-type='" + item.type + "' type='number' class='item-height-input form-control sync' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.height + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Offset Long</label>" +
                   "<input class='item-ilongoffset-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.iLongOffset + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Offset Lat</label>" +
                   "<input class='item-ilatoffset-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.iLatOffset + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>On/Off</label>" +
                  "<input class='item-ionoff-input form-control sync' title='0/1' placeholder='0/1' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.ionoff + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Specials</label>" +
                  "<select class='item-specials-select item-specials-select-" + (nextIndex + parseInt(k)) + " form-control sync' id='" + (nextIndex + parseInt(k)) + "'>" +
                        window.iSpecialsOptions +
                   "</select>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Symbol Name</label>" +
                  "<select class='item-symbol-name-select item-symbol-name-select-" + (nextIndex + parseInt(k)) + " form-control sync' id='" + (nextIndex + parseInt(k)) + "'>" +
                        window.iSeatSymbolOptions +
                   "</select>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Occ Weight</label>" +
                   "<input style='min-width: 70px;' class='occ-weight-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.occw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Item Weight</label>" +
                   "<input style='min-width: 70px;' class='item-weight-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.itemw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Max Weight</label>" +
                   "<input style='min-width: 70px;' class='item-max-input form-control sync' type='number' id='" + (nextIndex + parseInt(k)) + "' step='any' value='" + item.maxw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Occ Name</label>" +
                   "<input style='min-width: 70px;' class='occ-name-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.occname + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Left/Right</label>" +
                  "<select class='item-leftright-select item-leftright-select-" + (nextIndex + parseInt(k)) + " form-control sync' id='" + (nextIndex + parseInt(k)) + "'><option value='-'>-</option><option value='L'>L</option><option value='R'>R</option></select>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Arm Alternate </label>" +
                   "<input style='min-width: 70px;' class='item-alternate-input form-control sync' type='text' id='" + (nextIndex + parseInt(k)) + "' value='" + item.alternate + "'>" +
                "</div>" +
              "</div>" +
          "</div>" +
       "</div>"
     );
     $('.item-symbol-name-select-' + (nextIndex + parseInt(k))).val(item.symbolname);
     $('.item-leftright-select-' + (nextIndex + parseInt(k))).val(item.leftright);
     $('.item-specials-select-' + (nextIndex + parseInt(k))).val(item.specials);
     var itemId = (nextIndex + parseInt(k));
    var item = item;
    var partId = item['partId'];
    var row = item['row'];
    var cloneItem = {
      row,
      id: item.id,
      partId,
      unitX: item.unitX,
      unitY: item.unitY,
      pxX: item.pxX,
      pxY: item.pxY,
      src: item.src,
      width: item.width,
      height: item.height,
      rotation: item.rotation,
      iLatOffset: item.iLatOffset,
      iLongOffset: item.iLongOffset,
      label: item.label,
      name: item.name,
      ionoff: item.ionoff,
      specials: item.specials,
      symbolname: item.symbolname,
      occw: item.occw,
      itemw: item.itemw,
      maxw: item.maxw,
      occname: item.occname,
      leftright: item.leftright,
      alternate: item.alternate,
      status: item.status,
      type: item.type,
      sequence: getNewSequence(),
    };
    window.store.push(cloneItem);
    addSymbol(item.type, partId , item.pxY, item.pxX, item.src, item.width, item.height, item.label, item.rotation);
    syncStore();
  });
  $('#store-items').animate({scrollTop: $(document).height()}, 'slow');
  $('#pasteModal').modal('hide');
}
function displayStore() {
  $('#store-items').html("");
  Object.keys(window.store).forEach(function (k) {
     var item = window.store[k];
     var count = 4;
     var itemInfo = JSON.stringify(item);
     $('#store-items').append(
       "<div class='row-block store-item' id='" + k + "' data-value='"+(parseInt(k) + parseInt(count))+"'>" +
          "<button type='button' data-toggle='collapse' data-target='#list-items-" + k + "' class='btn btn-warning btn-xs item-list-toggle float-right'>Full View</button>" +
          "<button type='button' data-id='" + k + "' class='btn btn-success btn-xs duplicate-item-btn float-right'>Duplicate</button>" +
          "<div class='log-block'>" +
              "<label id='counter' style='font-size: 19px;color: #e61010;position: absolute;margin-top: 5px;margin-left: 7px;'>"+(parseInt(k) + parseInt(count))+"</label><br/>"+
              "<div class='form-group'>" +
                  "<i id='" + k + "' class='fa fa-trash item-trash'></i>" +
              "</div>" +
              "<div class='form-group'>" +
              "<i id='copy_" + k + "' class='fa fa-copy item-copy' onclick= 'CopyItems("+itemInfo+", "+k+");' value =''></i>" +
              "</div>" +
              "<div class='form-group'>" +
                  "<label>Seat Label</label>" +
                  "<input data-type='" + item.type + "' class='item-label-input form-control sync' type='text' id='" + k + "' value='" + item.label + "' />" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Name</label>" +
                "<input style='min-width: 120px !important;' class='item-name-input form-control sync' type='text' id='" + k + "' value='" + item.name + "'>" +
              "</div>" +
              "<div class='form-group " + getClass(item.type) + "'>" +
                  "<div style='width: 60px; cursor: pointer;'>" +
                     "<img class='list-item-symbol' style='width:100%;' id='" + k + "' src='" + item.src + "'>" +
                  "</div>" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Long</label>" +
                "<input class='unit-y-input form-control sync' step='any' type='number' id='" + k + "' value='" + item.unitY + "' />" +
              "</div>" +
              "<div class='form-group'>" +
                "<label>Station Lat</label>" +
                "<input class='unit-x-input form-control sync' step='any' type='number' id='" + k + "' value='" + item.unitX + "' />" +
              "</div>" +
              "<div class='form-group " + getClass(item.type) + "'>" +
                "<label>Rotation</label>" +
                "<input data-type='" + item.type + "' class='item-rotation-input form-control sync' step='any' type='number' min='-360' max='360' id='" + k + "' value='" + item.rotation + "' />" +
              "</div>" +
              "<div id='list-items-" + k + "' class='collapse list-items'>" +
                "<div class='form-group " + getClass(item.type) + "'>" +
                   "<label>Symbol Width</label>" +
                   "<input data-type='" + item.type + "' type='number' class='item-width-input form-control sync' id='" + k + "' step='any' value='" + item.width + "'>" +
                "</div>" +
                "<div class='form-group " + getClass(item.type) + "'>" +
                   "<label>Symbol Height</label>" +
                   "<input data-type='" + item.type + "' type='number' class='item-height-input form-control sync' id='" + k + "' step='any' value='" + item.height + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Offset Long</label>" +
                   "<input class='item-ilongoffset-input form-control sync' type='number' id='" + k + "' step='any' value='" + item.iLongOffset + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Offset Lat</label>" +
                   "<input class='item-ilatoffset-input form-control sync' type='number' id='" + k + "' step='any' value='" + item.iLatOffset + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>On/Off</label>" +
                  "<input class='item-ionoff-input form-control sync' title='0/1' placeholder='0/1' type='number' id='" + k + "' step='any' value='" + item.ionoff + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Specials</label>" +
                  "<select class='item-specials-select item-specials-select-" + k + " form-control sync' id='" + k + "'>" +
                        window.iSpecialsOptions +
                   "</select>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Symbol Name</label>" +
                  "<select class='item-symbol-name-select item-symbol-name-select-" + k + " form-control sync' id='" + k + "'>" +
                        window.iSeatSymbolOptions +
                   "</select>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Occ Weight</label>" +
                   "<input style='min-width: 70px;' class='occ-weight-input form-control sync' type='number' id='" + k + "' step='any' value='" + item.occw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Item Weight</label>" +
                   "<input style='min-width: 70px;' class='item-weight-input form-control sync' type='number' id='" + k + "' step='any' value='" + item.itemw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Max Weight</label>" +
                   "<input style='min-width: 70px;' class='item-max-input form-control sync' type='number' id='" + k + "' step='any' value='" + item.maxw + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Occ Name</label>" +
                   "<input style='min-width: 70px;' class='occ-name-input form-control sync' type='text' id='" + k + "' value='" + item.occname + "'>" +
                "</div>" +
                "<div class='form-group'>" +
                  "<label>Left/Right</label>" +
                  "<select class='item-leftright-select item-leftright-select-" + k + " form-control sync' id='" + k + "'><option value='-'>-</option><option value='L'>L</option><option value='R'>R</option></select>" +
                "</div>" +
                "<div class='form-group'>" +
                   "<label>Arm Alternate </label>" +
                   "<input style='min-width: 70px;' class='item-alternate-input form-control sync' type='text' id='" + k + "' value='" + item.alternate + "'>" +
                "</div>" +
              "</div>" +
          "</div>" +
       "</div>"
     );
     $('.item-symbol-name-select-' + k).val(item.symbolname);
     $('.item-leftright-select-' + k).val(item.leftright);
     $('.item-specials-select-' + k).val(item.specials);
  });
}
var number = document.getElementById('itemPosition');
number.onkeydown = function(e) {

    if(!((e.keyCode > 95 && e.keyCode < 106)

      || (e.keyCode > 47 && e.keyCode < 58)

      || e.keyCode == 8)) {

        return false;

    }

}
var copyItem = [];
var copyIndexItem = [];
var indexValueForDropdown = 0;
function CopyItems(item, i){
  indexValueForDropdown++;
  partIdArray.push(item.partId);
  console.log('item', item);
  window.iSeatSymbolData.forEach(element => {    //dropdown value
    // element[indexValueForDropdown] = item.partId;
    element.partId = item.partId;
  })
  console.log('copy iSeatSymbolData', window.iSeatSymbolData);
  $(".clearCopiedItems").show();
 // $("#copy_"+i).removeClass("colo");
  if($("#copy_"+i).hasClass('copy_color')) {
    $("#copy_"+i).removeClass('copy_color');
    var id = item['row']; 
    $.each(copyItem, function(key, val){
      if(typeof(val['row']) != "undefined" && val['row'] !== null){
        if(val['row'] === id){
          copyItem.splice(key, 1);
          return false;
        }
      }
    });
  } else{
    $("#copy_"+i).addClass('copy_color');   
        copyItem.push(item);
  }
  $('.pasteItems').removeClass("hidden");
  $('.clearCopiedItems').removeClass("hidden");
  localStorage.setItem("copyItems", JSON.stringify(copyItem));
}

function clearCopiedData(){ 
  copyItem = [];
  var removeData = localStorage.removeItem('copyItems');
  if(removeData == undefined){

    $(".clearCopiedItems").hide();
    
  }
  
     $(".item-copy").removeClass("copy_color");
 
  $('.gyronimo-handle').html("Cleared copied items.");
  $('.gyronimo-handle').removeClass("hidden");
  $('.gyronimo-handle').addClass("alert alert-dark-success");
  $('.pasteItems').addClass("hidden");
  setTimeout(function () {
    $('.gyronimo-handle').addClass("hidden");
  }, 5000);
}

$(document).ready(function(){
  if(localStorage.getItem("copyItems") === null){
    $('.pasteItems').addClass("hidden");
    $('.clearCopiedItems').addClass("hidden");
  } else{
    $('.pasteItems').removeClass("hidden");
    $('.clearCopiedItems').removeClass("hidden");
  }
});
function extractInt(str) {
  return str.replace(/\D+$/g, "");
}

function syncStore() {
  document.getElementById("store").value = JSON.stringify(window.store);
}

function getDimension(id) {
  var dimension;
  var widthPx = $("#" + id).css("width");
  var heightPx = $("#" + id).css("height");
  if(widthPx != undefined && heightPx != undefined) {
    var width = widthPx.replace(/\D+$/g, "") / 2;
    var height = heightPx.replace(/\D+$/g, "") / 2;
    dimension = {
      width: width,
      height: height
    }
  } else {
    dimension = {
      width: 0,
      height: 0
    }
  }

  return dimension;
}

function getDimensionDiv(id) {
  var dimension;
  var width = $("#" + id).width();
  var height = $("#" + id).height();
  if(width != undefined && height != undefined) {
    dimension = {
      width: width,
      height: height
    }
  } else {
    dimension = {
      width: 0,
      height: 0
    }
  }

  return dimension;
}

function getPxX(unitX, unitOffsetX, width) {
  var x1 = parseInt(document.getElementById("x1-input").value, 10);
  var x2 = parseInt(document.getElementById("x2-input").value, 10);
  var leftX = JSON.parse(document.getElementById("leftX").value);
  var rightX = JSON.parse(document.getElementById("rightX").value);
  var pxX = leftX.left + ((parseFloat(unitX, 10) - x1) * getPxPerUnitX(x1, x2, leftX.left, rightX.left)) + parseInt(unitOffsetX, 10);

  return pxX - (width / 2);
}

function getPxY(unitY, unitOffsetY, height) {
  var fwd = parseInt(document.getElementById("fwd-input").value, 10);
  var aft = parseInt(document.getElementById("aft-input").value, 10);
  var topY = JSON.parse(document.getElementById("topY").value);
  var bottomY = JSON.parse(document.getElementById("bottomY").value);
  var pxY = topY.top + ((parseFloat(unitY, 10) - fwd) * getPxPerUnitY(fwd, aft, topY.top, bottomY.top)) + parseInt(unitOffsetY, 10);

  return pxY - (height / 2);
}

function updateStoreParts() {
  Object.keys(window.store).forEach(function (k) {
    if(window.store[k].type == "no-symbol") return;
    document.getElementById(window.store[k].partId).style.position = "absolute";
    document.getElementById(window.store[k].partId).style.top = window.store[k].pxY;
    document.getElementById(window.store[k].partId).style.left = window.store[k].pxX;
  });
}

function getPxPerUnitX(x1, x2, leftX, rightX) {
  var distanceUnit = parseInt(x2, 10) - parseInt(x1, 10);
  var distancePx = parseInt(rightX, 10) - parseInt(leftX, 10);
  var pxPerUnit = distancePx / distanceUnit;

  return pxPerUnit;
}

function getPxPerUnitY(fwd, aft, topY, bottomY) {
  var distanceUnit = parseInt(aft, 10) - parseInt(fwd, 10);
  var distancePx = parseInt(bottomY, 10) - parseInt(topY, 10);
  var pxPerUnit = distancePx / distanceUnit;

  return pxPerUnit;
}

function updateYPosition(id) {
  setLinesDefaultOffset();
  var fwd = parseInt(document.getElementById("fwd-input").value, 10);
  var aft = parseInt(document.getElementById("aft-input").value, 10);
  var topY = JSON.parse(document.getElementById("topY").value);
  var bottomY = JSON.parse(document.getElementById("bottomY").value);
  var offsetY = window.store[id].iLongOffset;

  var unitY = window.store[id].unitY;
  var height = window.store[id].height;

  var pxy = window.store[id].pxY;

  //var pxY = topY.top + ((parseInt(unitY, 10) + parseInt(offsetY, 10) - fwd) * getPxPerUnitY(fwd, aft, topY.top, bottomY.top));
  var pxY = topY.top + ((parseFloat(unitY, 10) - fwd) * getPxPerUnitY(fwd, aft, topY.top, bottomY.top)) + parseInt(offsetY, 10);
  // window.store[id].pxY = ((pxY - (height / 2)) - 15) + 'px';
  window.store[id].pxY = (pxY - (height / 2)) + 'px';

  syncStore();
  updateStoreParts();
}

function updateYPositions() {
  Object.keys(window.store).forEach(function (k) {
    updateYPosition(k);
  });
}

function updateXPosition(id) {
  setLinesDefaultOffset();
  var x1 = parseInt(document.getElementById("x1-input").value, 10);
  var x2 = parseInt(document.getElementById("x2-input").value, 10);
  var leftX = JSON.parse(document.getElementById("leftX").value);
  var rightX = JSON.parse(document.getElementById("rightX").value);
  var offsetX = window.store[id].iLatOffset;

  var unitX = window.store[id].unitX;
  var width = window.store[id].width;
  //var pxX = leftX.left + ((parseInt(unitX, 10) + parseInt(offsetX, 10) - x1) * getPxPerUnitX(x1, x2, leftX.left, rightX.left));
  var pxX = leftX.left + ((parseFloat(unitX, 10) - x1) * getPxPerUnitX(x1, x2, leftX.left, rightX.left)) + parseInt(offsetX, 10);
  window.store[id].pxX = (pxX - (width / 2)) + 'px';

  syncStore();
  updateStoreParts();
}

function updateXPositions() {
  Object.keys(window.store).forEach(function (k) {
    updateXPosition(k);
  });
}

function updateXUnit(k, value) {
  window.store[k].unitX = parseFloat(value, 10);
  syncStore();
  updateXPosition(k);
}

function updateYUnit(k, value) {
  window.store[k].unitY = parseFloat(value, 10);
  syncStore();
  updateYPosition(k);
}

function updateItemWidth(k, value, type) {
  var partId = window.store[k].partId;
  window.store[k].width = parseFloat(value, 10);
  syncStore();
  if (type == 'symbol') {
    $("#" + partId + " img").width(value + "px");
  }
  updateXPosition(k);
}

function updateItemHeight(k, value, type) {
  var partId = window.store[k].partId;
  window.store[k].height = parseFloat(value, 10);
  syncStore();
  if (type == 'symbol') {
    $("#" + partId + " img").height(value + "px");
  }
  updateYPosition(k);
}

function updateItemRotation(k, value, type) {
  var partId = window.store[k].partId;
  window.store[k].rotation = parseFloat(value, 10);
  syncStore();
  if (type == 'symbol') {
    rotate(partId, value);
  }
  updateYPosition(k);
  updateXPosition(k);
}

function rotate(partId, degrees) {
  $("#" + partId + " img").css({'-webkit-transform' : 'rotate('+ degrees +'deg)',
                 '-moz-transform' : 'rotate('+ degrees +'deg)',
                 '-ms-transform' : 'rotate('+ degrees +'deg)',
                 'transform' : 'rotate('+ degrees +'deg)'});
}

function updateItemOffY(k, value) {
  var partId = window.store[k].partId;
  var currentY = extractInt(window.store[k].pxY);
  var currentOffY = window.store[k].iLongOffset;
  if(value > currentOffY) {
    var newY = parseInt(currentY, 10) + parseInt(value, 10);
  } else {
    var newY = parseInt(currentY, 10) - parseInt(value, 10);
  }
  window.store[k].pxY = newY + "px";
  window.store[k].iLongOffset = parseInt(value, 10);
  syncStore();
  document.getElementById(partId).style.top = window.store[k].pxY;
}

function updateItemOffX(k, value) {
  var partId = window.store[k].partId;
  var currentX = extractInt(window.store[k].pxX);
  var currentOffX = window.store[k].iLatOffset;
  if(value > currentOffX) {
    var newX = parseInt(currentX, 10) + parseInt(value, 10);
  } else {
    var newX = parseInt(currentX, 10) - parseInt(value, 10);
  }
  window.store[k].iLatOffset = parseInt(value, 10);
  window.store[k].pxX = newX + "px";
  syncStore();
  document.getElementById(partId).style.left = window.store[k].pxX;
}

function setLinesDefaultOffset(shouldUpdateInputs = true) {
  var parentPos = $('#wrapper').parent().offset();
  var topParentPos = parseInt(parentPos.top, 10);
  var topParentLeft = parseInt(parentPos.left, 10);
  var fwdRedLinePos = $('#fwd-red-line').offset();
  var fwdRedLineOffset = {
    top: parseInt(fwdRedLinePos.top, 10) - topParentPos + (window.settings.lineWidthPx / 2),
    left: parseInt(fwdRedLinePos.left, 10) - topParentLeft
  }

  var aftBlueLinePos = $('#aft-blue-line').offset();
  var aftBlueLineOffset = {
    top: parseInt(aftBlueLinePos.top, 10) - topParentPos  + (window.settings.lineWidthPx / 2),
    left: parseInt(aftBlueLinePos.left, 10) - topParentLeft
  }

  var x1YellowLinePos = $('#x1-yellow-line').offset();
  var x1YellowLineOffset = {
    top: parseInt(x1YellowLinePos.top, 10) - topParentPos,
    left: parseInt(x1YellowLinePos.left, 10) - topParentLeft + (window.settings.yellowLineWidthPx / 2)
  }

  var x2GreenLinePos = $('#x2-green-line').offset();
  var x2GreenLineOffset = {
    top: parseInt(x2GreenLinePos.top, 10) - topParentPos,
    left: parseInt(x2GreenLinePos.left, 10) - topParentLeft + (window.settings.lineWidthPx / 2)
  }

  document.getElementById("topY").value = JSON.stringify(fwdRedLineOffset);
  document.getElementById("bottomY").value = JSON.stringify(aftBlueLineOffset);
  document.getElementById("leftX").value = JSON.stringify(x1YellowLineOffset);
  document.getElementById("rightX").value = JSON.stringify(x2GreenLineOffset);
  
  if (shouldUpdateInputs) {
    $('#line-fwd-ypos-input').val(fwdRedLineOffset.top);
    $('#line-aft-ypos-input').val(aftBlueLineOffset.top);
    $('#line-x1-xpos-input').val(x1YellowLineOffset.left);
    $('#line-x2-xpos-input').val(x2GreenLineOffset.left);
  }
}

//Make the DIV element draggagle:
dragElement(document.getElementById("fwd-red-line"));
dragElement(document.getElementById("aft-blue-line"));
dragElement(document.getElementById("x1-yellow-line"));
dragElement(document.getElementById("x2-green-line"));

function dragElement(elmnt) {
  var pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
  if (document.getElementById(elmnt.id + "header")) {
  // /* if present, the header is where you move the DIV from:*/
  // document.getElementById(elmnt.id + "header").onmousedown = dragMouseDown;
  } else {
  /* otherwise, move the DIV from anywhere inside the DIV:*/
    elmnt.onmousedown = dragMouseDown;
  }

  function dragMouseDown(e) {
    e = e || window.event;
    e.preventDefault();
    // synced = false;
    // console.log(1);
    // get the mouse cursor position at startup:
    pos3 = e.clientX;
    pos4 = e.clientY;
    document.onmouseup = closeDragElement;
    // call a function whenever the cursor moves:
    document.onmousemove = elementDrag;
  }

  function elementDrag() {
    setLinesDefaultOffset();
    updateXPositions();
    updateYPositions();
    synced = false;
  }

  function closeDragElement() {
    document.onmouseup = null;
    document.onmousemove = null;
  }
}

$('#copyConfigData').on('click', function(){
    // if (confirm('Are you sure ?')) {
     var form = $('#gyronimo');
     var clientEmail = $('#copyConfig').find('option:selected').text();

     console.log(form.serialize());
     $.ajaxSetup({
       headers: {
         'X-CSRF-TOKEN':  $('meta[name="csrf-token"]').attr('content')
       }
     });
     $.ajax({
        type: "POST",
        cache: false,
        url: "/config/copyConfigData/{{$config->configurations_id}}/"+clientEmail,
        data: form.serialize(),
        processData: true,
        dataType: "json",
        success: function (json) {
          $('#configModal').modal('hide');
          synced = true;
          $('.gyronimo-handle').html(json.message);
          $('.gyronimo-handle').removeClass("hidden");
          $('.gyronimo-handle').addClass("alert alert-dark-success");
          setTimeout(function () {
            $('.gyronimo-handle').addClass("hidden");
          } , 5000);
        },
        error: function () {
          $('.gyronimo-handle').html('Something went wrong!');
          $('.gyronimo-handle').removeClass("hidden");
          $('.gyronimo-handle').addClass("alert alert-dark-danger");
          setTimeout(function () {
            $('.gyronimo-handle').addClass("hidden");
          }, 5000);
        }
    });
    // }
  });

$('.save').on('click', function(){
  var clientSelection = $('#copyConfig').val();
  var clientEmail = $('#copyConfig').find('option:selected').text();

  if(clientSelection != ""){
    $('#configModal').modal('show');
    $('#clientEmail').html(clientEmail);
  } else {
    toastr.warning("Item Is Locked. Contact Master Admin To Unlock");  
  }
});
</script>

            {{ Form::close() }}
            </div>
        </div>
@endsection
