<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
      $route = $request->segment(1);
      if($route == 'update') {
        return [
          'first_name' => 'required',
          'last_name' => 'required',
          'image' => 'image| mimes:jpeg,jpg,png',
          'address' => 'required',
          'phone' => 'required',
          'email' => 'required|email',
          'password' => 'sometimes|required|min:6',
          'language' => 'required',
        ];
      } else {
        return [
          'first_name' => 'required',
          'last_name' => 'required',
          'image' => 'image| mimes:jpeg,jpg,png',
          'address' => 'required',
          'phone' => 'required',
          'email' => 'required|email',
          'password' => 'sometimes|required|min:6|confirmed',
          'language' => 'required',
        ];
      }
    }
}
