<?php

namespace App\Http\Controllers\Admin;

use App\Acdata;
use App\Http\Controllers\Controller;
use Redirect;
use Schema;
use App\User;
use App\Configurations;
use App\Http\Requests\CreateListingRequest;
use App\Http\Requests\UpdateListingRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\Traits\GetDropdownValueFromDBTrait;
use DB;
use App\Http\Requests\ConfigRequest;
use App\Variant;
use App\Configuration_image;
use App\Item;
use Config;
use Auth;


class ConfigurationsController extends Controller
{
  use GetDropdownValueFromDBTrait;

  public function index()
  {
    $grantedConfigurations = [];
    $configurations = Auth::user()->configurations;
    $userRoleId = Auth::user()->role_id;
    $grantedConfigurations = explode(',', $configurations);

    $configurations = DB::table('configurations')
      ->select('configurations_id', 'is_locked', 'config_name', 'variant.variant_name', 'remark', 'callsign', 'manufacturer_name', 'model_name', 'copy_from_id', 'client_email')
      ->leftJoin('variant', 'configurations.variant', '=', 'variant.variant_id')
      ->leftJoin('manufacturer', 'manufacturer.id', '=', 'configurations.manufacturer')
      ->leftJoin('model', 'model.id', '=', 'configurations.model')
      ->when($userRoleId === 2, function ($query) use ($grantedConfigurations) {
        return $query->whereIn('configurations.configurations_id', $grantedConfigurations);
      })->orderBy('configurations.configurations_id', 'DESC')->paginate(50);
    $manifacturer = DB::table('configurations')
    ->select('manufacturer_name')
    ->leftJoin('manufacturer', 'manufacturer.id', '=', 'configurations.manufacturer')
    ->groupBy('manufacturer_name')
    ->get();  
    $model = DB::table('configurations')
    ->select('model_name')
    ->leftJoin('model', 'model.id', '=', 'configurations.model')
    ->groupBy('model_name')
    ->get();   
    $callsign = DB::table('configurations')
    ->select('callsign')
    ->groupBy('callsign')
    ->get();   
    return view('admin.configure.list', compact('configurations','manifacturer','model','callsign'));
  }

  public function index2(Request $request)
  {
    $grantedConfigurations = [];
    $configurations = Auth::user()->configurations;
    $userRoleId = Auth::user()->role_id;
    $grantedConfigurations = explode(',', $configurations);
    $configurations = DB::table('configurations')
      ->select('configurations_id', 'is_locked', 'config_name', 'variant.variant_name', 'remark', 'callsign', 'manufacturer_name', 'model_name', 'copy_from_id', 'client_email')
      ->leftJoin('variant', 'configurations.variant', '=', 'variant.variant_id')
      ->leftJoin('manufacturer', 'manufacturer.id', '=', 'configurations.manufacturer')
      ->leftJoin('model', 'model.id', '=', 'configurations.model')
      ->when($userRoleId === 2, function ($query) use ($grantedConfigurations) {
        return $query->whereIn('configurations.configurations_id', $grantedConfigurations);
      });
    
    
   
    if(!($request['manifacture'] == "filtre") && !($request['manifacture'] == NULL))
    {
      $configurations = $configurations->where('manufacturer_name','=',$request['manifacture']);
    }
    if(!($request['model'] == "filtre") && !($request['model'] == NULL))
    {
      $configurations = $configurations->where('model_name','=',$request['model']);
    }
    if(!($request['callsign'] == "filtre") && !($request['callsign'] == NULL))
    {
      $configurations = $configurations->where('callsign','=',$request['callsign']);
    }
    
    if(!($request['search'] == NULL))
    {
      $search = $request['search'];
      // $configurations = $configurations->where('manufacturer_name', 'like', '%'.$search.'%')
      // ->orwhere('config_name', 'like', '%'.$search.'%')
      // ->orwhere('model_name', 'like', '%'.$search.'%')
      // ->orwhere('callsign', 'like', '%'.$search.'%')
      // ->orwhere('remark', 'like', '%'.$search.'%');

      $configurations = $configurations->Where(function ($query) use ($search) {
        $query->where('manufacturer_name', 'like', '%'.$search.'%')
        ->orwhere('config_name', 'like', '%'.$search.'%')
        ->orwhere('model_name', 'like', '%'.$search.'%')
        ->orwhere('callsign', 'like', '%'.$search.'%')
        ->orwhere('configurations_id', 'like', '%'.$search.'%')
        ->orwhere('remark', 'like', '%'.$search.'%');
      });
    }
    if(isset($request['no_of_entries']))
    {
      $perPage = $request['no_of_entries'];
    }
    else{
      $perPage = 50;
    }
    if(isset($request['page']))
    {
      $page = $request['page'];
    }
    else
    {
      $page = 1;

    }
    $configurations = $configurations->orderBy('configurations.configurations_id', 'DESC')->paginate($perPage,['*'],'page',$page);
    
    $manifacturer = DB::table('configurations')
    ->select('manufacturer_name')
    ->leftJoin('manufacturer', 'manufacturer.id', '=', 'configurations.manufacturer')
    ->groupBy('manufacturer_name')
    ->get();  
    $model = DB::table('configurations')
    ->select('model_name')
    ->leftJoin('model', 'model.id', '=', 'configurations.model')
    ->groupBy('model_name')
    ->get();   
    $callsign = DB::table('configurations')
    ->select('callsign')
    ->groupBy('callsign')
    ->get();  
    return view('admin.configure.list', compact('configurations','manifacturer','model','callsign','request'));
  }
  public function create()
  {
    $aircraft = DB::table('aircraft_type')->get();
    $manufacturer = $this->getManufacturer();
    $variant = $this->getVariant();
    $model = $this->getModel();
    $configImage = DB::table('configuration_image')
      ->orderBy('file_name', 'asc')
      ->get();

    return view('admin.configure.create', compact('manufacturer', 'variant', 'aircraft', 'model', 'configImage'));
  }

  public function setting()
  {
    $aircrafts = DB::table('configuration_image')->orderBy('file_name', 'asc')->get();
    $items = DB::table('items')->orderBy('name', 'asc')->get();
    $specials = DB::table('i_specials')->orderBy('ispecial', 'asc')->get();
    $isymbols = DB::table('i_seatsymbol')->orderBy('iseatsymbol', 'asc')->get();
    $specialItems = DB::table('special_items')->orderBy('special_item_name', 'asc')->get();
    $aircraft_types = DB::table('ac_aircraft_type')->get();
    $manufacturer_types = DB::table('ac_manufacturer')->orderBy('ac_manfacturer_name', 'asc')->get();
    $variant_types = DB::table('ac_variant')->orderBy('ac_variant_name', 'asc')->get();
    $model_types = DB::table('ac_model')->orderBy('ac_model_name', 'asc')->get();
    $display_types =  DB::table('ac_allavailableacdatabase')->where('is_deleted', 0)->orderBy('display_name', 'asc')->get();
    return view('admin.configure.setting', compact('aircrafts', 'items', 'specials', 'isymbols', 'specialItems', 'aircraft_types', 'manufacturer_types', 'model_types', 'variant_types', 'display_types'));
  }
  public function symbolitem()
  {
    $isymbol['status'] = "success";
    $isymbol['data'] = DB::table('i_seatsymbol')->get();
    return $isymbol;
  }

  public function specialitems()
  {
    $specialItem['status'] = "success";
    $specialItem['data'] = DB::table('special_items')->get();
    return $specialItem;
  }


  public function specials()
  {
    $special['status'] = "success";
    $special['data'] = DB::table('i_specials')->get();
    return $special;
  }

  public function acmanufacturer()
  {
    $manufacturer['status'] = "success";
    $manufacturer['data'] = DB::table('ac_manufacturer')->get();
    return $manufacturer;
  }

  public function acvarianttypes()
  {
    $variant['status'] = "success";
    $variant['data'] = DB::table('ac_variant')->get();
    return $variant;
  }
  public function acmodeltypes()
  {
    $model['status'] = "success";
    $model['data'] = DB::table('ac_model')->get();
    return $model;
  }
  public function displaydata()
  {
    $display_types = DB::table('ac_allavailableacdatabase')->where('is_deleted', 0)->orderBy('display_name', 'asc')->get();
    $display_manufacture = DB::table('ac_manufacturer')->get();
    $display_model  = DB::table('ac_model')->get();
    $display_variant = DB::table('ac_variant')->get();
    $data['display_types'] =   $display_types;
    $data['display_manufacture'] = $display_manufacture;
    $data['display_model'] = $display_model;
    $data['display_variant'] = $display_variant;

    return json_encode($data);
  }
  public function storeallacdata(Request $request)
  {
    $data['ac_aircraft'] = $request->ac_aircraft;
    $data['ac_manufacturer'] = $request->ac_manufacturer;
    $data['ac_model'] = $request->ac_model;
    $data['ac_variant'] = $request->ac_variant;
    $data['display_name'] = $request->display_name;
    DB::table('ac_allavailableacdatabase')->insert([
      'ac_aircraft_id' => $data['ac_aircraft'],
      'ac_manufacturer_id' => $data['ac_manufacturer'],
      'ac_model_id' => $data['ac_model'],
      'ac_variant_id' => $data['ac_variant'],
      'display_name' => $data['display_name'],

    ]);
    return json_encode($data);
  }
  public function updateallacdata(Request $request, $id)
  {
    $data['ac_aircraft'] = $request->ac_aircraft;
    $data['ac_manufacturer'] = $request->ac_manufacturer;
    $data['ac_model'] = $request->ac_model;
    $data['ac_variant'] = $request->ac_variant;
    $data['display_name'] = $request->display_name;

    DB::table('ac_allavailableacdatabase')
      ->where('id', $id)
      ->update([
        'ac_aircraft_id' => $data['ac_aircraft'],
        'ac_manufacturer_id' => $data['ac_manufacturer'],
        'ac_model_id' => $data['ac_model'],
        'ac_variant_id' => $data['ac_variant'],
        'display_name' => $data['display_name'],
        'updated_at' => date("Y-m-d H:i:s"),
      ]);
    return json_encode($data);
  }
  //  public function editacdata($id) {
  // $alldata = DB::table('allavailableacdatabase')
  //                 ->where('id', $id)
  //                 ->first();            
  // $data['aircraft_types_edit'] = DB::table('ac_aircraft_type')->get(); 
  // $aircraft_types_edit = DB::table('ac_aircraft_type')->get(); 
  // $data['manufacturer_types_edit'] = DB::table('ac_manufacturer')->get();
  // $data['variant_types_edit'] = DB::table('ac_variant')->get();
  // $data['model_types_edit'] = DB::table('ac_model')->get();
  // $data['alldata'] = $alldata;
  // $data['aircraft_types_edit'] = $aircraft_types_edit;

  // return json_encode($data);

  //return view('admin.configure.setting', compact('data','aircraft_types_edit'));

  //  return view('admin.configure.setting', compact('aircraft_types_edit','manufacturer_types_edit', 'variant_types_edit', 'model_types_edit','config'));
  // }
  public function editacdata(Request $request, $id)
  {

    $alldata = DB::table('ac_allavailableacdatabase')
      ->where('id', $id)
      ->first();
    $types = DB::table('ac_aircraft_type')->get();
    $manufacturer_types_edit = DB::table('ac_manufacturer')->orderBy('ac_manfacturer_name', 'asc')->get();
    $variant_types_edit = DB::table('ac_variant')->orderBy('ac_variant_name', 'asc')->get();
    $model_types_edit = DB::table('ac_model')->orderBy('ac_model_name', 'asc')->get();
    $res['data'] = $alldata;
    $res['types'] = $types;
    $res['manufacturer_types_edit'] = $manufacturer_types_edit;
    $res['variant_types_edit'] = $variant_types_edit;
    $res['model_types_edit'] = $model_types_edit;

    return json_encode($res);
  }
  public function addAcManufacturer(Request $request)
  {
    $data = $request->ac_manufacturer_data;
    DB::table('ac_manufacturer')->insert(['ac_manfacturer_name' => $data]);

    return json_encode($data);
  }
  public function removeAcManufacturer(Request $request, $id)
  {
    DB::table('ac_manufacturer')->where('manufacture_id', $id)->delete();
    return redirect('/config/setting');
  }
  public function addAcModel(Request $request)
  {
    $data = $request->ac_model_data;
    DB::table('ac_model')->insert(['ac_model_name' => $data]);

    return json_encode($data);
  }
  public function removeAcModel(Request $request, $id)
  {
    DB::table('ac_model')->where('model_id', $id)->delete();
    return redirect('/config/setting');
  }

  public function addAcvariant(Request $request)
  {
    $data = $request->ac_variant_data;
    DB::table('ac_variant')->insert(['ac_variant_name' => $data]);

    return json_encode($data);
  }
  public function removeAcVariant(Request $request, $id)
  {
    DB::table('ac_variant')->where('variant_id', $id)->delete();
    return redirect('/config/setting');
  }
  public function removeAcDisplayname(Request $request, $id)
  {

    $display_data = Acdata::find($id);
    $display_data->delete();
    $display_data->is_deleted = 1;
    $display_data->save();
    // DB::table('ac_allavailableacdatabase')->where('id', $id)->delete();
    return redirect('/config/setting');
  }
  public function removeAcManufacture(Request $request, $id)
  {
    $manufacture = \App\Manufacturer::find($id);
    $manufacture->delete();

    return 'success';
  }
  public function store(ConfigRequest $request, Configurations $config)
  {
    $all = $request->all();
    $all['fwd_top_px'] = '0px';
    $all['fwd_left_px'] = '0px';
    $all['aft_top_px'] = '550px';
    $all['aft_left_px'] = '0px';
    $all['x1_top_px'] = '0px';
    $all['x1_left_px'] = '106px';
    $all['x2_top_px'] = '0px';
    $all['x2_left_px'] = '300px';
    $all['box_width'] = 0;
    $all['box_height'] = 0;
    $all['cacwidth'] = 0;
    $all['cacheight'] = 0;
    $all['cacy'] = 0;
    $all['cacx'] = 0;
    $all['remark'] = empty($all['remark']) ? '' : $all['remark'];
    $all['cweightunits'] = 'kg';
    $all['cmaxramp'] = 0;
    $all['cmaxtow'] = 0;
    $all['cmaxldw'] = 0;
    $all['ccalclateralfuel'] = 'ok';
    $all['cfuelunits'] = 'kg';
    $all['ctankmaxfuelvolume'] = 0;
    $all['cfactorlbsgal'] = 6.4989;
    $all['cfactorkgliter'] = 0.79;
    $all['centermode'] = 'volume';
    $all['cfuelflowlbsperh'] = 0;
    $all['cpresetmain'] = 0;
    $all['cpresetlanding'] = 0;
    $all['cquickloadpreset'] = 90;
    $all['cyupheliindividual'] = 0;
    $all['yupheliplan'] = 0;
    $all['swapoffon'] = 'off';
    $all['cquickcrew'] = 'q';
    $all['cidwidwn'] = 'ID';
    $all['ccolorcode'] = 'Yellow';
    $all['cflightlegs'] = 'FlightMode';
    $all['clongarmfrontseat'] = 1000; // FWD
    $all['clongarmrearseat'] = 5000; // AFT
    $all['ckeeptozero'] = 0; // X1
    $all['clatarmrightseat'] = 50; // X2
    $all['cseatsfront'] = 0; // FWD YPOS
    $all['cseatsrear'] = 550; // AFT YPOS
    $all['clatcenter'] = 106; // X1 XPOS
    $all['clatright'] = 300; // X2 XPOS
    $all['cseatwidth'] = 45;
    $all['cseatheight'] = 50;
    $all['cfuelpanelheight'] = 160;
    $all['cfuelpanelstart'] = 'open';
    $all['clargetopview'] = 'no';
    $all['cconfigequiplabel'] = 'no';
    $all['cspecialmanifest'] = '';
    $all['csetupoptions'] = '';
    $all['cdateuseu'] = 'EU';
    $all['cpickerminuteinterval'] = 1;
    $all['cpickerlocale'] = 'en-GB';
    $all['cconfigstationsstart'] = 4;
    $all['cconfigstationsend'] = 12;
    $all['cmanifestexport'] = 'yes';
    $all['csummaryexport'] = 'no';
    $all['callowinteroredit'] = 'no';
    $all['ccheckmargin'] = 'no';
    $all['cmarginpercent'] = 0;
    $all['csecondcgenvelope'] = 'no';
    $all['clinepilot'] = 6;
    $all['ccalcmaxexternalorhoist'] = 'no';
    $all['callowequipchange'] = 'no';
    $all['cfwdaftcgcheck'] = 'off';
    $all['cauxfuelvolume'] = 0;
    $all['cdateformat'] = 'dd-MM-yyyy  HH-mm';
    $all['cfltdataelements'] = '';
    $all['callowbewoverride'] = 'no';
    $all['clockresetifnotsent'] = 'no';
    $all['cifunitsaremeter'] = 'no';
    $all['csetlineasfreeload'] = '';
    $all['cportlandboth'] = '';
    $all['criskassess'] = '';
    $all['cdocviewer'] = '';
    $all['cintconfigurator'] = '';
    $all['callsign'] = '';
    $all['unit'] = 'kg';
    $all['mass'] = 'kg';
    $all['lonsta'] = 'mm';
    $all['lonmom'] = 'kg.mm';
    $all['latsta'] = 'mm';
    $all['latmom'] = 'kg.m';
    $all['ccheckacupdates'] = 'no';
    $all['cboxedsliders'] = '';
    $all['cboxalpha'] = '';
    $all['cslideralpha'] = '';
    $all['cboxgap'] = '';
    $all['ctopypos'] = '';
    $all['cboxstyle'] = '';
    $all['ccgexternal'] = 'no';
    $all['cperfbuttonwidth'] = 150;
    $all['copy_from_id'] = 0;
    $all['client_email'] = '';

    $all['selectorbuttons'] = '';
    $all['factorcrewweight'] = '';
    $all['flighttypes'] = '';
    $all['supplyfuelvolume'] = '';
    $all['subtractsupplyfuel'] = '';
    $all['secondmaxavailtext'] = '';
    $all['dependsondisplaybutton'] = '';
    $all['maxavailonmanifest'] = '';
    $all['fuelpresets'] = '';
    $all['autolandingfuelpreset'] = '';
    $all['extra1'] = '';
    $all['extra2'] = '';
    $all['extra3'] = '';
    $all['extra4'] = '';
    $all['extra5'] = '';
    $all['extra6'] = '';
    $all['extra7'] = '';
    $all['extra8'] = '';
    $all['extra9'] = '';
    $all['extra10'] = '';


    $data = Configurations::create($all);

    $component = [
      'config_id' => $data->id,
      'ilongarm' => 0,
      'ilatarm' => 0,
      'item_id' => 1,
      'isymbolwidth' => 0,
      'isymbolheight' => 0,
      'irotation' => 0,
      'ilongoffset' => 0,
      'ilatoffset' => 0,
      'iseatlabel' => '',
      'istationname' => 'BEW',
      'ionoff' => 1,
      'ispecials' => 4,
      'part_id' => '12151451.151',
      'iseatsymbol' => 1,
      'ioccweight' => 0,
      'iweight' => 0,
      'imaxweight' => 300,
      'ioccname' => '-',
      'ileftright' => '-',
      'iarmalternate' => '',
      'ilatmom' => 0,
      'ilongmom' => 0,
      'sequence' => 0,
      'status' => 1,
      'type' => 'symbol'
    ];
    DB::table('components')->insert($component);

    return redirect('/config/edit/' . $data->id);
  }

  public function edit($id)
  {
    $config = DB::table('configurations')
      ->leftJoin('configuration_image', 'configuration_image.configuration_image_id', '=', 'configurations.image2')
      ->where('configurations.configurations_id', $id)
      ->first();
    if (!$config) {
      abort(404);
    }

    $manufacturer = DB::table('manufacturer')->get();
    $aircraft = DB::table('aircraft_type')->get();
    $aircrafts = DB::table('configuration_image')->get();
    $variant = DB::table('variant')->get();
    $model = DB::table('model')->orderBy('model_name')->get();
    $configImage = DB::table('configuration_image')->get();
    $items = DB::table('items')->get();
    $specialItems = DB::table('special_items')->get();
    $iSeatSymbol = DB::table('i_seatsymbol')->get();
    $iSpecials = DB::table('i_specials')->get();
    $userConfiguration = DB::table('users')->where('role_id', '=', '2')->get();

    return view('admin.configure.edit', compact('manufacturer', 'variant', 'aircraft', 'model', 'configImage', 'config', 'items', 'specialItems', 'iSeatSymbol', 'aircrafts', 'iSpecials', 'userConfiguration'));
  }

  public function copy($id)
  {
    $last = Configurations::orderBy('configurations_id', 'desc')->first();
    $cloneId = $last->configurations_id + 1;

    $config = Configurations::where('configurations_id', '=', $id)->first();
    $cloneConfig = $config->replicate();
    $cloneConfig->configurations_id = $cloneId;
    $cloneConfig->config_name .= '_copy';
    $cloneConfig->is_locked = 1;
    $cloneConfig->save();

    $components = DB::table('components')
      ->where('config_id', $id)
      ->get();

    foreach ($components as $component) {
      $num = floor(rand() * 100) + 1;
      $cloneComponent = [
        'config_id' => $cloneId,
        'ilongarm' => $component->ilongarm,
        'ilatarm' => $component->ilatarm,
        'item_id' => $component->item_id,
        'isymbolwidth' => $component->isymbolwidth,
        'isymbolheight' => $component->isymbolheight,
        'irotation' => $component->irotation,
        'ilongoffset' => $component->ilongoffset,
        'ilatoffset' => $component->ilatoffset,
        'iseatlabel' => $component->iseatlabel,
        'istationname' => $component->istationname,
        'ionoff' => $component->ionoff,
        'ispecials' => $component->ispecials,
        'part_id' => "part$num",
        'iseatsymbol' => $component->iseatsymbol,
        'ioccweight' => $component->ioccweight,
        'iweight' => $component->iweight,
        'imaxweight' => $component->imaxweight,
        'ioccname' => $component->ioccname,
        'ileftright' => $component->ileftright,
        'iarmalternate' => $component->iarmalternate,
        'ilatmom' => $component->ilatmom,
        'ilongmom' => $component->ilongmom,
        'sequence' => $component->sequence,
        'status' => $component->status,
        'type' => $component->type,
      ];
      DB::table('components')->insert($cloneComponent);
    }

    return redirect('/config');
  }

  public function getComponents($id)
  {
    $components = DB::table('components')
      ->select('components.*', 'items.id as itemId', 'items.name', 'items.image', 'items.width', 'items.height')
      ->leftJoin('items', 'components.item_id', '=', 'items.id')
      ->where('config_id', $id)
      ->orderBy('components.sequence', 'asc')
      ->get();

    return json_encode($components);
  }

  public function orderComponents(Request $request)
  {
    $i = 1;
    foreach ($request->orders as $id) {
      DB::table('components')
        ->where('config_id', $request->configId)
        ->where('id', $id)
        ->update([
          'sequence' => $i
        ]);
      $i++;
    }

    return ConfigurationsController::getComponents($request->configId);
  }

    /**
   * @OA\Get( path="/api/configComponent/{id}",
   * summary = "to get response from database",
   *  tags={"unsecure Api"},
   *     @OA\Parameter(
   *        name="id", in="path",required=true, 
   *          @OA\Schema(type="integer",)
   *     ),
   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */

  public function getConfiguration($id)
  {
    
    $configurations = DB::table('configurations')
      ->select(
        'config_name',
        'aircraft_name AS aircraft_type ',
        'manufacturer_name',
        'model_name',
        'variant_name',
        'image2',
        'box_width',
        'box_height',
        'cacwidth',
        'cacheight',
        'cacy',
        'cacx',
        'remark',
        'created_at',
        'updated_at',
        'cweightunits',
        'cmaxramp',
        'cmaxtow',
        'cmaxldw',
        'ccalclateralfuel',
        'cfuelunits',
        'ctankmaxfuelvolume',
        'cfactorlbsgal',
        'cfactorkgliter',
        'centermode',
        'cfuelflowlbsperh',
        'cpresetmain',
        'cpresetlanding',
        'cquickloadpreset',
        'cyupheliindividual',
        'yupheliplan',
        'swapoffon',
        'cquickcrew',
        'cidwidwn',
        'ccolorcode',
        'cflightlegs',
        'clongarmfrontseat',
        'clongarmrearseat',
        'ckeeptozero',
        'clatarmrightseat',
        'cseatsfront',
        'cseatsrear',
        'cseatwidth',
        'cseatheight',
        'clatcenter',
        'clatright',
        'cfuelpanelheight',
        'cfuelpanelstart',
        'clargetopview',
        'cconfigequiplabel',
        'cspecialmanifest',
        'csetupoptions',
        'cdateuseu',
        'cpickerminuteinterval',
        'cpickerlocale',
        'cconfigstationsstart',
        'cconfigstationsend',
        'cmanifestexport',
        'csummaryexport',
        'callowinteroredit',
        'ccheckmargin',
        'cmarginpercent',
        'csecondcgenvelope',
        'clinepilot',
        'ccalcmaxexternalorhoist',
        'callowequipchange',
        'cfwdaftcgcheck',
        'cauxfuelvolume',
        'cdateformat',
        'cfltdataelements',
        'callowbewoverride',
        'clockresetifnotsent',
        'cifunitsaremeter',
        'csetlineasfreeload',
        'cportlandboth',
        'criskassess',
        'cdocviewer',
        'cintconfigurator',
        'callsign',
        'unit',
        'mass',
        'lonsta',
        'lonmom',
        'latsta',
        'latmom',
        'ccheckacupdates',
        'cboxedsliders',
        'cboxalpha',
        'cslideralpha',
        'cboxgap',
        'ctopypos',
        'cboxstyle',
        'ccgexternal',
        'cperfbuttonwidth',
        'selectorbuttons',
        'factorcrewweight',
        'flighttypes',
        'supplyfuelvolume',
        'subtractsupplyfuel',
        'secondmaxavailtext',
        'dependsondisplaybutton',
        'maxavailonmanifest',
        'fuelpresets',
        'autolandingfuelpreset',
        'extra1',
        'extra2',
        'extra3',
        'extra4',
        'extra5',
        'extra6',
        'extra7',
        'extra8',
        'extra9',
        'extra10'
      )
      ->leftJoin('aircraft_type', 'configurations.aircraft_type', '=', 'aircraft_type.aircraft_id')
      ->leftJoin('manufacturer', 'configurations.manufacturer', '=', 'manufacturer.id')
      ->leftJoin('model', 'configurations.model', '=', 'model.id')
      ->leftJoin('variant', 'configurations.variant', '=', 'variant.variant_id')
      ->where('configurations.configurations_id', $id)
      ->first();

    $components = DB::table('components')
      ->select(
        'components.id',
        'components.ilongarm',
        'components.ilatarm',
        'components.item_id',
        'components.isymbolwidth',
        'components.isymbolheight',
        'components.irotation',
        'components.ilongoffset',
        'components.ilatoffset',
        'components.iseatlabel',
        'i_seatsymbol.iseatsymbol',
        'i_specials.ispecial as ispecial',
        'components.istationname',
        'components.iweight',
        'components.ioccweight',
        'components.ionoff',
        'components.imaxweight',
        'components.ioccname',
        'components.ileftright',
        'components.iarmalternate',
        'components.ilatmom',
        'components.ilongmom',
        'components.status',
        'components.type'
      )
      ->leftJoin('i_seatsymbol', 'components.iseatsymbol', '=', 'i_seatsymbol.iseatsymbol_id')
      ->leftJoin('i_specials', 'components.ispecials', '=', 'i_specials.ispecial_id')
      ->where('config_id', $id)
      ->orderBy('components.sequence', 'asc')
      ->get();

    ini_set('serialize_precision','-1');
    $response = array(
      'configurations' => $configurations ? $configurations : '',
      'components' => $components,
    );

    return $response;
  }

  
    /**
   * @OA\Get( path="/api/configComponentnew/{id}",
   * summary = "to get response from database",
   *  tags={"Flightpad"},
   *     @OA\Parameter(
   *        name="id", in="path",required=true, 
   *          @OA\Schema(type="integer",)
   *     ),
   *      @OA\Parameter(
   *        name="AppKey", in="header",required=true, 
   *          @OA\Schema(type="string",)
   *     ),
   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */

  public function getConfigurationnew(Request $request, $id)
  {

    $configurations = DB::table('configurations')
      ->select(
        'config_name',
        'aircraft_name AS aircraft_type ',
        'manufacturer_name',
        'model_name',
        'variant_name',
        'image2',
        'box_width',
        'box_height',
        'cacwidth',
        'cacheight',
        'cacy',
        'cacx',
        'remark',
        'created_at',
        'updated_at',
        'cweightunits',
        'cmaxramp',
        'cmaxtow',
        'cmaxldw',
        'ccalclateralfuel',
        'cfuelunits',
        'ctankmaxfuelvolume',
        'cfactorlbsgal',
        'cfactorkgliter',
        'centermode',
        'cfuelflowlbsperh',
        'cpresetmain',
        'cpresetlanding',
        'cquickloadpreset',
        'cyupheliindividual',
        'yupheliplan',
        'swapoffon',
        'cquickcrew',
        'cidwidwn',
        'ccolorcode',
        'cflightlegs',
        'clongarmfrontseat',
        'clongarmrearseat',
        'ckeeptozero',
        'clatarmrightseat',
        'cseatsfront',
        'cseatsrear',
        'cseatwidth',
        'cseatheight',
        'clatcenter',
        'clatright',
        'cfuelpanelheight',
        'cfuelpanelstart',
        'clargetopview',
        'cconfigequiplabel',
        'cspecialmanifest',
        'csetupoptions',
        'cdateuseu',
        'cpickerminuteinterval',
        'cpickerlocale',
        'cconfigstationsstart',
        'cconfigstationsend',
        'cmanifestexport',
        'csummaryexport',
        'callowinteroredit',
        'ccheckmargin',
        'cmarginpercent',
        'csecondcgenvelope',
        'clinepilot',
        'ccalcmaxexternalorhoist',
        'callowequipchange',
        'cfwdaftcgcheck',
        'cauxfuelvolume',
        'cdateformat',
        'cfltdataelements',
        'callowbewoverride',
        'clockresetifnotsent',
        'cifunitsaremeter',
        'csetlineasfreeload',
        'cportlandboth',
        'criskassess',
        'cdocviewer',
        'cintconfigurator',
        'callsign',
        'unit',
        'mass',
        'lonsta',
        'lonmom',
        'latsta',
        'latmom',
        'ccheckacupdates',
        'cboxedsliders',
        'cboxalpha',
        'cslideralpha',
        'cboxgap',
        'ctopypos',
        'cboxstyle',
        'ccgexternal',
        'cperfbuttonwidth',
        'selectorbuttons',
        'factorcrewweight',
        'flighttypes',
        'supplyfuelvolume',
        'subtractsupplyfuel',
        'secondmaxavailtext',
        'dependsondisplaybutton',
        'maxavailonmanifest',
        'fuelpresets',
        'autolandingfuelpreset',
        'extra1',
        'extra2',
        'extra3',
        'extra4',
        'extra5',
        'extra6',
        'extra7',
        'extra8',
        'extra9',
        'extra10'
      )
      ->leftJoin('aircraft_type', 'configurations.aircraft_type', '=', 'aircraft_type.aircraft_id')
      ->leftJoin('manufacturer', 'configurations.manufacturer', '=', 'manufacturer.id')
      ->leftJoin('model', 'configurations.model', '=', 'model.id')
      ->leftJoin('variant', 'configurations.variant', '=', 'variant.variant_id')
      ->where('configurations.configurations_id', $id)
      ->first();

    $components = DB::table('components')
      ->select(
        'components.id',
        'components.ilongarm',
        'components.ilatarm',
        'components.item_id',
        'components.isymbolwidth',
        'components.isymbolheight',
        'components.irotation',
        'components.ilongoffset',
        'components.ilatoffset',
        'components.iseatlabel',
        'i_seatsymbol.iseatsymbol',
        'i_specials.ispecial as ispecial',
        'components.istationname',
        'components.iweight',
        'components.ioccweight',
        'components.ionoff',
        'components.imaxweight',
        'components.ioccname',
        'components.ileftright',
        'components.iarmalternate',
        'components.ilatmom',
        'components.ilongmom',
        'components.status',
        'components.type'
      )
      ->leftJoin('i_seatsymbol', 'components.iseatsymbol', '=', 'i_seatsymbol.iseatsymbol_id')
      ->leftJoin('i_specials', 'components.ispecials', '=', 'i_specials.ispecial_id')
      ->where('config_id', $id)
      ->orderBy('components.sequence', 'asc')
      ->get();
    
      ini_set('serialize_precision','-1');
      $response = array(
      'configurations' => $configurations ? $configurations : '',
      'components' => $components,
    );

    return json_encode($response);
  }

  public function itemDestroy($partId)
  {
    DB::table('components')
      ->where('part_id', $partId)
      ->delete();
    return response()->json([
      'status' => 'success',
      'message' => 'Successfully deleted  '
    ]);
  }

  public function update(Request $request, Configurations $config, $id)
  {
    $config = DB::table('configurations')->where('configurations_id', $id)->first();
    $componentHistory = DB::table('components')->where('config_id', $id)->get();
    $undoData['config_data'] = $config;
    $undoData['store'] = json_encode($componentHistory);
    $data = request()->except(['_token']);

    $history_data = array(
      'table_name' => 'configurations',
      'row_id' => $id,
      'history_data' => json_encode($undoData)
    );
    $history_available = DB::table('history')->where(array('table_name' => 'configurations', 'row_id' => $id))->first();
    if (empty($history_available)) {
      DB::table('history')->insert($history_data);
    } else {
      DB::table('history')->where(array('table_name' => 'configurations', 'row_id' => $id))->update($history_data);
    }

    $topY = json_decode($data['top_y']);
    $bottomY = json_decode($data['bottom_y']);
    $leftX = json_decode($data['left_x']);
    $rightX = json_decode($data['right_x']);

    $data['fwd_top_px'] = $topY->top . 'px';
    $data['fwd_left_px'] = $topY->left . 'px';
    $data['aft_top_px'] = $bottomY->top . 'px';
    $data['aft_left_px'] = $bottomY->left . 'px';
    $data['x1_top_px'] = $leftX->top . 'px';
    $data['x1_left_px'] = $leftX->left . 'px';
    $data['x2_top_px'] = $rightX->top . 'px';
    $data['x2_left_px'] = $rightX->left . 'px';

    $store = json_decode($data['store']);
    foreach ($store as $s) {
      $components = DB::table('components')
        ->where('config_id', $id)
        ->where('part_id', $s->partId)
        ->first();

      $component = [
        'config_id' => $id,
        'ilongarm' => empty($s->unitX) ? 0 : $s->unitX,
        'ilatarm' => empty($s->unitY) ? 0 : $s->unitY,
        'item_id' => $s->id,
        'isymbolwidth' => empty($s->width) ? 0 : $s->width,
        'isymbolheight' => empty($s->height) ? 0 : $s->height,
        'irotation' => empty($s->rotation) ? 0 : $s->rotation,
        'ilongoffset' => empty($s->iLongOffset) ? 0 : $s->iLongOffset,
        'ilatoffset' => empty($s->iLatOffset) ? 0 : $s->iLatOffset,
        'iseatlabel' => empty($s->label) ? '' : $s->label,
        'istationname' => empty($s->name) ? '' : $s->name,
        'ionoff' => $s->ionoff,
        'ispecials' => empty($s->specials) ? '' : $s->specials,
        'part_id' => $s->partId,
        'iseatsymbol' => empty($s->symbolname) ? '' : $s->symbolname,
        'ioccweight' => empty($s->occw) ? 0 : $s->occw,
        'iweight' => empty($s->itemw) ? 0 : $s->itemw,
        'imaxweight' => empty($s->maxw) ? 0 : $s->maxw,
        'ioccname' => empty($s->occname) ? '-' : $s->occname,
        'ileftright' => empty($s->leftright) ? '-' : $s->leftright,
        'iarmalternate' => empty($s->alternate) ? '' : $s->alternate,
        'ilatmom' => $s->itemw * $s->unitX,
        'ilongmom' => $s->itemw * $s->unitY,
        'status' => empty($s->status) ? 0 : $s->status,
        'type' => empty($s->type) ? 'symbol' : $s->type,
        'sequence' => $s->sequence
      ];
      // echo "<pre>";print_r($component);

      if ($components) {
        DB::table('components')
          ->where('config_id', $id)
          ->where('part_id', $s->partId)
          ->update($component);
      } else {
        DB::table('components')->insert($component);
      }
    }
    $data = array_except($data, ['top_y', 'bottom_y', 'left_x', 'right_x', 'store']);
    // echo "<pre>";print_r($data);
    $itemUnit = Config::get('constants.configurationItemUnits');

    $unit = empty($data['unit']) ? 'kg' : $data['unit'];

    $configuration = [
      'config_name' => empty($data['config_name']) ? '' : $data['config_name'],
      'aircraft_type' => empty($data['aircraft_type']) ? 0 : $data['aircraft_type'],
      'manufacturer' => empty($data['manufacturer']) ? 0 : $data['manufacturer'],
      'model' => empty($data['model']) ? 0 : $data['model'],
      'variant' => empty($data['variant']) ? 0 : $data['variant'],
      'box_width' => empty($data['box_width']) ? 0 : $data['box_width'],
      'box_height' => empty($data['box_height']) ? 0 : $data['box_height'],
      'cseatsfront' => empty($data['cseatsfront']) ? 0 : $data['cseatsfront'],
      'cseatsrear' => empty($data['cseatsrear']) ? 550 : $data['cseatsrear'],
      'clatcenter' => empty($data['clatcenter']) ? 106 : $data['clatcenter'],
      'clatright' => empty($data['clatright']) ? 300 : $data['clatright'],
      'cacwidth' => empty($data['cacwidth']) ? 0 : $data['cacwidth'],
      'cacheight' => empty($data['cacheight']) ? 0 : $data['cacheight'],
      'cacy' => empty($data['cacy']) ? 0 : $data['cacy'],
      'cacx' => empty($data['cacx']) ? 0 : $data['cacx'],
      'cweightunits' => empty($data['cweightunits']) ? 'kg' : $data['cweightunits'],
      'cmaxramp' => empty($data['cmaxramp']) ? 0 : $data['cmaxramp'],
      'cmaxtow' => empty($data['cmaxtow']) ? 0 : $data['cmaxtow'],
      'cmaxldw' => empty($data['cmaxldw']) ? 0 : $data['cmaxldw'],
      'ccalclateralfuel' => empty($data['ccalclateralfuel']) ? 0 : $data['ccalclateralfuel'],
      'cfuelunits' => empty($data['cfuelunits']) ? 'kg' : $data['cfuelunits'],
      'centermode' => empty($data['centermode']) ? 'volume' : $data['centermode'],
      'cfuelflowlbsperh' => empty($data['cfuelflowlbsperh']) ? 0 : $data['cfuelflowlbsperh'],
      'cpresetmain' => empty($data['cpresetmain']) ? 0 : $data['cpresetmain'],
      'cpresetlanding' => empty($data['cpresetlanding']) ? 0 : $data['cpresetlanding'],
      'swapoffon' => empty($data['swapoffon']) ? 'off' : $data['swapoffon'],
      'cquickcrew' => empty($data['cquickcrew']) ? 'q' : $data['cquickcrew'],
      'cidwidwn' => empty($data['cidwidwn']) ? 'ID' : $data['cidwidwn'],
      'ccolorcode' => empty($data['ccolorcode']) ? 'Yellow' : $data['ccolorcode'],
      'cflightlegs' => empty($data['cflightlegs']) ? 'FlightMode' : $data['cflightlegs'],
      'clongarmfrontseat' => empty($data['clongarmfrontseat']) ? 1000 : $data['clongarmfrontseat'],
      'clongarmrearseat' => empty($data['clongarmrearseat']) ? 5000 : $data['clongarmrearseat'],
      'ckeeptozero' => empty($data['ckeeptozero']) ? 0 : $data['ckeeptozero'],
      'clatarmrightseat' => empty($data['clatarmrightseat']) ? 50 : $data['clatarmrightseat'],
      'cseatwidth' => empty($data['cseatwidth']) ? 45 : $data['cseatwidth'],
      'cseatheight' => empty($data['cseatheight']) ? 50 : $data['cseatheight'],
      'cfuelpanelheight' => empty($data['cfuelpanelheight']) ? 160 : $data['cfuelpanelheight'],
      'cfuelpanelstart' => empty($data['cfuelpanelstart']) ? 'open' : $data['cfuelpanelstart'],
      'clargetopview' => empty($data['clargetopview']) ? 'no' : $data['clargetopview'],
      'cconfigequiplabel' => empty($data['cconfigequiplabel']) ? 'no' : $data['cconfigequiplabel'],
      'cspecialmanifest' => empty($data['cspecialmanifest']) ? '' : $data['cspecialmanifest'],
      'csetupoptions' => empty($data['csetupoptions']) ? '' : $data['csetupoptions'],
      'cdateuseu' => empty($data['cdateuseu']) ? 'EU' : $data['cdateuseu'],
      'cpickerminuteinterval' => empty($data['cpickerminuteinterval']) ? 1 : $data['cpickerminuteinterval'],
      'cpickerlocale' => empty($data['cpickerlocale']) ? 'en-GB' : $data['cpickerlocale'],
      'cconfigstationsstart' => empty($data['cconfigstationsstart']) ? 4 : $data['cconfigstationsstart'],
      'cconfigstationsend' => empty($data['cconfigstationsend']) ? 12 : $data['cconfigstationsend'],
      'cmanifestexport' => empty($data['cmanifestexport']) ? 'yes' : $data['cmanifestexport'],
      'csummaryexport' => empty($data['csummaryexport']) ? 'no' : $data['csummaryexport'],
      'callowinteroredit' => empty($data['callowinteroredit']) ? 'no' : $data['callowinteroredit'],
      'ccheckmargin' => empty($data['ccheckmargin']) ? 'no' : $data['ccheckmargin'],
      'cmarginpercent' => empty($data['cmarginpercent']) ? 0 : $data['cmarginpercent'],
      'csecondcgenvelope' => empty($data['csecondcgenvelope']) ? 'no' : $data['csecondcgenvelope'],
      'clinepilot' => empty($data['clinepilot']) ? 6 : $data['clinepilot'],
      'ccalcmaxexternalorhoist' => empty($data['ccalcmaxexternalorhoist']) ? 'no' : $data['ccalcmaxexternalorhoist'],
      'callowequipchange' => empty($data['callowequipchange']) ? 'no' : $data['callowequipchange'],
      'cfwdaftcgcheck' => empty($data['cfwdaftcgcheck']) ? 'off' : $data['cfwdaftcgcheck'],
      'cauxfuelvolume' => empty($data['cauxfuelvolume']) ? 0 : $data['cauxfuelvolume'],
      'cdateformat' => empty($data['cdateformat']) ? 'dd-MM-yyyy  HH-mm' : $data['cdateformat'],
      'cfltdataelements' => empty($data['cfltdataelements']) ? '' : $data['cfltdataelements'],
      'callowbewoverride' => empty($data['callowbewoverride']) ? 'no' : $data['callowbewoverride'],
      'clockresetifnotsent' => empty($data['clockresetifnotsent']) ? 'no' : $data['clockresetifnotsent'],
      'cifunitsaremeter' => empty($data['cifunitsaremeter']) ? 'no' : $data['cifunitsaremeter'],
      'csetlineasfreeload' => empty($data['csetlineasfreeload']) ? '' : $data['csetlineasfreeload'],
      'cportlandboth' => empty($data['cportlandboth']) ? '' : $data['cportlandboth'],
      'criskassess' => empty($data['criskassess']) ? '' : $data['criskassess'],
      'cdocviewer' => empty($data['cdocviewer']) ? '' : $data['cdocviewer'],
      'cintconfigurator' => empty($data['cintconfigurator']) ? '' : $data['cintconfigurator'],
      'cquickloadpreset' => empty($data['cquickloadpreset']) ? 90 : $data['cquickloadpreset'],
      'callsign' => empty($data['callsign']) ? '' : $data['callsign'],
      'unit' => $unit,
      'mass' => $itemUnit[$unit]['mass'],
      'lonsta' => $itemUnit[$unit]['lonsta'],
      'lonmom' => $itemUnit[$unit]['lonmom'],
      'latsta' => $itemUnit[$unit]['latsta'],
      'latmom' => $itemUnit[$unit]['latmom'],
      'yupheliplan' => empty($data['yupheliplan']) ? 0 : $data['yupheliplan'],
      'ctankmaxfuelvolume' => empty($data['ctankmaxfuelvolume']) ? 0 : $data['ctankmaxfuelvolume'],
      'cfactorlbsgal' => empty($data['cfactorlbsgal']) ? 6.4989 : $data['cfactorlbsgal'],
      'cfactorkgliter' => empty($data['cfactorkgliter']) ? 0.79 : $data['cfactorkgliter'],
      'fwd_top_px' => empty($data['fwd_top_px']) ? '0px' : $data['fwd_top_px'],
      'fwd_left_px' => empty($data['fwd_left_px']) ? '0px' : $data['fwd_left_px'],
      'aft_top_px' => empty($data['aft_top_px']) ? '550px' : $data['aft_top_px'],
      'aft_left_px' => empty($data['aft_left_px']) ? '0px' : $data['aft_left_px'],
      'x1_top_px' => empty($data['x1_top_px']) ? '0px' : $data['x1_top_px'],
      'x1_left_px' => empty($data['x1_left_px']) ? '106px' : $data['x1_left_px'],
      'x2_top_px' => empty($data['x2_top_px']) ? '0px' : $data['x2_top_px'],
      'x2_left_px' => empty($data['x2_left_px']) ? '300px' : $data['x2_left_px'],
      'cyupheliindividual' => empty($data['cyupheliindividual']) ? 0 : $data['cyupheliindividual'],
      'ccheckacupdates' => empty($data['ccheckacupdates']) ? 'no' : $data['ccheckacupdates'],
      'cboxedsliders' => empty($data['cboxedsliders']) ? '' : $data['cboxedsliders'],
      'cboxalpha' => empty($data['cboxalpha']) ? '' : $data['cboxalpha'],
      'cslideralpha' => empty($data['cslideralpha']) ? '' : $data['cslideralpha'],
      'cboxgap' => empty($data['cboxgap']) ? '' : $data['cboxgap'],
      'ctopypos' => empty($data['ctopypos']) ? '' : $data['ctopypos'],
      'cboxstyle' => empty($data['cboxstyle']) ? '' : $data['cboxstyle'],
      'ccgexternal' => empty($data['ccgexternal']) ? 'no' : $data['ccgexternal'],
      'cperfbuttonwidth' => empty($data['cperfbuttonwidth']) ? 150 : $data['cperfbuttonwidth'],
      'image2' => empty($data['image2']) ? 1 : $data['image2'],
      'remark' => empty($data['remark']) ? '' : $data['remark'],
      'selectorbuttons' => empty($data['selectorbuttons']) ? '' : $data['selectorbuttons'],
      'factorcrewweight' => empty($data['factorcrewweight']) ? '' : $data['factorcrewweight'],
      'flighttypes' => empty($data['flighttypes']) ? '' : $data['flighttypes'],
      'supplyfuelvolume' => empty($data['supplyfuelvolume']) ? '' : $data['supplyfuelvolume'],
      'subtractsupplyfuel' => empty($data['subtractsupplyfuel']) ? '' : $data['subtractsupplyfuel'],
      'secondmaxavailtext' => empty($data['secondmaxavailtext']) ? '' : $data['secondmaxavailtext'],
      'dependsondisplaybutton' => empty($data['dependsondisplaybutton']) ? '' : $data['dependsondisplaybutton'],
      'maxavailonmanifest' => empty($data['maxavailonmanifest']) ? '' : $data['maxavailonmanifest'],
      'fuelpresets' => empty($data['fuelpresets']) ? '' : $data['fuelpresets'],
      'autolandingfuelpreset' => empty($data['autolandingfuelpreset']) ? '' : $data['autolandingfuelpreset'],
      'extra1' => empty($data['extra1']) ? '' : $data['extra1'],
      'extra2' => empty($data['extra2']) ? '' : $data['extra2'],
      'extra3' => empty($data['extra3']) ? '' : $data['extra3'],
      'extra4' => empty($data['extra4']) ? '' : $data['extra4'],
      'extra5' => empty($data['extra5']) ? '' : $data['extra5'],
      'extra6' => empty($data['extra6']) ? '' : $data['extra6'],
      'extra7' => empty($data['extra7']) ? '' : $data['extra7'],
      'extra8' => empty($data['extra8']) ? '' : $data['extra8'],
      'extra9' => empty($data['extra9']) ? '' : $data['extra9'],
      'extra10' => empty($data['extra10']) ? '' : $data['extra10'],
    ];

    // echo "<pre>";print_r($data);exit;

    DB::table('configurations')
      ->where('configurations_id', $id)
      ->update($configuration);

    // return redirect('config/edit/'.$id);
    return response()->json([
      'status' => 'success',
      'message' => 'Successfully saved'
    ]);
  }

  public function undoChanges(Request $request)
  {
    $table_name = $request->table_name;
    $id = $request->row_id;
    $history_data = DB::table('history')->where(array('table_name' => $table_name, 'row_id' => $id))->get();
    $data1 = json_decode($history_data[0]->history_data);
    $data = $data1->config_data;
    $history_data = array(
      'table_name' => 'configurations',
      'row_id' => $id,
      'history_data' => json_encode($data)
    );

    $store = json_decode($data1->store);
    foreach ($store as $s) {
      $components = DB::table('components')
        ->where('config_id', $id)
        ->where('part_id', $s->part_id)
        ->first();

      $component = [
        'config_id' => $id,
        'ilongarm' => empty($s->ilongarm) ? 0 : $s->ilongarm,
        'ilatarm' => empty($s->ilatarm) ? 0 : $s->ilatarm,
        'item_id' => $s->item_id,
        'isymbolwidth' => empty($s->isymbolwidth) ? 0 : $s->isymbolwidth,
        'isymbolheight' => empty($s->isymbolheight) ? 0 : $s->isymbolheight,
        'irotation' => empty($s->irotation) ? 0 : $s->irotation,
        'ilongoffset' => empty($s->ilongoffset) ? 0 : $s->ilongoffset,
        'ilatoffset' => empty($s->ilatoffset) ? 0 : $s->ilatoffset,
        'iseatlabel' => empty($s->iseatlabel) ? '' : $s->iseatlabel,
        'istationname' => empty($s->istationname) ? '' : $s->istationname,
        'ionoff' => $s->ionoff,
        'ispecials' => empty($s->ispecials) ? '' : $s->ispecials,
        'part_id' => $s->part_id,
        'iseatsymbol' => empty($s->iseatsymbol) ? '' : $s->iseatsymbol,
        'ioccweight' => empty($s->ioccweight) ? 0 : $s->ioccweight,
        'iweight' => empty($s->iweight) ? 0 : $s->iweight,
        'imaxweight' => empty($s->imaxweight) ? 0 : $s->imaxweight,
        'ioccname' => empty($s->ioccname) ? '-' : $s->ioccname,
        'ileftright' => empty($s->ileftright) ? '-' : $s->ileftright,
        'iarmalternate' => empty($s->iarmalternate) ? '' : $s->iarmalternate,
        'ilatmom' => $s->ilatmom,
        'ilongmom' => $s->ilongmom,
        'status' => empty($s->status) ? 0 : $s->status,
        'type' => empty($s->type) ? 'symbol' : $s->type,
        'sequence' => $s->sequence
      ];
      if ($components) {
        DB::table('components')
          ->where('config_id', $id)
          ->where('part_id', $s->part_id)
          ->update($component);
      } else {
        DB::table('components')->insert($component);
      }
    }
    $itemUnit = Config::get('constants.configurationItemUnits');
    $unit = empty($data->unit) ? 'kg' : $data->unit;
    $configuration = [
      'config_name' => empty($data->config_name) ? '' : $data->config_name,
      'aircraft_type' => empty($data->aircraft_type) ? 0 : $data->aircraft_type,
      'manufacturer' => empty($data->manufacturer) ? 0 : $data->manufacturer,
      'model' => empty($data->model) ? 0 : $data->model,
      'variant' => empty($data->variant) ? 0 : $data->variant,
      'box_width' => empty($data->box_width) ? 0 : $data->box_width,
      'box_height' => empty($data->box_height) ? 0 : $data->box_height,
      'cseatsfront' => empty($data->cseatsfront) ? 0 : $data->cseatsfront,
      'cseatsrear' => empty($data->cseatsrear) ? 550 : $data->cseatsrear,
      'clatcenter' => empty($data->clatcenter) ? 106 : $data->clatcenter,
      'clatright' => empty($data->clatright) ? 300 : $data->clatright,
      'cacwidth' => empty($data->cacwidth) ? 0 : $data->cacwidth,
      'cacheight' => empty($data->cacheight) ? 0 : $data->cacheight,
      'cacy' => empty($data->cacy) ? 0 : $data->cacy,
      'cacx' => empty($data->cacx) ? 0 : $data->cacx,
      'cweightunits' => empty($data->cweightunits) ? 'kg' : $data->cweightunits,
      'cmaxramp' => empty($data->cmaxramp) ? 0 : $data->cmaxramp,
      'cmaxtow' => empty($data->cmaxtow) ? 0 : $data->cmaxtow,
      'cmaxldw' => empty($data->cmaxldw) ? 0 : $data->cmaxldw,
      'ccalclateralfuel' => empty($data->ccalclateralfuel) ? 0 : $data->ccalclateralfuel,
      'cfuelunits' => empty($data->cfuelunits) ? 'kg' : $data->cfuelunits,
      'centermode' => empty($data->centermode) ? 'volume' : $data->centermode,
      'cfuelflowlbsperh' => empty($data->cfuelflowlbsperh) ? 0 : $data->cfuelflowlbsperh,
      'cpresetmain' => empty($data->cpresetmain) ? 0 : $data->cpresetmain,
      'cpresetlanding' => empty($data->cpresetlanding) ? 0 : $data->cpresetlanding,
      'swapoffon' => empty($data->swapoffon) ? 'off' : $data->swapoffon,
      'cquickcrew' => empty($data->cquickcrew) ? 'q' : $data->cquickcrew,
      'cidwidwn' => empty($data->cidwidwn) ? 'ID' : $data->cidwidwn,
      'ccolorcode' => empty($data->ccolorcode) ? 'Yellow' : $data->ccolorcode,
      'cflightlegs' => empty($data->cflightlegs) ? 'FlightMode' : $data->cflightlegs,
      'clongarmfrontseat' => empty($data->clongarmfrontseat) ? 1000 : $data->clongarmfrontseat,
      'clongarmrearseat' => empty($data->clongarmrearseat) ? 5000 : $data->clongarmrearseat,
      'ckeeptozero' => empty($data->ckeeptozero) ? 0 : $data->ckeeptozero,
      'clatarmrightseat' => empty($data->clatarmrightseat) ? 50 : $data->clatarmrightseat,
      'cseatwidth' => empty($data->cseatwidth) ? 45 : $data->cseatwidth,
      'cseatheight' => empty($data->cseatheight) ? 50 : $data->cseatheight,
      'cfuelpanelheight' => empty($data->cfuelpanelheight) ? 160 : $data->cfuelpanelheight,
      'cfuelpanelstart' => empty($data->cfuelpanelstart) ? 'open' : $data->cfuelpanelstart,
      'clargetopview' => empty($data->clargetopview) ? 'no' : $data->clargetopview,
      'cconfigequiplabel' => empty($data->cconfigequiplabel) ? 'no' : $data->cconfigequiplabel,
      'cspecialmanifest' => empty($data->cspecialmanifest) ? '' : $data->cspecialmanifest,
      'csetupoptions' => empty($data->csetupoptions) ? '' : $data->csetupoptions,
      'cdateuseu' => empty($data->cdateuseu) ? 'EU' : $data->cdateuseu,
      'cpickerminuteinterval' => empty($data->cpickerminuteinterval) ? 1 : $data->cpickerminuteinterval,
      'cpickerlocale' => empty($data->cpickerlocale) ? 'en-GB' : $data->cpickerlocale,
      'cconfigstationsstart' => empty($data->cconfigstationsstart) ? 4 : $data->cconfigstationsstart,
      'cconfigstationsend' => empty($data->cconfigstationsend) ? 12 : $data->cconfigstationsend,
      'cmanifestexport' => empty($data->cmanifestexport) ? 'yes' : $data->cmanifestexport,
      'csummaryexport' => empty($data->csummaryexport) ? 'no' : $data->csummaryexport,
      'callowinteroredit' => empty($data->callowinteroredit) ? 'no' : $data->callowinteroredit,
      'ccheckmargin' => empty($data->ccheckmargin) ? 'no' : $data->ccheckmargin,
      'cmarginpercent' => empty($data->cmarginpercent) ? 0 : $data->cmarginpercent,
      'csecondcgenvelope' => empty($data->csecondcgenvelope) ? 'no' : $data->csecondcgenvelope,
      'clinepilot' => empty($data->clinepilot) ? 6 : $data->clinepilot,
      'ccalcmaxexternalorhoist' => empty($data->ccalcmaxexternalorhoist) ? 'no' : $data->ccalcmaxexternalorhoist,
      'callowequipchange' => empty($data->callowequipchange) ? 'no' : $data->callowequipchange,
      'cfwdaftcgcheck' => empty($data->cfwdaftcgcheck) ? 'off' : $data->cfwdaftcgcheck,
      'cauxfuelvolume' => empty($data->cauxfuelvolume) ? 0 : $data->cauxfuelvolume,
      'cdateformat' => empty($data->cdateformat) ? 'dd-MM-yyyy  HH-mm' : $data->cdateformat,
      'cfltdataelements' => empty($data->cfltdataelements) ? '' : $data->cfltdataelements,
      'callowbewoverride' => empty($data->callowbewoverride) ? 'no' : $data->callowbewoverride,
      'clockresetifnotsent' => empty($data->clockresetifnotsent) ? 'no' : $data->clockresetifnotsent,
      'cifunitsaremeter' => empty($data->cifunitsaremeter) ? 'no' : $data->cifunitsaremeter,
      'csetlineasfreeload' => empty($data->csetlineasfreeload) ? '' : $data->csetlineasfreeload,
      'cportlandboth' => empty($data->cportlandboth) ? '' : $data->cportlandboth,
      'criskassess' => empty($data->criskassess) ? '' : $data->criskassess,
      'cdocviewer' => empty($data->cdocviewer) ? '' : $data->cdocviewer,
      'cintconfigurator' => empty($data->cintconfigurator) ? '' : $data->cintconfigurator,
      'cquickloadpreset' => empty($data->cquickloadpreset) ? 90 : $data->cquickloadpreset,
      'callsign' => empty($data->callsign) ? '' : $data->callsign,
      'unit' => $unit,
      'mass' => $itemUnit[$unit]['mass'],
      'lonsta' => $itemUnit[$unit]['lonsta'],
      'lonmom' => $itemUnit[$unit]['lonmom'],
      'latsta' => $itemUnit[$unit]['latsta'],
      'latmom' => $itemUnit[$unit]['latmom'],
      'yupheliplan' => empty($data->yupheliplan) ? 0 : $data->yupheliplan,
      'ctankmaxfuelvolume' => empty($data->ctankmaxfuelvolume) ? 0 : $data->ctankmaxfuelvolume,
      'cfactorlbsgal' => empty($data->cfactorlbsgal) ? 6.4989 : $data->cfactorlbsgal,
      'cfactorkgliter' => empty($data->cfactorkgliter) ? 0.79 : $data->cfactorkgliter,
      'fwd_top_px' => empty($data->fwd_top_px) ? '0px' : $data->fwd_top_px,
      'fwd_left_px' => empty($data->fwd_left_px) ? '0px' : $data->fwd_left_px,
      'aft_top_px' => empty($data->aft_top_px) ? '550px' : $data->aft_top_px,
      'aft_left_px' => empty($data->aft_left_px) ? '0px' : $data->aft_left_px,
      'x1_top_px' => empty($data->x1_top_px) ? '0px' : $data->x1_top_px,
      'x1_left_px' => empty($data->x1_left_px) ? '106px' : $data->x1_left_px,
      'x2_top_px' => empty($data->x2_top_px) ? '0px' : $data->x2_top_px,
      'x2_left_px' => empty($data->x2_left_px) ? '300px' : $data->x2_left_px,
      'cyupheliindividual' => empty($data->cyupheliindividual) ? 0 : $data->cyupheliindividual,
      'ccheckacupdates' => empty($data->ccheckacupdates) ? 'no' : $data->ccheckacupdates,
      'cboxedsliders' => empty($data->cboxedsliders) ? '' : $data->cboxedsliders,
      'cboxalpha' => empty($data->cboxalpha) ? '' : $data->cboxalpha,
      'cslideralpha' => empty($data->cslideralpha) ? '' : $data->cslideralpha,
      'cboxgap' => empty($data->cboxgap) ? '' : $data->cboxgap,
      'ctopypos' => empty($data->ctopypos) ? '' : $data->ctopypos,
      'cboxstyle' => empty($data->cboxstyle) ? '' : $data->cboxstyle,
      'ccgexternal' => empty($data->ccgexternal) ? 'no' : $data->ccgexternal,
      'cperfbuttonwidth' => empty($data->cperfbuttonwidth) ? 150 : $data->cperfbuttonwidth,
      'image2' => empty($data->image2) ? 1 : $data->image2,
      'remark' => empty($data->remark) ? '' : $data->remark,
      'selectorbuttons' => empty($data->selectorbuttons) ? '' : $data->selectorbuttons,
      'factorcrewweight' => empty($data->factorcrewweight) ? '' : $data->factorcrewweight,
      'flighttypes' => empty($data->flighttypes) ? '' : $data->flighttypes,
      'supplyfuelvolume' => empty($data->supplyfuelvolume) ? '' : $data->supplyfuelvolume,
      'subtractsupplyfuel' => empty($data->subtractsupplyfuel) ? '' : $data->subtractsupplyfuel,
      'secondmaxavailtext' => empty($data->secondmaxavailtext) ? '' : $data->secondmaxavailtext,
      'dependsondisplaybutton' => empty($data->dependsondisplaybutton) ? '' : $data->dependsondisplaybutton,
      'maxavailonmanifest' => empty($data->maxavailonmanifest) ? '' : $data->maxavailonmanifest,
      'fuelpresets' => empty($data->fuelpresets) ? '' : $data->fuelpresets,
      'autolandingfuelpreset' => empty($data->autolandingfuelpreset) ? '' : $data->autolandingfuelpreset,
      'extra1' => empty($data->extra1) ? '' : $data->extra1,
      'extra3' => empty($data->extra3) ? '' : $data->extra3,
      'extra4' => empty($data->extra4) ? '' : $data->extra4,
      'extra2' => empty($data->extra2) ? '' : $data->extra2,
      'extra5' => empty($data->extra5) ? '' : $data->extra5,
      'extra6' => empty($data->extra6) ? '' : $data->extra6,
      'extra7' => empty($data->extra7) ? '' : $data->extra7,
      'extra8' => empty($data->extra8) ? '' : $data->extra8,
      'extra9' => empty($data->extra9) ? '' : $data->extra9,
      'extra10' => empty($data->extra10) ? '' : $data->extra10,
    ];

    DB::table('configurations')
      ->where('configurations_id', $id)
      ->update($configuration);

    return response()->json([
      'status' => 'success',
      'message' => 'Successfully saved'
    ]);
  }

  public function destroy($id)
  {
    DB::table('configurations')->where('configurations_id', $id)->delete();
  }

  public function addManufacturer(Request $request)
  {
    $data = $request->manufacturer_data;
    DB::table('manufacturer')->insert(['manufacturer_name' => $data]);

    return json_encode($data);
  }

  public function removeManufacture(Request $request, $id)
  {
    $manufacture = \App\Manufacturer::find($id);
    $manufacture->delete();

    return 'success';
  }

  public function removeModel(Request $request, $id)
  {
    $manufacture = \App\Aircraft_model::find($id);
    $manufacture->delete();

    return 'success';
  }
  //new
  public function removespecial(Request $request, $id)
  {
    DB::table('i_specials')->where('ispecial_id', $id)->delete();
    return redirect('/config/setting');
  }
  public function removesymbol(Request $request)
  {
    $id = $request->id;
    DB::table('i_seatsymbol')->where('iseatsymbol_id', $id)->delete();
    $res['success'] = 1;
    return json_encode($res);
    // return redirect('/config/setting');
  }

  public function addModel(Request $request)
  {
    $data = $request->model_data;
    DB::table('model')->insert(['model_name' => $data]);
    return json_encode($data);
  }

  //new
  public function addspecial(Request $request)
  {
    $data = $request->spe_data;
    DB::table('i_specials')->insert(['ispecial' => $data]);
    return json_encode($data);
  }

  public function addsymbol(Request $request)
  {
    $data = $request->sym_data;
    $isSymbolExists = DB::table('i_seatsymbol')->where('iseatsymbol', $data)->exists();
    if (!$isSymbolExists) {
      DB::table('i_seatsymbol')->insert(['iseatsymbol' => $data]);
    }
    return json_encode($data);
  }

  public function addVariant(Request $request)
  {
    $variantName = $request->variant_name;
    DB::table('variant')->insert(['variant_name' => $variantName]);

    return json_encode($variantName);
  }

  public function removeVariant($id)
  {
    Variant::where('variant_id', '=', $id)->delete();

    return 'success';
  }

  public function configAircraftUpload(Request $request)
  {
    $this->validate($request, [
      'aircraft' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
    ]);
    $aircraft = $request->file('aircraft');
    $aircraftName = $aircraft->getClientOriginalName();
    $name = time() . '_' . $aircraftName;

    $file = public_path() . '/uploads/' . $aircraftName;
    if (!File::exists($file)) {
      $Configuration_image = new Configuration_image();
      $Configuration_image->files = $name;
      $Configuration_image->file_name = $aircraftName;
      $Configuration_image->save();
      Storage::disk('public')->put($name,  File::get($aircraft));
    }

    return redirect('/config/setting');
  }

  public function configSymbolUpload(Request $request)
  {
    $this->validate($request, [
      'symbol' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
    ]);
    $symbol = $request->file('symbol');
    $path = $symbol->getRealPath();
    $original = $symbol->getClientOriginalName();
    $name = time() . '_' . $original;
    list($width, $height) = getimagesize($path);

    // $isFileExists = DB::table('items')->where('name',$original)->exists();

    // $file = public_path().'/uploads/'.$original;
    // if(!$isFileExists || !File::exists($file)) {
    $Item = new Item();
    $Item->name = $original;
    $Item->image = $name;
    $Item->width = $width;
    $Item->height = $height;
    $Item->save();
    Storage::disk('public')->put($name,  File::get($symbol));
    // }


    return redirect('/config/setting');
  }

  public function configAircraftRemove(Request $request)
  {
    $id = $request->id;
    $deleted = 0;
    $data = Configuration_image::where('configuration_image_id', $id)->first();
    if ($data->files && file_exists(public_path('uploads') . '/' . $data->files)) {
      unlink(public_path('/uploads') . '/' . $data->files);
      $deleted = 1;
    }
    $data2 = Configuration_image::where('configuration_image_id', $id)->delete();
    // $data->delete();

    // $aircraft = DB::table('configuration_image')->where('configuration_image_id', '=', $id)->first();

    // $aircraft = DB::table('configuration_image')->where('configuration_image_id', '=', $id)->first();
    // $file = public_path().'/uploads/'.$aircraft->files;
    // if(File::exists($file)) {
    //     File::delete($file);
    //     Configuration_image::where('configuration_image_id', '=', $id)->delete();
    // }

    return 'success';
  }

  public function configSymbolRemove(Request $request)
  {
    $id = $request->id;
    $items = Item::find($id);

    if ($items->image && file_exists(public_path('uploads') . '/' . $items->image)) {
      unlink(public_path('/uploads') . '/' . $items->image);
    }

    $items->delete();
    // $symbol = DB::table('items')->where('id', '=', $id)->first();
    // $file = public_path().'/uploads/'.$symbol->image;

    // if(File::exists($file)) {
    //   File::delete($file);
    //   Item::find($id)->delete();
    // }

    return 'success';
  }

  public function specialItem($id)
  {
    $data = DB::table('special_items')->where('id', '=', $id)->first();

    return json_encode($data);
  }

  // public function addSpecialItem(Request $request){
  //   $data = request()->except(['_token']);
  //   if(empty($data['special_item_name'])) {
  //     $status = 'failed';
  //     $message = 'Enter correct special item name';
  //   } else {
  //     $checkAsset = DB::table('special_items')->where('special_item_name', '=', $data['special_item_name'])->first();
  //     $asset = [
  //       'special_item_alternate' => isset($data['special_item_alternate']) ? $data['special_item_alternate'] : '',
  //       'special_item_symbol' => isset($data['special_item_symbol']) ? $data['special_item_symbol'] : '',
  //       'special_item_ionoff' => isset($data['special_item_ionoff']) ? $data['special_item_ionoff'] : '',
  //       'special_item_name' => isset($data['special_item_name']) ? $data['special_item_name'] : '',
  //       'special_item_specials' => isset($data['special_item_specials']) ? $data['special_item_specials'] : '',
  //       'special_item_station_name' => isset($data['special_item_station_name']) ? $data['special_item_station_name'] : '',
  //       'special_item_weight' => isset($data['special_item_weight']) ? $data['special_item_weight'] : 0
  //     ];
  //
  //     if($checkAsset) {
  //       DB::table('special_items')
  //         ->where('special_item_id', '=', $data['special_item_id'])
  //         ->update($asset);
  //     } else {
  //       DB::table('special_items')->insert($asset);
  //     }
  //     $status = 'success';
  //     $message = 'Successfully saved';
  //   }
  //
  //   return response()->json([
  //        'status' => $status,
  //        'message' => $message
  //   ]);
  // }

  public function addSpecialItem(Request $request)
  {
    $data = request()->except(['_token', 'special_item_id']);
    if (empty($data['special_item_name'])) {
      $status = 'failed';
      $message = 'Enter correct special item name';
    } else {
      DB::table('special_items')->insert(['special_item_name' => $data['special_item_name']]);
      $status = 'success';
      $message = 'Successfully saved';
    }

    return response()->json([
      'status' => $status,
      'message' => $message
    ]);
  }

  public function removeSpecialItem($id)
  {
    DB::table('special_items')->where('special_item_id', '=', $id)->delete();

    return 'success';
  }


  public function lockUnlockState(Request $request, $id, $is_locked)
  {
    $stateVal = ($is_locked == 1) ? 0 : 1;
    DB::table('configurations')->where('configurations_id', $id)->update(array('is_locked' => $stateVal));
    return redirect('/config');
  }

  // copy config data to client with new config id
  public function copyConfigData(Request $request, Configurations $config, $id, $email)
  {
    $last = Configurations::orderBy('configurations_id', 'desc')->first();
    $cloneId = $last->configurations_id + 1;

    $config = DB::table('configurations')->where('configurations_id', $id)->first();
    $data = request()->except(['_token']);

    $config = Configurations::where('configurations_id', '=', $id)->first();
    $cloneConfig = $config->replicate();
    $cloneConfig->configurations_id = $cloneId;
    $cloneConfig->is_locked = 1;
    $cloneConfig->copy_from_id = $id;
    $cloneConfig->client_email = $email;
    $cloneConfig->save();

    $getNewConfigId = $cloneConfig->id;

    // $getNewConfigId = DB::table('configurations')
    //                                 ->insertGetId($configuration);

    $components = DB::table('components')
      ->where('config_id', $id)
      ->get();

    foreach ($components as $component) {
      $num = floor(rand() * 100) + 1;
      $cloneComponent = [
        'config_id' => $cloneId,
        'ilongarm' => $component->ilongarm,
        'ilatarm' => $component->ilatarm,
        'item_id' => $component->item_id,
        'isymbolwidth' => $component->isymbolwidth,
        'isymbolheight' => $component->isymbolheight,
        'irotation' => $component->irotation,
        'ilongoffset' => $component->ilongoffset,
        'ilatoffset' => $component->ilatoffset,
        'iseatlabel' => $component->iseatlabel,
        'istationname' => $component->istationname,
        'ionoff' => $component->ionoff,
        'ispecials' => $component->ispecials,
        'part_id' => "part$num",
        'iseatsymbol' => $component->iseatsymbol,
        'ioccweight' => $component->ioccweight,
        'iweight' => $component->iweight,
        'imaxweight' => $component->imaxweight,
        'ioccname' => $component->ioccname,
        'ileftright' => $component->ileftright,
        'iarmalternate' => $component->iarmalternate,
        'ilatmom' => $component->ilatmom,
        'ilongmom' => $component->ilongmom,
        'sequence' => $component->sequence,
        'status' => $component->status,
        'type' => $component->type,
      ];
      DB::table('components')->insert($cloneComponent);
    }

    // $userId = Auth::user()->id;
    $getUserData = DB::table('users')
      ->select('configurations')
      ->where('email', $email)
      ->value('configurations');

    $newConfigUserId = ($getUserData == "") ? $getNewConfigId : $getUserData . ',' . $getNewConfigId;
    if (stripos($getUserData, (string)$getNewConfigId) !== true) {
      $updateData = DB::table('users')
        ->where('email', $email)
        ->update(array('configurations' => $newConfigUserId));
    }

    // return redirect('config/edit/'.$id);
    return response()->json([
      'status' => 'success',
      'message' => 'Copied Config Successfully to ' . $email
    ]);
  }

 
}
