<?php

namespace App\Http\Controllers\Admin;

use App\AirCraft;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\Traits\GetDropdownValueFromDBTrait;
use DB;
use Auth;
use App\AircraftFlightpadApi;
class AirCraftController extends Controller
{
    use GetDropdownValueFromDBTrait;

    public function index(){
        $airCraft = DB::table('airCraft')
                          ->select('airCraft.ac_id','airCraft_data.is_locked','variant.variant_name', 'remark', 'manufacturer_name', 'model_name','aircraft_type.aircraft_name')
                          ->leftJoin('airCraft_data', 'airCraft.ac_id', '=', 'airCraft_data.ac_id')
                          ->leftJoin('aircraft_type', 'airCraft.aircraft_type', '=', 'aircraft_type.aircraft_id')
                          ->leftJoin('variant', 'airCraft.variant', '=', 'variant.variant_id')
                          ->leftJoin('manufacturer', 'manufacturer.id', '=', 'airCraft.manufacturer')
                          ->leftJoin('model', 'model.id', '=', 'airCraft.model')
                          ->get();

        return view('admin.airCraft.list', compact('airCraft'));
    }

    public function create() {
        $aircraft = DB::table('aircraft_type')->get();
        $manufacturer = $this->getManufacturer();
        $variant = $this->getVariant();
        $model = $this->getModel();
        $configImage = DB::table('configuration_image')
                         ->orderBy('file_name', 'asc')
                         ->get();

        return view('admin.airCraft.create', compact('manufacturer', 'variant', 'aircraft', 'model', 'configImage'));
    }

    public function store(Request $request, AirCraft $airCraft) {
        $all = $request->all();
        $all['remark'] = empty($all['remark']) ? '' : $all['remark'];
        $data = AirCraft::create($all);
        DB::table('airCraft_data')->insert(array(
                                                'ac_id' => $data->id, 
                                                'basic_empty_weight' => 0, 
                                                'mm_long' => 0, 
                                                'mm_lat' => 0, 
                                                'cg_envelope' => '', 
                                                'fuel_interpolation' => '', 
                                                'available_charts' => '', 
                                                'interior_config' => '',
                                                'cg_envelope_name' => '', 
                                                'fuel_interpolation_name' => '', 
                                                'available_charts_name' => '', 
                                                'interior_config_name' => '',
                                                'unit' => 0,
                                                'version' => 0,
                                                'm_to_w' => 0,
                                                'fuel' => 0,
                                                'category' => '',
                                                'thub_name' => '',
                                                'topview_name' => '',
                                                'desc_1' => '',
                                                'desc_2' => '',
                                                'remarks' => '',
                                                ));
        return redirect('/airCraft/edit/'.$data->id);
    }

    public function edit($id) {
        $airCraftEdit = DB::table('airCraft')
                        ->where('airCraft.ac_id', $id)
                        ->first();
        if (!$airCraftEdit) { abort(404); }

        $airCraftData = DB::table('airCraft_data')
                        ->where('ac_id', $id)
                        ->first();
        if (!$airCraftData) { abort(404); }

        $airCraftPerformanceData = DB::table('airCraft_performance_files')
                        ->where('ac_id', $id)
                        ->get();
        if (!$airCraftPerformanceData) { abort(404); }

        $manufacturer = DB::table('manufacturer')->get();
        $aircraft = DB::table('aircraft_type')->get();
        $variant = DB::table('variant')->get();
        $model = DB::table('model')->get();
        $items = DB::table('items')->get();
        $unit = DB::table('unit')->get();
        $specialItems = DB::table('special_items')->get();
        $iSeatSymbol = DB::table('i_seatsymbol')->get();
        $iSpecials = DB::table('i_specials')->get();

        return view('admin.airCraft.edit', compact('manufacturer', 'variant', 'aircraft',
                                                    'model', 'airCraftEdit', 'airCraftData',
                                                    'airCraftPerformanceData', 'items', 'specialItems', 
                                                    'iSeatSymbol','iSpecials','unit'
                                                 ));
    }

    public function update(Request $request, $id) {
        //$data = request()->except(['_token','x_value','y_value','dps']);
        $data = request()->all();
        $remark = empty($data['remark']) ? '' :  $data['remark'];
        $aircraftType = $data['aircraft_type'];
        $manufacturer = $data['manufacturer'];
        $model = $data['model'];
        $variant = $data['variant'];
        $basicWeight = $data['basic_weight'];
        $mmLong = $data['mm_long'];
        $mmLat = $data['mm_lat'];
        $cgEnvelope = empty($data['cg_envelope']) ? '' :  $data['cg_envelope'];
        $fuelInterpln = empty($data['fuel_interpln']) ? '' :  $data['fuel_interpln'];
        $availableCharts =empty($data['available_charts']) ? '' :   $data['available_charts'];
        $interiorConfig = empty($data['interior_config']) ? '' :  $data['interior_config'];
        $cgEnvelopeName = empty($data['cg_label']) ? '' :  $data['cg_label'];
        $fuelInterplnName = empty($data['fuel_interpolation_label']) ? '' :  $data['fuel_interpolation_label'];
        $availableChartsName = empty($data['available_chart_label']) ? '' :  $data['available_chart_label'];
        $interiorConfigName = empty($data['interior_label']) ? '' :  $data['interior_label'];
        $updatedAt = date('Y-m-d H:i:s');

        $unit = empty($data['unit']) ? 0 :  $data['unit'];
        $version = empty($data['version']) ? 0 :  $data['version'];
        $mtow = empty($data['mtow']) ? 0 :  $data['mtow'];
        $fuel = empty($data['fuel_mx']) ? 0 :  $data['fuel_mx'];
        $category = empty($data['category']) ? '' :  $data['category'];
        $thumb = empty($data['thumb_nm']) ? '' :  $data['thumb_nm'];
        $topnm = empty($data['top_nm']) ? '' :  $data['top_nm'];
        $desc1 = empty($data['desc_1']) ? '' :  $data['desc_1'];
        $desc2 = empty($data['desc_2']) ? '' :  $data['desc_2'];
        $remarks = empty($data['remarks']) ? '' :  $data['remarks'];

        $fileNameArr = json_decode($data['fileNameArr']);
        $fileTextArr = json_decode($data['fileTextArr']);

        DB::table('airCraft')
                ->where('ac_id', $id)
                ->update(array(
                            'aircraft_type' => $aircraftType, 
                            'manufacturer' => $manufacturer, 
                            'model' => $model, 
                            'variant' => $variant, 
                            'remark' => $remark, 
                            'updated_at' => $updatedAt
                        ));

        DB::table('airCraft_data')
                ->where('ac_id', $id)
                ->update(array(
                            'basic_empty_weight' => $basicWeight, 
                            'mm_long' => $mmLong, 
                            'mm_lat' => $mmLat, 
                            'cg_envelope' => $cgEnvelope, 
                            'fuel_interpolation' => $fuelInterpln, 
                            'available_charts' => $availableCharts, 
                            'interior_config' => $interiorConfig,
                            'cg_envelope_name' => $cgEnvelopeName,
                            'fuel_interpolation_name' => $fuelInterplnName,
                            'available_charts_name' => $availableChartsName,
                            'interior_config_name' => $interiorConfigName,
                            'unit' => $unit,
                            'version' => $version,
                            'm_to_w' => $mtow,
                            'fuel' => $fuel,
                            'category' => $category,
                            'thub_name' => $thumb,
                            'topview_name' => $topnm,
                            'desc_1' => $desc1,
                            'desc_2' => $desc2,
                            'remarks' => $remarks,
                        ));
      
       foreach($fileNameArr as $nameItem){
            DB::table('airCraft_performance_files')
                ->where('ac_per_id', $nameItem->id)
                ->update(array(
                            'name' => $nameItem->name, 
                        ));
        }

        foreach($fileTextArr as $fileTextItem){
            DB::table('airCraft_performance_files')
                ->where('ac_per_id', $fileTextItem->id)
                ->update(array(
                            'file_text' => $fileTextItem->fileText, 
                        ));
        }

        return response()->json([
             'status' => 'success',
             'message' => 'Successfully saved'
        ]);
    }

    public function copy($id) {
        
        $getAircraft = DB::table('airCraft')
                                    ->where('ac_id', $id)
                                    ->first();
        $getCopyAircraftId = DB::table('airCraft')
                                    ->insertGetId(array(
                                                    'aircraft_type' => $getAircraft->aircraft_type,
                                                    'manufacturer' => $getAircraft->manufacturer,
                                                    'model' => $getAircraft->model,
                                                    'variant' => $getAircraft->variant,
                                                    'remark' => $getAircraft->remark,
                                                    'created_at' => date('Y-m-d H:i:s'),
                                                    'updated_at' => date('Y-m-d H:i:s')
                                                ));

        $getAircraftData = DB::table('airCraft_data')
                                    ->where('ac_id', $id)
                                    ->first();
        $CopyAircraftData = DB::table('airCraft_data')
                                    ->insert(array(
                                            'ac_id' => $getCopyAircraftId,
                                            'basic_empty_weight' => $getAircraftData->basic_empty_weight,
                                            'mm_long' => $getAircraftData->mm_long,
                                            'mm_lat' => $getAircraftData->mm_lat,
                                            'cg_envelope' => $getAircraftData->cg_envelope,
                                            'fuel_interpolation' =>  $getAircraftData->fuel_interpolation,
                                            'available_charts' =>  $getAircraftData->available_charts,
                                            'interior_config' =>  $getAircraftData->interior_config,
                                            'cg_envelope_name' => $getAircraftData->cg_envelope_name,
                                            'fuel_interpolation_name' =>  $getAircraftData->fuel_interpolation_name,
                                            'available_charts_name' =>  $getAircraftData->available_charts_name,
                                            'interior_config_name' =>  $getAircraftData->interior_config_name,
                                            'unit' => $getAircraftData->unit,
                                            'version' => $getAircraftData->version,
                                            'm_to_w' => $getAircraftData->m_to_w,
                                            'fuel' => $getAircraftData->fuel,
                                            'category' => $getAircraftData->category,
                                            'thub_name' => $getAircraftData->thub_name,
                                            'topview_name' => $getAircraftData->topview_name,
                                            'desc_1' => $getAircraftData->desc_1,
                                            'desc_2' => $getAircraftData->desc_2,
                                            'remarks' => $getAircraftData->remarks,
                                            'is_locked' => 1,
                                        ));
                                        
        $getPerformanceFileData = DB::table('airCraft_performance_files')
                                            ->where('ac_id', $id)
                                            ->get();

        foreach($getPerformanceFileData as $row){
            $copyPerformanceFileData = DB::table('airCraft_performance_files')
                                                ->insert(array(
                                                        'ac_id' => $getCopyAircraftId,
                                                        'name' => $row->name,
                                                        'file_text' => $row->file_text,
                                                    ));
        }
        return redirect('/airCraft');
    }

    public function destroy($id) {
        DB::table('airCraft')->where('ac_id', $id)->delete();
        DB::table('airCraft_data')->where('ac_id', $id)->delete();
        DB::table('airCraft_performance_files')->where('ac_id', $id)->delete();
    }

    public function performanceFileDestroy($id) {
        DB::table('airCraft_performance_files')->where('ac_per_id', $id)->delete();
    }

    public function addPerformance(Request $request, $id) {
        //$data = request()->except(['_token','x_value','y_value','dps']);
        $data = request()->all();

        $name = empty($data['name']) ? '' :  $data['name'];
        $fileText =empty($data['fileText']) ? '' :   $data['fileText'];

        $cgEnvelope = empty($data['cg_envelope']) ? '' :  $data['cg_envelope'];
        $fuelInterpln = empty($data['fuel_interpln']) ? '' :  $data['fuel_interpln'];
        $availableCharts =empty($data['available_charts']) ? '' :   $data['available_charts'];
        $interiorConfig = empty($data['interior_config']) ? '' :  $data['interior_config'];

        DB::table('airCraft_performance_files')
                ->insert(array(
                            'ac_id' => $id,
                            'name' => $name, 
                            'file_text' => $fileText, 
                        ));

        DB::table('airCraft_data')
                        ->where('ac_id', $id)
                        ->update(array(
                                    'cg_envelope' => $cgEnvelope, 
                                    'fuel_interpolation' => $fuelInterpln, 
                                    'available_charts' => $availableCharts, 
                                    'interior_config' => $interiorConfig,
                                ));

        return response()->json([
             'status' => 'success',
             'message' => 'Performance file Successfully added'
        ]);
    }

    public function lockUnlockState(Request $request, $id, $is_locked){
        $stateVal = ($is_locked == 1) ? 0 : 1;
        DB::table('airCraft_data')->where('ac_id',$id)->update(array('is_locked' => $stateVal));
        return redirect('/airCraft');
    }
    
 /**
   * @OA\Get( path="/api/aircraftnew/{id}",
   * summary = "to get response from database",
   *  tags={"Flightpad"},
   *     @OA\Parameter(
   *        name="id", in="path",required=true, 
   *          @OA\Schema(type="integer",)
   *     ),
   *      @OA\Parameter(
   *        name="AppKey", in="header",required=true, 
   *          @OA\Schema(type="string",)
   *     ),
   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */
    public function getAircraftnew(Request $request, $id){
       // $appkey = $request->header('AppKey');
       // $userAppkey= config('constants.AuthKey');
        
      // if($userAppkey == $appkey){
        $airCraftData = DB::table('airCraft')
                                    ->select(
                                        'aircraft_name AS aircraft_type ',
                                        'airCraft.ac_id',
                                        'manufacturer_name',
                                        'model_name',
                                        'variant_name',
                                        'remark',
                                        'airCraft_data.basic_empty_weight',
                                        'airCraft_data.mm_long',
                                        'airCraft_data.mm_lat',
                                        'airCraft_data.cg_envelope',
                                        'airCraft_data.fuel_interpolation',
                                        'airCraft_data.available_charts',
                                        'airCraft_data.interior_config',
                                        'unit_nm AS original_unit',
                                        'airCraft_data.version AS version',
                                        'airCraft_data.m_to_w AS MTOW',
                                        'airCraft_data.fuel AS fuel max',
                                        'airCraft_data.category AS category',
                                        'airCraft_data.thub_name AS thumbnail_name',
                                        'airCraft_data.topview_name AS topview_name',
                                        'airCraft_data.desc_1 AS description_1',
                                        'airCraft_data.desc_2 AS description_2',
                                        'airCraft_data.remarks AS remarks'
                                    )
                                    ->leftJoin('aircraft_type', 'airCraft.aircraft_type', '=', 'aircraft_type.aircraft_id')
                                    ->leftJoin('airCraft_data', 'airCraft.ac_id', '=', 'airCraft_data.ac_id')
                                    ->leftJoin('manufacturer', 'airCraft.manufacturer', '=', 'manufacturer.id')
                                    ->leftJoin('model', 'airCraft.model', '=', 'model.id')
                                    ->leftJoin('unit', 'airCraft_data.unit', '=', 'unit.id')
                                    ->leftJoin('variant', 'airCraft.variant', '=', 'variant.variant_id')
                                    ->where('airCraft.ac_id', $id)->first();

        $getPerformanceFiles = DB::table('airCraft_performance_files')
                                                ->select('name','file_text')
                                                ->where('ac_id',$id)
                                                ->get();
        $response = array(
            'aircraft' => $airCraftData ? $airCraftData : '',
            'performanceFiles' => $getPerformanceFiles ? $getPerformanceFiles : ''
        );
  //  }else {
  //    $response['fail'] = "auth fail";
  //  }
        return json_encode($response,JSON_PRETTY_PRINT);
    }



    /**
   * @OA\Get( path="/api/aircraft/{id}",
   * summary = "to get response from database",
   *  tags={"unsecure Api"},
   *     @OA\Parameter(
   *        name="id", in="path",required=true, 
   *          @OA\Schema(type="integer",)
   *     ),
   
   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */
    public function getAircraft(Request $request,$id){
    
        $airCraftData = DB::table('airCraft')
                                    ->select(
                                        'aircraft_name AS aircraft_type ',
                                        'airCraft.ac_id',
                                        'manufacturer_name',
                                        'model_name',
                                        'variant_name',
                                        'remark',
                                        'airCraft_data.basic_empty_weight',
                                        'airCraft_data.mm_long',
                                        'airCraft_data.mm_lat',
                                        'airCraft_data.cg_envelope',
                                        'airCraft_data.fuel_interpolation',
                                        'airCraft_data.available_charts',
                                        'airCraft_data.interior_config',
                                        'unit_nm AS original_unit',
                                        'airCraft_data.version AS version',
                                        'airCraft_data.m_to_w AS MTOW',
                                        'airCraft_data.fuel AS fuel max',
                                        'airCraft_data.category AS category',
                                        'airCraft_data.thub_name AS thumbnail_name',
                                        'airCraft_data.topview_name AS topview_name',
                                        'airCraft_data.desc_1 AS description_1',
                                        'airCraft_data.desc_2 AS description_2',
                                        'airCraft_data.remarks AS remarks'
                                    )
                                    ->leftJoin('aircraft_type', 'airCraft.aircraft_type', '=', 'aircraft_type.aircraft_id')
                                    ->leftJoin('airCraft_data', 'airCraft.ac_id', '=', 'airCraft_data.ac_id')
                                    ->leftJoin('manufacturer', 'airCraft.manufacturer', '=', 'manufacturer.id')
                                    ->leftJoin('model', 'airCraft.model', '=', 'model.id')
                                    ->leftJoin('unit', 'airCraft_data.unit', '=', 'unit.id')
                                    ->leftJoin('variant', 'airCraft.variant', '=', 'variant.variant_id')
                                    ->where('airCraft.ac_id', $id)->first();

        $getPerformanceFiles = DB::table('airCraft_performance_files')
                                                ->select('name','file_text')
                                                ->where('ac_id',$id)
                                                ->get();
        $response = array(
            'aircraft' => $airCraftData ? $airCraftData : '',
            'performanceFiles' => $getPerformanceFiles ? $getPerformanceFiles : ''
        );

        return json_encode($response,JSON_PRETTY_PRINT);
    
    }

    public function addAircraft(Request $request){
        $input = $request->all();
        $data = AircraftFlightpadApi::create($input);

        return $data;

    }

    public function addAircraftnew(Request $request){
        $input = $request->all();
        $data = AircraftFlightpadApi::create($input);

        return $data;

    }
    public function aircraftview()
    {
        $airCraft = AircraftFlightpadApi::all()->sortByDesc("id");
        $concat_aircraft = [];
        foreach($airCraft as $airCraf)
        {
            
            $str_aircraft = "fleetACCategory: ".$airCraf['fleetACCategory'].", Manufacturer: ".$airCraf['Manufacturer'].", fleetAC_Type: ".$airCraf['fleetAC_Type'].", priceCategory: ".$airCraf['priceCategory'].", checkTrial: ".$airCraf['checkTrial']; 
            $airCraf['aircraft'] = $str_aircraft;
           // array_push($concat_aircraft,$str_aircraft);
        }
       
        return view('admin.aircraftapi.aircraft_list', compact('airCraft'));
    }
}
