<?php

namespace Tests;

use Illuminate\Contracts\Console\Kernel;
use Illuminate\Support\Facades\Artisan;

trait CreatesApplication
{
    /**
     * Creates the application.
     *
     * @return \Illuminate\Foundation\Application
     */
    public function createApplication()
    {
        $app = require __DIR__.'/../bootstrap/app.php';

        $app->make(Kernel::class)->bootstrap();
      
        $this->clearCache();
        Artisan::call('migrate:fresh');
        Artisan::call('db:seed');
        return $app;
        
    }
    private function clearCache(): void
    {
        Artisan::call('cache:clear');
    }
}
