<?php $__env->startSection('content'); ?>
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="#">CG Envelope</a></li>
           </ol>
       </nav>
   </div>
</div>
<div class="container-fluid">
  <div class="product-list--area bg-boxshadow">
      <div class="row">
          <div class="col-lg-12">
              <div class="ibox">
                  <div class="ibox-content">
                      <table id="cgEnvelopes" class="display table table-stripped toggle-arrow-tiny" data-page-size="15">
                          <thead>
                            <tr>
                                <th data-orderable="false"></th>
                                <th data-orderable="false"></th>
                                <th class="select-filter" data-orderable="false">Manufacturer</th>
                                <th class="select-filter" data-orderable="false">Model</th>
                                <th data-orderable="false"></th>
                                <th data-orderable="false"></th>
                            </tr>
                            <tr>
                                <th data-orderable="true">ID</th>
                                <th data-orderable="true">CG Envelope Name</th>
                                <th data-orderable="true">Manufacturer</th>
                                <th data-orderable="true">Model</th>
                                <th data-orderable="true">Remark</th>
                                <th class="text-right" data-orderable="false">Action</th>
                            </tr>
                          </thead>
                          <tbody>
                          <?php if(count($cgEnvelopes)): ?>
                            <?php $__currentLoopData = $cgEnvelopes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?=$b->envelope_id?></td>
                                    <td><?=$b->envelope_name?></td>
                                    <td><?=$b->manufacturer_name?></td>
                                    <td><?=$b->model_name?></td>
                                    <td><?=$b->remark?></td>
                                    <td class="text-right">
                                        <div class="btn-group">
                                            <div class="btn-group">
                                              <?php if(Auth::user()->role_id == 3): ?>
                                                <?php if($b->is_locked == 1): ?>
                                                  <a class="btn btn-locked btn-sm " data-id="<?php echo e($b->is_locked); ?>" style="background:#b1dd8c;color:#fff;width: 88px;" href="<?php echo e(route('cgEnvelope/lockUnlockState',['id'=>$b->envelope_id,'is_locked'=>$b->is_locked])); ?>">Unlocked</a>
                                                <?php else: ?>
                                                  <a class="btn btn-locked btn-sm " data-id="<?php echo e($b->is_locked); ?>" style="background:#d357fe;color:#fff;width: 88px;" href="<?php echo e(route('cgEnvelope/lockUnlockState',['id'=>$b->envelope_id,'is_locked'=>$b->is_locked])); ?>">Locked</a>
                                                <?php endif; ?> 
                                              <?php else: ?>
                                                <?php if($b->is_locked == 1): ?>
                                                  <a class="btn btn-locked btn-sm unlocked_row" data-id="<?php echo e($b->is_locked); ?>" style="background:#b1dd8c;color:#fff;width: 88px;" >Unlocked</a>
                                                <?php else: ?>
                                                  <a class="btn btn-locked btn-sm unlocked_row" data-id="<?php echo e($b->is_locked); ?>" style="background:#d357fe;color:#fff;width: 88px;" >Locked</a>
                                                <?php endif; ?> 
                                              <?php endif; ?> 
                                              <a class="btn btn-success btn-sm" href="<?php echo e(route('cgEnvelope/edit', $b->envelope_id)); ?>">Edit</a>
                                              <?php if(Auth::user()->role_id === 1 || Auth::user()->role_id === 3): ?>
                                                <a class="btn btn-warning btn-sm" href="<?php echo e(route('cgEnvelope/copy', $b->envelope_id)); ?>">Copy</a>
                                                <?php if($b->is_locked == 1): ?>
                                                  <a id="<?php echo e($b->envelope_id); ?>" class="btn btn-danger btn-sm delete_row">Delete</a>
                                                  <?php else: ?>
                                                  <a id="<?php echo e($b->envelope_id); ?>" class="btn btn-danger btn-sm delete">Delete</a>
                                                <?php endif; ?>
                                              <?php endif; ?>
                                          </div>
                                      </div>
                                    </td>
                                </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                  <tr><td>Don't have any records!</td></tr>
                            <?php endif; ?>
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script type="text/javascript">
$(document).ready(function() {
  $('#cgEnvelopes').DataTable({
    orderCellsTop: true,
    lengthMenu: [200, 10, 25, 50, 100, 300, 500, 900, 1200],
    initComplete: function () {
      this.api().columns('.select-filter').every(function () {
        var column = this;
        var select = $('<select class="select2"><option value="">Filter</option></select>')
          .appendTo($(column.header()).empty())
          .on('change', function () {
              var val = $.fn.dataTable.util.escapeRegex(
                  $(this).val()
              );
              column
                  .search(val ? '^'+val+'$' : '', true, false)
                  .draw();
        });
        column.data().unique().sort().each(function (d, j) {
          if(d !== '') {
            select.append('<option value="'+d+'">'+d+'</option>')
          }
        });
      });
    }
  });
  $('.select2').select2();



});
$('.table').on('click', '.delete_row', function() {
  if (confirm('Are you sure ?')) {
    var id = $(this).attr('id');
		$(this).closest('tr').remove();
		$.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: "cgEnvelope/delete/" + id,
      type: 'delete',
      dataType: "JSON",
      success: function () {},
      error: function() {}
   });
  }
});


$('.table').on('click', '.unlocked_row', function() {
var is_locked = $(this).text(); 
var lableText = (is_locked == "Locked") ? "Unlock" : "Lock"; 
toastr.warning("Only Master Admin Can " + lableText + " Item");
});

$('.table').on('click', '.delete', function() {
toastr.warning("Item Is Locked. Contact Master Admin To Unlock.");
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>