<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::group(['middleware' => ['flighpad_user_api']], function () {
Route::post('/getUserInformation','UsersController@getUserInfo');
Route::get('/flightpadaircraftlistnew','Admin\FlightpadaircraftController@getFlightPadAircraftsnew');
Route::get('/aircraftnew/{id}', 'Admin\AirCraftController@getAircraftnew')->name('aircraftnew');
Route::get('/cgEnvelopenew/{id}', 'Admin\CGEnvelopeController@getCgEnvelopesnew')->name('cgEnvelopenew');
Route::get('/configComponentnew/{id}', 'Admin\ConfigurationsController@getConfigurationnew')->name('configComponentnew');
Route::post('/addAircraftnew','Admin\AirCraftController@addAircraftnew');
Route::get('/flightpadusers2new','Admin\FlightpadusersController@getFlightPadUsers2new');

});

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
// Route::post('/getUserInformation','UsersController@getUserInfo')->name('getUserInformation');
// Route::post('/getUserInformationnew','UsersController@getUserInfonew')->name('getUserInformationnew');
Route::post('/getUserInformations','Admin\FlightpadusersController@getUserInfos');
Route::get('/configComponent/{id}', 'Admin\ConfigurationsController@getConfiguration')->name('configComponent');
Route::delete('/component/{id}', 'Admin\ConfigurationsController@itemDestroy')->name('component');
Route::get('/cgEnvelope/{id}', 'Admin\CGEnvelopeController@getCgEnvelopes')->name('cgEnvelope');

Route::get('/aircraft/{id}', 'Admin\AirCraftController@getAircraft')->name('aircraft');

Route::get('/flightpadusers','Admin\FlightpadusersController@getFlightPadUsers');
Route::get('/flightpadusers2','Admin\FlightpadusersController@getFlightPadUsers2');

Route::get('/flightpadaircraftlist','Admin\FlightpadaircraftController@getFlightPadAircrafts');


Route::post('/download_info','Admin\DownloadinfoController@downloadInfo')->name("down");


Route::post('/addAircraft','Admin\AirCraftController@addAircraft');


