@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="#">User List</a></li>
               </li>
           </ol>
       </nav>
   </div>
</div>
<div class="container-fluid">
	<div class="row">
        <div class="col-12">
            <div class="product-list--area bg-boxshadow">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th data-toggle="true">Id</th>
                                            <th data-toggle="true">Name</th>
                                            <th data-toggle="true">Email</th>
																						<th data-toggle="true">Type</th>
                                            <th class="text-right" data-sort-ignore="true">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    	@foreach($user as $b)
	                                        <tr>
                                                <td>{{$b->id}}</td>
                                                <td>{{$b->first_name .' '. $b->last_name }}</td>
                                                <td>{{$b->email}}</td>
                                                <td>{{$b->title}}</td>
                                            <td class="text-right">
                                                <div class="btn-group">
                                                    <div class="btn-group">
                                                      @if(Auth::user()->role_id === 1)
                                                        @if($b->title == 'admin')
                                                                <a class="btn btn-primary btn-sm" href="{{route('show', $b->id)}}">View</a>
                                                                <a class="btn btn-success btn-sm" href="{{route('edit', $b->id)}}">Edit</a>
                                                        @elseif($b->title == 'client')
                                                                <a class="btn btn-primary btn-sm" href="{{route('show', $b->id)}}">View</a>
                                                                <a class="btn btn-success btn-sm" href="{{route('edit', $b->id)}}">Edit</a>
                                                        @endif
                                                      @endif
                                                      @if(Auth::user()->role_id === 3)
                                                        <a class="btn btn-primary btn-sm" href="{{route('show', $b->id)}}">View</a>
                                                        <a class="btn btn-success btn-sm" href="{{route('edit', $b->id)}}">Edit</a>
                                                        <a class="btn btn-danger btn-sm delete_row" href="{{route('delete', $b->id)}}">Delete</a>
                                                      @endif
                                              	    </div>
                                          	    </div>
                                            </td>
                                          </tr>
                                          @if ($b->granted)
                                            <tr class="granted">
                                              <td colspan="5">
                                                <div style="margin: 0">{!! $b->granted !!}</div>
                                              </td>
                                            </tr>
                                          @endif
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="7">
                                                <ul class="pagination float-right mt-30"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
$(document).ready(function(){
	$('.table').on('click','.delete_row', function(){
        if (confirm('Are you sure ?')) {
            var id = $(this).attr('id');
            $(this).closest('tr').remove();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "delete/"+id,
                type: 'delete', // replaced from put
                dataType: "JSON",
                data:{"id":id},
                statusCode: {
                    419: function() {
                        window.location.href = "{{route('login')}}";
                    },
                },
                success: function (response){
                    console.log(response); // see the reponse sent
                },
                error: function(xhr) {
                console.log(xhr.responseText); // this line will save you tons of hours while debugging
                // do something here because of error
            }
        });
    }else{
       return false;
    }
});

});

$('.table').on('click', '.delete', function() {
  toastr.warning("Only Master Admin Can delete this user.");
});

</script>
@endsection
