<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightPadAircraftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flight_pad_aircrafts', function (Blueprint $table) {
            $table->increments('id');
            $table->string('image_name');
            $table->integer('category');
            $table->integer('id_backend');
            $table->string('type');
            $table->string('manufacturer');
            $table->string('model');
            $table->string('display_manufacturer');
            $table->string('display_name');
            $table->string('variant');
            $table->string('callsign');
            $table->string('unit');
            $table->integer('BEW');
            $table->string('moment_long');
            $table->string('moment_lat');
            $table->integer('MTOW');
            $table->integer('max_fuel');
            $table->text('description_line1');
            $table->text('description_line2');
            $table->string('version');
            $table->string('internal_remarks');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flight_pad_aircrafts');
    }
}
