<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Laraveldaily\Quickadmin\Observers\UserActionsObserver;


use Illuminate\Database\Eloquent\SoftDeletes;

class Listing extends Model {

    use SoftDeletes;

    /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
    protected $dates = ['deleted_at'];

    protected $table    = 'listing';
    
    protected $fillable = [
          'f_name',
          'l_name',
          'user_name',
          'address',
          'phone',
          'email',
          'languages',
          'sdfdsfds'
    ];
    

    public static function boot()
    {
        parent::boot();

        Listing::observe(new UserActionsObserver);
    }
    
    
    
    
}