<?php

namespace App\Http\Controllers;

use App\Role;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use DB;
use Auth;

class UsersController extends Controller
{
    /**
     * Show a list of users
     * @return \Illuminate\View\View
     */
    public function index()
    {

        $users = User::all();

        return view('admin.users.index', compact('users'));
    }

    /**
     * Show a page of user creation
     * @return \Illuminate\View\View
     */
    public function create()
    {
        $roles = Role::pluck('title', 'id');

        return view('admin.users.create', compact('roles'));
    }

    /**
     * Insert new user into the system
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $input['password'] = Hash::make($input['password']);
        $user = User::create($input);

        return redirect()->route('users.index')->withMessage(trans('quickadmin::admin.users-controller-successfully_created'));
    }

    /**
     * Show a user edit page
     *
     * @param $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $user  = User::findOrFail($id);
        $roles = Role::pluck('title', 'id');

        return view('admin.users.edit', compact('user', 'roles'));
    }

    /**
     * Update our user information
     *
     * @param Request $request
     * @param         $id
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);
        $input = $request->all();
        $input['password'] = Hash::make($input['password']);
        $user->update($input);

        return redirect()->route('users.index')->withMessage(trans('quickadmin::admin.users-controller-successfully_updated'));
    }

    /**
     * Destroy specific user
     *
     * @param $id
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $user = User::findOrFail($id);
        User::destroy($id);

        return redirect()->route('users.index')->withMessage(trans('quickadmin::admin.users-controller-successfully_deleted'));
    }


 
    public function getUserInfo(Request $request){
        $token = bin2hex(openssl_random_pseudo_bytes(64));
        $username = $request->username;
        $password = $request->password;
        $userInfo = DB::table('flight_pad_users')
            ->where('username',$username)
            ->where('password',$password)->get();
           
        $data = array();
        if(sizeof($userInfo) === 0){
            $data['success'] = 0;
            $data['message'] = 'Username not found';
        } else {
        $updateAuthToken = DB::update('UPDATE flight_pad_users SET auth_token = ? WHERE username = ? and password = ?', [$token, $username, $password]);
            
            foreach($userInfo as $key=>$value){
                $data1['id'] = $value->id;
                $data1['customer_name'] = $value->customer_name;
                $data1['username'] = $value->username;
                $data1['password'] = $value->password;
                $data1['fc_com_key'] = $value->fc_com_key;
                $data1['attributes'] = $value->attributes;
                $data1['position'] = $value->position;
                $data1['features'] = $value->features;
                $data1['auth_token'] = $token;
                $data1['aircraft_type'] = $value->aircraft_type;
                $data1['created_at'] = $value->created_at;
                $data1['updated_at'] = $value->updated_at;
             
            }
            $users = DB::table('flight_pad_users')
            ->where('customer_name',$userInfo[0]->customer_name)
            ->where('fc_com_key',$userInfo[0]->fc_com_key)->get();
            $data1['users'] = array();
            $data1['CustomerAircraft'] = array();
            foreach($users as $k => $v){
                $data3['id'] = $v->id;
                $data3['username'] = $v->username;
                $data3['password'] = $v->password;
                $data3['attributes'] = $v->attributes;
                $data3['aircraft_type'] = $v->aircraft_type;
                array_push($data1['users'], $data3);
            }

            $customer_flightpad1 = DB::table('fp_customer')
                ->where('customer_name', $userInfo[0]->customer_name)
                ->where('fc_com_key', $userInfo[0]->fc_com_key)->first();
               

            if ($customer_flightpad1) {

                $customer_aircraft_data = DB::table('customer_aircraft')
                    ->where('customer_id', $customer_flightpad1->id)->get();

                
                foreach ($customer_aircraft_data as $key => $val) {

                    $customer_aircraft_config_info = DB::table('ac_config_list')->select(['id', 'config_id', 'config_data'])
                        ->where('aircraft_id', $val->id)
                        ->get();
                    $customer_aircraft_config_info1 = DB::table('ac_config_list')->select('aircraft_id')
                        ->where('aircraft_id', $val->id)
                        ->get();

                    $customer_aircraft_cgenvelope_info = DB::table('ac_cg_envelope_list')->select(['id', 'cg_id', 'cg_data'])
                        ->where('aircraft_id', $val->id)
                        ->get();

                    $aircraft_data =  DB::table('ac_allavailableacdatabase')->select('display_name')->where('id', $val->available_aircraft)
                        ->get();

                    foreach ($customer_aircraft_config_info1 as $k => $v) {

                        $data5['CustomerAircraftId']  = $v->aircraft_id;
                    }

                    foreach ($aircraft_data as $kd => $vr) {

                        $data5['AircraftName']  = $vr->display_name;
                    }
                    $data5['AcText'] = $val->ac_text;
                    $data5['Configurations'] = $customer_aircraft_config_info;
                    $data5['CGenvelope'] = $customer_aircraft_cgenvelope_info;
                    $data5['FuelInterpolation'] = $val->ac_fuelinterpolation;
                    $data5['CGmultiple'] = $val->ac_cgmultiple;
                    $data1['CustomerAircraft']= $data5;
                }
            }
            $data['success'] = 1;
            $data['UserInfo'] = $data1;
            
        }
        return json_encode($data);
    }

}
