<?php

namespace App\Http\Controllers\Admin;

use App\Cg_envelope_data;
use App\Customer_aircraft;
use App\ConfigListData;
use App\CgEnvelopeAcList;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\FlightPadUser;
use App\Fpcustomers;
use DB;
use Log;
use Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Validator;
use Intervention\Image\ImageManagerStatic as Image;
use OpenApi\Annotations as OA;

use Illuminate\Support\Facades\Config;

/**
 * @OA\Info(title="Flightpad API", version="1.0")
 */


class FlightpadusersController extends Controller
{
    public function flightpadusers()
    {
        $list_data = array();
        $data =  DB::select("SELECT 
        DISTINCT customer_name,fc_com_key, GROUP_CONCAT(id SEPARATOR ', ') as id,  
        GROUP_CONCAT(password SEPARATOR ', ') as password,
        GROUP_CONCAT(attributes SEPARATOR ', ') as attributes,
        GROUP_CONCAT(username SEPARATOR ', ')  as username,
        GROUP_CONCAT(position SEPARATOR ', ')  as position,
        GROUP_CONCAT(aircraft_type SEPARATOR ', ')  as aircraft_type,
        GROUP_CONCAT(created_at SEPARATOR ', ')  as created_at,
        GROUP_CONCAT(updated_at SEPARATOR ', ')  as updated_at
                FROM 
                flight_pad_users
                GROUP BY
                flight_pad_users.customer_name, flight_pad_users.fc_com_key ORDER BY position asc");

        foreach ($data as $dat_Exp) {

            $data1['customer_name'] =  $dat_Exp->customer_name;
            $data1['fc_com_key'] =   $dat_Exp->fc_com_key;
            $data2['id'] = explode(",", $dat_Exp->id)[0];
            $data2['username'] = explode(",", $dat_Exp->username)[0];
            $data2['password'] = explode(",", $dat_Exp->password)[0];
            $data2['attributes'] = explode(",", $dat_Exp->attributes)[0];
            $data1['users'] = array();
            foreach (explode(",", $dat_Exp->id) as $k => $v) {
                $data2['customer_name'] =  $dat_Exp->customer_name;
                $data2['id'] = $v;
                $data2['username'] = explode(",", $dat_Exp->username)[$k];
                $data2['password'] = explode(",", $dat_Exp->password)[$k];
                if (!empty($data2['attributes'])) {
                    $data2['attributes'] = explode(",", $dat_Exp->attributes)[$k];
                }

                array_push($data1['users'], $data2);
            }

            array_push($list_data, $data1);
        }
        return view('admin.flightpadusers.flightpadusers_list', compact('list_data'));
    }

    public function addFlightpaduser()
    {
        $roles = DB::table('roles')->get();
        $feature_data =  DB::table('features')->get();
        $attribute_data =  DB::table('flightpad_attributes')->get();
        $aircraft_data =  DB::table('ac_allavailableacdatabase')->orderBy('display_name', 'asc')->get();
        $aircraft_text_data =  DB::table('ac_text')->get();
        // $config_data = DB::table('configurations')->get();
        $config_data = DB::table('configurations')
            ->select('configurations_id', 'is_locked', 'config_name', 'variant.variant_name', 'remark', 'callsign', 'manufacturer_name', 'model_name', 'copy_from_id', 'client_email')
            ->leftJoin('variant', 'configurations.variant', '=', 'variant.variant_id')
            ->leftJoin('manufacturer', 'manufacturer.id', '=', 'configurations.manufacturer')
            ->leftJoin('model', 'model.id', '=', 'configurations.model')->get();

        $cgEnvelopes = DB::table('cg_envelopes')
            ->select('envelope_id', 'is_locked', 'envelope_name', 'variant.variant_name', 'remark', 'manufacturer_name', 'model_name')
            ->leftJoin('variant', 'cg_envelopes.variant', '=', 'variant.variant_id')
            ->leftJoin('manufacturer', 'manufacturer.id', '=', 'cg_envelopes.manufacturer')
            ->leftJoin('model', 'model.id', '=', 'cg_envelopes.model')
            ->get();
        if (Auth::user()->role_id == 1) {
            $roles = array_except($roles, [2]);
        }
        return view('admin.flightpadusers.create_flightpaduser')
            ->with(compact('roles', 'feature_data', 'attribute_data', 'aircraft_data', 'aircraft_text_data', 'config_data', 'cgEnvelopes'));
    }

    public function editFlightpaduser($id)
    {
        $customer_info = DB::table('flight_pad_users')
            ->where('flight_pad_users.id', $id)
            ->first();
        // dd($customer_info->fc_com_key);

        $user_feature_info = DB::table('fp_customer')
            ->where('fp_customer.fc_com_key', $customer_info->fc_com_key)
            ->first();

        $flightpadAttributes = DB::table('flightpad_attributes')->get();
        $aircraft_data =  DB::table('ac_allavailableacdatabase')->orderBy('display_name', 'asc')->get();
        $aircraft_customer = DB::table('ac_text')->get();
        $feature_data =  DB::table('features')->get();
        // $config_data = DB::table('configurations')->get();
        $config_data = DB::table('configurations')
            ->select('configurations_id', 'is_locked', 'config_name', 'variant.variant_name', 'remark', 'callsign', 'manufacturer_name', 'model_name', 'copy_from_id', 'client_email')
            ->leftJoin('variant', 'configurations.variant', '=', 'variant.variant_id')
            ->leftJoin('manufacturer', 'manufacturer.id', '=', 'configurations.manufacturer')
            ->leftJoin('model', 'model.id', '=', 'configurations.model')->get();
        $cgEnvelopes = DB::table('cg_envelopes')
            ->select('envelope_id', 'is_locked', 'envelope_name', 'variant.variant_name', 'remark', 'manufacturer_name', 'model_name')
            ->leftJoin('variant', 'cg_envelopes.variant', '=', 'variant.variant_id')
            ->leftJoin('manufacturer', 'manufacturer.id', '=', 'cg_envelopes.manufacturer')
            ->leftJoin('model', 'model.id', '=', 'cg_envelopes.model')
            ->get();
        if (!$customer_info) {
            abort(404);
        } else {
            $user_info = DB::table('flight_pad_users')
                ->where('flight_pad_users.customer_name', $customer_info->customer_name)
                ->where('flight_pad_users.fc_com_key', $customer_info->fc_com_key)
                ->get();

            // $aircraft_customer_info = DB::table('customer_aircraft')
            //     ->where('customer_aircraft.ac_customer_name', $customer_info->customer_name)
            //     ->where('customer_aircraft.ac_fc_com_key', $customer_info->fc_com_key)
            //     ->get();
            if (!empty($user_feature_info)) {

                $aircraft_customer_data_info = DB::table('customer_aircraft')
                    ->where('customer_aircraft.customer_id', $user_feature_info->id)
                    ->get();
                $list_data_info = array();
                foreach ($aircraft_customer_data_info as $k => $v) {
                    $customer_aircraft_config_info = DB::table('ac_config_list')
                        ->where('ac_config_list.aircraft_id', $v->id)
                        ->get();
                    array_push($list_data_info, $customer_aircraft_config_info);
                }
                
                $aircraft_customer_info = DB::table('customer_aircraft')
                    ->where('customer_aircraft.customer_id', $user_feature_info->id)
                    ->get();
                $cg_data_info = array();
                foreach ($aircraft_customer_data_info as $cgk => $cgv) {
                    $customer_aircraft_cgenvelope_info = DB::table('ac_cg_envelope_list')
                        ->where('ac_cg_envelope_list.aircraft_id', $cgv->id)
                        ->get();
                    array_push($cg_data_info, $customer_aircraft_cgenvelope_info);
                }
                // dd($cg_data_info);
                return view('admin.flightpadusers.edit_flightpaduser', compact('customer_info', 'user_info', 'flightpadAttributes', 'feature_data', 'user_feature_info', 'aircraft_data', 'aircraft_customer_info', 'aircraft_customer', 'list_data_info', 'config_data', 'cg_data_info', 'cgEnvelopes'));
            } else {
                return view('admin.flightpadusers.edit_flightpaduser', compact('customer_info', 'user_info', 'flightpadAttributes', 'feature_data', 'user_feature_info', 'aircraft_data', 'aircraft_customer',  'config_data', 'cgEnvelopes'));
            }
        }
    }

    public function storeFlightpaduser(Request $request)
    {
        $rules = [
            'customer_name' => 'required',
            'username' => 'required',
            'password' => 'required',
            // 'password_confirmation' => 'required',
            'fc_com_key' => 'required',

        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->validate($request, $rules);
        }
        $users = Fpcustomers::where('fc_com_key', '=', $request->get('fc_com_key'))->first();
        if ($users) {
            $id = $users->id;
            $fp_customer = Fpcustomers::find($id);
            $fp_customer->customer_name = $request->customer_name;
            $fp_customer->fc_com_key = $request->fc_com_key;
            $fp_customer->features =  $request->features;
            $data = Fpcustomers::orderBy('position', 'DESC')->first();
            if ($data) {
                $fp_customer->position = $data->position + 1;
            } else {
                $fp_customer->position = 1;
            }
            $fp_customer->save();
        } else {
            $fp_customer = new Fpcustomers();
            $fp_customer->customer_name = $request->get('customer_name');
            $fp_customer->features = $request->get('features');
            $fp_customer->fc_com_key = $request->get('fc_com_key');
            $data = Fpcustomers::orderBy('position', 'DESC')->first();
            if ($data) {
                $fp_customer->position = $data->position + 1;
            } else {
                $fp_customer->position = 1;
            }
            $fp_customer->save();
        }

        $i = 0;
        $j = 0;



        foreach ($request->get('aircraft_name') as $key2 => $val2) {

            $customer_aircraft = new Customer_aircraft;
            $customer_aircraft->customer_id = $fp_customer->id;
            $customer_aircraft->available_aircraft = $request->get('aircraft_name')[$key2];
            $customer_aircraft->ac_text = $request->get('ac_text')[$key2];
            $customer_aircraft->ac_fuelinterpolation = $request->get('ac_fuelinterpolation')[$key2];
            $customer_aircraft->ac_cgmultiple = $request->get('ac_cgmultiple')[$key2];
            $customer_aircraft->save();
            if ($request->hasfile('ac_image')) {
                $file = $request->file('ac_image')[$key2];
                $name = $file->getClientOriginalName();
                $st_name = time() . '_' . $name;
                $customer_aircraft->ac_image = $st_name;
                $customer_aircraft->ac_image_name = $st_name;

                $customer_aircraft->update([
                    'ac_image' => '/LOGO_Manifest/' . $name,
                    'ac_image_name' => '/LOGO_Manifest/' . $st_name
                ]);
                Storage::disk('public')->put($st_name, File::get($file));
            }
            $configKId = 'config_id_' . $i;
            $configName = 'config_data_' . $i;
            $cgId = 'cg_id_' . $j;
            $cgName = 'cg_data_' . $j;
            if ($request->has('config_id_' . $i)) {
                foreach ($request->get($configKId) as $configkey2 => $configval2) {
                    $config_aircraft = new ConfigListData;
                    $config_aircraft->aircraft_id = $customer_aircraft->id;
                    $config_aircraft->config_id = $request->get($configKId)[$configkey2];
                    $config_aircraft->config_data = $request->get($configName)[$configkey2];
                    $config_aircraft->save();
                }
            }
            $i++;
            if ($request->has('cg_id_' . $j)) {
                foreach ($request->get($cgId) as $cgkey2 => $cgval2) {
                    $cg_aircraft = new CgEnvelopeAcList;
                    $cg_aircraft->aircraft_id = $customer_aircraft->id;
                    $cg_aircraft->cg_id = $request->get($cgId)[$cgkey2];
                    $cg_aircraft->cg_data = $request->get($cgName)[$cgkey2];
                    $cg_aircraft->save();
                }
            }
            $j++;
        }

        foreach ($request->get('username') as $key => $value) {
            $flightpaduser = new FlightPadUser;
            $flightpaduser->customer_name = $request->get('customer_name');
            $flightpaduser->username = $request->get('username')[$key];
            $flightpaduser->password = $request->get('password')[$key];
            $flightpaduser->features =  $request->get('features');
            $flightpaduser->fc_com_key = $request->get('fc_com_key');
            $flightpaduser->aircraft_type = $request->get('aircraft_type')[$key];
            if ($request->get('fattributes')[$key] != null || $request->get('fattributes')[$key] != '') {
                $flightpaduser->attributes =  str_replace(',', ' ', $request->get('fattributes')[$key]);
            } else {
                $flightpaduser->attributes = ' ';
            }

            $data = FlightPadUser::orderBy('position', 'DESC')->first();
            if ($data) {
                $flightpaduser->position = $data->position + 1;
            } else {
                $flightpaduser->position = 1;
            }

            $flightpaduser->save();
        }
        $id = $flightpaduser['id'];
        $path = "/edit_flightpaduser"."/".$id;
        return redirect($path);
    }

    public function deleteFlightpaduser(Request $request)
    {
        $id = $request->id;
        $flighpaduser = FlightPadUser::find($id);
        $flighpaduser->delete();
        $res['success'] = 1;
        return json_encode($res);
    }

    public function updateFlightPadUser(Request $request)
    {
        try {
            $rules = [
                'customer_name' => 'required',
                "username"    => "required|array|min:1",
                'password' => 'required',
                'fc_com_key' => 'required',

            ];
            $id = $request->id;
            $flightpadcustomerInfo = FlightPadUser::find($id);
            $flightpaduser = DB::table('flight_pad_users')
                ->where('customer_name', $flightpadcustomerInfo->customer_name)
                ->where('fc_com_key', $flightpadcustomerInfo->fc_com_key)->get();

            foreach ($flightpaduser as $key => $value) {

                if (in_array($value->id, $request->user_id) === false) {

                    DB::table('flight_pad_users')->where('id', $value->id)->delete();
                }
            };
            $customer_flightpad = DB::table('fp_customer')
                ->where('customer_name', $flightpadcustomerInfo->customer_name)
                ->where('fc_com_key', $flightpadcustomerInfo->fc_com_key)->get();

            if (sizeof($customer_flightpad) == 0) {

                $fp_customer = new Fpcustomers;
                $fp_customer->customer_name = $request->customer_name;
                $fp_customer->fc_com_key = $request->fc_com_key;
                $fp_customer->features =  $request->features;
                
                $data = Fpcustomers::orderBy('position', 'DESC')->first();
                if ($data) {
                    $fp_customer->position = $data->position + 1;
                } else {
                    $fp_customer->position = 1;
                }

                $fp_customer->save();
            } else {
                foreach ($customer_flightpad as $ke => $valu) {

                    $id = $valu->id;
                    $fp_customer = Fpcustomers::find($id);
                    $fp_customer->customer_name = $request->customer_name;
                    $fp_customer->fc_com_key = $request->fc_com_key;
                    $fp_customer->features =  $request->features;
                    
                    $data = Fpcustomers::orderBy('position', 'DESC')->first();
                    if ($data) {
                        $fp_customer->position = $data->position + 1;
                    } else {
                        $fp_customer->position = 1;
                    }

                    $fp_customer->save();
                }
            }
            $customer_flightpad1 = DB::table('fp_customer')
                ->where('customer_name', $flightpadcustomerInfo->customer_name)
                ->where('fc_com_key', $flightpadcustomerInfo->fc_com_key)->first();
            if (!empty($customer_flightpad1)) {


                $customer_aircraft_data = DB::table('customer_aircraft')->select('id')
                    ->where('customer_id', $customer_flightpad1->id)->get();

                $customer_aircraft_array = array();
                if ($request->customeraircraft) {

                    foreach ($request->customeraircraft as $ckey => $cvalue) {
                        array_push($customer_aircraft_array, $cvalue['customer_aircraft_id']);
                    }
                    foreach ($customer_aircraft_data as $cus_key => $cus_value) {
                        if (in_array($cus_value->id, $customer_aircraft_array) == false) {
                            DB::table('customer_aircraft')->where('id', $cus_value->id)->delete();
                            break;
                        }
                    }
                    foreach ($request->customeraircraft as $ckey => $cvalue) {
                        
                        if (!empty($cvalue['customer_aircraft_id'])) {
                            $id = $cvalue['customer_aircraft_id'];
                            $customer_aircraft = Customer_aircraft::find($id);
                            $customer_aircraft->customer_id = $fp_customer->id;
                            $customer_aircraft->available_aircraft = $cvalue['aircraft_name'];
                            $customer_aircraft->ac_text =  $cvalue['ac_text'];
                            $customer_aircraft->ac_fuelinterpolation = $cvalue['ac_fuelinterpolation'];
                            $customer_aircraft->ac_performance = $cvalue['ac_performance'];
                            $customer_aircraft->ac_cgmultiple = $cvalue['ac_cgmultiple'];
                            // if (isset($cvalue['ac_image'])) {
                            //     $file = $cvalue['ac_image'];
                            //     $name = $file->getClientOriginalName();
                            //     $st_name = time() . '_' . $name;
                            //     $customer_aircraft->ac_image = $st_name;
                            //     $customer_aircraft->ac_image_name = $st_name;
                            //     $customer_aircraft->update([
                            //         'ac_image' => '/LOGO_Manifest/' . $name,
                            //         'ac_image_name' => '/LOGO_Manifest/' . $st_name
                            //     ]);
                            //     Storage::disk('public')->put($st_name, File::get($file));
                            // }
                            $customer_aircraft->save();
                        } else {
                            $customer_aircraft = new Customer_aircraft;
                            $customer_aircraft->customer_id = $fp_customer->id;
                            $customer_aircraft->available_aircraft = $cvalue['aircraft_name'];
                            $customer_aircraft->ac_text =  $cvalue['ac_text'];
                            $customer_aircraft->ac_fuelinterpolation = $cvalue['ac_fuelinterpolation'];
                            $customer_aircraft->ac_performance = $cvalue['ac_performance'];
                            $customer_aircraft->ac_cgmultiple = $cvalue['ac_cgmultiple'];
                            $customer_aircraft->save();
                            
                            // if (isset($cvalue['ac_image'])) {
                            //     $file = $cvalue['ac_image'];
                            //     $name = $file->getClientOriginalName();
                            //     $st_name = time() . '_' . $name;
                            //     $customer_aircraft->ac_image = $name;
                            //     $customer_aircraft->ac_image_name = $st_name;
                            //     Storage::disk('public')->put($st_name, File::get($file));
                            //     $customer_aircraft->update([
                            //         'ac_image' => '/LOGO_Manifest/' . $name,
                            //         'ac_image_name' => '/LOGO_Manifest/' . $st_name
                            //     ]);
                            // }
                        }

                        $config_list_data = DB::table('ac_config_list')->select('id')
                            ->where('aircraft_id', $cvalue['customer_aircraft_id'])->get();

                        if (isset($cvalue['config'])) {
                            foreach ($config_list_data as $config_key => $config_val) {
                                if (in_array($config_val->id, $cvalue['config']['aircraft_config_id']) == false) {
                                    DB::table('ac_config_list')->where('id', $config_val->id)->delete();
                                }
                            }
                            
                            

                            foreach ($cvalue['config']['aircraft_config_id'] as $k => $v) {

                                if (empty($v)) {
                                    $config_aircraft = new ConfigListData;
                                    $config_aircraft->aircraft_id = $customer_aircraft->id;
                                    $config_aircraft->config_id = $cvalue['config']['config_id'][$k];
                                    $config_aircraft->config_data = $cvalue['config']['config_data'][$k];
                                    $config_aircraft->save();
                                }
                            }
                        } else {
                            foreach ($config_list_data as $config_key => $config_val) {

                                DB::table('ac_config_list')->where('id', $config_val->id)->delete();
                            }
                        }

                        $cg_list_data = DB::table('ac_cg_envelope_list')->select('id')
                            ->where('aircraft_id', $cvalue['customer_aircraft_id'])->get();

                        if (isset($cvalue['cgenvelop'])) {


                            foreach ($cg_list_data as $cg_key => $cg_val) {
                                if (in_array($cg_val->id, $cvalue['cgenvelop']['aircraft_envelope_id']) == false) {
                                    DB::table('ac_cg_envelope_list')->where('id', $cg_val->id)->delete();
                                }
                            }
                            foreach ($cvalue['cgenvelop']['aircraft_envelope_id'] as $ck => $cv) {

                                if (empty($cv)) {

                                    $cg_aircraft = new CgEnvelopeAcList();
                                    $cg_aircraft->aircraft_id = $customer_aircraft->id;
                                    $cg_aircraft->cg_id = $cvalue['cgenvelop']['cg_id'][$ck];
                                    $cg_aircraft->cg_data = $cvalue['cgenvelop']['cg_data'][$ck];
                                    $cg_aircraft->save();
                                }
                            }
                        } else {
                            foreach ($cg_list_data as $cg_key => $cg_val) {
                                DB::table('ac_cg_envelope_list')->where('id', $cg_val->id)->delete();
                            }
                        }
                    }
                } else {
                    foreach ($customer_aircraft_data as $cus_key => $cus_value) {
                        DB::table('customer_aircraft')->where('id', $cus_value->id)->delete();
                    };
                }
            }
            $image_delete =0;
            foreach ($request->user_id as $key1 => $val) {
                if ($val !== null) {
                    $fudata = FlightPadUser::find($val);
                    $fudata->customer_name = $request->customer_name;
                    $fudata->fc_com_key = $request->fc_com_key;
                    $fudata->features =  $request->features;
                    $fudata->username = $request->username[$key1];
                    $fudata->password = $request->password[$key1];
                    $fudata->aircraft_type = $request->aircraft_types[$key1];
                    
                    if($request['deletetrigger'] == "false")
                    {
                        if (isset($request['ac_image'])) {
                            if($fudata['ac_image'] != ""){
                                if($image_delete == 0){
                                $image_path = public_path().'/uploads'.'/'.$fudata['ac_image'];
                                unlink($image_path);
                                $image_delete++;
                            }
                            }
                            $file = $request['ac_image'];
                            $name = $file->getClientOriginalName();
                            $st_name = time() . '_' . $name;
                            $fudata->ac_image = $st_name;
                            $fudata->ac_image_name = $st_name;
                            // $fp_customer->update([
                            //     'ac_image' => '/LOGO_Manifest/' . $name,
                            //     'ac_image_name' => '/LOGO_Manifest/' . $st_name
                            // ]);
                            Storage::disk('public')->put($st_name, File::get($file));
                            
                        }
                        
                    }
                    else{
                        if($fudata['ac_image'] != ""){
                            if($image_delete == 0){
                            $image_path = public_path().'/uploads'.'/'.$fudata['ac_image'];
                            unlink($image_path);
                            $image_delete++;
                        }
                        }
                        $fudata->ac_image = "";
                        $fudata->ac_image_name = "";
                    }
                    $data = FlightPadUser::orderBy('position', 'DESC')->first();

                    if ($data) {
                        $fudata->position = $data->position + 1;
                    } else {
                        $fudata->position = 1;
                    }
                    if ($request->fattributes[$key1] != null || $request->fattributes[$key1] != '') {
                        $fudata->attributes =  str_replace(',', ' ', $request->fattributes[$key1]);
                    } else {
                        $fudata->attributes = ' ';
                    }

                    $fudata->save();
                } else {
                    $fudata = new FlightPadUser();
                    $fudata->customer_name = $request->customer_name;
                    $fudata->fc_com_key = $request->fc_com_key;
                    $fudata->features =  $request->features;
                    $fudata->username = $request->username[$key1];
                    $fudata->password = $request->password[$key1];
                    $fudata->aircraft_type = $request->aircraft_types[$key1];
                    if (isset($request['ac_image'])) {
                        $file = $request['ac_image'];
                        $name = $file->getClientOriginalName();
                        $st_name = time() . '_' . $name;
                        $fudata->ac_image = $st_name;
                        $fudata->ac_image_name = $st_name;
                        // $fp_customer->update([
                        //     'ac_image' => '/LOGO_Manifest/' . $name,
                        //     'ac_image_name' => '/LOGO_Manifest/' . $st_name
                        // ]);
                        Storage::disk('public')->put($st_name, File::get($file));
                    }
                    $data = FlightPadUser::orderBy('position', 'DESC')->first();

                    if ($data) {
                        $fudata->position = $data->position + 1;
                    } else {
                        $fudata->position = 1;
                    }
                    if ($request->fattributes[$key1] != null || $request->fattributes[$key1] != '') {
                        $fudata->attributes =  str_replace(',', ' ', $request->fattributes[$key1]);
                    } else {
                        $fudata->attributes = ' ';
                    }


                    $fudata->save();
                }
            }

            return redirect()->back()->with('message', 'Successfully saved');
        } catch (Exception $e) {
            $result = [
                'error' => $e->getMessage() . ' in line no ' . $e->getLine() . ' in file ' . $e->getFile()
            ];
            Log::error($e->getTraceAsString());
            $result['success'] = 0;
        }
        return json_encode($result);
    }
    public function update(Request $request)
    {
        $rules = [
            'customer_name' => 'required',
            "username"    => "required|array|min:1",
            'password' => 'required',
            'fc_com_key' => 'required',

        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->validate($request, $rules);
        }
        $id = $request->id;
        $flightpadCustomer = Customer::find($id);

        $flightpaduser = DB::table('flight_pad_users')
            ->where('customer_name', $flightpadCustomer->customer_name)
            ->where('fc_com_key', $flightpadCustomer->fc_com_key)->get();

        foreach ($flightpaduser as $key => $value) {
            if (in_array($value->id, $request->user_id) === false) {
                DB::table('flight_pad_users')->where('id', $value->id)->delete();
            }
        }
        foreach ($request->user_id as $key1 => $val) {
            if ($val !== null) {
                $fudata = FlightPadUser::find($val);
                $fudata->customer_name = $request->customer_name;
                $fudata->fc_com_key = $request->fc_com_key;
                $fudata->features =  $request->features;
                $fudata->username = $request->username[$key1];
                $fudata->password = $request->password[$key1];
                $fudata->aircraft_type = $request->aircraft_types[$key1];
                $data = FlightPadUser::orderBy('position', 'DESC')->first();

                if ($data) {
                    $fudata->position = $data->position + 1;
                } else {
                    $fudata->position = 1;
                }
                $fudata->attributes = $request->fattributes[$key1];

                $fudata->save();
            } else {
                $fudata = new FlightPadUser();
                $fudata->customer_name = $request->customer_name;
                $fudata->fc_com_key = $request->fc_com_key;
                $fudata->features =  $request->features;
                $fudata->username = $request->username[$key1];
                $fudata->password = $request->password[$key1];
                $fudata->aircraft_type = $request->aircraft_types[$key1];
                $data = FlightPadUser::orderBy('position', 'DESC')->first();

                if ($data) {
                    $fudata->position = $data->position + 1;
                } else {
                    $fudata->position = 1;
                }
                $fudata->attributes = $request->fattributes[$key1];

                $fudata->save();
            }
        }

        $flightpadCustomer->customer_name = $request->get('customer_name');
        $flightpadCustomer->fc_com_key = $request->get('fc_com_key');
        $flightpadCustomer->features =  $request->get('features');
        $flightpadCustomer->save();
        return back();
    }

    public function changeRowOrder(Request $request)
    {
        $position = $request->position;
        $i = 1;
        foreach ($position as $id) {
            $flightpaduser = FlightPadUser::find($id);
            $flightpaduser->position = $i;
            $flightpaduser->save();
            // $sql = "Update sorting_items SET position_order=".$i." WHERE id=".$v;
            // $mysqli->query($sql);
            $i++;
        }
    }


    // api

    /**
     * @OA\Get( path="/api/flightpadusers2new",
     * summary = "to get response from database", 
     * tags={"Flightpad"},
     *       @OA\Parameter(
     *        name="Appkey", in="header",required=true,description= "pass appKey for authentication",
     *          @OA\Schema(type="string",)
     *     ),
     * @OA\Response(response="200", description="An example resource"),
     * @OA\Response(response="404", description="Not found")
     * 
     * )
     */
    public function getFlightPadUsers2(Request $request)
    {

        $data =  DB::select("SELECT 
            DISTINCT id,customer_name,fc_com_key,features,username,password,attributes,position,aircraft_type,created_at,updated_at
                    FROM 
                    flight_pad_users ORDER BY position asc");
        $list_data = array();
        foreach ($data as $dat_Exp) {
            $data1['customer_name'] =  $dat_Exp->customer_name;
            $data1['fc_com_key'] =   $dat_Exp->fc_com_key;
            $data1['features'] =   $dat_Exp->features;
            $data1['id'] = $dat_Exp->id;
            $data1['username'] = $dat_Exp->username;
            $data1['password'] = $dat_Exp->password;
            $data1['attributes'] = $dat_Exp->attributes;
            $data1['position'] = $dat_Exp->position;
            $data1['aircraft_type'] = $dat_Exp->aircraft_type;
            $data1['created_at'] =  $dat_Exp->created_at;
            $data1['updated_at'] = $dat_Exp->updated_at;
            $data1['users'] = array();
            $users = DB::select('SELECT * FROM `flight_pad_users` WHERE customer_name = "' . $dat_Exp->customer_name . '" AND fc_com_key="' . $dat_Exp->fc_com_key . '"');
            foreach ($users as $k => $v) {
                $data2['id'] = $v->id;
                $data2['username'] = $v->username;
                $data2['password'] = $v->password;
                $data2['attributes'] = $v->attributes;
                $data2['aircraft_type'] = $v->aircraft_type;
                array_push($data1['users'], $data2);
            }
            array_push($list_data, $data1);
        }
        $result['success'] = 1;
        $result['data'] = $list_data;
        return $result;
    }


    /**
     * @OA\Get( path="/api/flightpadusers2",
     * summary = "to get response from database", 
     * tags={"unsecure Api"},
    
    
     * @OA\Response(response="200", description="An example resource"),
     * @OA\Response(response="404", description="Not found")
     * 
     * )
     */
    public function getFlightPadUsers2new(Request $request)
    {
      //  $appkey = $request->header('AppKey');
       // $userAppkey = config('constants.AuthKey');

       // if ($userAppkey == $appkey) {
            $data =  DB::select("SELECT 
            DISTINCT id,customer_name,fc_com_key,features,username,password,attributes,position,aircraft_type,created_at,updated_at
                    FROM 
                    flight_pad_users ORDER BY position asc");
            $list_data = array();
            foreach ($data as $dat_Exp) {
                $data1['customer_name'] =  $dat_Exp->customer_name;
                $data1['fc_com_key'] =   $dat_Exp->fc_com_key;
                $data1['features'] =   $dat_Exp->features;
                $data1['id'] = $dat_Exp->id;
                $data1['username'] = $dat_Exp->username;
                $data1['password'] = $dat_Exp->password;
                $data1['attributes'] = $dat_Exp->attributes;
                $data1['position'] = $dat_Exp->position;
                $data1['aircraft_type'] = $dat_Exp->aircraft_type;
                $data1['created_at'] =  $dat_Exp->created_at;
                $data1['updated_at'] = $dat_Exp->updated_at;
                $data1['users'] = array();
                $users = DB::select('SELECT * FROM `flight_pad_users` WHERE customer_name = "' . $dat_Exp->customer_name . '" AND fc_com_key="' . $dat_Exp->fc_com_key . '"');
                foreach ($users as $k => $v) {
                    $data2['id'] = $v->id;
                    $data2['username'] = $v->username;
                    $data2['password'] = $v->password;
                    $data2['attributes'] = $v->attributes;
                    $data2['aircraft_type'] = $v->aircraft_type;
                    array_push($data1['users'], $data2);
                }
                array_push($list_data, $data1);
            }
            $result['success'] = 1;
            $result['data'] = $list_data;
            return $result;
      //  } else {
      //      $result['fail'] = 'authentication fail';
      //  }
        return $result;
    }

    public function getFlightPadUsers()
    {
        $flightpadusers = FlightPadUser::all();
        $result['success'] = 1;
        $result['data'] = $flightpadusers;
        return $result;
    }

    /**
     * @OA\Get( path="/api/flightpadusers",
     * summary = "to get respfdffdfdonse from database", 
     * tags={"unsecure Api"},
     * @OA\Response(response="200", description="An example resource"),
     * @OA\Response(response="404", description="Not found")
     * 
     * )
     */
    // api
    public function getcustomer(Request $request)
    {
        $customer_names['customer'] = DB::table('flight_pad_users')
            ->where('customer_name', $request['customer_name'])->get();
            
            $customer_names['fc_com_key'] = DB::table('flight_pad_users')
            ->where('fc_com_key', $request['fc_com_key'])->get();
        return $customer_names;
    }
    public function getcustomername(Request $request)
    {
        $customer_name = DB::table('flight_pad_users')
            ->where('fc_com_key', $request['fc_com_key'])->get();
            $customer_name['customer'] = FlightPadUser::all();
        return $customer_name;
    }
    public function getallconfig(Request $request)
    {

        $data['config_list'] = $request->config_list;
        $data['ss'] =  DB::table('configurations')
            ->select('configurations_id', 'is_locked', 'config_name', 'variant.variant_name', 'remark', 'callsign', 'manufacturer_name', 'model_name', 'copy_from_id', 'client_email')
            ->leftJoin('variant', 'configurations.variant', '=', 'variant.variant_id')
            ->leftJoin('manufacturer', 'manufacturer.id', '=', 'configurations.manufacturer')
            ->leftJoin('model', 'model.id', '=', 'configurations.model')
            ->where('configurations.configurations_id', $data['config_list'])
            ->first();
        return json_encode($data);
    }
    public function getallcgdata(Request $request)
    {
        $data1['cg_envelop_list'] = $request->config_list;
        $data['cg'] =  DB::table('cg_envelopes')
            ->select('envelope_id', 'envelope_name',  'remark', 'manufacturer_name', 'model_name')
            ->join('manufacturer', 'manufacturer.id', '=', 'cg_envelopes.manufacturer')
            ->join('model', 'model.id', '=', 'cg_envelopes.model')
            ->where('cg_envelopes.envelope_id', $data1['cg_envelop_list'])
            ->first();
        return json_encode($data);
    }
    /**
     * @OA\Post( path="/api/getUserInformations",
     * summary = "to get response from database",
     * security = { { "basicAuth": {} } },
     *  tags={"User"},
     *      @OA\Parameter(
     *        name="username", in="query",required=true, 
     *          @OA\Schema(type="string",)
     *     ),
     *       @OA\Parameter(
     *        name="password", in="query",required=true, 
     *          @OA\Schema(type="string",)
     *     ),
     *       @OA\Parameter(
     *        name="Appkey", in="header",required=true,description= "pass appKey for authentication",
     *          @OA\Schema(type="string",)
     *     ),
     * @OA\Response(response="200", description="An example resource"),
     * @OA\Response(response="404", description="Not found"),
     * )
     */
    public function getUserInfos(Request $request)
    {
        $data6 =[];
        $token = bin2hex(openssl_random_pseudo_bytes(64));
        $username = $request->username;
        $password = $request->password;
        $userInfo = DB::table('flight_pad_users')
            ->where('username', $username)
            ->where('password', $password)->get();

        $data = array();
        if (sizeof($userInfo) === 0) {
            $data['success'] = 0;
            $data['message'] = 'Username not found';
        } 
        else {
            $updateAuthToken = DB::update('UPDATE flight_pad_users SET auth_token = ? WHERE username = ? and password = ?', [$token, $username, $password]);
            $appkey = $request->header('AppKey');
            $userAppkey = config('constants.AuthKey');

            if ($userAppkey == $appkey) {
                foreach ($userInfo as $key => $value) {
                    $data1['id'] = $value->id;
                    $data1['customer_name'] = $value->customer_name;
                    $data1['username'] = $value->username;
                    $data1['password'] = $value->password;
                    $data1['fc_com_key'] = $value->fc_com_key;
                    $data1['attributes'] = $value->attributes;
                    $data1['position'] = $value->position;
                    $data1['features'] = $value->features;
                    $data1['auth_token'] = $token;
                    $data1['aircraft_type'] = $value->aircraft_type;
                    $data1['created_at'] = $value->created_at;
                    $data1['updated_at'] = $value->updated_at;
                    $data1['logoManifest'] = "";
                    
                }
                $users = DB::table('flight_pad_users')
                    ->where('customer_name', $userInfo[0]->customer_name)
                    ->where('fc_com_key', $userInfo[0]->fc_com_key)->get();
                   
                $data1['users'] = array();
                $data1['CustomerAircraft'] = array();
                foreach ($users as $k => $v) {
                    $data3['id'] = $v->id;
                    $data3['username'] = $v->username;
                    $data3['password'] = $v->password;
                    $data3['attributes'] = $v->attributes;
                    $data3['aircraft_type'] = $v->aircraft_type;
                    if($v->ac_image_name != ""){
                    $imagePath  = url('uploads'.'/'.$v->ac_image_name);
                    $data1['logoManifest'] = $imagePath;
                    }
                    else{
                        $data1['logoManifest'] = "";
                    }
                    array_push($data1['users'], $data3);
                }

                $customer_flightpad1 = DB::table('fp_customer')
                    ->where('customer_name', $userInfo[0]->customer_name)
                    ->where('fc_com_key', $userInfo[0]->fc_com_key)->first();


                if ($customer_flightpad1) {

                    $customer_aircraft_data = DB::table('customer_aircraft')
                        ->where('customer_id', $customer_flightpad1->id)->get();
                    $count_of_aircraft = count($customer_aircraft_data);

                    foreach ($customer_aircraft_data as $key => $val) {

                        $customer_aircraft_config_info = DB::table('ac_config_list')->select(['id', 'config_id', 'config_data'])
                            ->where('aircraft_id', $val->id)
                            ->get();
                        $customer_aircraft_config_info1 = DB::table('ac_config_list')->select('aircraft_id')
                            ->where('aircraft_id', $val->id)
                            ->get();

                        $customer_aircraft_cgenvelope_info = DB::table('ac_cg_envelope_list')->select(['id', 'cg_id', 'cg_data'])
                            ->where('aircraft_id', $val->id)
                            ->get();

                        $aircraft_data =  DB::table('ac_allavailableacdatabase')->select('display_name')->where('id', $val->available_aircraft)
                            ->get();

                        // foreach ($customer_aircraft_config_info1 as $k => $v) {

                        //     $data5['CustomerAircraftId']  = $v->aircraft_id;
                        // }

                        foreach ($aircraft_data as $kd => $vr) {

                            $data5['AircraftName']  = $vr->display_name;
                        }
                        $data5['CustomerAircraftId'] = $val->id;
                        $data5['AcText'] = $val->ac_text;
                        $data5['Configurations'] = $customer_aircraft_config_info;
                        $data5['CGenvelope'] = $customer_aircraft_cgenvelope_info;
                        $data5['FuelInterpolation'] = $val->ac_fuelinterpolation;
                        $data5['Performance'] = $val->ac_performance;
                        $data5['CGmultiple'] = $val->ac_cgmultiple;

                        array_push($data6,$data5);
                    }
                    $data1['CustomerAircraft'] = $data6;
                }
                
                $data['success'] = 1;
                $data['UserInfo'] = $data1;
            } else {
                $data['Fail'] = "Authentication Require";
            }
        }
        return $data;
    }
}
