<?php $__env->startSection('content'); ?>
<div class="breadcrumb-area">
  <div class="container-fluid">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="#">Config</a></li>
        <li class="breadcrumb-item"><a class="active-color" href="#">Setting</a>
        </li>
      </ol>
    </nav>
  </div>
</div>
<div class="row">
  <div class="col-lg-12">
    <div class="bg-boxshadow">
      <div class="ibox-content from-block mb-30">
        <div class="row">
          <div class="col-sm-4">
            <div class="form-group">
              <label class="col-form-label">Aircraft Image</label>
              <div class="button dropdown">
                <?php if(count($aircrafts)): ?>
                <select class="selectpicker form-control mb-15" id="aircraft-selector" name="image2">
                  <?php $__currentLoopData = $aircrafts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aircraft): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option data-thumbnail="<?php echo e($aircraft->files); ?>" value="<?php echo e($aircraft->configuration_image_id); ?>"><?php echo e($aircraft->file_name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php else: ?>
                <div class="alert alert-dark-warning">You don't have any aircrafts!</div>
                <?php endif; ?>
                <form action="<?php echo e(url('/configAircraft/upload')); ?>" method="post" enctype="multipart/form-data">
                  <?php echo e(csrf_field()); ?>

                  <input type="file" name="aircraft" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2 "><br />
                  <button type="submit" class="btn btn-primary btn-xs" id="config_image_add">Add</button>
                  <button type="button" onclick="removeAircraft();" class="btn btn-danger btn-xs">Remove</button>
                </form>
              </div>
              <br />
              <img height="100px" class="aircraft-preview" alt="aircraft">
            </div>
          </div>
          <div class="col-sm-4">
            <div class="form-group">
              <label class="col-form-label">Item Symbol</label>
              <div class="button dropdown">
                <?php if(count($items)): ?>
                <select class="selectpicker form-control mb-15" id="symbol-selector" name="image2">
                  <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option data-thumbnail="<?php echo e($item->image); ?>" value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php else: ?>
                <div class="alert alert-dark-warning">You don't have any symbols!</div>
                <?php endif; ?>
                <form action="<?php echo e(url('/configSymbol/upload')); ?>" method="post" enctype="multipart/form-data">
                  <?php echo e(csrf_field()); ?>

                  <input type="file" name="symbol" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2 "><br />
                  <button type="submit" class="btn btn-primary btn-xs" id="config_image_add">Add</button>
                  <button type="button" class="btn btn-danger btn-xs" onclick="removeSymbol();">Remove</button>
                </form>
              </div>
              <br />
              <img height="100px" class="symbol-preview" alt="symbol">
            </div>
          </div>
          <div class="col-sm-4">
            <div class="form-group">
              <label class="col-form-label">Symbol Name</label>
              <!-- <div class="button dropdown"> -->
                <!-- <?php if(count($isymbols)): ?> -->
                <select data-style="btn-select-tag" class="form-control mb-15" id="sdbox" name="model">
                  <!-- <?php $__currentLoopData = $isymbols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $isymbol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($isymbol->iseatsymbol_id); ?>"><?php echo e($isymbol->iseatsymbol); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> -->
                </select>
                <!-- <?php else: ?>
                <div class="alert alert-dark-warning">You don't have any Symbol!</div>
                <?php endif; ?> -->
                <input placeholder="Enter Symbol Name" type="text" id="symbol_data" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                <p><span class="errors" style="color:red" id="symbol_error"></span></p>
                <button type="button" class="btn btn-primary btn-xs symbolAdd">Add</button>
                <button type="button" class="btn btn-danger btn-xs" onclick="deleteSymbol();">Remove</button>
              <!-- </div> -->
            </div>
          </div>
          <div class="col-sm-4">
            <div class="form-group">
              <label class="col-form-label">Specials</label>
              <div class="button dropdown">
                <?php if(count($specials)): ?>
                <select data-style="btn-select-tag" class="form-control mb-15" id="spbox" name="model">
                  <!-- <?php $__currentLoopData = $specials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $special): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($special->ispecial_id); ?>"><?php echo e($special->ispecial); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> -->
                </select>
                <?php else: ?>
                <div class="alert alert-dark-warning">You don't have any Symbol!</div>
                <?php endif; ?>
                <input required placeholder="Enter Special Name" type="text" id="special_data" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                <p><span class="errors" style="color:red" id="special_error"></span></p>
                <button type="button" class="btn btn-primary btn-xs specialAdd">Add</button>
                <button type="button" class="btn btn-danger btn-xs" onclick="deleteSpecial();">Remove</button>
              </div>
            </div>
          </div>
          <div class="col-sm-4">
            <form method="post" id="special_item_form">
              <div class="form-group">
                <label class="col-form-label">All Text Item</label>
                <div class="button dropdown">
                  <?php if(count($specialItems)): ?>
                  <select data-style="btn-select-tag" class="form-control mb-15" name="special_item_id" id="special_item_box">
                    <!-- <?php $__currentLoopData = $specialItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> -->
                    <!-- <option data-asset="<?php echo e(json_encode($specialItem)); ?>" value="<?php echo e($specialItem->special_item_id); ?>"><?php echo e($specialItem->special_item_name); ?></option> -->
                    <!-- <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> -->
                  </select>
                  <?php else: ?>
                  <div class="alert alert-dark-warning">You don't have any special items!</div>
                  <?php endif; ?>
                  <input required placeholder="Enter all text item name" type="text" name="special_item_name" id="special_item_name" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                  <button type="submit" class="btn btn-primary btn-xs customerDataAdd">Add/Edit</button>
                  <button type="button" class="btn btn-danger btn-xs" onclick="deleteCustomerData();">Remove</button>
                  <div id="handle_special_item_form"></div>
                </div>
              </div>
            </form>


          </div>
          <div class="col-sm-4">
            <div class="form-group">
              <label class="col-form-label">AllAvailableACDatabase</label>
              <div class="button dropdown">
                <?php if(count($display_types)): ?>
                <select data-style="btn-select-tag" class="form-control mb-15" id="display_box" name="display_name">
                  <?php $__currentLoopData = $display_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $display_types_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($display_types_data->id); ?>"><?php echo e($display_types_data->display_name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php else: ?>
                <div class="alert alert-dark-warning">You don't have any data items!</div>
                <?php endif; ?>
                <button type="button" class="btn btn-primary btn-xs availableac">Add</button>
                <button type="button" class="btn btn-primary btn-xs edit_data">Edit</button>

                <button type="button" class="btn btn-danger btn-xs" onclick="deleteacdisplayname();">Remove</button>

              </div>
            </div>
          </div>
          <!-- <div class="col-sm-4">
                                <form method="post" id="special_item_form">
                                  <div class="form-group">
                                    <label class="col-form-label">All Text Item</label>
                                    <div class="button dropdown">
                                      <?php if(count($specialItems)): ?>
                                        <select data-style="btn-select-tag" class="form-control mb-15" name="special_item_id" id="special_item_box">
                                          <?php $__currentLoopData = $specialItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option data-asset="<?php echo e(json_encode($specialItem)); ?>" value="<?php echo e($specialItem->special_item_id); ?>"><?php echo e($specialItem->special_item_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      <?php else: ?>
                                        <div class="alert alert-dark-warning">You don't have any special items!</div>
                                      <?php endif; ?>
                                      <input required placeholder="Enter all text item name" type="text" name="special_item_name" id="special_item_name" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                                      <button type="submit" class="btn btn-primary btn-xs customerDataAdd">Add/Edit</button>
                                      <button type="button" class="btn btn-danger btn-xs" onclick="deleteCustomerData();">Remove</button>
                                      <div id="handle_special_item_form"></div>
                                     </div>
                                  </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <div class="button dropdown">
                                      <label class="col-form-label">Symbol Name</label>
                                      <?php if(count($isymbols)): ?>
                                      <select data-style="btn-select-tag" class="form-control mb-15" id="special_item_symbol" name="special_item_symbol">
                                        <?php $__currentLoopData = $isymbols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $isymbol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($isymbol->iseatsymbol_id); ?>"><?php echo e($isymbol->iseatsymbol); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </select>
                                      <?php else: ?>
                                        <div class="alert alert-dark-warning">You don't have any Symbol!</div>
                                      <?php endif; ?>
                                      <label class="col-form-label">Station Name</label>
                                      <input required placeholder="Enter station name" type="text" name="special_item_station_name" id="special_item_station_name" style="padding: 5px; margin-bottom: 10px; border:1px solid #f2f2f2; width: 100%">
                                      <label class="col-form-label">On/Off</label>
                                      <select class="item-ionoff-select form-control" id="special_item_ionoff" name="special_item_ionoff">
                                        <option value="0">0</option> +
                                        <option value="1">1</option> +
                                      </select>
                                      <label class="col-form-label">Item Weight</label>
                                      <input required placeholder="Enter item weight" type="number" name="special_item_weight" id="special_item_weight" style="padding: 5px; margin: 0 0 10px 0; border:1px solid #f2f2f2; width: 100%">
                                      <label class="col-form-label">Special</label>
                                      <input required placeholder="Enter item special" type="text" name="special_item_specials" id="special_item_specials" style="padding: 5px; margin: 0 0 10px 0; border:1px solid #f2f2f2; width: 100%">
                                      <label class="col-form-label">Arm Alternate</label>
                                      <input required placeholder="Enter arm alternate" type="text" name="special_item_alternate" id="special_item_alternate" style="padding: 5px; margin-bottom: 10px; border:1px solid #f2f2f2; width: 100%">
                                    </div>
                                </div>
                            </div>
                          </form> -->
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document" style="
       position: absolute;
    left: 21%;
    max-width: 75%;">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Enter New Aircraft</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">

        <div class="bg-boxshadow">

          <div class="ibox-content from-block mb-30">
            <div class="row">
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="order_id">Aircraft Type</label>
                  <select data-style="btn-select-tag" class="selectpicker form-control mb-15 ac_aircraft_type " name="ac_aircraft_type">
                    <?php $__currentLoopData = $aircraft_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aircraft_types_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($aircraft_types_data->aircraft_id); ?>"><?php echo e($aircraft_types_data->ac_aircraft_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </div>
              </div>
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="status">Manufacturer</label>

                  <select data-style="btn-select-tag" class="form-control mb-15 ac_manufacturer dbox2" id="dbox2" name="ac_manufacturer">
                    <!-- <?php $__currentLoopData = $manufacturer_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer_types_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($manufacturer_types_data->manufacture_id); ?>"><?php echo e($manufacturer_types_data->ac_manfacturer_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> -->
                  </select>
                  <p><span class="errors" style="color:red" id="manufacture_error"></span></p>
                  <input required name="manufacturer_name" placeholder="Enter manufacturer" type="text" id="manufacturer_data" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                  <button type="button" class="btn  btn-primary btn-xs manufacturerAdd" id="ProbListBtn2">Add</button>
                  <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="deleteacmanufacture();">Remove</button>
                </div>
              </div>
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="status">Model</label>

                  <select data-style="btn-select-tag" class="form-control mb-15 ac_model dbox2_model" id="dbox2_model" name="ac_model">
                    <!-- <?php $__currentLoopData = $model_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model_types_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($model_types_data->model_id); ?>"><?php echo e($model_types_data->ac_model_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> -->
                  </select>
                  <input required name="model_name" placeholder="Enter model" type="text" id="model_data" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                  <button type="button" class="btn  btn-primary btn-xs modelAdd" id="ProbListBtn2">Add</button>
                  <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="deleteacmodel();">Remove</button>
                </div>
              </div>
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="status">Variant</label>

                  <select data-style="btn-select-tag" class="form-control mb-15 ac_variant dbox2_variant" id="dbox2_variant" name="ac_variant">
                    <?php $__currentLoopData = $variant_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant_types_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($variant_types_data->variant_id); ?>"><?php echo e($variant_types_data->ac_variant_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                  <input required name="variant_name" placeholder="Enter Variant" type="text" class="variant_data" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                  <button type="button" class="btn  btn-primary btn-xs variantAdd" id="ProbListBtn2">Add</button>
                  <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="deleteacvariant();">Remove</button>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
      <div class="modal-footer">
        <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button> -->
        <button type="submit" class="btn btn-primary save_data">Save Aircraft</button>
      </div>

    </div>
  </div>
</div>


<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModal" aria-hidden="true">
  <div class="modal-dialog" role="document" style="
       position: relative;
    left: 5%;
    max-width: 67%;">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editModallabel">Edit Aircraft</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="bg-boxshadow">
          <div class="ibox-content from-block mb-30">
            <div class="row">
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="order_id">Aircraft Type</label>
                  <select data-style="btn-select-tag" class="selectpicker form-control mb-15 ac_aircraft_type_edit " name="ac_aircraft_type_edit">

                  </select>
                </div>
              </div>

              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="status">Manufacturer</label>
                  <select data-style="btn-select-tag" class="selectpicker form-control mb-15 ac_manufacture_edit dbox2" id="dbox2_edit" name="ac_manufacture_edit">
                  </select>
                  <input required name="manufacturer_name" placeholder="Enter manufacturer" type="text" id="manufacturer_data_edit" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                  <button type="button" class="btn  btn-primary btn-xs manufacturerAdd_edit" id="ProbListBtn2">Add</button>
                  <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="deleteacmanufacture_edit();">Remove</button>
                </div>
              </div>

              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="status">Model</label>
                  <select data-style="btn-select-tag" class="selectpicker form-control mb-15 ac_model_edit dbox2_model" id="dbox2_model_edit" name="ac_model_edit">
                  </select>
                  <input required name="model_name" placeholder="Enter model" type="text" id="model_data_edit" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                  <button type="button" class="btn  btn-primary btn-xs modelAdd_edit" id="ProbListBtn2">Add</button>
                  <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="deleteacmodel_edit();">Remove</button>
                </div>
              </div>
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="col-form-label" for="status">Variant</label>
                  <select required data-style="btn-select-tag" class="selectpicker form-control mb-15  ac_variant_edit dbox2_variant" id="dbox2_variant_edit" name="ac_variant_edit">
                  </select>
                  <input required name="variant_name" placeholder="Enter Variant" type="text" class="variant_data_edit" style="padding: 5px; margin-bottom: 20px; border:1px solid #f2f2f2; width: 100%">
                  <button type="submit" class="btn  btn-primary btn-xs variantAdd_edit" id="ProbListBtn2">Add</button>
                  <button type="button" class="btn btn-primary btn-xs" id="test2" onclick="deleteacvariant_edit();">Remove</button>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-primary update_data">Update Aircraft</button>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
  $(document).ready(function() {
    getSymbolItem();
    getSpecialItem();
    getSpecials();
    aircraft();
    displayadddata();
    display_user();
    // displayremovevariant();
    // displayremovemodel();
    getModelItem();
    getvariantItem();
    getmanufactureItem()
    // var cou = $('#display_box option').length;
    // alert(cou);
    // if ()
    $("#aircraft-selector").change(function() {
      aircraft = $(this).find(':selected').data('thumbnail');
      $('.aircraft-preview').attr('src', '/uploads/' + aircraft);
    });

    symbol();

    $("#symbol-selector").change(function() {
      symbol = $(this).find(':selected').data('thumbnail');
      $('.symbol-preview').attr('src', '/uploads/' + symbol);
    });

    $(document).on('change', '#special_item_box', function() {
      var asset = $(this).find(':selected').data('asset');
      $('#special_item_alternate').val(asset.special_item_alternate);
      $('#special_item_symbol').val(asset.special_item_symbol);
      $('#special_item_ionoff').val(asset.special_item_ionoff);
      $('#special_item_name').val(asset.special_item_name);
      $('#special_item_specials').val(asset.special_item_specials);
      $('#special_item_station_name').val(asset.special_item_station_name);
      $('#special_item_weight').val(asset.special_item_weight);
    });

  });

  function aircraft() {
    var aircraft = $('#aircraft-selector').find(':selected').data('thumbnail');
    $('.aircraft-preview').attr('src', '/uploads/' + aircraft);
  }

  function symbol() {
    var symbol = $('#symbol-selector').find(':selected').data('thumbnail');
    $('.symbol-preview').attr('src', '/uploads/' + symbol);
  }

  function removeAircraft() {
    // var index = $('#aircraft-selector').get(0).selectedIndex;
    // var id = $('#aircraft-selector').val();

    // $.ajaxSetup({
    //   headers: {
    //     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //   }
    // });
    // $.ajax({
    //     url: '/configAircraft/remove/' + id,
    //     type: 'post',
    //     cache: false,
    //     processData: true,
    //     success: function () {
    //       $('#aircraft-selector option:eq(' + index + ')').remove();
    //       aircraft();
    //     }
    //  });

    var index = $('#aircraft-selector').get(0).selectedIndex;
    var id = $('#aircraft-selector').val();
    console.log(id);
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      // url: "/configAircraft/remove/",
      url: '<?php echo e(url("/configAircraft/remove/")); ?>',
      type: 'delete',
      data: {
        "id": id
      },
      success: function(response) {
        $('#aircraft-selector option:eq(' + index + ')').remove();
        console.log(response);
      },
    });
  }
  $('.availableac').click(function() {
    $('#exampleModal').modal('show');
  });

  $('.edit_data').click(function() {

    var id = $('#display_box').val();
    // alert(id);
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/editacdata/' + id,
      type: 'GET',
      cache: false,
      data: {
        id: id
      },
      processData: true,
      dataType: 'JSON',
      success: function(response) {
        var strDropdownHtml = '';
        var strDropdownHtml_manu = '';
        var strDropdownHtml_model = '';
        var strDropdownHtml_variant = '';

        $.each(response.types, function(index, value) {

          if (response.data.ac_aircraft_id == value.aircraft_id) {
            strDropdownHtml += "<option selected value=" + value.aircraft_id + ">" + value.ac_aircraft_name + "</option>";
          } else {
            strDropdownHtml += "<option value=" + value.aircraft_id + ">" + value.ac_aircraft_name + "</option>";
          }


        });
        $.each(response.manufacturer_types_edit, function(index, value) {

          if (response.data.ac_manufacturer_id == value.manufacture_id) {
            strDropdownHtml_manu += "<option selected value=" + value.manufacture_id + ">" + value.ac_manfacturer_name + "</option>";
          } else {
            strDropdownHtml_manu += "<option  value=" + value.manufacture_id + ">" + value.ac_manfacturer_name + "</option>";
          }
                  // getmanufactureItem();

        });

        $.each(response.model_types_edit, function(index, value) {

          if (response.data.ac_model_id == value.model_id) {
            strDropdownHtml_model += "<option selected value=" + value.model_id + ">" + value.ac_model_name + "</option>";
          } else {
            strDropdownHtml_model += "<option  value=" + value.model_id + ">" + value.ac_model_name + "</option>";
          }
          // getModelItem();

        });

        $.each(response.variant_types_edit, function(index, value) {
          if (response.data.ac_variant_id == value.variant_id) {
            strDropdownHtml_variant += "<option selected value=" + value.variant_id + ">" + value.ac_variant_name + "</option>";
          } else {
            strDropdownHtml_variant += "<option  value=" + value.variant_id + ">" + value.ac_variant_name + "</option>";
          }


        });

        $('.ac_aircraft_type_edit').html(strDropdownHtml);
        $('.ac_manufacture_edit').html(strDropdownHtml_manu);
        $('.ac_model_edit').html(strDropdownHtml_model);
        $('.ac_variant_edit').html(strDropdownHtml_variant);
        //  $('#editModal').show();
        $('#editModal').modal('show');
      }

    });


  });
  $('.manufacturerAdd_edit').click(function() {
    var ac_manufacturer_data = $('#manufacturer_data_edit').val();
    if (ac_manufacturer_data == '') {
      $('#manufacturer_data_edit').text('Please enter Manufacturer name');
    } else {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/addAcManufacturer',
        type: 'POST',
        cache: false,
        data: {
          ac_manufacturer_data: ac_manufacturer_data
        },
        processData: true,
        success: function(data) {
          console.log(data);
          data = data.replace(/\"/g, "");
          $('#manufacturer_data_edit').val('');
          // displayremovemanufacture();
          getmanufactureItem();
          // $('.dbox2').append('<option value="Option Value">' + data + '</option>');
          //  getManufacturerItem();
        }
      });
    }
  });
  $('.modelAdd_edit').click(function() {
    var ac_model_data = $('#model_data_edit').val();
    if (ac_model_data == '') {
      $('#manufacturer_data_edit').text('Please enter Manufacturer name');
    } else {


      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/addAcModel',
        type: 'POST',
        cache: false,
        data: {
          ac_model_data: ac_model_data
        },
        processData: true,
        success: function(data) {
          console.log(data);
          data = data.replace(/\"/g, "");
          $('#model_data_edit').val('');
          // $('.dbox2_model').append('<option value="Option Value">' + data + '</option>');
          // getManufacturerItem();
          displayremovemodel();
        }
      });
    }
  });

  $('.variantAdd_edit').click(function() {
    var ac_variant_data = $('.variant_data_edit').val();
    if (ac_variant_data == '') {
      $('.variant_data_edit').text('Please enter Manufacturer name');
    } else {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });

      $.ajax({
        url: '/config/addAcvariant',
        type: 'POST',
        cache: false,
        data: {
          ac_variant_data: ac_variant_data
        },
        processData: true,
        success: function(data) {
          console.log(data);
          data = data.replace(/\"/g, "");
          $('.variant_data_edit').val('');
          $('.dbox2_variant').append('<option value="Option Value">' + data + '</option>');
          // getManufacturerItem();
          // displayremovevariant();
          getvariantItem();

        }
      });
    }
  });
  $('.save_data').click(function() {

    var ac_aircraft = $('.ac_aircraft_type').val();
    var ac_aircraft_name = $('.ac_aircraft_type option:selected').text();
    var ac_manufacturer = $('.ac_manufacturer').val();
    var ac_manufacturer_name = $('.ac_manufacturer option:selected').text();
    var ac_model = $('.ac_model').val();
    var ac_model_name = $('.ac_model option:selected').text();
    var ac_variant = $('.ac_variant').val();
    var ac_variant_name = $('.ac_variant option:selected').text();

    var display_name = ac_manufacturer_name + ', ' + ac_model_name + ' (' + ac_aircraft_name + ')';



    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '<?php echo e(url("/config/storeallacdata")); ?>',
      type: 'POST',
      cache: false,
      data: {
        ac_aircraft: ac_aircraft,
        ac_manufacturer: ac_manufacturer,
        ac_model: ac_model,
        ac_variant: ac_variant,
        display_name: display_name
      },
      processData: true,
      success: function(data) {
        console.log(data);
        data = data.replace(/\"/g, "");
        var displayid = $('#display_box').val();
        displayadddata();
        // $('#display_box').prepend('<option value="Option Value"  option:selected>' + display_name + '</option>');
      }
    });
    $('#exampleModal').modal('hide');
    // window.location.reload();
  });

  $('.update_data').click(function() {
    var id = $('#display_box').val();
    var ac_aircraft = $('.ac_aircraft_type_edit').val();
    var ac_aircraft_name = $('.ac_aircraft_type_edit option:selected').text();
    var ac_manufacturer = $('.ac_manufacture_edit').val();
    var ac_manufacturer_name = $('.ac_manufacture_edit option:selected').text();
    var ac_model = $('.ac_model_edit').val();
    var ac_model_name = $('.ac_model_edit option:selected').text();
    var ac_variant = $('.ac_variant_edit').val();
    var ac_variant_name = $('.ac_variant_edit option:selected').text();
    var display_name = ac_manufacturer_name + ', ' + ac_model_name + ' (' + ac_aircraft_name + ')';
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/updateallacdata/' + id,
      type: 'get',
      cache: false,
      processData: true,
      data: {
        ac_aircraft: ac_aircraft,
        ac_manufacturer: ac_manufacturer,
        ac_model: ac_model,
        ac_variant: ac_variant,
        display_name: display_name
      },
      success: function(data) {
        displaydata(display_name);

      },

    });
    //  window.location.reload();
    $('#editModal').modal('hide');


  });

  function displayadddata() {

    var strDropdownHtml_alldataAdd = '';
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/displaydata/',
      type: 'get',
      cache: false,
      processData: true,
      dataType: 'JSON',
      success: function(data) {

        $.each(data.display_types, function(index, value) {

          strDropdownHtml_alldataAdd += '<option  value=' + value.id + '>' + value.display_name + '</option>';

        });
        $('#display_box').html(strDropdownHtml_alldataAdd);
      },

    });
  }

  function displaydata(displayAllId) {
    var displaySelectedId = $('#display_box').val();

    var displayAllId = '';
    var strDropdownHtml_alldata = '';
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/displaydata/',
      type: 'get',
      cache: false,
      processData: true,
      dataType: 'JSON',
      success: function(data) {

        $.each(data.display_types, function(index, value) {
          displayAllId = value.id;
          if (displaySelectedId == displayAllId) {
            strDropdownHtml_alldata += '<option selected value=' + value.id + '>' + value.display_name + '</option>';

          } else {
            strDropdownHtml_alldata += '<option  value=' + value.id + '>' + value.display_name + '</option>';

          }
        });
        $('#display_box').html(strDropdownHtml_alldata);
      },

    });
  }

  function removeSymbol() {
    // var index = $('#symbol-selector').get(0).selectedIndex;
    // var id = $('#symbol-selector').val();

    // $.ajaxSetup({
    //   headers: {
    //     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //   }
    // });
    // $.ajax({
    //     url: '/configSymbol/remove/' + id,
    //     type: 'post',
    //     cache: false,
    //     processData: true,
    //     success: function () {
    //       $('#symbol-selector option:eq(' + index + ')').remove();
    //       symbol();
    //     }
    //  });

    var index = $('#symbol-selector').get(0).selectedIndex;
    var id = $('#symbol-selector').val();
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      // url: "/configSymbol/remove/",
      url: '<?php echo e(url("/configSymbol/remove/")); ?>',
      type: 'delete',
      data: {
        "id": id
      },
      success: function(response) {
        $('#symbol-selector option:eq(' + index + ')').remove();
        console.log(response);
      },
    });
  }

  $('.symbolAdd').click(function() {
    var sym_data = $('#symbol_data').val();
    if (sym_data == '') {
      $('#symbol_error').text('Please enter symbol name');
    } else {
      $('#symbol_error').text('');
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '<?php echo e(url("/config/addsymbol")); ?>',
        type: 'POST',
        cache: false,
        data: {
          sym_data: sym_data
        },
        processData: true,
        success: function(data) {
          data = data.replace(/\"/g, "");
          $('#symbol_data').val('');
          $('#sdbox').append('<option value="Option Value">' + data + '</option>');
          getSymbolItem();
        }
      });
    }
  });

  function getSymbolItem(){
  $.ajax({
      url: '<?php echo e(route('get-symbolitem')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
      //  console.log(data);
          var symbolString = "";

        // sort  the array
        var sortdata= data.data.sort(function(a, b) {
                    var textA = a.iseatsymbol.toUpperCase();
                    var textB = b.iseatsymbol.toUpperCase();
                    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
                  });

          // bind value to html element
          $.each(sortdata, function(i, item ) {
            console.log(item);
            symbolString += '<option value="'+item.iseatsymbol_id+'">'+item.iseatsymbol+'</option>';
          });
          $('#sdbox').html(symbolString);
      }
      
   });
  
}

  $('.specialAdd').click(function() {
    var spe_data = $('#special_data').val();
    if (spe_data == '') {
      $('#special_error').text('Please enter special name');
    } else {
      $('#special_error').text('');
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/addspecial',
        type: 'POST',
        cache: false,
        data: {
          spe_data: spe_data
        },
        processData: true,
        success: function(data) {
          data = data.replace(/\"/g, "");
          $('#special_data').val('');
          $('#spbox').append('<option value="Option Value">' + data + '</option>');
          getSpecials();
        }
      });
    }
  });

  function getSpecials(){
  $.ajax({
      url: '<?php echo e(route('get-specials')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
        console.log(data);
          var specialsString = "";

        // sort  the array
        var sortdata= data.data.sort(function(a, b) {
                    var textA = a.ispecial.toUpperCase();
                    var textB = b.ispecial.toUpperCase();
                    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
                  });

          // bind value to html element
          $.each(sortdata, function(i, item ) {
            specialsString += '<option value="'+item.ispecial_id+'">'+item.ispecial+'</option>';
          });
          $('#spbox').html(specialsString);
      }
      
   });
  
}
  $('.manufacturerAdd').click(function() {
    var ac_manufacturer_data = $('#manufacturer_data').val();
    if (ac_manufacturer_data == '') {
      $('#manufacturer_data').text('Please enter special name');
    } else {


      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });

      $.ajax({
        url: '/config/addAcManufacturer',
        type: 'POST',
        cache: false,
        data: {
          ac_manufacturer_data: ac_manufacturer_data
        },
        processData: true,
        success: function(data) {
          console.log(data);
          data = data.replace(/\"/g, "");
          $('#manufacturer_data').val('');
          // displayremovemanufacture();
          
          //  $('.dbox2').append('<option value="Option Value">' + data + '</option>');
         getmanufactureItem();
        }
      });
    }
  });

  function deleteacmanufacture() {
    var index = $('#dbox2').get(0).selectedIndex;
    var m_id = $('#dbox2').val();
    var delete_confirmation = confirm("Are you sure you want to delete this record ?");

    if (delete_confirmation == true) {
      $('#dbox2 option:eq(' + index + ')').remove();
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/removeAcManufacturer/' + m_id,
        type: 'post',
        cache: false,
        processData: true,
        success: function() {
          // displayremovemanufacture();
          getmanufactureItem();
        }
      });
    } else {
      return false;
    }
  }

  function deleteacmanufacture_edit() {
    var index = $('#dbox2_edit').get(0).selectedIndex;
    var m_id = $('#dbox2_edit').val();
    var delete_confirmation = confirm("Are you sure you want to delete this record ?");

    if (delete_confirmation == true) {
      $('#dbox2_edit option:eq(' + index + ')').remove();
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/removeAcManufacturer/' + m_id,
        type: 'post',
        cache: false,
        processData: true,
        success: function() {
          // displayremovemanufacture();
          getmanufactureItem();
        }
      });
    } else {
      return false;
    }
  }
  // function displayremovemanufacture(){
  //     var strDropdownHtml_alldataman ='';
  //     $.ajaxSetup({
  //     headers: {
  //       'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
  //     }
  //   });
  //   $.ajax({
  //     url: '/config/displaydata/',
  //     type: 'get',
  //     cache: false,
  //     processData: true,
  //     dataType: 'JSON',
  //     success: function(data) {

  //       $.each(data.display_manufacture, function(index, value) {
  //         strDropdownHtml_alldataman += '<option  value=' + value.manufacture_id + '>' + value.ac_manfacturer_name + '</option>';

  //       });
  //       $('.dbox2').html(strDropdownHtml_alldataman);
  //       getmanufactureItem();
  //     },

  //   });
  //   }

    function getmanufactureItem(){
  $.ajax({
      url: '<?php echo e(route('get-acmanufacturer')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
       
          var manufactureString = "";

        // sort  the array
        var sortdata= data.data.sort(function(a, b) {
                    var textA = a.ac_manfacturer_name.toUpperCase();
                    var textB = b.ac_manfacturer_name.toUpperCase();
                    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
                  });

          // bind value to html element
          $.each(sortdata, function(i, item ) {
            manufactureString += '<option value="'+item.manufacture_id+'">'+item.ac_manfacturer_name+'</option>';
          });
          $('.dbox2').html(manufactureString);
      }
      
   });
  
}

  $('.modelAdd').click(function() {
    var ac_model_data = $('#model_data').val();
    if (ac_model_data == '') {
      $('#model_data').text('Please enter special name');
    } else {

      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });

      $.ajax({
        url: '/config/addAcModel',
        type: 'POST',
        cache: false,
        data: {
          ac_model_data: ac_model_data
        },
        processData: true,
        success: function(data) {
          data = data.replace(/\"/g, "");
          $('#model_data').val('');
          displayremovemodel();
          // $('.dbox2_model').append('<option value="Option Value">' + data + '</option>');
          // getManufacturerItem();
        }
      });
    }
  });

  function deleteacmodel() {
    var index = $('#dbox2_model').get(0).selectedIndex;
    var m_id = $('#dbox2_model').val();
    var delete_confirmation = confirm("Are you sure you want to delete this record ?");

    if (delete_confirmation == true) {
      $('#dbox2_model option:eq(' + index + ')').remove();
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/removeAcModel/' + m_id,
        type: 'post',
        cache: false,
        processData: true,
        success: function() {
          displayremovemodel();
        }
      });
    } else {
      return false;
    }
  }

  function deleteacmodel_edit() {
    var index = $('#dbox2_model_edit').get(0).selectedIndex;
    var m_id = $('#dbox2_model_edit').val();
    var delete_confirmation = confirm("Are you sure you want to delete this record ?");
    if (delete_confirmation == true) {
      $('#dbox2_model_edit option:eq(' + index + ')').remove();
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/removeAcModel/' + m_id,
        type: 'post',
        cache: false,
        processData: true,
        success: function() {
          displayremovemodel();
        }
      });
    } else {
      return false;
    }
  }
  function displayremovemodel(){
      var strDropdownHtml_alldatamodel ='';
      $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/displaydata/',
      type: 'get',
      cache: false,
      processData: true,
      dataType: 'JSON',
      success: function(data) {

        $.each(data.display_model, function(index, value) {
          strDropdownHtml_alldatamodel += '<option  value=' + value.model_id + '>' + value.ac_model_name + '</option>';

        });
        $('.dbox2_model').html(strDropdownHtml_alldatamodel);
        getModelItem();
      },

    });
    }
    function getModelItem(){
  $.ajax({
      url: '<?php echo e(route('get-acmodeltypes')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
        console.log(data);
          var modelString = "";

        // sort  the array
        var sortdata= data.data.sort(function(a, b) {
                    var textA = a.ac_model_name.toUpperCase();
                    var textB = b.ac_model_name.toUpperCase();
                    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
                  });

          // bind value to html element
          $.each(sortdata, function(i, item ) {
            modelString += '<option value="'+item.model_id+'">'+item.ac_model_name+'</option>';
          });
          $('.dbox2_model').html(modelString);
      }
      
   });
  
}

  function deleteacvariant() {
    var index = $('#dbox2_variant').get(0).selectedIndex;
    var m_id = $('#dbox2_variant').val();
    var delete_confirmation = confirm("Are you sure you want to delete this record ?");

    if (delete_confirmation == true) {
      $('#dbox2_variant option:eq(' + index + ')').remove();
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/removeAcVariant/' + m_id,
        type: 'post',
        cache: false,
        processData: true,
        success: function() {
          // displayremovevariant();
          getvariantItem();
        }
      });
    } else {
      return false;
    }
  }

  function deleteacvariant_edit() {
    var index = $('#dbox2_variant_edit').get(0).selectedIndex;
    var m_id = $('#dbox2_variant_edit').val();
    var delete_confirmation = confirm("Are you sure you want to delete this record ?");

    if (delete_confirmation == true) {
      $('#dbox2_variant_edit option:eq(' + index + ')').remove();
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url: '/config/removeAcVariant/' + m_id,
        type: 'post',
        cache: false,
        processData: true,
        success: function() {
          // displayremovevariant();
          getvariantItem();
        }
      });
    } else {
      return false;
    }
  }
  $('.variantAdd').click(function() {
    var ac_variant_data = $('.variant_data').val();
    if (ac_variant_data == '') {} else {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });

      $.ajax({
        url: '/config/addAcvariant',
        type: 'POST',
        cache: false,
        data: {
          ac_variant_data: ac_variant_data
        },
        processData: true,
        success: function(data) {
          
          data = data.replace(/\"/g, "");
          $('.variant_data').val('');
          // $('.dbox2_variant').append('<option value="Option Value">' + data + '</option>');
          // getManufacturerItem();
          // displayremovevariant();
          getvariantItem();
        }
      });
    }
  });
//   function displayremovevariant(){
//     var strDropdownHtml_alldatavariant ='';
//       $.ajaxSetup({
//       headers: {
//         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//       }
//     });
//     $.ajax({
//       url: '/config/displaydata/',
//       type: 'get',
//       cache: false,
//       processData: true,
//       dataType: 'JSON',
//       success: function(data) {

//         $.each(data.display_variant, function(index, value) {
//           strDropdownHtml_alldatavariant += '<option  value=' + value.variant_id + '>' + value.ac_variant_name + '</option>';

//         });
//         $('.dbox2_variant').html(strDropdownHtml_alldatavariant);
//         getvariantItem();
//       },

//     });
// }

function getvariantItem(){
  $.ajax({
      url: '<?php echo e(route('get-acvarianttypes')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
        console.log(data);
          var variantString = "";

        // sort  the array
        var sortdata= data.data.sort(function(a, b) {
                    var textA = a.ac_variant_name.toUpperCase();
                    var textB = b.ac_variant_name.toUpperCase();
                    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
                  });

          // bind value to html element
          $.each(sortdata, function(i, item ) {
            if(item.variant_id == 1) {
              variantString += '<option value="'+item.variant_id+'" selected="selected">'+item.ac_variant_name+'</option>';
            }
            else {
              variantString += '<option value="'+item.variant_id+'">'+item.ac_variant_name+'</option>';

            }
          });
          $('.dbox2_variant').html(variantString);
      }
      
   });
  
}

  function deleteacdisplayname() {
    var index = $('#display_box').get(0).selectedIndex;
    var m_id = $('#display_box').val();

    var delete_confirmation = confirm("Are you sure you want to delete this record ?");

    if (delete_confirmation == true) {

      $('#display_box option:eq(' + index + ')').remove();
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });

      $.ajax({
        url: '/config/removeAcDisplayname/' + m_id,
        type: 'post',
        cache: false,
        data: {
          id: m_id
        },
        processData: true,

        success: function(data) {

        }

      });

    } else {

      return false;
    }

  }
  // Special Items
  // $(document).on("submit", '#special_item_form', function(e) {
  //   var form = $(this);
  //   e.preventDefault();
  //   $.ajaxSetup({
  //     headers: {
  //       'X-CSRF-TOKEN':  $('meta[name="csrf-token"]').attr('content')
  //     }
  //   });
  //   $.ajax({
  //      type: "POST",
  //      cache: false,
  //      url: '/config/addSpecialItem',
  //      data: form.serialize(),
  //      processData: true,
  //      dataType: "json",
  //      success: function (json) {
  //        if(json.status == 'success') {
  //          toSuccess(json.message);
  //          $('#special_item_form')[0].reset();
  //        } else {
  //          toError(json.message);
  //        }
  //      },
  //      error: function () {
  //          toError('Something went wrong!');
  //      }
  //  });
  // });

  $(document).on("submit", '#special_item_form', function(e) {
    var form = $(this);
    var special_item_name = $('#special_item_name').val();
    e.preventDefault();
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      type: "POST",
      cache: false,
      url: '/config/addSpecialItem',
      data: form.serialize(),
      processData: true,
      dataType: "json",
      success: function(json) {
        if (json.status == 'success') {
          // toSuccess(json.message);
          // $('#special_item_form')[0].reset();
          $('#special_item_name').val('');
          $('#special_item_box').append('<option value="Option Value">' + special_item_name + '</option>');
          getSpecialItem();
        } else {
          toError(json.message);
        }
      },
      error: function() {
        toError('Something went wrong!');
      }
    });
  });

  function getSpecialItem(){
  $.ajax({
      url: '<?php echo e(route('get-specialitems')); ?>',
      type: 'GET',
      cache: false,
      processData: true,
      success: function (data) {
        console.log(data);
          var specialitemString = "";

        // sort  the array
        var sortdata= data.data.sort(function(a, b) {
                    var textA = a.special_item_name.toUpperCase();
                    var textB = b.special_item_name.toUpperCase();
                    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
                  });

          // bind value to html element
          $.each(sortdata, function(i, item ) {
            console.log(item);
            specialitemString += '<option value="'+item.special_item_id+'">'+item.special_item_name+'</option>';
          });
          $('#special_item_box').html(specialitemString);
      }
      
   });
  
}
  function toSuccess(message) {
    $('#handle_special_item_form').html(message);
    $('#handle_special_item_form').removeClass("hidden");
    $('#handle_special_item_form').addClass("alert alert-dark-success");
    setTimeout(function() {
      $('#handle_special_item_form').addClass("hidden");
    }, 5000);
  }

  function toError(message) {
    $('#handle_special_item_form').html(message);
    $('#handle_special_item_form').removeClass("hidden");
    $('#handle_special_item_form').addClass("alert alert-dark-danger");
    setTimeout(function() {
      $('#handle_special_item_form').addClass("hidden");
    }, 5000);
  }

  function deleteSymbol() {
    // var index = $('#sdbox').get(0).selectedIndex;
    // var m_id = $('#sdbox').val();

    // $('#sdbox option:eq(' + index + ')').remove();
    // $.ajaxSetup({
    //   headers: {
    //     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //   }
    // });
    // $.ajax({
    //     url: '/config/removesymbol/'+ m_id,
    //     type: 'post',
    //     cache: false,
    //     processData: true,
    //     success: function () {}
    // });


    var index = $('#sdbox').get(0).selectedIndex;
    var id = $('#sdbox').val();
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      // url: "/configSymbol/remove/",
      url: '<?php echo e(url("/config/removesymbol/")); ?>',
      type: 'delete',
      data: {
        "id": id
      },
      success: function(response) {

        $('#sdbox option:eq(' + index + ')').remove();
        console.log(response);
        // location.reload();
        // $('#symbol-selector option:eq(' + index + ')').remove();
      },
    });
  }

  function deleteSpecial() {
    var index = $('#spbox').get(0).selectedIndex;
    var m_id = $('#spbox').val();

    $('#spbox option:eq(' + index + ')').remove();
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/removespecial/' + m_id,
      type: 'post',
      cache: false,
      processData: true,
      success: function() {}
    });
  }

  function deleteCustomerData() {
    var index = $('#special_item_box').get(0).selectedIndex;
    var m_id = $('#special_item_box').val();

    $('#special_item_box option:eq(' + index + ')').remove();
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/removeSpecialItem/' + m_id,
      type: 'post',
      cache: false,
      processData: true,
      success: function() {}
    });
  }


  function display_user(){
    var username = "hangar";
    var password = "637512";
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url: '/config/displayuser',
      type: 'get',
      cache: false,
      processData: true,
      data: {
        username: username, password: password
      },
      success: function(data) {
        console.log(data);
      }
    });

  }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>