
<?php $__env->startSection('content'); ?>
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="<?php echo e(route('cgEnvelope')); ?>">CG Envelope</a></li>
               <li class="breadcrumb-item"><a class="active-color" href="#">CG Envelope Edit</a>
               </li>
           </ol>
       </nav>
   </div>
</div>
        <div class="row">
            <div class="col-lg-12">
            <?php echo e(Form::open(array('route' => ['cgEnvelope/update', $envelope->envelope_id], 'id' => 'gyronimo'))); ?>

                <div class="bg-boxshadow">
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="creat-new">
                            CG Envelope Name <input type="text" class="sync" placeholder="Enter CG Envelope name" name="envelope_name" value="<?php echo e(@$envelope->envelope_name); ?>">
                            <?php if($errors->has('envelope_name')): ?>
                                <div class="error" style="color: red"><?php echo e($errors->first('envelope_name')); ?></div>
                            <?php endif; ?>
                        </div>
                      </div>
                      <div class="col-sm-2" style="position: absolute;left: 48%;font-size: 17px;">
                        <div class="creat-new">
                          <label class="col-form-label" for="order_id">ID : <?php echo e($envelope->envelope_id); ?> </label>
                        </div>
                      </div>
                      <div class="form-group creat-new" style="padding-left: 9%;">
                          <label for="remark">Remark</label>
                          <input type="text" class="sync" placeholder="Enter remark" name="remark" value="<?php echo e(@$envelope->remark); ?>">
                      </div>
                      <!-- <div class="col-sm-6">
                        <div class="creat-new">
                          Remark <input type="text" class="sync" placeholder="Enter remark" name="remark" value="<?php echo e(@$envelope->remark); ?>">
                        </div>
                      </div> -->
                    </div>
                    <div class="ibox-content from-block mb-30">
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="order_id">Aircraft Type</label>
                                    <select data-style="btn-select-tag" class="selectpicker form-control mb-15 sync" name="aircraft_type">
                                        <?php $__currentLoopData = $aircraft; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aircraftData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php ($selected = ''); ?>
                                            <?php if($envelope->aircraft_type === $aircraftData->aircraft_id): ?>
                                            <?php ($selected = 'selected'); ?>
                                            <?php endif; ?>
                                            <option value="<?php echo e($aircraftData->aircraft_id); ?>" <?php echo e($selected); ?>><?php echo e($aircraftData->aircraft_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label">Manufacturer</label>
                                    <select data-style="btn-select-tag" class="form-control mb-15 sync" id="dbox2" name="manufacturer">
                                        <?php $__currentLoopData = $manufacturer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturerData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php ($selected = ''); ?>
                                            <?php if($envelope->manufacturer === $manufacturerData->id): ?>
                                            <?php ($selected = 'selected'); ?>
                                            <?php endif; ?>
                                            <option value="<?php echo e($manufacturerData->id); ?>" <?php echo e($selected); ?>> <?php echo e($manufacturerData->manufacturer_name); ?> </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Model</label>
                                    <select data-style="btn-select-tag" class="form-control mb-15 sync" id="dbox" name="model">
                                        <?php $__currentLoopData = $model; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modelData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php ($selected = ''); ?>
                                            <?php if($envelope->model === $modelData->id): ?>
                                            <?php ($selected = 'selected'); ?>
                                            <?php endif; ?>
                                            <option value="<?php echo e($modelData->id); ?>" <?php echo e($selected); ?>><?php echo e($modelData->model_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Variant</label>
                                     <select cdata-style="btn-select-tag" class="selectpicker form-control mb-15 sync" name="variant">
                                        <?php $__currentLoopData = $variant; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variantData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php ($selected = ''); ?>
                                            <?php if($envelope->variant === $variantData->variant_id): ?>
                                            <?php ($selected = 'selected'); ?>
                                            <?php endif; ?>
                                            <option value="<?php echo e($variantData->variant_id); ?>" <?php echo e($selected); ?>><?php echo e($variantData->variant_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Unit</label>
                                     <select cdata-style="btn-select-tag" class="form-control mb-15 sync" name="unit">
                                       <option <?php if($envelope->unit == 'kg') echo 'selected="selected"'; ?>>kg</option>
                                       <option <?php if($envelope->unit == 'lbs') echo 'selected="selected"'; ?>>lbs</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 text-center">
                      <?php if($envelope->is_locked != 1): ?>
                        <label style="color:#e22800;font-size:30px;">LOCKED! You can not save changes!</label>
                      <?php endif; ?>
                    </div>
                </div>
  <div class="row">
    <div class="col-12">
      <div class="product-list--area bg-boxshadow">
        <div id='gyronimo-handle'></div>
        <div class="box-block">
         <div class="row">
           <div class="col-sm-2">
             <div class="form-group">
               <label class="col-form-label">BOX Width</label>
               <input class="form-control mb-15 sync" type="number" placeholder="Enter width px" id="box-width-input" name="box_width" value="<?php echo e($envelope->box_width); ?>">
             </div>
          </div>
          <div class="col-sm-2">
            <div class="form-group">
               <label class="col-form-label">Box height</label>
               <input class="form-control mb-15 sync" type="number" placeholder="Enter height px" id="box-height-input" name="box_height" value="<?php echo e($envelope->box_height); ?>">
             </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
              <div id="wrapper">
                <div id="chartContainer" style="width: 450px;"></div>
              </div>
          </div>
          <div class="col-md-5">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                   X Min:
                   <input id="xMin" type="number" step="any" placeholder="Enter X-Min" class="form-control" name="x_min" value="<?php echo e(@$envelope->x_min); ?>">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   X Max:
                   <input id="xMax" type="number"  step="any" placeholder="Enter X-Max" class="form-control" name="x_max" value="<?php echo e(@$envelope->x_max); ?>">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   X-Steps:
                   <input id="xLine" type="number"  step="any" placeholder="Enter X-Line" class="form-control" name="x_line" value="<?php echo e(@$envelope->x_line); ?>">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   Y Min:
                   <input id="yMin" type="number" step="any" placeholder="Enter Y-Min" class="form-control" name="y_min" value="<?php echo e(@$envelope->y_min); ?>">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   Y Max:
                   <input id="yMax" type="number" step="any" placeholder="Enter Y-Max" class="form-control" name="y_max" value="<?php echo e(@$envelope->y_max); ?>">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   Y-Steps:
                   <input id="yLine" type="number" step="any" placeholder="Enter Y-Line" class="form-control" name="y_line" value="<?php echo e(@$envelope->y_line); ?>">
                </div>
              </div>
            <div class="col-md-4">
              <div class="form-group">
                 X Value:
                 <input id="xValue" type="number" step="any" placeholder="Enter X-Value" class="form-control" name="x_value[]">
                 <div class="xvalue-error"></div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                 Y Value:
                 <input id="yValue" type="number" step="any" placeholder="Enter Y-Value" class="form-control" name="y_value[]">
                 <div class="yvalue-error"></div>
              </div>
            </div>
           
            <div class="col-md-12">
              <div class="form-group">
                <button id="renderButton" style="margin-right: 20px;" class="btn btn-info" type="button">Add Point</button>
                 <button id="refreshGraphicsButton"  class="btn btn-primary btn-md" type="button">Create/Refresh Graphics</button>
              </div>
            </div>
          </div>
          <br />
          <div class="row">
            <div class="col-md-12 hidden" id="chartTableHeader">
              <h6>Points</h6>
              <table class="table table-responsive" id="table-responsive">
                <thead>
                <th>X</th>
                <th>Y</th>
                <th>Action</th>
              </thead>
              <tbody id="chartTable"></tbody>
              </table>
            </div>
          </div>
          </div>
        </div>
     </div>
     <div class="row">
         <div class="col-sm-12">
             <div class="button-block">
               <button onclick="location.href='<?php echo e(route('cgEnvelope')); ?>'" class="btn btn-primary btn-md" type="button">Cancel</button>
               <?php if($envelope->is_locked == 1): ?>
                  <button class="btn btn-info btn-md" type="submit" id="save">Save</button>
               <?php else: ?>
                    <button class="btn btn-info btn-md save" type="button">Save</button>
               <?php endif; ?>
             </div>
         </div>
     </div><br/>
     <div id='gyronimo-handle' class='gyronimo-handle'></div>
          </div>
        </div>
    </div>
    <input id="syncDps" name="dps" type="hidden">
</form>
</div>
<input id="envelopeId" type="hidden" value="<?php echo e(Request::segment(3)); ?>">
<script src="<?php echo e(asset('js/jquery-1.12.4.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery-ui.js')); ?>"></script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
var synced = true;
var store = new Array();
var frame = new Array();
var dps = new Array();
var dpsStore = new Array();
var chart;
var canvasWidth ;
var canvasHeight ;
var boxWidth = $('#box-width-input').val();
var boxHeight = $('#box-height-input').val();

var appUrl = 	window.location.origin ? window.location.origin + '/' : window.location.protocol + '/' + window.location.host;
var settings = {
  envelopeId: $('#envelopeId').val(),
};

window.onbeforeunload = function (e) {
  if(!synced) {
    var e = e || window.event;
    if (e) {
      e.returnValue = 'Data not saved yet!';
    }
    return 'Data not saved yet!';
  }
};

//
$(document).ready(function () {
  var xMin;
  var xMax;
  var yMin;
  var yMax;

  
  chart = new CanvasJS.Chart("chartContainer", {
    backgroundColor: "black",
    height: boxHeight,
    width: boxWidth,
    axisX:{
      title: "X Axis",
      labelFontColor: "white",
      minimum: xMin,
      maximum: xMax,
      gridThickness: 1,
    },
    axisY:{
      title: "Y Axis",
      labelFontColor: "white",
      minimum: yMin,
      maximum: yMax,
    }, 
    data: [{
      type: "line",
      dataPoints: window.dps,
    }]
  });
  chart.render();
 

  $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
  });

  $.ajax({
      url: '/envelopePoints/' + window.settings.envelopeId,
      cache: false,
      type: 'get',
      success: function(data) {
        window.dps.length = 0;
        data.forEach(function (value) {
          var points = {
            x: value.x_value,
            y: value.y_value
          };
          window.dpsStore.push(points);
          window.dps.push(points);
        });
        displayFrame();
        chartDataStore();
        closeLine();
        chart.render();
      }
  });

  $(document).on('keyup change', '.sync', function () {
    synced = false;
  });

  $(document).on('click', '#renderButton', function () {
      var xVal = $('#xValue').val();
      var yVal = $('#yValue').val();
      
      if(checkXYInputNumber(xVal,yVal) == true){
        if(xVal != "" && yVal != ""){
              addDataPointsAndRender();
              return false;
        } else {
              checkValue(xVal, yVal);
              return false;
        }
      }

  });

/**
  Refresh graphics click
 */
  $('#refreshGraphicsButton').on('click', function(){
      refreshGraphics();
  });

  $('.table-responsive').on('click','#editItem', function () {
      var firstValue;
      var secondValue;
      var elementId;
      var $this = $(this);
      var tds = $this.closest('tr').find('td').filter(function() {
      var trElem = $(this).closest("tr");
      elementId = trElem.attr('id');
      var firstTd = $(trElem).children("td")[0];
      var secondTd = $(trElem).children("td")[1];
          firstValue = $(firstTd).text();
          secondValue = $(secondTd).text();
        return $(this).find('.editbtn').length === 0;
      });
      //if ($this.html() === 'Edit') {
      //  $this.html('Save');
      //  tds.prop('contenteditable', true);
      //  tds.css({'border':'1px solid grey'});
     // }
      if($this.html() === 'Save'){
        dpsUpdate(window.dpsStore, elementId, firstValue, secondValue);
        syncDps();
        closeLine();
        chart.render();
        $this.html('Edit');
        tds.prop('contenteditable', false);
        tds.css({'border':'0px'});
      } else {
        $this.html('Save');
        tds.prop('contenteditable', true);
        tds.css({'border':'1px solid grey'});
      }
    });

    $('.table-responsive').on('click','#deleteItem', function () {
      var trElem = $(this).closest("tr");
      elementId = trElem.attr('id');
      trElem.remove();
      dpsDelete(dps, elementId);
      chart.render();
      if(window.dpsStore.length === 0){
         $("#chartTableHeader").css('visibility', 'hidden');
      }
    });

    $('#gyronimo').on("submit", function(e) {
     var form = $(this);
     syncDps();
     e.preventDefault();
     $.ajaxSetup({
       headers: {
         'X-CSRF-TOKEN':  $('meta[name="csrf-token"]').attr('content')
       }
     });
     $.ajax({
        type: "POST",
        cache: false,
        url: form.attr('action'),
        data: form.serialize(),
        processData: true,
        dataType: "json",
        success: function (json) {
          synced = true;
          $('#gyronimo-handle').html(json.message);
          $('.gyronimo-handle').html(json.message);
          $('#gyronimo-handle').removeClass("hidden");
          $('.gyronimo-handle').removeClass("hidden");
          $('#gyronimo-handle').addClass("alert alert-dark-success");
          $('.gyronimo-handle').addClass("alert alert-dark-success");
          setTimeout(function () {
            $('#gyronimo-handle').addClass("hidden");
            $('.gyronimo-handle').addClass("hidden");
          }, 5000);
        },
        error: function () {
          $('#gyronimo-handle').html('Something went wrong!');
          $('#gyronimo-handle').removeClass("hidden");
          $('#gyronimo-handle').addClass("alert alert-dark-danger");
          setTimeout(function () {
            $('#gyronimo-handle').addClass("hidden");
          }, 5000);
        }
    });
  });

});

function displayFrame() {
  xMin = document.getElementById("xMin").value;
  xMax = document.getElementById("xMax").value;
  yMin = document.getElementById("yMin").value;
  yMax = document.getElementById("yMax").value;
  xLine = document.getElementById("xLine").value;
  yLine = document.getElementById("yLine").value;
  xSub = (xMax - xMin)/xLine;
  ySub = (yMax - yMin)/yLine;
  //xSum =  + Number(xLine) + 1;
 // ySum =  + Number(yLine) + 1;
  xInterval = xSub ;
  yInterval = ySub ;
  chart.options.axisX.minimum = xMin;
  chart.options.axisX.maximum = xMax;
  chart.options.axisY.minimum = yMin;
  chart.options.axisY.maximum = yMax;
  chart.options.axisX.interval = xInterval;
  chart.options.axisY.interval = yInterval;
}

function syncDps() {
  document.getElementById("syncDps").value = JSON.stringify(window.dpsStore);
}

function addDataPointsAndRender() {
    xValue = Number(document.getElementById("xValue").value);
    yValue = Number(document.getElementById("yValue").value);
  
    $("#chartTableHeader").css('visibility', 'visible');
    dpsStoreData(xValue, yValue);
    closeLine();
    chartDataStore();

    refreshGraphics();

    document.getElementById("xValue").value = '';
    document.getElementById("yValue").value = '';
    
}

/**
Refresh the graphics as per X & Y inputs and render the chart as per graphics value  
 */
function refreshGraphics(){
    displayFrame();
     window.frame.push({
       xMin: xMin,
       xMax: xMax,
       yMin: yMin,
       yMax: yMax,
     })
    chart.render();
}

function dpsStoreData(xValue, yValue){
  window.dpsStore.push({
    x: xValue,
    y: yValue
  });
  window.dps.length = 0;
  window.dpsStore.forEach(function (value) {
    window.dps.push(value);
  });
}

function dpsUpdate(dps, key, valueOne, valueTwo){
  // window.dps[key].x = parseInt(valueOne);
  // window.dps[key].y = parseInt(valueTwo);
  window.dpsStore[key].x = parseFloat(valueOne);
  window.dpsStore[key].y = parseFloat(valueTwo);
}

function dpsDelete(dps, index){
  dps.splice(index, 1);
  dpsStore.splice(index, 1);
  closeLine();
}

function chartDataStore(){
  $('#chartTableHeader').removeClass('hidden');
  $("#chartTable").html("");
  if(window.dpsStore.length === 0){
    $("#chartTableHeader").css('visibility', 'hidden');
  }
  Object.keys(window.dpsStore).forEach(function (i) {
    var data = dpsStore[i];
    $("#chartTable").append(
      "<tr id='"+i+"'><td contenteditable='false'>"+data.x+"</td><td contenteditable='false'>"+data.y+"</td><td><a  id='editItem' class='editbtn'>Edit </a> | <a id='deleteItem'> Delete </a></tr>"
    );
  });
}

function closeLine(){
  var count = window.dpsStore.length;
  if (count > 2) {
    var close = {
        x: window.dpsStore[0].x,
        y: window.dpsStore[0].y
    };
    //window.dps.push(close);
  }
}

//set height width onchange for box
$('#box-width-input').on('change', function () {
      var boxWidth = $('#box-width-input').val();
      $('.canvasjs-chart-canvas').width(boxWidth);
});

$('#box-height-input').on('change', function () {
      var boxHeight = $('#box-height-input').val();
      $('.canvasjs-chart-canvas').height(boxHeight);
});

/**
added Enter click event added records
 */
$('#xValue').keypress(function(e) {
    $(".xvalue-error").hide();
    $(".yvalue-error").hide();
    var key = e.which;
    var xVal = $('#xValue').val();
    var yVal = $('#yValue').val();
    if (key == 13) // the enter key code
    {
      if(checkXYInputNumber(xVal,yVal) == true){
        if(xVal != "" && yVal != ""){
          addDataPointsAndRender();
          return false;
        } else {
          checkValue(xVal, yVal);
          return false;
        }
      }
    } 
});

$('#yValue').keypress(function(e) {
    $(".xvalue-error").hide();
    $(".yvalue-error").hide();
    var key = e.which;
    var xVal = $('#xValue').val();
    var yVal = $('#yValue').val();
    if (key == 13) // the enter key code
    {
      if(checkXYInputNumber(xVal,yVal) == true){
        if(xVal != "" && yVal != ""){
          addDataPointsAndRender();
          return false;
        } else {
          checkValue(xVal, yVal);
          return false;
        }
      }

    } 
});

function checkValue(xVal, yVal){
    if(xVal == "" && yVal == ""){
        showError(".xvalue-error", "xValue is required");
        showError(".yvalue-error", "yValue is required");
    } else if(xVal == ""){
        showError(".xvalue-error", "xValue is required");
    } else if(yVal == "") {
        showError(".yvalue-error", "yValue is required");
    }
}

function showError(errorClass, message){
      $(errorClass).attr('style', 'color: #dc3545');
      $(errorClass).html(message);
      $(errorClass).show();
}

function checkXYInputNumber(xVal,yVal){
      var xMinVal = $('#xMin').val();
      var xMaxVal = $('#xMax').val();

      var yMinVal = $('#yMin').val();
      var yMaxVal = $('#yMax').val();

      var result = true;

    if(parseInt(xVal) < parseInt(xMinVal)){
        showError(".xvalue-error", "Please enter X value between "+xMinVal+" to "+xMaxVal);
        result = false;
     } else if(parseInt(xVal) > parseInt(xMaxVal)){
        showError(".xvalue-error", "Please enter X value between "+xMinVal+" to "+xMaxVal);
        result = false;
     } 
     if(parseInt(yVal) < parseInt(yMinVal)){
        showError(".yvalue-error", "Please enter Y value between "+yMinVal+" to "+yMaxVal);
        result = false;
     } else if(parseInt(yVal) > parseInt(yMaxVal)){
        showError(".yvalue-error", "Please enter Y value between "+yMinVal+" to "+yMaxVal);
        result = false;
     }
  return result;
}

$('.save').on('click', function(){
  toastr.warning("Item Is Locked. Contact Master Admin To Unlock");  
});

// $('#yValue').mouseout(function(){
//   $(".form-control:focus, .single-line:focus").removeAttr('style');
//   $(".error").removeAttr('style');
//   $(".error").html("");
// });

// var renderButton = document.getElementById("renderButton");
// renderButton.addEventListener("click", addDataPointsAndRender);
</script>
<?php echo e(Form::close()); ?>

<!-- <script type="text/javascript">
    window.onload = function() {
        // addDataPointsAndRender();
    }
</script> -->
    <script type="text/javascript" src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>