@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="{{route('config')}}">Config</a></li>
               <li class="breadcrumb-item"><a class="active-color" href="#">Config Edit</a>
               </li>
           </ol>
       </nav>
   </div>
</div>
<div class="modal fade" id="myModal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
         <h5 class="modal-title">Item Symbol Images</h5>
         <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <form method="get" id="item-form">
          <div class="form-group row">
            @foreach($items as $item)
              <div class="col-sm-3 image-block">
                  <label style="cursor: pointer; padding-bottom: 10px;" >
                      <img src="{{asset('img/'.$item->image)}}" id="{{$item->id}}" alt="item-{{$item->id}}" class="img-thumbnail img-check">
                  </label>
              </div>
            @endforeach
              <div class="unit-block hidden">
                 <div class="from-data">
                   <span style="min-width: 30px; margin-left: 15px; margin-right: 5px">Unit x</span>
                    <input type="number" placeholder="Enter Unit X " id="x-unit">
                  </div>

                  <div class="from-data">
                   <span style="min-width: 30px; margin-left: 15px; margin-right: 5px">Unit y</span>
                    <input type="number" placeholder="Enter Unit Y " id="y-unit">
                  </div>
               </div>
             </div>
          <input type="button" value="Add Item" id="check-item" class="btn btn-success">
         </form>
      </div>
    </div>
  </div>
</div>
        <div class="row">
            <div class="col-lg-12">
            {{ Form::open(array('route' => ['config/update',$config->configurations_id])) }}

                <div class="bg-boxshadow">
                    <div class="creat-new">
                        Config Name :  <input type="text" id="pwd" placeholder="Enter Config Name" name="config_name" value="{{@$config->config_name}}">
                        @if ($errors->has('config_name'))
                            <div class="error" style="color: red">{{ $errors->first('config_name') }}</div>
                        @endif
                    </div>
                    <div class="ibox-content from-block mb-30">
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="order_id"> Aircraft Type  </label>
                                    <select data-style="btn-select-tag" class="selectpicker form-control mb-15" name="aircraft_type">

                                        @foreach($aircraft as $aircraftData)
                                        @php($selected = '')
                                            @if($config->aircraft_type === $aircraftData->aircraft_id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$aircraftData->aircraft_id}}" {{$selected}}>{{$aircraftData->aircraft_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="status"> Manufacturer  </label>
                                    <select data-style="btn-select-tag" class="form-control mb-15" id="dbox2" name="manufacturer">
                                        @foreach($manufacturer as $manufacturerData)
                                        @php($selected = '')
                                            @if($config->manufacturer === $manufacturerData->id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$manufacturerData->id}}" {{$selected}}> {{$manufacturerData->manufacturer_name}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer"> Model </label>
                                    <select data-style="btn-select-tag" class="form-control mb-15" id="dbox" name="model">
                                        @foreach($model as $modelData)
                                        @php($selected = '')
                                            @if($config->model === $modelData->id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$modelData->id}}" {{$selected}}>{{$modelData->model_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label  class="col-form-label" for="customer"> Variant </label>
                                     <select cdata-style="btn-select-tag" class="selectpicker form-control mb-15" name="variant">
                                        @foreach($variant as $variantData)
                                        @php($selected = '')
                                            @if($config->variant === $variantData->variant_id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$variantData->variant_id}}" {{$selected}}>{{$variantData->variant_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>

                <div class="row">
    <div class="col-12">
        <div class="product-list--area bg-boxshadow">
            <div class="row images-block">
              <div class="col-sm-6" style="padding-left: 0px; padding-right: 0px;">
                  <div
                    class="Helicopter-frame"
                    id="wrapper"
                    style="background-image: url({{asset('img/'.$config->image2)}}); background-size: cover">
                       <div id="fwd-red-line" class="lines red-line" style="top: {{$config->fwd_top_px}}; left: {{$config->fwd_left_px}}"></div>
                       <div id="aft-blue-line" class="lines blue-line" style="top: {{$config->aft_top_px}}; left: {{$config->aft_left_px}}"></div>
                       <div id="x1-green-line" class="lines greenline" style="top: {{$config->x1_top_px}}; left: {{$config->x1_left_px}}"></div>
                       <div id="x2-yellow-line" class="lines yellowline" style="top: {{$config->x2_top_px}}; left: {{$config->x2_left_px}}"></div>
                  </div>
              </div>
              <div class="col-sm-6">
                <div class="parameter">
                    <div class="from-data red-color"> <span style="min-width: 80px; font-size: 20px;">  FWD:  </span>
                        <input type="number" placeholder="Enter Unit" id="fwd-input" value="{{$config->fwd}}" name="fwd"> </div>
                    <div class="from-data blue-color"> <span style="min-width: 80px; font-size: 20px;"> AFT:  </span>
                        <input type="number" placeholder="Enter Unit" id="aft-input" value="{{$config->aft}}" name="aft"> </div>
                 </div>
                 <div class="parameter-xy">
                    <div class="from-data yellow-color"> <span style="min-width: 80px; font-size: 20px;">  X1 </span>
                     <input type="number" placeholder="Enter Unit" id="x1-input" value="{{$config->x1}}" name="x1"> </div>
                    <div class="from-data green-color"> <span style="min-width: 80px; font-size: 20px;"> X2  </span>
                     <input type="number" placeholder="Enter Unit" id="x2-input" value="{{$config->x2}}" name="x2"> </div>
                 </div>
              <div class="add-items">
                <button style="width: 200px; padding: 10px; margin-bottom: 10px" type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal">Add Item</button>
              </div>
              <div class="adde-items">
                  <div id="store-items"></div>
              </div>
            </div>
             </div>
             <div class="row">
                 <div class="col-sm-12">
                     <div class="button-block">
                       <button class="btn btn-primary btn-md" type="submit"> Cancel </button>
                       <button class="btn btn-info btn-md" type="submit" id="save"> Save </button>
                       <!-- <button class="btn btn-success btn-md" type="submit"> Copy data from exiting configuration </button> -->
                     </div>
                 </div>
             </div>
            </div>

        </div>

    </div>
<input id="current" type="hidden">

<input id="topY" name="top_y" type="hidden">
<input id="bottomY" name="bottom_y" type="hidden">
<input id="leftX" name="left_x" type="hidden">
<input id="rightX" name="right_x" type="hidden">
<input id="store" name="store" type="hidden">
<input id="config" type="hidden" value="{{Request::segment(3)}}">
</form>
</div>
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
<script type="text/javascript">
var store = new Array();
var parentPos = $('#wrapper').parent().offset();
var appUrl = 	window.location.origin ? window.location.origin + '/' : window.location.protocol + '/' + window.location.host;
var config = 	$('#config').val();

document.getElementById("store").value = JSON.stringify(window.store);
$(document).ready(function () {
  setLinesDefaultOffset();

  $.ajaxSetup({
      headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
  });

  $.ajax({
      url: '/components/' + config,
      cache: false,
      type: 'get',
      success: function(data) {
          var components = JSON.parse(data);
          setLinesDefaultOffset();
          Object.keys(components).forEach(function (component) {
            var comp = components[component];
            var unitY = parseInt(comp.latitude, 10);
            var pxY = getPxY(unitY);
            var unitX = parseInt(comp.longitude, 10);
            var pxX = getPxX(unitX);

            var data = {
              id: comp.item_id,
              partId: comp.part_id,
              unitX,
              unitY,
              pxX: pxX + 'px',
              pxY: pxY + 'px',
              src: appUrl + 'img/' + comp.image,
            };

            $('#wrapper').append("<img id='" + data.partId + "' class='helicopter-parts' src='" + data.src + "' style='position: absolute; top: "+data.pxY+"; left: "+data.pxX+"' />");
            window.store.push(data);
          });
          displayStore();
      }
  });


  $('.img-check').on('click', function () {
      document.getElementById("current").value = $(this).attr('id');
  });

  $('.lines').on('mouseenter', function () {
      setLinesDefaultOffset();
  });

  $('#check-item').on('click', function () {
      $(".image-block").toggleClass('hidden', 'show');
      $(".unit-block").toggleClass('hidden', 'show');

      setLinesDefaultOffset();

      var id = document.getElementById("current").value;
      var src = $('#' + id).attr('src');

      var unitY = parseInt(document.getElementById("y-unit").value, 10);
      var pxY = getPxY(unitY);

      var unitX = parseInt(document.getElementById("x-unit").value, 10);
      var pxX = getPxX(unitX);

      var data = {
        id,
        partId: Math.random(),
        unitX,
        unitY,
        pxX: pxX + 'px',
        pxY: pxY + 'px',
        src
      };

      $('#wrapper').append("<img id='" + data.partId + "' class='helicopter-parts' src='" + src + "' style='position: absolute; top: "+data.pxY+"; left: "+data.pxX+"' />");
      // console.log(data);
      window.store.push(data);
      document.getElementById("store").value = JSON.stringify(window.store);
      displayStore();
      $('#myModal').modal('hide');
      $('#item-form')[0].reset();
  });

  $(document).on('click', 'img.helicopter-parts', function () {
      $(this).addClass('ShowBorderRed') // Add class to the clicked image
      .siblings().removeClass('ShowBorderRed'); // Remove class from other sibling images
      var id = $(this).attr('id');
      document.getElementById("current").value = id;
  });

  $('.image-block').click(function(){
    $(".unit-block").addClass("animated slideInRight");
    $(".image-block").toggleClass("hidden", "show");
    $(".unit-block").toggleClass("hidden", "show");
  });

  $('#fwd-input, #aft-input').on('keyup', function () {
    updateYPositions();
  });

  $('#fwd-red-line, #aft-blue-line').on('ondrag', function () {
    alert('change');
  });

  $('#x1-input, #x2-input').on('keyup', function () {
    updateXPositions();
  });

  $(document).on('keyup', '.unit-x-input', function () {
    var id = $(this).attr('id');
    var value = $(this).val();
    updateXUnit(id, value);
  });

  $(document).on('keyup', '.unit-y-input', function () {
    var id = $(this).attr('id');
    var value = $(this).val();
    updateYUnit(id, value);
  });

});

function displayStore() {
  $('#store-items').html("");
  Object.keys(window.store).forEach(function (k) {
     $('#store-items').append(
       "<div class='row-block'>" +
        "<span class='id'>#" + k + "</span>"+
         "<img src='" + window.store[k].src + "'>"+
         "<span class='long'>Lon : <input class='unit-x-input' type='text' id='" + k + "' value='" + window.store[k].unitX + "' /></span>"+
         "<span class='lat'>Lat : <input class='unit-y-input' type='text' id='" + k + "' value='" + window.store[k].unitY + "' /></span>"+
       "</div>"
     );
  });
}

function getPxX(unitX) {
  var x1 = parseInt(document.getElementById("x1-input").value, 10);
  var x2 = parseInt(document.getElementById("x2-input").value, 10);
  var leftX = JSON.parse(document.getElementById("leftX").value);
  var rightX = JSON.parse(document.getElementById("rightX").value);
  var pxX = leftX.left + ((parseInt(unitX, 10) - x1) * getPxPerUnitX(x1, x2, leftX.left, rightX.left));

  return pxX;
}

function getPxY(unitY) {
  var fwd = parseInt(document.getElementById("fwd-input").value, 10);
  var aft = parseInt(document.getElementById("aft-input").value, 10);
  var topY = JSON.parse(document.getElementById("topY").value);
  var bottomY = JSON.parse(document.getElementById("bottomY").value);
  var pxY = topY.top + ((parseInt(unitY, 10) - fwd) * getPxPerUnitY(fwd, aft, topY.top, bottomY.top));

  return pxY;
}

function updateStoreParts() {
  Object.keys(window.store).forEach(function (k) {
    document.getElementById(window.store[k].partId).style.position = "absolute";
    document.getElementById(window.store[k].partId).style.top = window.store[k].pxY;
    document.getElementById(window.store[k].partId).style.left = window.store[k].pxX;
  });
}

function getPxPerUnitX(x1, x2, leftX, rightX) {
  var distanceUnit = parseInt(x2, 10) - parseInt(x1, 10);
  var distancePx = parseInt(rightX, 10) - parseInt(leftX, 10);
  var pxPerUnit = distancePx / distanceUnit;

  return pxPerUnit;
}

function getPxPerUnitY(fwd, aft, topY, bottomY) {
  var distanceUnit = parseInt(aft, 10) - parseInt(fwd, 10);
  var distancePx = parseInt(bottomY, 10) - parseInt(topY, 10);
  var pxPerUnit = distancePx / distanceUnit;

  return pxPerUnit;
}

function updateYPosition(id) {
  var fwd = parseInt(document.getElementById("fwd-input").value, 10);
  var aft = parseInt(document.getElementById("aft-input").value, 10);
  var topY = JSON.parse(document.getElementById("topY").value);
  var bottomY = JSON.parse(document.getElementById("bottomY").value);

  var unitY = window.store[id].unitY;
  var pxY = topY.top + ((parseInt(unitY, 10) - fwd) * getPxPerUnitY(fwd, aft, topY.top, bottomY.top));
  window.store[id].pxY = pxY + 'px';
  document.getElementById("store").value = JSON.stringify(window.store);
  updateStoreParts();
}

function updateYPositions() {
  Object.keys(window.store).forEach(function (k) {
    updateYPosition(k);
  });
}

function updateXPosition(id) {
  var x1 = parseInt(document.getElementById("x1-input").value, 10);
  var x2 = parseInt(document.getElementById("x2-input").value, 10);
  var leftX = JSON.parse(document.getElementById("leftX").value);
  var rightX = JSON.parse(document.getElementById("rightX").value);

  var unitX = window.store[id].unitX;
  var pxX = leftX.left + ((parseInt(unitX, 10) - x1) * getPxPerUnitX(x1, x2, leftX.left, rightX.left));
  window.store[id].pxX = pxX + 'px';
  document.getElementById("store").value = JSON.stringify(window.store);
  updateStoreParts();
}

function updateXPositions() {
  Object.keys(window.store).forEach(function (k) {
    updateXPosition(k);
  });
}

function updateXUnit(k, value) {
  window.store[k].unitX = parseInt(value, 10);
  document.getElementById("store").value = JSON.stringify(window.store);
  updateXPosition(k);
}

function updateYUnit(k, value) {
  window.store[k].unitY = parseInt(value, 10);
  document.getElementById("store").value = JSON.stringify(window.store);
  updateYPosition(k);
}

function setLinesDefaultOffset() {
  var masterPos = window.parentPos;
  var fwdRedLinePos = $('#fwd-red-line').offset();
  var fwdRedLineOffset = {
      top: parseInt(fwdRedLinePos.top - masterPos.top, 10),
      left: parseInt(fwdRedLinePos.left - masterPos.left, 10)
  }

  var aftBlueLinePos = $('#aft-blue-line').offset();
  var aftBlueLineOffset = {
      top: parseInt(aftBlueLinePos.top - masterPos.top, 10),
      left: parseInt(aftBlueLinePos.left - masterPos.left, 10)
  }

  var x2YellowLinePos = $('#x2-yellow-line').offset();
  var x2YellowLineOffset = {
    top: parseInt(x2YellowLinePos.top - masterPos.top, 10),
    left: parseInt(x2YellowLinePos.left - masterPos.left, 10)
  }

  var x1GreenLinePos = $('#x1-green-line').offset();
  var x1GreenLineOffset = {
      top: parseInt(x1GreenLinePos.top - masterPos.top, 10),
      left: parseInt(x1GreenLinePos.left - masterPos.left, 10)
  }

  document.getElementById("topY").value = JSON.stringify(fwdRedLineOffset);
  document.getElementById("bottomY").value = JSON.stringify(aftBlueLineOffset);
  document.getElementById("leftX").value = JSON.stringify(x2YellowLineOffset);
  document.getElementById("rightX").value = JSON.stringify(x1GreenLineOffset);
  // console.log(fwdRedLineOffset);
  // console.log(aftBlueLineOffset);
  // console.log(masterPos);
  // console.log(x2YellowLineOffset);
  // console.log(x1GreenLineOffset);
}

//Make the DIV element draggagle:
dragElement(document.getElementById("fwd-red-line"));
dragElement(document.getElementById("aft-blue-line"));
dragElement(document.getElementById("x1-green-line"));
dragElement(document.getElementById("x2-yellow-line"));

function dragElement(elmnt) {
  var pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
  if (document.getElementById(elmnt.id + "header")) {
  // /* if present, the header is where you move the DIV from:*/
  // document.getElementById(elmnt.id + "header").onmousedown = dragMouseDown;
  } else {
  /* otherwise, move the DIV from anywhere inside the DIV:*/
  elmnt.onmousedown = dragMouseDown;
}

function dragMouseDown(e) {
  e = e || window.event;
  e.preventDefault();

  // get the mouse cursor position at startup:
  pos3 = e.clientWidth;
  pos4 = e.clientHeight;
  document.onmouseup = closeDragElement;
  // call a function whenever the cursor moves:
  document.onmousemove = elementDrag;
}

function elementDrag(e) {
  e = e || window.event;
  e.preventDefault();

  // calculate the new cursor position:
  pos1 = pos3 - e.clientX;
  pos2 = pos4 - e.clientHeight;
  pos3 = e.clientX;
  pos4 = e.clientHeight;
  // set the element's new position:
  elmnt.style.top = (elmnt.offsetTop - pos2) + "px";
  elmnt.style.left = (elmnt.offsetLeft - pos1) + "px";
}

function closeDragElement() {
  /* stop moving when mouse button is released:*/
  document.onmouseup = null;
  document.onmousemove = null;
}
}

function dragElement(elmnt) {
  var pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
  if (document.getElementById(elmnt.id + "header")) {
  // /* if present, the header is where you move the DIV from:*/
  // document.getElementById(elmnt.id + "header").onmousedown = dragMouseDown;
  } else {
  /* otherwise, move the DIV from anywhere inside the DIV:*/
  elmnt.onmousedown = dragMouseDown;
}

function dragMouseDown(e) {
  e = e || window.event;
  e.preventDefault();
  // get the mouse cursor position at startup:
  pos3 = e.clientX;
  pos4 = e.clientY;
  document.onmouseup = closeDragElement;
  // call a function whenever the cursor moves:
  document.onmousemove = elementDrag;
}

function elementDrag(e) {
  e = e || window.event;
  e.preventDefault();

  // calculate the new cursor position:
  pos1 = pos3 - e.clientX;
  pos2 = pos4 - e.clientY;
  pos3 = e.clientX;
  pos4 = e.clientY;
  // set the element's new position:
  elmnt.style.top = (elmnt.offsetTop - pos2) + "px";
  elmnt.style.left = (elmnt.offsetLeft - pos1) + "px";
  setLinesDefaultOffset();
  updateXPositions();
  updateYPositions();
}

  function closeDragElement() {
  /* stop moving when mouse button is released:*/
  document.onmouseup = null;
  document.onmousemove = null;
  }
}
</script>
            {{ Form::close() }}
            </div>
        </div>
@endsection
