@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
    <div class="container-fluid">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                <a href="#">
                  @if(isset($user))
                    Edit User
                  @else
                    Create User
                  @endif
                </a></li>
                </li>
            </ol>
        </nav>
    </div>
</div>
            @if(isset($user))
            {{ Form::open(array('route' => ['update',$user->id],'files'=>true, 'id'=> 'updateUser')) }}
            @endif
            {{ Form::open(array('route' => 'store','files'=>true)) }}
            <div class="ibox bg-boxshadow min-height mb-50">
              <div class="row user-form">
                <div class="col-sm-6">
                  <div class="form-group row">
                    <label class="col-sm-12 col-form-label">First Name</label>
                    <div class="col-sm-12">
                        <input type="text" class="form-control" id="fnm" placeholder="Enter first name" name="first_name" value="{{@$user->first_name}}">
                        @if ($errors->has('first_name'))
                            <div class="error" style="color: red">{{ $errors->first('first_name') }}</div>
                        @endif
                    </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Last Name</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="lnm" placeholder="Enter last name" name="last_name" value="{{@$user->last_name}}">
                          @if ($errors->has('last_name'))
                              <div class="error" style="color: red">{{ $errors->first('last_name') }}</div>
                          @endif
                      </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Address</label>
                      <div class="col-sm-12">
                        <textarea class="form-control" id="address" placeholder="Enter address" name="address">{{@$user->address}}</textarea>
                          @if ($errors->has('address'))
                              <div class="error" style="color: red">{{ $errors->first('address') }}</div>
                          @endif
                      </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Email</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="email" placeholder="Enter Email Id" name="email" value="{{@$user->email}}">
                          @if ($errors->has('email'))
                              <div class="error" style="color: red">{{ $errors->first('email') }}</div>
                          @endif
                      </div>
                  </div>
                </div>
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Password</label>
                      <div class="col-sm-12">
                          <input type="password" class="form-control" id="pwd" placeholder="Enter New Password" name="password">
                          @if ($errors->has('password'))
                              <div class="error" style="color: red">{{ $errors->first('password') }}</div>
                          @endif
                      </div>
                  </div>
                </div>
                @if(!isset($user))
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Confirm  Password</label>
                      <div class="col-sm-12">
                          <input id="password-confirm" type="password" class="form-control" name="password_confirmation" placeholder="Enter Confirm Password">
                          @if ($errors->has('confirm password'))
                              <div class="error" style="color: red">{{ $errors->first('confirm password') }}</div>
                          @endif
                      </div>
                  </div>
                </div>
                @endif
                <div class="col-sm-6">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Phone</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="phone" placeholder="Enter phone" name="phone" value="{{@$user->phone}}">
                          @if ($errors->has('phone'))
                              <div class="error" style="color: red">{{ $errors->first('phone') }}</div>
                          @endif
                      </div>
                  </div>
                </div>
                <div class="col-sm-6" style="display:none">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Language</label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="language" placeholder="Enter language" name="language" value="{{@$user->language}}">
                          @if ($errors->has('language'))
                              <div class="error" style="color: red">{{ $errors->first('language') }}</div>
                          @endif
                      </div>
                  </div>
                </div>
                <div class="col-sm-6" style="display:none">
                  <div class="form-group row">
                    <label class="col-sm-12 col-form-label" for="image">Image</label>
                    <div class="col-sm-12">
                      {!! Form::file('image', array('class' => 'form-control')) !!}
                      @if ($errors->has('image'))
                        <div class="error" style="color: red">{{ $errors->first('image') }}</div>
                      @endif
                    </div>
                  </div>
                </div>
                @if(Auth::user()->role_id === 1 || Auth::user()->role_id === 3)
                  <div class="col-sm-6">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">User Type</label>
                      <div class="col-sm-12">
                        <select data-style="btn-select-tag" class="form-control mb-15 user-type" name="role_id">
                          @foreach($roles as $key => $role)
                              @php($selected = '')
                              @if(isset($user) && $role->id == $user->role_id)
                                @php($selected = 'selected')
                              @endif
                              <option {{$selected}} value="{{$role->id}}">{{$role->title}}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Customer Data</label>
                      <div class="col-sm-12">
                        <input type="text" class="form-control" placeholder="Enter customer data" name="customer_data" value="{{@$user->customer_data}}">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">User Fleet Control Id</label>
                      <div class="col-sm-12">
                        <input type="text" class="form-control" placeholder="Enter user fleet control id" name="user_fleet_control_id" value="{{@$user->user_fleet_control_id}}">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6 access-configurations">
                    <div class="form-group row">
                      <label class="col-sm-12 col-form-label">Configurations</label>
                      <div class="col-sm-12">
                        @if (count($configurations))
                          <select name="configurations[]" class="selectpicker form-control mb-15 configurations" multiple="multiple">
                              @foreach($configurations as $config)
                                  @php($selected = '')
                                  @if(isset($grantedConfigurations) && in_array($config->configurations_id, $grantedConfigurations))
                                    @php($selected = 'selected')
                                  @endif
                                  <option {{$selected}} value="{{$config->configurations_id}}">{{$config->configurations_id}}. {{$config->config_name}}</option>
                              @endforeach
                          </select>
                        @else
                          <div class="alert alert-dark-warning">You don't have any configurations!</div>
                        @endif
                      </div>
                    </div>
                  </div>
                @endif
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
          </div>
          {{ Form::close() }}
          <br /><br /><br /><br />
          <br /><br /><br /><br />
@endsection
@section('script')
<script src="{{asset('/js/plugins-js/fselect-js/fselect.js')}}"></script>
<script type="text/javascript">
$(document).ready(function() {
  check($('.user-type').val());
  $('.configurations').fSelect();
  $('.user-type').change(function() {
    check($(this).val());
  });


  $(document).on("submit", '#updateUser', function(e) {

    var pwd = $('#pwd').val();
    var data = {
        password : pwd
      }
    $.ajax({
          type: "GET",
          url: '/checkPassowrdChanged',
          data: data,
          dataType: "json",
          success: function (json) {
            updateUserData(json);
          },
          error: function () {
            
          }
      });


    
  });

  function updateUserData(pwd){
      
    if(pwd == 1){
      alert("Change password? Are you sure?");
    }

    var form = $('#updateUser');
     e.preventDefault();
     $.ajaxSetup({
       headers: {
         'X-CSRF-TOKEN':  $('meta[name="csrf-token"]').attr('content')
       }
     });
     $.ajax({
        type: "POST",
        cache: false,
        url: form.attr('action'),
        data: form.serialize(),
        processData: true,
        dataType: "json",
    });
      
  }

  function check(val) {
    if(val == 1) {
      $('.access-configurations').hide();
    } else {
      $('.access-configurations').show();
    }
  }

});
</script>
@endsection
