@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="#">Download Counter</a></li>
           </ol>
       </nav>
   </div>
</div>
<div class="container-fluid">
<div>
  <div>
    <a href="{{url('/airCraft/downloads_statistics')}}" class="btn btn-info">Downloads Statistics</a>
  </div>

</div>
  <div class="product-list--area bg-boxshadow">
      <div class="row">
          <div class="col-lg-12">
              <div class="ibox">
                  <div class="ibox-content">
                      <table id="airCraft" class="display table table-stripped toggle-arrow-tiny" data-page-size="15">
                          <thead>
                            <tr>
                                <th data-orderable="true">Date</th>
                                <th data-orderable="true">Aircraft Category</th>
                                <th data-orderable="true">Manufacturer</th>
                                <th data-orderable="true">Aircraft Type</th>
                                <th data-orderable="true">Category</th>
                                <th data-orderable="true">Business</th>
                            </tr>
                          </thead>
                          <tbody>
                          @if (count($airtCraftData))
                            @foreach($airtCraftData as $b)
                                <tr>
                                    <td><?=date('d.m.Y', strtotime($b->created_at))?></td>
                                    <td><?=$b->fleet_ac_category?></td>
                                    <td><?=$b->manufacturer?></td>
                                    <td><?=$b->fleet_ac_Type?></td>
                                    <td><?=$b->category_price?></td>
                                    <td><?=$b->business?></td>
                                    <tr>
                            @endforeach
                          @endif
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection
@section('script')

  <script>
    var token = "{{ csrf_token() }}";
    var base_url = "<?php echo url('/'); ?>";
  </script>

  <script type="text/javascript">
   $(document).ready(function(){
        $('#date_filter').change(function(){
            var date_filter = $('#date_filter').val();
            $.ajaxSetup({
              headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
            });

            $.ajax({
                type: 'POST', 
                url: "{{url('airCraft/mostLoadedAirCraft')}}",
                data: {
                    "date_filter": date_filter
                },
                dataType: 'JSON',
                success: function (response)
                {
                    console.log(response);
                    $('#airCraft').html(response.html);
                }
                
            });
        });
   })
    
  </script>

@endsection
