<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsInFlightPadUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flight_pad_users', function (Blueprint $table) {
            $table->string('auth_token')->after('position')->nullable();
            $table->string('aircraft_type')->after('fc_com_key')->nullable();
            $table->string('features')->after('attributes')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flight_pad_users', function (Blueprint $table) {
            $table->dropColumn('auth_token');
            $table->dropColumn('aircraft_type');
            $table->dropColumn('features');
        });
    }
}
