<?php

namespace App\Http\Middleware;

use Closure;
use DB;

class AuthKey
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $Appkey = $request->header('AppKey');
        $auth_token = $request->header('AuthToken');
        if ($auth_token != "") {
            if ($this->validateAuthToken($auth_token) == false) {
                $res['message'] = 'Auth fail';
                $res['status'] = 0;
                return json_encode($res);
            } else {
                return $next($request);
            }
        } elseif ($Appkey != "") {
            $userkey = config('constants.AuthKey');
            if ($Appkey != $userkey) {
                return response()->json(['message' => 'Auth fail1', 'status' => 0]);
            }
            return $next($request);
        } else {
            return response()->json(['message' => 'Auth fail', 'status' => 0]);
        }
    }
    public function validateAuthToken($auth_token)
    {
        $resultUser = DB::table('flight_pad_users')->where('auth_token', $auth_token)->get();

        if (count($resultUser) > 0 && $auth_token != null) {
            return true;
        } else {
            return false;
        }
    }
}
